{
    "en": {
        "auth": {
            "failed": "These credentials do not match our records.",
            "password": "Password",
            "throttle": "Too many login attempts. Please try again in {seconds} seconds.",
            "current_password": "Current Password",
            "logout": "Logout",
            "login": "Login",
            "login_subheading": "Welcome, please sign in to your dashboard",
            "forgot_password": "Forgot Your Password?",
            "email_address": "E-Mail Address",
            "confirm_password": "Confirm Password",
            "new_password": "New Password",
            "change_password": "Change Password",
            "remember_me": "Remember me?",
            "signing_in": "Signing in...",
            "sign_in_heading": "Sign in to your account"
        },
        "pagination": {
            "previous": "Previous",
            "next": "Next"
        },
        "passwords": {
            "reset": "Your password has been reset!",
            "sent": "We have emailed your password reset link!",
            "throttled": "Please wait before retrying.",
            "token": "This password reset token is invalid.",
            "user": "We can't find a user with that email address.",
            "reset_password": "Reset Password",
            "send_password_reset_link": "Send Password Reset Link"
        },
        "validation": {
            "accepted": "The {attribute} field must be accepted.",
            "accepted_if": "The {attribute} field must be accepted when {other} is {value}.",
            "active_url": "The {attribute} field must be a valid URL.",
            "after": "The {attribute} field must be a date after {date}.",
            "after_or_equal": "The {attribute} field must be a date after or equal to {date}.",
            "alpha": "The {attribute} field must only contain letters.",
            "alpha_dash": "The {attribute} field must only contain letters, numbers, dashes, and underscores.",
            "alpha_num": "The {attribute} field must only contain letters and numbers.",
            "array": "The {attribute} field must be an array.",
            "ascii": "The {attribute} field must only contain single-byte alphanumeric characters and symbols.",
            "before": "The {attribute} field must be a date before {date}.",
            "before_or_equal": "The {attribute} field must be a date before or equal to {date}.",
            "between": {
                "array": "The {attribute} field must have between {min} and {max} items.",
                "file": "The {attribute} field must be between {min} and {max} kilobytes.",
                "numeric": "The {attribute} field must be between {min} and {max}.",
                "string": "The {attribute} field must be between {min} and {max} characters."
            },
            "boolean": "The {attribute} field must be true or false.",
            "can": "The {attribute} field contains an unauthorized value.",
            "confirmed": "The {attribute} field confirmation does not match.",
            "current_password": "The password is incorrect.",
            "date": "The {attribute} field must be a valid date.",
            "date_equals": "The {attribute} field must be a date equal to {date}.",
            "date_format": "The {attribute} field must match the format {format}.",
            "decimal": "The {attribute} field must have {decimal} decimal places.",
            "declined": "The {attribute} field must be declined.",
            "declined_if": "The {attribute} field must be declined when {other} is {value}.",
            "different": "The {attribute} field and {other} must be different.",
            "digits": "The {attribute} field must be {digits} digits.",
            "digits_between": "The {attribute} field must be between {min} and {max} digits.",
            "dimensions": "The {attribute} field has invalid image dimensions.",
            "distinct": "The {attribute} field has a duplicate value.",
            "doesnt_end_with": "The {attribute} field must not end with one of the following: {values}.",
            "doesnt_start_with": "The {attribute} field must not start with one of the following: {values}.",
            "email": "The {attribute} field must be a valid email address.",
            "ends_with": "The {attribute} field must end with one of the following: {values}.",
            "enum": "The selected {attribute} is invalid.",
            "exists": "The selected {attribute} is invalid.",
            "extensions": "The {attribute} field must have one of the following extensions: {values}.",
            "file": "The {attribute} field must be a file.",
            "filled": "The {attribute} field must have a value.",
            "gt": {
                "array": "The {attribute} field must have more than {value} items.",
                "file": "The {attribute} field must be greater than {value} kilobytes.",
                "numeric": "The {attribute} field must be greater than {value}.",
                "string": "The {attribute} field must be greater than {value} characters."
            },
            "gte": {
                "array": "The {attribute} field must have {value} items or more.",
                "file": "The {attribute} field must be greater than or equal to {value} kilobytes.",
                "numeric": "The {attribute} field must be greater than or equal to {value}.",
                "string": "The {attribute} field must be greater than or equal to {value} characters."
            },
            "hex_color": "The {attribute} field must be a valid hexadecimal color.",
            "image": "The {attribute} field must be an image.",
            "in": "The selected {attribute} is invalid.",
            "in_array": "The {attribute} field must exist in {other}.",
            "integer": "The {attribute} field must be an integer.",
            "ip": "The {attribute} field must be a valid IP address.",
            "ipv4": "The {attribute} field must be a valid IPv4 address.",
            "ipv6": "The {attribute} field must be a valid IPv6 address.",
            "json": "The {attribute} field must be a valid JSON string.",
            "lowercase": "The {attribute} field must be lowercase.",
            "lt": {
                "array": "The {attribute} field must have less than {value} items.",
                "file": "The {attribute} field must be less than {value} kilobytes.",
                "numeric": "The {attribute} field must be less than {value}.",
                "string": "The {attribute} field must be less than {value} characters."
            },
            "lte": {
                "array": "The {attribute} field must not have more than {value} items.",
                "file": "The {attribute} field must be less than or equal to {value} kilobytes.",
                "numeric": "The {attribute} field must be less than or equal to {value}.",
                "string": "The {attribute} field must be less than or equal to {value} characters."
            },
            "mac_address": "The {attribute} field must be a valid MAC address.",
            "max": {
                "array": "The {attribute} field must not have more than {max} items.",
                "file": "The {attribute} field must not be greater than {max} kilobytes.",
                "numeric": "The {attribute} field must not be greater than {max}.",
                "string": "The {attribute} field must not be greater than {max} characters."
            },
            "max_digits": "The {attribute} field must not have more than {max} digits.",
            "mimes": "The {attribute} field must be a file of type: {values}.",
            "mimetypes": "The {attribute} field must be a file of type: {values}.",
            "min": {
                "array": "The {attribute} field must have at least {min} items.",
                "file": "The {attribute} field must be at least {min} kilobytes.",
                "numeric": "The {attribute} field must be at least {min}.",
                "string": "The {attribute} field must be at least {min} characters."
            },
            "min_digits": "The {attribute} field must have at least {min} digits.",
            "missing": "The {attribute} field must be missing.",
            "missing_if": "The {attribute} field must be missing when {other} is {value}.",
            "missing_unless": "The {attribute} field must be missing unless {other} is {value}.",
            "missing_with": "The {attribute} field must be missing when {values} is present.",
            "missing_with_all": "The {attribute} field must be missing when {values} are present.",
            "multiple_of": "The {attribute} field must be a multiple of {value}.",
            "not_in": "The selected {attribute} is invalid.",
            "not_regex": "The {attribute} field format is invalid.",
            "numeric": "The {attribute} field must be a number.",
            "password": {
                "letters": "The {attribute} field must contain at least one letter.",
                "mixed": "The {attribute} field must contain at least one uppercase and one lowercase letter.",
                "numbers": "The {attribute} field must contain at least one number.",
                "symbols": "The {attribute} field must contain at least one symbol.",
                "uncompromised": "The given {attribute} has appeared in a data leak. Please choose a different {attribute}."
            },
            "present": "The {attribute} field must be present.",
            "present_if": "The {attribute} field must be present when {other} is {value}.",
            "present_unless": "The {attribute} field must be present unless {other} is {value}.",
            "present_with": "The {attribute} field must be present when {values} is present.",
            "present_with_all": "The {attribute} field must be present when {values} are present.",
            "prohibited": "The {attribute} field is prohibited.",
            "prohibited_if": "The {attribute} field is prohibited when {other} is {value}.",
            "prohibited_unless": "The {attribute} field is prohibited unless {other} is in {values}.",
            "prohibits": "The {attribute} field prohibits {other} from being present.",
            "regex": "The {attribute} field format is invalid.",
            "required": "The {attribute} field is required.",
            "required_array_keys": "The {attribute} field must contain entries for: {values}.",
            "required_if": "The {attribute} field is required when {other} is {value}.",
            "required_if_accepted": "The {attribute} field is required when {other} is accepted.",
            "required_unless": "The {attribute} field is required unless {other} is in {values}.",
            "required_with": "The {attribute} field is required when {values} is present.",
            "required_with_all": "The {attribute} field is required when {values} are present.",
            "required_without": "The {attribute} field is required when {values} is not present.",
            "required_without_all": "The {attribute} field is required when none of {values} are present.",
            "same": "The {attribute} field must match {other}.",
            "size": {
                "array": "The {attribute} field must contain {size} items.",
                "file": "The {attribute} field must be {size} kilobytes.",
                "numeric": "The {attribute} field must be {size}.",
                "string": "The {attribute} field must be {size} characters."
            },
            "starts_with": "The {attribute} field must start with one of the following: {values}.",
            "string": "The {attribute} field must be a string.",
            "timezone": "The {attribute} field must be a valid timezone.",
            "unique": "The {attribute} has already been taken.",
            "uploaded": "The {attribute} failed to upload.",
            "uppercase": "The {attribute} field must be uppercase.",
            "url": "The {attribute} field must be a valid URL.",
            "ulid": "The {attribute} field must be a valid ULID.",
            "uuid": "The {attribute} field must be a valid UUID.",
            "recaptcha": "ReCaptcha verification failed.",
            "numeric_field": "The {attribute} is not a valid number, provide a valid number for example 1200, 1200.00 or 1200.255.",
            "calling_prefix": "The {attribute} must start with valid country calling code, for example: +994",
            "required_file": "Please add a file.",
            "invalid_options": "The provided option \"{options}\" is invalid.|The provided options \"{options}\" are invalid.",
            "custom": {
                "notifications.*.email": "Enter valid email address.",
                "notifications.*.filled": "Enter email address.",
                "_privacy-policy.accepted": "You must accept the privacy policy"
            },
            "import": {
                "user": {
                    "invalid": "You provided a user that don't exists. You must add the user ID or the user full name."
                }
            },
            "attributes": []
        },
        "activities": {
            "activity": {
                "activities": "Activities",
                "activity": "Activity",
                "add": "Add Activity",
                "description": "Description",
                "description_info": "The description is visible to all guests",
                "note": "Note",
                "note_info": "Notes are private and visible only for the sales reps.",
                "title": "Title",
                "due_date": "Due Date",
                "end_date": "End Date",
                "create": "Create Activity",
                "download_ics": "Download .ics file",
                "created": "Activity successfully created",
                "updated": "Activity successfully updated",
                "deleted": "Activity successfully deleted",
                "export": "Export Activities",
                "import": "Import Activities",
                "guests": "Guests",
                "guest": "Guest",
                "count_guests": "1 guest | {count} guests",
                "create_follow_up_task": "Create follow up task",
                "follow_up_with_title": "Follow up with {with}",
                "title_via_create_message": "Regarding an email: {subject}",
                "reminder_update_info": "Because the reminder for this activity is already sent, you will need to update the due date in order a new reminder to be pushed to the queue.",
                "owner_assigned_date": "Owner Assigned Date",
                "reminder_sent_date": "Reminder Sent Date",
                "reminder": "Reminder",
                "owner": "Owner",
                "mark_as_completed": "Mark as completed",
                "mark_as_incomplete": "Mark as incomplete",
                "is_completed": "Is Completed",
                "completed_at": "Completed At",
                "overdue": "Overdue",
                "doesnt_have_activities": "No Activities",
                "count": "No Activities | 1 Activity | {count} Activities",
                "incomplete_activities": "Incomplete Activities",
                "activity_was_due": "This activity was due at {date}",
                "next_activity_date": "Next Activity Date",
                "next_activity_date_info": "This field is read only and is automatically updated based on the record upcoming activities, indicates when the sale rep next action should be taken.",
                "cards": {
                    "my_activities": "My activities",
                    "my_activities_info": "This cards reflects the activities that you are added as owner",
                    "created_by_agent": "Activities created by sales agent",
                    "created_by_agent_info": "View the number of activities each sales agent is created. See who is creating the most activities and who is creating the least.",
                    "upcoming": "Upcoming activities",
                    "upcoming_info": "This card reflects the activities that are upcoming and the one that you are attending to."
                },
                "type": {
                    "default_type": "Default Activity Type",
                    "delete_primary_warning": "You cannot delete primary activity type.",
                    "delete_usage_warning": "The type is already associated with activities, hence, cannot be deleted.",
                    "delete_usage_calendars_warning": "This type is used as default type when creating activities via connected calendars, hence, cannot be deleted.",
                    "delete_is_default": "This is a default activity type, hence, cannot be deleted.",
                    "type": "Activity Type",
                    "types": "Activity Types",
                    "name": "Name",
                    "icon": "Icon"
                },
                "filters": {
                    "activity_type_disabled": "Activity type is used in the current filter, hence, you cannot select activity type from this section",
                    "open": "Open Activities",
                    "due_today": "Due Today",
                    "due_this_week": "Due This Week",
                    "display": {
                        "has": "has activities {value}:",
                        "overdue": "has {value}: activities",
                        "doesnt_have_activities": "does not have any activities"
                    },
                    "all": "All",
                    "today": "Today",
                    "tomorrow": "Tomorrow",
                    "this_week": "This Week",
                    "next_week": "Next Week",
                    "done": "Done",
                    "done_empty_state": "Done activities will be shown here."
                },
                "settings": {
                    "send_contact_email": "Sent \"Contact attends to activity\" mail template to contacts",
                    "send_contact_email_info": "If enabled, when contact is added as guest on activity, a mail template will be sent with attached .ics file and activity information."
                },
                "manage_activities": "Manage Activities",
                "info": "Schedule and manage activities with contacts and sales reps.",
                "timeline": {
                    "heading": "An activity has been created"
                },
                "permissions": {
                    "attends_and_owned": "Attends and owned only"
                },
                "actions": {
                    "update_type": "Update type"
                },
                "notifications": {
                    "due": "Your {activity} activity is due on {date}",
                    "assigned": "You have been assigned to activity {name} by {user}",
                    "added_as_guest": "You have been added as guest to activity"
                },
                "mail_placeholders": {
                    "assigneer": "The user name who assigned the activity"
                },
                "validation": {
                    "end_date": {
                        "less_than_due": "The end date must not be less then the due date."
                    },
                    "end_time": {
                        "required_when_end_date_is_in_future": "You must specify end time when the end date is on a different day."
                    }
                },
                "workflows": {
                    "actions": {
                        "create": "Create Activity"
                    },
                    "fields": {
                        "create": {
                            "title": "With activity title",
                            "note": "Add note (optional)"
                        }
                    }
                },
                "metrics": {
                    "todays": "Today's Activities"
                },
                "empty_state": {
                    "title": "You have not created any activities.",
                    "description": "Get started by creating a new activity."
                }
            },
            "calendar": {
                "calendar": "Calendar",
                "calendar_sync": "Calendar Sync",
                "reconfigure": "Reconfigure",
                "choose_oauth_account": "Choose an account type to start syncing calendar events",
                "account_being_connected": "You're about to connect {email} account.",
                "save_events_as": "Save calendar event as:",
                "sync_activity_types": "Sync the following activity types to calendar:",
                "sync_support_only_primary": "It's possible to sync only the account primary calendar.",
                "only_future_events_will_be_synced": "Only future events will be synced.",
                "events_will_sync_from": "Events created from {date} will be synced.",
                "events_being_synced_from": "Events created from {date} are being synced.",
                "missing_outlook_integration": "Microsoft application not configured, you must configure your Microsoft application in order to sync Outlook calendar.",
                "missing_google_integration": "Google application project not configured, you must configure your Google application project in order to connect to sync Google calendar.",
                "timeline": {
                    "imported_via_calendar_attendee": "Contact imported via {user} calendar because was added as attendee to an event."
                },
                "fullcalendar": {
                    "locale": {
                        "buttonText": {
                            "prev": "Previous period",
                            "next": "Next period",
                            "prevYear": "Prev year",
                            "nextYear": "Next year",
                            "year": "year",
                            "today": "Today",
                            "month": "Month",
                            "week": "Week",
                            "day": "Day",
                            "list": "List"
                        },
                        "weekText": "W",
                        "allDayText": "All Day",
                        "moreLinkText": "more",
                        "noEventsText": "No activities to display"
                    }
                }
            }
        },
        "billable": {
            "billable": {
                "total": "Total",
                "sub_total": "Sub Total",
                "includes_discount": "includes discount of {amount}",
                "tax_amount_is_inclusive": "inc",
                "tax_types": {
                    "inclusive": "Tax Inclusive",
                    "exclusive": "Tax Exclusive",
                    "no_tax": "No Tax"
                }
            },
            "product": {
                "products": "Products",
                "product": "Product",
                "create": "Create Product",
                "edit": "Edit Product",
                "export": "Export products",
                "import": "Import Products",
                "created": "Product successfully created",
                "updated": "Product successfully updated",
                "deleted": "Product successfully deleted",
                "related_products": "Related Products",
                "manage": "Manage Products",
                "name": "Name",
                "description": "Description",
                "table_heading": "Product",
                "tax": "Tax",
                "quantity": "Quantity",
                "qty": "QTY",
                "unit_price": "Unit Price",
                "direct_cost": "Direct Cost",
                "unit": "Unit (kg, lots)",
                "sku": "SKU",
                "is_active": "Active",
                "tax_rate": "Tax Rate",
                "tax_label": "Tax Label",
                "tax_percent": "Tax Percent",
                "discount": "Discount",
                "amount": "Amount",
                "discount_percent": "Discount Percent",
                "discount_amount": "Discount Amount",
                "will_be_added_as_new": "{name} will be added as new product",
                "total_products": "Total Products",
                "total_sold": "Total Sold",
                "sold_amount_exc_tax": "Sold Amount (tax exl.)",
                "interest_in_product": "Interest In Product",
                "resource_has_no_products": "No products added, start by selecting a product",
                "exists_in_trash_by_name": "Product with the same name already exists in the trash, would you like to restore the trashed product?",
                "choose_or_enter": "Choose or enter a product",
                "cards": {
                    "performance": "Product performance",
                    "performance_info": "\"Interest in product\" column reflects all products that are added to deals, but the \"Total Sold\" column reflects the products that are added to deals and the deals are marked as won"
                },
                "count": "0 products | 1 product | {count} products",
                "settings": {
                    "default_tax_type": "Do you sell your products at rates inclusive of Tax?",
                    "default_discount_type": "Default discount type"
                },
                "actions": {
                    "mark_as_active": "Mark as active",
                    "mark_as_inactive": "Mark as inactive",
                    "update_unit_price": "Update price",
                    "update_tax_rate": "Update tax rate",
                    "update_tax_label": "Update tax label"
                },
                "validation": {
                    "sku": {
                        "unique": "A product with this SKU already exists."
                    }
                },
                "empty_state": {
                    "title": "You have not created any products.",
                    "description": "Save time by using predefined products."
                }
            }
        },
        "brands": {
            "brand": {
                "brand": "Brand",
                "brands": "Brands",
                "create": "Create Brand",
                "update": "Update Brand",
                "form": {
                    "sections": {
                        "general": "General",
                        "navigation": "Navigation",
                        "email": "Email",
                        "thank_you": "Thank You",
                        "signature": "Signature",
                        "pdf": "PDF"
                    },
                    "is_default": "This the the company default brand?",
                    "name": "How do you refer to this brand internally?",
                    "display_name": "How do you want it displayed to your clients?",
                    "primary_color": "Choose the brand primary color",
                    "upload_logo": "Upload your company logo",
                    "navigation": {
                        "background_color": "Navigation background color",
                        "upload_logo_info": "If you have a dark background, use a light logo. If you're using a light background color use a logo with dark text."
                    },
                    "pdf": {
                        "default_font": "Default font family",
                        "default_font_info": "The {fontName} font gives the most decent Unicode character coverage by default, make sure to select a proper font if special or unicode characters are not displayed properly on the PDF document.",
                        "size": "Size",
                        "orientation": "Orientation",
                        "orientation_portrait": "Portrait",
                        "orientation_landscape": "Landspace"
                    },
                    "email": {
                        "upload_logo_info": "Make sure the logo is suitable for a white background, if no logo is uploaded, the dark logo uploaded in General settings will be used instead."
                    },
                    "document": {
                        "send": {
                            "info": "When you send a document",
                            "subject": "Default subject",
                            "message": "Default email message when you're sending a document",
                            "button_text": "Email button text"
                        },
                        "sign": {
                            "info": "When someone signs your document",
                            "subject": "Default subject line for thank you email",
                            "message": "Email message to send when someone signs your document",
                            "after_sign_message": "After signing, what should the message say?"
                        },
                        "accept": {
                            "after_accept_message": "After accepting (without digital signature), what should the message say?"
                        }
                    },
                    "signature": {
                        "bound_text": "Legal Bound Text"
                    }
                },
                "delete_documents_usage_warning": "The brand is already associated with documents, hence, cannot be deleted.",
                "created": "Brand successfully created.",
                "updated": "Brand successfully updated.",
                "deleted": "Brand successfully deleted"
            }
        },
        "calls": {
            "call": {
                "calls": "Calls",
                "call": "Call",
                "add": "Log Call",
                "make": "Make a phone call",
                "log": "Briefly describe the outcome of the call...",
                "manage_calls": "Manage Calls",
                "total_calls": "Total Calls",
                "activate_voip": "Activate",
                "voip_activated": "Activated",
                "info": "You can log calls and you and your team and keep track of all performed interactions.",
                "info_created": "{user} logged a call on {date}",
                "follow_up_task_body": "Regarding a call log: {content}",
                "created": "Call successfully logged",
                "updated": "Call successfully updated",
                "deleted": "Call successfully deleted",
                "date": "Call Date",
                "read_outcome": "Read Outcome",
                "outcome": {
                    "outcomes": "Call Outcomes",
                    "outcome": "Outcome",
                    "call_outcome": "Call Outcome",
                    "select_outcome": "Select Outcome",
                    "delete_warning": "The call outcome is already associated with calls, hence, cannot be deleted.",
                    "name": "Name"
                },
                "no_voip_permissions": "You account is not authorized to make calls",
                "voip_permissions": "VoIP Calling",
                "new_from": "New call from {number}",
                "connected_with": "Connected with {number}",
                "ended": "Call ended {number}",
                "speaker_volume": "Speaker Volume",
                "mic_volume": "Mic Volume",
                "mute": "Mute",
                "unmute": "Unmute",
                "answer": "Answer Call",
                "hangup": "Hangup Call",
                "reject": "Reject Call",
                "unknown_devices": "Seeing unknown devices?",
                "hide_bar": "Hide this bar",
                "activation_required": "Calling feature activation required",
                "activation_gesture_required": "Most browsers require user gesture (click) to activate calling feature\n        like audio and microphone. This is handled on your first click when you\n        enter your dashboard, since, you did not click anything in\n        {askForActivationIn} minute, we ask you to activate the calling\n        functionality by clicking below.",
                "cards": {
                    "by_day": "Logged calls by day",
                    "by_sale_agent": "Total logged calls by sales agent",
                    "logged_calls": "Logged calls",
                    "outcome_overview": "Call outcome overview"
                },
                "workflows": {
                    "triggers": {
                        "logged": "Call Logged",
                        "missed_incoming_call": "Missed Incoming Call"
                    }
                },
                "timeline": {
                    "heading": "New call has been logged"
                },
                "capabilities": {
                    "use_voip": "Make and Answer Calls"
                }
            },
            "twilio": {
                "create_app": "Create Application",
                "disconnect": "Disconnect Integration",
                "number": "Select Twilio number from your account that will be used to make and receive calls.",
                "retrieve_numbers": "Retrieve Numbers",
                "app": "Create application that will handle initiating new calls and incoming calls."
            }
        },
        "comments": {
            "comment": {
                "add": "Add comment",
                "comments": "Comments",
                "reply": "Reply",
                "created": "Comment added successfully",
                "updated": "Comment updated successfully",
                "user_left_comment": "{user} left a comment",
                "total": "Comments ({total})",
                "no_comments": "No comments here.",
                "add_placeholder": "Write a new comment, send your team notification by typing {'@'} followed by their name"
            }
        },
        "contacts": {
            "company": {
                "company": "Company",
                "companies": "Companies",
                "add": "Add Company",
                "dissociate": "Dissociate Company",
                "child": "Child Company | Child Companies",
                "create": "Create Company",
                "export": "Export Companies",
                "total": "Total Companies",
                "import": "Import Companies",
                "create_with": "Create Company with {name}",
                "associate_with": "Associate Company with {name}",
                "associate_field_info": "Use this field to find and associate exisiting company instead of creating new one.",
                "no_contacts_associated": "The company has no contacts associated.",
                "no_deals_associated": "The company has no deals associated.",
                "exists_in_trash_by_email": "Company with this email address already exists in the trash, you won't be able to create a new company with the same email address, would you like to restore the trashed company?",
                "exists_in_trash_by_name": "Company with the same name already exists in the trash, would you like to restore the trashed company?",
                "exists_in_trash_by_phone": "Company ({company}) with the following numbers: {phone_numbers}, already exists in the trash, would you like to restore the trashed company?",
                "possible_duplicate": "Possible duplicate company {display_name}.",
                "count": {
                    "all": "1 companies | {count} companies"
                },
                "notifications": {
                    "assigned": "You have been assigned to a company {name} by {user}"
                },
                "cards": {
                    "by_source": "Companies by source",
                    "by_day": "Companies by day"
                },
                "settings": {
                    "automatically_associate_with_contacts": "Automatically create and associate companies with contacts",
                    "automatically_associate_with_contacts_info": "Automatically associate contacts with companies based on a contact email address and a company domain."
                },
                "industry": {
                    "industries": "Industries",
                    "industry": "Industry"
                },
                "filters": {
                    "my": "My Companies",
                    "my_recently_assigned": "My Recently Assigned Companies"
                },
                "mail_placeholders": {
                    "assigneer": "The user name who assigned the company"
                },
                "workflows": {
                    "triggers": {
                        "created": "Company Created"
                    },
                    "actions": {
                        "fields": {
                            "email_to_company": "Company email",
                            "email_to_owner_email": "Company owner email",
                            "email_to_creator_email": "Company creator email",
                            "email_to_contact": "Company primary contact"
                        }
                    }
                },
                "validation": {
                    "email": {
                        "unique": "A company with this email already exist."
                    }
                },
                "empty_state": {
                    "title": "You have not created any companies.",
                    "description": "Get started by creating a new company."
                }
            },
            "contact": {
                "contact": "Contact",
                "contacts": "Contacts",
                "convert": "Convert to Contact",
                "create": "Create Contact",
                "add": "Add Contact",
                "total": "Total Contacts",
                "import": "Import Contacts",
                "export": "Export Contacts",
                "no_companies_associated": "The contact has no companies associated.",
                "no_deals_associated": "The contact has no deals associated.",
                "works_at": "{job_title} at {company}",
                "create_with": "Create Contact with {name}",
                "associate_with": "Associate Contact with {name}",
                "associated_company": "Associated contact company",
                "dissociate": "Dissociate Contact",
                "exists_in_trash_by_email": "Contact with this email address already exists in the trash, you won't be able to create a new contact with the same email address, would you like to restore the trashed contact?",
                "exists_in_trash_by_phone": "Contact ({contact}) with the following numbers: {phone_numbers}, already exists in the trash, would you like to restore the trashed contact?",
                "possible_duplicate": "Possible duplicate contact {display_name}.",
                "associate_field_info": "Use this field to find and associate exisiting contact instead of creating new one.",
                "cards": {
                    "recently_created": "Recently created contacts",
                    "recently_created_info": "Showing the last {total} created contacts in the last {days} days, sorted by newest on top.",
                    "by_day": "Contacts by day",
                    "by_source": "Contacts by source"
                },
                "count": {
                    "all": "1 contact | {count} contacts"
                },
                "notifications": {
                    "assigned": "You have been assigned to a contact {name} by {user}"
                },
                "filters": {
                    "my": "My Contacts",
                    "my_recently_assigned": "My Recently Assigned Contacts"
                },
                "mail_placeholders": {
                    "assigneer": "The user name who assigned the contact"
                },
                "workflows": {
                    "triggers": {
                        "created": "Contact Created"
                    },
                    "actions": {
                        "fields": {
                            "email_to_contact": "Contact email",
                            "email_to_owner_email": "Contact owner email",
                            "email_to_creator_email": "Contact creator email",
                            "email_to_company": "Contact primary company"
                        }
                    }
                },
                "validation": {
                    "email": {
                        "unique": "A contact or team member with this email already exist."
                    },
                    "phone": {
                        "unique": "A contact with this phone number already exist."
                    }
                },
                "empty_state": {
                    "title": "You have not created any contacts.",
                    "description": "Start organizing the persons now."
                }
            },
            "fields": {
                "phone": {
                    "add": "+ Add another",
                    "copied": "Phone number copied to clipboard",
                    "types": {
                        "type": "Type",
                        "mobile": "Mobile",
                        "work": "Work",
                        "other": "Other"
                    }
                },
                "contacts": {
                    "first_name": "First Name",
                    "last_name": "Last Name",
                    "email": "E-Mail Address",
                    "job_title": "Job Name",
                    "phone": "Phone",
                    "street": "Street Address",
                    "city": "City",
                    "state": "State/Region",
                    "postal_code": "Postal Code",
                    "owner_assigned_date": "Owner Assigned Date",
                    "country": {
                        "name": "Country"
                    },
                    "source": {
                        "name": "Source"
                    },
                    "user": {
                        "name": "Owner"
                    }
                },
                "companies": {
                    "name": "Name",
                    "email": "E-Mail Address",
                    "parent": {
                        "name": "Parent Company"
                    },
                    "phone": "Phone",
                    "street": "Street Address",
                    "city": "City",
                    "state": "State/Region",
                    "postal_code": "Postal Code",
                    "domain": "Domain Name",
                    "owner_assigned_date": "Owner Assigned Date",
                    "country": {
                        "name": "Country"
                    },
                    "industry": {
                        "name": "Industry"
                    },
                    "user": {
                        "name": "Owner"
                    },
                    "source": {
                        "name": "Source"
                    }
                }
            },
            "source": {
                "source": "Source",
                "sources": "Sources",
                "delete_primary_warning": "You cannot delete primary source."
            }
        },
        "deals": {
            "board": {
                "board": "Board",
                "columns_sorted": "Columns successfully sorted"
            },
            "deal": {
                "deal": "Deal",
                "deals": "Deals",
                "create": "Create Deal",
                "add": "Add Deal",
                "sort_by": "Sort deals by",
                "name": "Deal Name",
                "choose_or_create": "Choose or create deal",
                "associate_with": "Associate deal with {name}",
                "add_products": "Add products",
                "dont_add_products": "Don't add products",
                "reopen": "Reopen",
                "won_date": "Won Date",
                "lost_date": "Lost Date",
                "status_related_filter_notice": "This rule is applicable mostly when filtering deals with status \"{status}\".",
                "status": {
                    "status": "Status",
                    "won": "Won",
                    "lost": "Lost",
                    "open": "Open"
                },
                "been_in_stage_time": "Been here for {time}",
                "hasnt_been_in_stage": "This deal has not been in this stage yet",
                "total_created": "Total Created",
                "total_assigned": "Total Assigned",
                "import": "Import Deals",
                "export": "Export Deals",
                "import_in": "Import Deals In {pipeline}",
                "total": "Total Deals",
                "closed_deals": "Closed Deals",
                "won_deals": "Won Deals",
                "open_deals": "Open Deals",
                "lost_deals": "Lost Deals",
                "forecast_amount": "Forecast Amount",
                "closed_amount": "Closed Amount",
                "dissociate": "Dissociate Deal",
                "no_companies_associated": "The deal has no companies associated.",
                "no_contacts_associated": "The deal has no contacts associated.",
                "associate_field_info": "Use this field to associate existing deal instead of creating new one.",
                "create_with": "Create Deal with {name}",
                "already_associated": "This deal is already associated with the {with}.",
                "lost_reasons": {
                    "lost_reason": "Lost Reason",
                    "lost_reasons": "Lost Reasons",
                    "name": "Name",
                    "choose_lost_reason": "Choose a lost reason",
                    "choose_lost_reason_or_enter": "Choose a lost reason or enter manually"
                },
                "settings": {
                    "lost_reason_is_required": "Lost reason is required",
                    "lost_reason_is_required_info": "When enabled, sales agents will be required to choose or enter lost reason when marking deal as lost.",
                    "allow_lost_reason_enter": "Allow sales agents to enter custom lost reason",
                    "allow_lost_reason_enter_info": "When disabled, sales agents will be able to choose only from the predefined list of lost reasons when marking the deal as lost."
                },
                "cards": {
                    "by_stage": "Deals by stage",
                    "lost_in_stage": "Lost deals stage",
                    "lost_in_stage_info": "View in what stage the deals are most lost. The stages shown in the reports are the stages that deal belonged at the time it was marked as lost.",
                    "won_in_stage": "Won deals stage",
                    "won_in_stage_info": "View in what stage the deals are most won. The stages shown in the reports are the stages that deal belonged at the time it was marked as won.",
                    "closing": "Closing deals",
                    "closing_info": "View the deals that are predicted to be closed based on the selected period and the expected close date, the deals marked as \"Won\" or \"Lost\" are excluded from the list.",
                    "recently_created": "Recently created deals",
                    "recently_modified": "Recently modified deals",
                    "won_by_revenue_by_month": "Won deals revenue by month",
                    "won_by_date": "Won deals by day",
                    "assigned_by_sale_agent": "Assigned deals by sales agent",
                    "assigned_by_sale_agent_info": "View the total number of assigned deals for each sale rep. See how much revenue these deals are likely to bring your business. And how much revenue you already have from closed deals.",
                    "created_by_sale_agent": "Created deals by sales agent",
                    "created_by_sale_agent_info": "View which sales reps are creating the most deals. See how much revenue these deals are likely to bring your business. And how much revenue you already have from closed deals.",
                    "recently_created_info": "Showing the last {total} created deals in the last {days} days, sorted by newest on top.",
                    "recently_modified_info": "Showing the last {total} modified deals in the last {days} days.",
                    "won_by_month": "Won deals by month"
                },
                "notifications": {
                    "assigned": "You have been assigned to a deal {name} by {user}"
                },
                "stage": {
                    "weighted_value": "{weighted_total} - {win_probability} of {total}",
                    "changed_date": "Stage Changed Date",
                    "add": "Add New Stage",
                    "name": "Stage Name",
                    "win_probability": "Win Probability",
                    "delete_usage_warning": "The stage is already associated with deals, hence, cannot be deleted."
                },
                "deal_amount": "Deal amount",
                "deal_expected_close_date": "Deal expected close date",
                "count": {
                    "all": "1 deal | {count} deals",
                    "open": "{resource} open deals count",
                    "won": "{resource} won deals count",
                    "lost": "{resource} lost deals count",
                    "closed": "{resource} closed deals count"
                },
                "pipeline": {
                    "name": "Pipeline Name",
                    "pipeline": "Pipeline",
                    "pipelines": "Pipelines",
                    "create": "Create Pipeline",
                    "edit": "Edit Pipeline",
                    "updated": "Pipeline updated successully",
                    "deleted": "Pipeline successfully deleted",
                    "delete_primary_warning": "The primary pipeline cannot be deleted.",
                    "delete_usage_warning_deals": "The pipeline is already associated with deals, hence, cannot be deleted.",
                    "visibility_group": {
                        "primary_restrictions": "This is the primary pipeline, hence, visibility cannot be changed."
                    },
                    "reorder": "Reorder pipelines",
                    "missing_stages": "The pipeline does not have any stages."
                },
                "actions": {
                    "change_stage": "Change Stage",
                    "mark_as_open": "Mark as open",
                    "mark_as_won": "Mark as won",
                    "mark_as_lost": "Mark as lost"
                },
                "filters": {
                    "my": "My Deals",
                    "my_recently_assigned": "My Recently Assigned Deals",
                    "created_this_month": "Deals Created This Month",
                    "won": "Won Deals",
                    "lost": "Lost Deals",
                    "open": "Open Deals"
                },
                "mail_placeholders": {
                    "assigneer": "The user name who assigned the deal"
                },
                "workflows": {
                    "triggers": {
                        "status_changed": "Deal Status Changed",
                        "stage_changed": "Deal Stage Changed",
                        "created": "Deal Created"
                    },
                    "actions": {
                        "mark_associated_activities_as_complete": "Mark Associated Activities as Completed",
                        "mark_associated_deals_as_won": "Mark Associated Deals as Won",
                        "mark_associated_deals_as_lost": "Mark Associated Deals as Lost",
                        "delete_associated_activities": "Delete Associated Activities",
                        "fields": {
                            "email_to_contact": "Deal primary contact",
                            "email_to_company": "Deal primary company",
                            "email_to_owner_email": "Deal owner email",
                            "email_to_creator_email": "Deal creator email",
                            "lost_reason": "With the following lost reason"
                        }
                    }
                },
                "timeline": {
                    "stage": {
                        "moved": "{user} moved deal from {previous} to {stage} stage"
                    },
                    "marked_as_lost": "{user} marked deal as lost with the following reason: {reason}",
                    "marked_as_won": "{user} marked deal as won",
                    "marked_as_open": "{user} marked deal as open"
                },
                "metrics": {
                    "open": "Open Deals"
                },
                "empty_state": {
                    "title": "You have not created any deals.",
                    "description": "Get started by creating a new deal."
                }
            },
            "fields": {
                "deals": {
                    "name": "Deal Name",
                    "expected_close_date": "Expected Close Date",
                    "amount": "Amount",
                    "owner_assigned_date": "Owner Assigned Date",
                    "user": {
                        "name": "Owner"
                    },
                    "stage": {
                        "name": "Stage"
                    },
                    "pipeline": {
                        "name": "Pipeline"
                    }
                }
            }
        },
        "documents": {
            "document": {
                "document": "Document",
                "documents": "Documents",
                "create": "Create Document",
                "info": "Send customizeable quotes, proposals and contracts to close deals faster.",
                "view": "View",
                "manage_documents": "Manage Documents",
                "total_documents": "Total Documents",
                "total_draft_documents": "Total Draft Documents",
                "deleted": "Document successfully deleted",
                "document_details": "Document Details",
                "document_activity": "Document Activity",
                "document_products": "Document Products",
                "download_pdf": "Download PDF",
                "view_pdf": "View PDF in Browser",
                "accept": "Accept",
                "sign": "Sign",
                "sent": "Document sent successfully",
                "deal_description": "When deal is selected, the deal will be automatically associated with the document, deal contacts will be added as signers, and all deal products will be added to the document.",
                "settings": {
                    "inherits_setting_from_brand": "Inherits from brand"
                },
                "products_snippet_missing": "To ensure that the products appear in the document preview and PDF, make sure to add them to the content via the {icon} icon.",
                "signatures_snippet_missing": "To ensure that the signatures appear in the document PDF, make sure to add them to the content via the {icon} icon.",
                "will_use_placeholders_from_record": "The placeholders added in the document content related to the {resourceName} resource will be taken form this record",
                "placeholders_replacement_info": "The placeholders of the document related to resources are replaced based on the first associated record, make sure to add associations to the document.",
                "limited_editing": "This document is accepted, editing abilities are limited.",
                "title": "Title",
                "copy_url": "Copy document public URL",
                "url_copied": "URL copied to clipboard",
                "count": {
                    "all": "1 document | {count} documents"
                },
                "sections": {
                    "details": "Details",
                    "send": "Send",
                    "signature": "Signature",
                    "content": "Content",
                    "products": "Products"
                },
                "status": {
                    "status": "Status",
                    "draft": "Draft",
                    "sent": "Sent",
                    "accepted": "Accepted",
                    "lost": "Lost"
                },
                "send": {
                    "select_brand": "Select a brand first in order to send the document.",
                    "connect_an_email_account": "Connect an mail account in order to send documents.",
                    "send_from_account": "Send the document from the following account",
                    "save_to_schedule": "In order to schedule document sending, you will need to save the document first",
                    "send_subject": "Message Subject",
                    "send_body": "Message Text",
                    "send_later": "Send later?",
                    "send": "Send Document",
                    "select_schedule_date": "Select date and time",
                    "schedule": "Schedule",
                    "is_scheduled": "This document is scheduled to be sent at {date}",
                    "send_to_signers": "Send the document to following signers",
                    "send_to_signers_empty": "In order to send the document to the signers, add signers via the \"Signature\" section."
                },
                "sent_by": "Sent by",
                "sent_at": "Sent at {date}",
                "signers": {
                    "add": "Add new signer",
                    "no_signers": "No signers, add signers for this document.",
                    "is_signed": "Signed?",
                    "document_signers": "Document Signers",
                    "signer_name": "Name",
                    "signer_email": "E-Mail Address",
                    "signature_date": "Date",
                    "name": "Signer Name",
                    "email": "Signer Email",
                    "enter_full_name": "Enter the signer full name",
                    "enter_email": "Please enter your e-mail address",
                    "confirm_email": "Confirm your e-mail address"
                },
                "accepted_at": "Accepted At",
                "signature": {
                    "no_signature": "No Signature",
                    "no_signature_description": "This document does not require a signature before acceptance.",
                    "e_signature": "Use e-signature",
                    "e_signature_description": "This document require e-signature before acceptance.",
                    "signature": "Signature",
                    "signatures": "Signatures",
                    "signed_on": "Signed on",
                    "sign_ip": "IP Address",
                    "verification_failed": "We were unable to verify your email address as a signer, contact the person that sent you the document to give information about the email address that is used.",
                    "accept_name": "To accept, type your name below"
                },
                "reactivated": "Document reactivated",
                "marked_as_lost": "Document successfully marked as lost",
                "marked_as_accepted": "Document successfully marked as accepted",
                "actions": {
                    "mark_as_lost": "Mark as Lost",
                    "mark_as_lost_message": "This action will mark this document as lost and none of the recipients will no longer be able to access it",
                    "mark_as_accepted": "Mark as Accepted",
                    "reactivate": "Reactivate",
                    "undo_acceptance": "Undo acceptance"
                },
                "cards": {
                    "by_type": "Documents by type",
                    "by_status": "Documents by status",
                    "sent_by_day": "Sent documents by day"
                },
                "recipients": {
                    "add": "Add new recipient",
                    "enter_full_name": "Enter the recipient full name",
                    "enter_email": "Enter the recipient e-mail address",
                    "no_recipients": "No recipients to send to document to.",
                    "is_sent": "Sent?",
                    "recipients": "Recipients",
                    "additional_recipients": "Additional recipients",
                    "recipient_name": "Name",
                    "recipient_email": "E-Mail Address",
                    "name": "Recipient Name",
                    "email": "Recipient Email"
                },
                "view_type": {
                    "html_view_type": "HTML view type",
                    "template_info": "When a template has a view type, after inserted, the document view type will be updated with the template type.",
                    "nav_top": {
                        "name": "Navigation Top",
                        "description": "Useful for simple documents that require no navigation via headings."
                    },
                    "nav_left": {
                        "name": "Navigation Left",
                        "description": "Useful for documents that require navigation via headings ({headingTagName})."
                    },
                    "nav_left_full_width": {
                        "name": "Navigation Left - Full Width",
                        "description": "The content section has no margin, useful for full width documents with headings ({headingTagName})."
                    }
                },
                "type": {
                    "type": "Document Type",
                    "types": "Document Types",
                    "name": "Name",
                    "default_type": "Default Document Type",
                    "delete_primary_warning": "You cannot delete primary document type.",
                    "delete_usage_warning": "The type is already associated with documents, hence, cannot be deleted.",
                    "delete_is_default": "This is a default document type, hence, cannot be deleted.",
                    "cannot_change_visibility_on_default": "This is a default company wide type, hence, the visibility cannot be changed."
                },
                "template": {
                    "insert_template": "Insert Template",
                    "save_as_template": "Save as Template",
                    "manage": "Manage templates",
                    "template": "Document Template",
                    "templates": "Document Templates",
                    "create": "Create Template",
                    "name": "Template Name",
                    "deleted": "Template successfully deleted",
                    "share_with_team_members": "Share this template with other team members?",
                    "is_shared": "Shared",
                    "empty_state": {
                        "title": "You have not created any templates.",
                        "description": "Create documents faster by using predefined templates."
                    }
                },
                "workflows": {
                    "triggers": {
                        "status_changed": "Document Status Changed"
                    },
                    "actions": {
                        "fields": {
                            "email_to_contact": "Document primary contact",
                            "email_to_company": "Document primary company",
                            "email_to_owner_email": "Document owner email",
                            "email_to_creator_email": "Document creator email"
                        }
                    }
                },
                "timeline": {
                    "heading": "Document Created"
                },
                "mail_placeholders": {
                    "assigneer": "The user name who assigned the document"
                },
                "notifications": {
                    "signed": "The {title} document has been signed",
                    "assigned": "You have been assigned to document {title} by {user}",
                    "accepted": "The {title} document has been accepted",
                    "viewed": "The {title} document has been viewed"
                },
                "filters": {
                    "status_disabled": "Status is used in the current filter, hence, you cannot select status from this section"
                },
                "activity": {
                    "created": "The document has been created by {user}",
                    "sent": "The document has been sent by {user}",
                    "marked_as_lost": "{user} marked the document as lost",
                    "marked_as_accepted": "{user} marked the document as accepted",
                    "marked_as_draft": "{user} marked the document as draft",
                    "sent_recipient": "{name} - {email}",
                    "signed": "The document signed by {signer_name}",
                    "accepted": "The document was accepted",
                    "viewed": "The document was viewed",
                    "downloaded": "The document PDF was downloaded"
                },
                "empty_state": {
                    "title": "You have not created any documents.",
                    "description": "Close deals faster by sending good looking trackable documents."
                }
            },
            "fields": {
                "documents": {
                    "title": "Document Title",
                    "owner_assigned_date": "Owner Assigned Date",
                    "accepted_at": "Accepted At",
                    "amount": "Amount",
                    "original_date_sent": "Original Date Sent",
                    "last_date_sent": "Last Date Sent",
                    "brand": {
                        "name": "Brand"
                    },
                    "user": {
                        "name": "Owner"
                    },
                    "type": {
                        "name": "Type"
                    }
                }
            },
            "pdf": {
                "default_font": "Default font family",
                "default_font_info": "The {fontName} font gives the most decent Unicode character coverage by default, make sure to select a proper font if special or unicode characters are not displayed properly on the PDF document.",
                "size": "Size",
                "orientation": "Orientation",
                "orientation_portrait": "Portrait",
                "orientation_landscape": "Landspace",
                "settings": "PDF Settings",
                "padding": "PDF padding",
                "no_padding": "No additional padding"
            }
        },
        "mailclient": {
            "inbox": {
                "inbox": "Inbox",
                "shared": "Shared Inbox",
                "new_message": "New Message",
                "trash": "Move To Trash",
                "move_to": "Move To",
                "forward": "Forward",
                "reply": "Reply",
                "reply_all": "Reply All",
                "reply_to_message": "Reply to {subject}",
                "forward_message": "Forward {subject}",
                "forwarded_message_placeholder": "{pre} Forwarded message {after}<br />\n                                        From: {from}<br />\n                                        Date: {date}<br />\n                                        Subject: {subject}<br />\n                                        To: {to}",
                "message_sent": "Message sent successfully.",
                "search_recipients": "Search or enter an email address...",
                "send": "Send",
                "sync_in_progress": "The system is currently synchronizing the accounts in background, try again later.",
                "synchronize": "Synchronize",
                "subject": "Subject",
                "no_subject": "No Subject",
                "unknown_address": "Unknown",
                "from": "From",
                "to": "To",
                "cc": "Cc",
                "bcc": "Bcc",
                "reply_to": "Reply To",
                "date": "Date",
                "unread_count": "Total Unread Emails",
                "pre_send_empty_placeholders_found": "You are about to send an email with empty placeholders. Before proceeding, please confirm that you really want to proceed with this action.",
                "will_use_placeholders_from_record": "The placeholders added in the message content related to the {resourceName} resource will be taken form this record",
                "filters": {
                    "is_read": "Is Read"
                }
            },
            "mail": {
                "compose": "Compose",
                "attachments": "Attachments",
                "emails": "Emails",
                "create": "Create Email",
                "send": "Send Email",
                "view": "View Mail",
                "from_header": "From Header",
                "from_name": "From Name",
                "messages": "Email Messages",
                "message": "Email Message",
                "new_message_placeholder": "Compose your email here. Type \"{trigger}\" to search dynamic fields.",
                "signature": "Email Signature",
                "signature_info": "Create signature that will be added to the bottom of your messages.",
                "show_quoted_content": "Show quoted content",
                "trimmed_content": "Trimmed Content",
                "disable_sync": "Disable Sync",
                "manage_emails": "Manage Emails",
                "info": "You can send and reply to emails directly via this section.",
                "from_header_info": "What people will see in the \"from address\" when they receive an email from this email address.",
                "placeholders_info": "Use {placeholders} placeholders to dynamically replace the content like company name, agent name (user who sends the email).",
                "mark_as_read": "Mark as read",
                "mark_as_unread": "Mark as unread",
                "message_queued_for_sending": "The message has been queued for sending, will be synchronized on the next sync batch.",
                "initial_sync_info": "This account is queued for initial sync and the synchronization will be performed as soon as the cron job runs, to prevent any synchronization interruptions, make sure the you have configured the cron job as explained in the documentation.",
                "account": {
                    "create_contact": "Create Contact record if record does not exists.",
                    "use_aliass": "Use alias email address",
                    "use_aliass_info": "The address needs to be a valid alias that already exists in the mail server, useful when using Google Workspace aliases.",
                    "enter_alias": "Alias E-Mail Address",
                    "personal": "Personal",
                    "shared": "Shared",
                    "accounts": "Email Accounts",
                    "sync_emails_from": "Sync emails from",
                    "sync_period_now": "Now",
                    "sync_period_1_month_ago": "1 month ago",
                    "sync_period_3_months_ago": "3 months ago",
                    "sync_period_6_months_ago": "6 months ago",
                    "sync_period_note": "In most cases you won't need and interact with all the emails from {date}, lower starting sync period will avoid importing hundreds of emails with attachments and helps save storage space, choosing a lower starting sync period is always recommended.",
                    "integration_not_configured": "There are no email accounts configured, configure personal or shared email accounts in order to send emails.",
                    "already_connected": "This email account is already connected.",
                    "select_type": "Select account type",
                    "no_active_folders": "This account has no active folders. Enable active folders by editing the mail account, the active folders will be the folders that will be synchronized to the application.",
                    "activate_folders": "Activate Folders",
                    "active_folders": "Active folders",
                    "active_folders_info": "Select the folders you wish to synchronize.",
                    "sent_folder": "Sent Folder",
                    "trash_folder": "Trash Folder",
                    "test_connection": "Test Connection",
                    "is_primary": "Primary Account",
                    "connection_error": "Connection test error, please check your configuration, refer to the error for more information: {message}",
                    "create": "Create Email Account",
                    "edit": "Edit Email Account",
                    "manage": "Manage Accounts",
                    "connect": "Connect Account",
                    "connect_shared": "Connect Shared Account",
                    "connect_personal": "Connect Personal Account",
                    "created": "Email account successfully added.",
                    "updated": "Email account successfully updated.",
                    "deleted": "Email account successfully deleted",
                    "no_accounts_configured": "No email accounts configured",
                    "no_accounts_configured_info": "Connect an account to start sending and organize emails in order close deals faster",
                    "create_shared_info": "Connect a company email account such as contact{'@'}company.com or sales{'@'}company.com",
                    "create_shared_confirmation_message": "When you connect a shared email account, be aware that shared email accounts can be accessed by all of the team members who have been granted \"access to shared inbox\". <br /> <br />\n        This means that each team member will be able to view and interact with the mails.",
                    "missing_sent_folder": "Action required, select the sent folder for this account.",
                    "missing_trash_folder": "Action required, select the trash folder for this account.",
                    "missing_primary_account": "Action required, configure a primary account for sending emails.",
                    "type": "Account Type",
                    "email_address": "Email Address",
                    "password": "Password",
                    "username": "Username",
                    "incoming_mail": "Incoming Mail (IMAP)",
                    "outgoing_mail": "Outgoing Mail (SMTP)",
                    "server": "Server",
                    "port": "Port",
                    "allow_non_secure_certificate": "Allow non-secure certificate",
                    "encryption": "Encryption",
                    "without_encryption": "Without Encryption",
                    "delete_warning": "If you are using this email account as \"System Email Account\" in settings, you will need to select another account for sending system related mails, additionally, you will need to check your workflows, if any workfow is configured to use the \"Send Email\" action with this particular email account, you will need to update the action mail account in order the workflow to continue sending mails.",
                    "featured": {
                        "sync": "2-way email sync with your email provider.",
                        "save_time": "Save time by making use of predefined templates.",
                        "placeholders": "Compose emails and templates with placeholders.",
                        "signature": "Add customized signature for a more professional look.",
                        "associations": "Associate emails to many {resources} and {resource}.",
                        "types": "Connect via IMAP, your Gmail or Outlook account."
                    }
                },
                "templates": {
                    "select": "Select",
                    "create": "Create Template",
                    "name": "Name",
                    "subject": "Subject",
                    "is_shared": "Share this template with other team members?",
                    "body": "Body",
                    "templates": "Templates",
                    "created": "Mail template successfully created.",
                    "updated": "Mail template successfully updated.",
                    "deleted": "Mail template successfully deleted"
                },
                "labels": {
                    "CATEGORY_PERSONAL": "Personal",
                    "CATEGORY_SOCIAL": "Social",
                    "CATEGORY_FORUMS": "Forums",
                    "IMPORTANT": "Important",
                    "CATEGORY_UPDATES": "Updates",
                    "CATEGORY_PROMOTIONS": "Promotions",
                    "CHAT": "Chat",
                    "SENT": "Sent",
                    "INBOX": "Inbox",
                    "TRASH": "Trash",
                    "DRAFT": "Draft",
                    "DRAFTS": "DRAFTS",
                    "SPAM": "Spam",
                    "STARRED": "Starred",
                    "UNREAD": "Unread"
                },
                "workflows": {
                    "actions": {
                        "send": "Send Email"
                    },
                    "fields": {
                        "from_account": "From email account",
                        "subject": "With subject",
                        "message": "With message",
                        "to": "To",
                        "send_from_owner_primary_account": "Owner Primary Email Account"
                    }
                },
                "validation": {
                    "invalid_recipients": "It looks like some of your recipients has invalid address."
                }
            },
            "schedule": {
                "send_later": "Send Later",
                "choose_date": "Choose date",
                "schedule": "Schedule",
                "scheduled_emails": "Scheduled Emails",
                "cancel_and_delete": "Cancel and delete",
                "message_scheduled": "The message was scheduled to be sent later",
                "will_retry_at": "Will retry at: {date}",
                "send_now": "Send Now",
                "scheduled_at": "Date Scheduled",
                "sent_at": "Date Sent",
                "scheduled_by": "Scheduled By",
                "status": "Status",
                "statuses": {
                    "pending": "Pending",
                    "sent": "Sent",
                    "sending": "Sending",
                    "failed": "Failed"
                }
            }
        },
        "notes": {
            "note": {
                "notes": "Notes",
                "note": "Note",
                "add": "Add Note",
                "create_notes": "Create Notes",
                "manage_notes": "Manage Notes",
                "info": "You can create notes for you and your team and keep track of important info here.",
                "info_created": "{user} left a note on {date}",
                "follow_up_task_body": "Regarding a note: {content}",
                "write": "Write a note...",
                "created": "Note successfully created",
                "updated": "Note successfully updated",
                "deleted": "Note successfully deleted",
                "timeline": {
                    "heading": "New note has been created"
                }
            }
        },
        "themestyle": {
            "style": {
                "theme_style": "Theme Style",
                "lightness_maximum": "Lightness Maximum",
                "lightness_minimum": "Lightness Minimum"
            }
        },
        "translator": {
            "translator": {
                "translator": "Translator",
                "new_locale": "New Locale",
                "create_new_locale": "Create New Locale",
                "locale_name": "Locale Name",
                "group_has_unsaved_translations": "The group has unsaved translations!",
                "changes_not_saved": "You haven't saved the translations for this group, to prevent losing your translations, save the group by clicking the Save button located at the bottom of the page.",
                "tools": {
                    "json-language": "Generate JSON language file."
                }
            }
        },
        "users": {
            "profile": {
                "update": "Update Profile",
                "profile": "Profile",
                "updated": "Profile successfully updated",
                "password_updated": "Password successfully updated",
                "avatar_info": "Upload your avatar so you team members can recognize your profile easily.",
                "profile_info": "Update your profile, including the email signature and login e-mail address.",
                "localization_info": "Tailor your profile localization as you require.",
                "notifications_info": "Decide which communications you'd like to receive and how.",
                "password_info": "Update your account password, for a more secure password, get use of the password generator."
            },
            "team": {
                "teams": "Teams",
                "team": "Team",
                "add": "Add Team",
                "create": "Create New Team",
                "edit": "Edit Team",
                "name": "Team name",
                "members": "Team members",
                "description": "Team description",
                "owner_team": "Owner Team",
                "select": "Select teams",
                "manager": "Manager",
                "your_teams": "Your Team|Your Teams",
                "managing_teams": "All of the teams and people you are managing.",
                "capabilities": {
                    "team_only": "Team Only"
                },
                "empty_state": {
                    "title": "No teams",
                    "description": "Get started by creating a new team."
                }
            },
            "user": {
                "user": "User",
                "users": "Users",
                "not_found": "No users found",
                "create": "Create User",
                "invite": "Invite User",
                "send_invitation": "Send Invitation",
                "accept_invitation": "Accept Invitation",
                "invited": "User invitation sent",
                "admin_users_excluded": "Admin users are excluded",
                "select": "Select users",
                "invitation_expires_after_info": "A mail with invitation link will be sent to the user to create an account, the link will be valid for {total} days and will be invalidated after the account is created.",
                "edit": "Edit User",
                "sales_agent": "Sales Agent",
                "name": "Name",
                "email": "E-Mail Address",
                "roles": "User Roles",
                "localization": "Localization",
                "enable_api": "Enable API Access",
                "super_admin": "Super Admin",
                "as_super_admin_info": "Enabling super admin access for the user will give full access to all features without any limitations.",
                "allow_api_info": "Allow the user to generate API tokens and use the tokens go make requests to the application endpoints.",
                "assign": "Assign",
                "not_authorized": "Your account is not authorized to perform this action.",
                "delete_transfer_to_same_user_warning": "You cannot transfer the data to the same user.",
                "delete_own_account_warning": "You cannot delete your own account.",
                "transfer_data_info": "The data for this user needs to be transferred to another user. Select user where you want to transfer the data.",
                "actions": {
                    "delete": "Delete User"
                },
                "notifications": {
                    "user_mentioned": "You have been mention by {name}"
                }
            }
        },
        "webforms": {
            "form": {
                "forms": "Web Forms",
                "form": "Web Form",
                "created": "Web form successfully added.",
                "updated": "Web form successfully updated.",
                "deleted": "Web form successfully deleted",
                "submission": "Web Form Submission",
                "total_submissions": "Submissions: {total}",
                "editor": "Editor",
                "submit_options": "Submit Options",
                "info": "Create customizeable web forms that can be embedded into your existing web site or share the forms as link to automatically create, deals, contacts and companies.",
                "inactive_info": "This form is inactive, you are able to preview the form because you are logged in, if you want the form to be publicly available, make sure to set the form as active.",
                "create": "Create Web Form",
                "active": "Active",
                "title": "Title",
                "title_visibility_info": "The title is not visible to the visitors that will be filling the form.",
                "fields_action_required": "Additional action required",
                "required_fields_needed": "To save new deals you must add at least contact email or phone field.",
                "must_requires_fields": "To save new deals, the web form must requires at least contact email or phone field.",
                "non_optional_fields_required": "Non optional fields required",
                "notifications": "Notifications",
                "notification_email_placeholder": "Enter email address",
                "new_notification": "+ Add Email",
                "no_sections": "This web form has no sections defined.",
                "style": {
                    "style": "Style",
                    "primary_color": "Primary Color",
                    "background_color": "Background Color",
                    "logo": "Display a logo on top of the form"
                },
                "success_page": {
                    "success_page": "Success Page",
                    "success_page_info": "What should happen after a visitor submits this form?",
                    "thank_you_message": "Display thank you message",
                    "redirect": "Redirect to another website",
                    "title": "Title",
                    "title_placeholder": "Enter text for the success message.",
                    "message": "Message",
                    "redirect_url": "Webiste URL",
                    "redirect_url_placeholder": "Enter URL to redirect after the form is submitted."
                },
                "saving_preferences": {
                    "saving_preferences": "Saving preferences",
                    "deal_title_prefix": "Deal title prefix",
                    "deal_title_prefix_info": "For each newly created deal via the form, the deal name will be prefixed with the text added in the field for easier recognition."
                },
                "sections": {
                    "new": "Add new section",
                    "type": "Section type",
                    "types": {
                        "input_field": "Input Field",
                        "message": "Message",
                        "file": "File"
                    },
                    "field": {
                        "resourceName": "Field for"
                    },
                    "introduction": {
                        "introduction": "Introduction",
                        "title": "Title",
                        "message": "Message"
                    },
                    "message": {
                        "message": "Message"
                    },
                    "file": {
                        "file": "File",
                        "files": "Files",
                        "multiple": "Allow multiple files upload?"
                    },
                    "submit": {
                        "button": "Submit Button",
                        "default_text": "Submit",
                        "button_text": "Button text",
                        "spam_protected": "Spam protected?",
                        "require_privacy_policy": "Require privacy policy consent",
                        "privacy_policy_url": "Privacy policy URL"
                    },
                    "embed": {
                        "embed": "Embed"
                    }
                }
            }
        },
        "core": {
            "actions": {
                "action": "Action",
                "actions": "Actions",
                "select": "Select Action",
                "confirmation_message": "Are you sure you want to perform this action?",
                "run_successfully": "The action run successfully.",
                "search_in_google": "Search In Google",
                "bulk_edit": "Bulk Edit",
                "records_count": "1 record | {count} records"
            },
            "api": {
                "api": "API",
                "access": "API Access",
                "access_tokens": "Access Tokens",
                "personal_access_tokens": "Personal Access Tokens",
                "personal_access_token": "Personal Access Token",
                "create_token": "Create New Token",
                "no_tokens": "You have not created any personal access tokens.",
                "token_name": "Name",
                "revoke_token": "Revoke",
                "token_last_used": "Last Used",
                "after_token_created_info": "Here is your new personal access token. This is the only time it will be shown so don't lose it!\n    You may now use this token to make API requests.",
                "empty_state": {
                    "description": "Use tokens to make API requests outside of the application."
                },
                "token_delete_warning": "Please note that if you delete your API token, it will immediately invalidate the token. This means any external services or code integrations using this token will stop to function. Ensure to remove or replace the token in all your implementations to prevent disruptions."
            },
            "app": {
                "delete": "Delete",
                "confirm": "Confirm",
                "cancel": "Cancel",
                "clear": "Clear",
                "save": "Save",
                "saved": "Saved.",
                "send": "Send",
                "save_and_exit": "Save & Exit",
                "exit": "Exit",
                "edit": "Edit",
                "copy": "Copy",
                "copy_link": "Copy Link",
                "copy_api_key": "Copy API Key",
                "clone": "Clone",
                "create": "Create",
                "change": "Change",
                "remove": "Remove",
                "hide": "Hide",
                "active": "Active",
                "view_details": "Details",
                "system_info": "System Info",
                "add_note": "Add Note",
                "add_another": "Add Another",
                "is_primary": "Primary",
                "is_default": "Default",
                "note_is_private": "Private note",
                "create_and_add_another": "Create & Add Another",
                "create_and_go_to_list": "Create & Go To List",
                "purchase_key": "Purchase Key",
                "enter_purchase_key": "Enter your purchase key",
                "privacy_policy": "Privacy Policy",
                "copied": "Text copied to clipboard",
                "insert_new_line": "Insert new line",
                "reset": "Reset",
                "optional": "Optional",
                "not_enough_data": "Not enough data to display",
                "no_search_results": "There are no results matching your search criteria",
                "recent_search_history": "Recent Search History",
                "discard_changes": "Discard Changes",
                "agree_to_privacy_policy": "By using this form you agree with the storage and handling of your data by this website in accordance with our {privacyPolicyLink}",
                "id": "ID",
                "deleted_at": "Deleted At",
                "apply": "Apply",
                "reload": "Reload",
                "loading": "Loading...",
                "please_wait": "Please wait...",
                "preview": "Preview",
                "address": "Address",
                "continue": "Continue",
                "open_in_app": "Open In App",
                "locale": "Locale",
                "details": "Details",
                "sort": "Sort",
                "expand": "Expand",
                "show_less": "Show Less",
                "show_all": "Show All",
                "has_more": "+{count} more",
                "throttle_error": "Too many requests, try again later.",
                "file_preview": "File Preview",
                "integrations": "Integrations",
                "attachments": "Attachments",
                "attach": "Attach",
                "changelog": "Changelog",
                "go_back": "Go Back",
                "back": "Back",
                "attach_files": "Attach Files",
                "file_too_large": "File too large, increase max upload size.",
                "no_attachments": "There are no attachments uploaded.",
                "download": "Download",
                "remember_selection": "Remember my selection for next time",
                "token_expired": "Sorry, your session has expired.",
                "all_caught_up": "You're all caught up!",
                "view_record": "View",
                "list_view": "List",
                "reminder_set_for": "Reminder set for {value} {type} before",
                "reminder_before_due": "before due",
                "integration_not_configured": "Integration is not configred",
                "associate_with_record": "Associate with records",
                "address_information": "Address Information",
                "search": "Search...",
                "type_to_search": "Type to search...",
                "type_more_to_search": "Type {characters} more characters to perform search...",
                "search_records": "Search records",
                "allowed_extensions": "Allowed upload extensions",
                "allowed_extensions_info": "Enter coma separated extensions to be whitelisted for file storage.",
                "last_modified_at": "Last Modified",
                "created_at": "Created At",
                "updated_at": "Updated At",
                "created_by": "Created By",
                "creation_date": "Creation Date",
                "drop_files": "Drop files to upload",
                "choose_image": "Choose Image",
                "ascending": "Ascending",
                "descending": "Descending",
                "sort_ascending": "Sort ascending",
                "sort_descending": "Sort descending",
                "upload": "Upload",
                "upload_avatar": "Upload Avatar",
                "avatar": "Avatar",
                "quick_create": "Quick Create",
                "no_owner": "No Owner",
                "owner_email_address": "Owner Email Address",
                "associate": "Associate",
                "timezone": "Timezone",
                "currency": "Currency",
                "system_default": "System Default",
                "auto_detect": "Auto Detect",
                "all": "All",
                "see_all": "See All",
                "select_file": "Select File",
                "file": "File",
                "form_validation_failed": "Form validation failed, check all fields",
                "form_validation_failed_with_sections": "Form validation failed, check the all of the sections and fields",
                "advanced": "Advanced",
                "yes": "Yes",
                "no": "No",
                "no_associations": "No associations",
                "associated_with_total_records": "Associated with {count} record|Associated with {count} records",
                "action_not_authorized": "Your account is not authorized to perform this action",
                "record_view": {
                    "manage_sidebar": "Manage sidebar sections",
                    "sections": {
                        "edit_heading": "Manage Sections",
                        "edit_subheading": "Reorder sections or toggle visibility",
                        "details": "Details"
                    }
                },
                "soft_deletes": {
                    "trashed": "Trashed",
                    "trashed_records": "Trashed Records",
                    "restore": "Restore",
                    "force_delete": "Permenently Delete",
                    "move_to_trash": "Move to Trash",
                    "empty_trash": "Empty Trash",
                    "trashed_pruning_info": "Trashed records will be deleted after {total} days."
                },
                "logo": {
                    "light": "Light Logo",
                    "dark": "Dark Logo"
                },
                "cards": {
                    "creation_date_info": "This card only reflects records that were created during the selected date range."
                },
                "theme": {
                    "switch_light": "Switch to light mode",
                    "switch_system": "Switch to system theme",
                    "switch_dark": "Switch to dark mode"
                },
                "menu": {
                    "metrics": {
                        "metrics": "Metrics",
                        "refresh_interval": "The metrics are refreshed every {interval} minutes."
                    }
                },
                "visibility_group": {
                    "visible_to": "Visible to",
                    "all": "Entire company"
                },
                "export": {
                    "export": "Export",
                    "type": "Type",
                    "select_range": "Select Range",
                    "apply_filters": "Export records based on the applied filters?"
                },
                "company": {
                    "name": "Company Name",
                    "country": "Country"
                },
                "password_generator": {
                    "heading": "Generate Password",
                    "strength": "Strength",
                    "length": "Length",
                    "digits": "Digits",
                    "symbols": "Symbols",
                    "weak": "Weak",
                    "average": "Average",
                    "strong": "Strong",
                    "secure": "Secure",
                    "copied": "Password copied to clipboard"
                },
                "weekdays": {
                    "monday": "Monday",
                    "tuesday": "Tuesday",
                    "wednesday": "Wednesday",
                    "thursday": "Thursday",
                    "friday": "Friday",
                    "saturday": "Saturday",
                    "sunday": "Sunday"
                },
                "colors": {
                    "color": "Color",
                    "colors": "Colors",
                    "remove": "Remove Color",
                    "palettes": "Color Palettes"
                }
            },
            "contentbuilder": {
                "snippets": {
                    "basic": "Basic",
                    "text": "Text",
                    "headline": "Headline",
                    "buttons": "Buttons",
                    "photos": "Photos",
                    "profile": "Profile",
                    "contact": "Contact",
                    "products": "Products",
                    "features": "Features",
                    "process": "Process",
                    "pricing": "Pricing",
                    "skills": "Skills",
                    "achievements": "Achievements",
                    "quotes": "Quotes",
                    "partners": "Partners",
                    "as_featured_on": "As Featured On",
                    "help_and_faq": "Help, FAQ"
                },
                "builder": {
                    "Bold": "Bold",
                    "Italic": "Italic",
                    "Hyperlink": "Hyperlink",
                    "Align": "Align",
                    "Paragraph": "Paragraph",
                    "Color": "Color",
                    "Formatting": "Formatting",
                    "List": "List",
                    "Text Settings": "Text Settings",
                    "Icon": "Icon",
                    "Clean": "Clean",
                    "Font": "Font",
                    "Previous": "Previous",
                    "Next": "Next",
                    "More": "More",
                    "Move Up": "Move Up",
                    "Move Down": "Move Down",
                    "Move Left": "Move Left",
                    "Move Right": "Move Right",
                    "Delete": "Delete",
                    "Add": "Add",
                    "Move": "Move",
                    "Duplicate": "Duplicate",
                    "Decrease": "Decrease",
                    "Increase": "Increase",
                    "HTML": "HTML",
                    "Headline": "Headline",
                    "Image": "Image",
                    "Heading 1": "Heading 1",
                    "Heading 2": "Heading 2",
                    "Heading 3": "Heading 3",
                    "Quote": "Quote",
                    "Preformatted": "Preformatted",
                    "Table": "Table",
                    "Spacer": "Spacer",
                    "Horizontal Line": "Horizontal Line",
                    "More...": "More...",
                    "Enlarge": "Enlarge",
                    "Ok": "Ok",
                    "Align Left": "Align Left",
                    "Align Center": "Align Center",
                    "Align Right": "Align Right",
                    "Align Full": "Align Full",
                    "Bullets": "Bullets",
                    "Numbering": "Numbering",
                    "Indent": "Indent",
                    "Outdent": "Outdent",
                    "Heading 4": "Heading 4",
                    "Underline": "Underline",
                    "Strikethrough": "Strikethrough",
                    "Superscript": "Superscript",
                    "Subscript": "Subscript",
                    "Uppercase": "Uppercase",
                    "Clear": "Clear",
                    "Choose..": "Choose..",
                    "Forecolor": "Forecolor",
                    "Backcolor": "Backcolor",
                    "Apply": "Apply",
                    "Cancel": "Cancel",
                    "Change Image": "Change Image",
                    "Link": "Link",
                    "Edit": "Edit",
                    "Source": "Source",
                    "Settings": "Settings",
                    "Change Icon": "Change Icon",
                    "Edit Table": "Edit Table",
                    "Select": "Select",
                    "Open new window": "Open new window",
                    "Open New Window": "Open New Window",
                    "Text": "Text",
                    "Title": "Title",
                    "Free": "Free",
                    "Style": "Style",
                    "Layout": "Layout",
                    "Background": "Background",
                    "Select Color": "Select Color",
                    "Text Color": "Text Color",
                    "Border Thickness": "Border Thickness",
                    "Border Color": "Border Color",
                    "Apply To": "Apply To",
                    "Current Row": "Current Row",
                    "Current Column": "Current Column",
                    "Even Rows": "Even Rows",
                    "Odd Rows": "Odd Rows",
                    "Current Cell": "Current Cell",
                    "Insert Row": "Insert Row",
                    "Insert Column": "Insert Column",
                    "Delete Row": "Delete Row",
                    "Delete Column": "Delete Column",
                    "Above": "Above",
                    "Below": "Below",
                    "Left": "Left",
                    "Right": "Right",
                    "Row": "Row",
                    "Column": "Column",
                    "Merge": "Merge",
                    "Merge Cell": "Merge Cell",
                    "css": "css",
                    "Class": "Class",
                    "Box": "Box",
                    "Spacing": "Spacing",
                    "Border": "Border",
                    "Corners": "Corners",
                    "Shadow": "Shadow",
                    "Display": "Display",
                    "Position": "Position",
                    "Effects": "Effects",
                    "Attributes": "Attributes",
                    "Animation": "Animation",
                    "Background Color": "Background Color",
                    "Gradient": "Gradient",
                    "Dimension": "Dimension",
                    "Responsive Positioning": "Responsive Positioning",
                    "Reset margin left on small screen": "Reset margin left on small screen",
                    "Reset margin right on small screen": "Reset margin right on small screen",
                    "Individual Sides": "Individual Sides",
                    "Select Font": "Select Font",
                    "Animate": "Animate",
                    "Delay": "Delay",
                    "Duration": "Duration",
                    "Animate Once": "Animate Once",
                    "Test": "Test",
                    "TEST": "TEST",
                    "Custom": "Custom",
                    "Module Settings": "Module Settings",
                    "Drag and drop an image or click to browse.": "Drag and drop an image or click to browse.",
                    "Are you sure you want to delete this block?": "Are you sure you want to delete this block?",
                    "Back": "Back",
                    "Or Specify Image Source": "Or Specify Image Source",
                    "Preferences": "Preferences",
                    "Hide element tool": "Hide element tool",
                    "Hide column tool": "Hide column tool",
                    "Line": "Line",
                    "Hide column HTML editor": "Hide column HTML editor",
                    "Hide row HTML editor": "Hide row HTML editor",
                    "Hide row move (up/down) buttons": "Hide row move (up/down) buttons",
                    "HTML syntax highlighting": "HTML syntax highlighting",
                    "Scrollable Editing Toolbar": "Scrollable Editing Toolbar",
                    "Toolbar position": "Toolbar position",
                    "Top": "Top",
                    "Toolbar visibility": "Toolbar visibility",
                    "Auto": "Auto",
                    "Always Visible": "Always Visible",
                    "Paste result": "Paste result",
                    "HTML (without styles)": "HTML (without styles)",
                    "HTML (with styles)": "HTML (with styles)",
                    "Text only": "Text only",
                    "Add Snippet": "Add Snippet",
                    "Grid Tool": "Grid Tool",
                    "Element Tool": "Element Tool",
                    "Builder Mode": "Builder Mode",
                    "Default": "Default",
                    "Minimal": "Minimal",
                    "Hide outline": "Hide outline",
                    "Hide element highlight": "Hide element highlight",
                    "Row tool position": "Row tool position",
                    "Add (+) button placement": "Add (+) button placement",
                    "Between Blocks (left)": "Between Blocks (left)",
                    "Between Blocks (center)": "Between Blocks (center)",
                    "Outline Mode": "Outline Mode",
                    "Row & column": "Row & column",
                    "Row only": "Row only",
                    "Draggable blocks without handle": "Draggable blocks without handle",
                    "Animated drag to sort": "Animated drag to sort",
                    "Open snippets sidebar on start": "Open snippets sidebar on start",
                    "Scrollable toolbar (top only)": "Scrollable toolbar (top only)",
                    "Please select a block": "Please select a block",
                    "Open snippet sidebar on start": "Open snippet sidebar on start",
                    "Hide snippet handle": "Hide snippet handle",
                    "Undo": "Undo",
                    "Redo": "Redo",
                    "Empty": "Empty",
                    "+ Click to add content": "+ Click to add content",
                    "B": "B",
                    "W": "W",
                    "Outline Style": "Outline Style",
                    "Colored": "Colored",
                    "Gray": "Gray",
                    "Hide Outline": "Hide Outline",
                    "Hide Column Tool": "Hide Column Tool",
                    "Row Tool Position": "Row Tool Position",
                    "Tool Style": "Tool Style",
                    "Hide Snippet (+) Tool": "Hide Snippet (+) Tool",
                    "Tool Outline": "Tool Outline",
                    "Button": "Button",
                    "Button Editor": "Button Editor",
                    "Edit Button": "Edit Button",
                    "Grid Editor": "Grid Editor",
                    "Outline": "Outline",
                    "Font Size": "Font Size",
                    "Line Spacing": "Line Spacing",
                    "Letter Spacing": "Letter Spacing",
                    "Close": "Close",
                    "Search & Replace": "Search & Replace",
                    "Word Count": "Word Count",
                    "words": "words",
                    "Characters": "Characters",
                    "Characters (no spaces)": "Characters (no spaces)",
                    "Add to Left": "Add to Left",
                    "Add to Right": "Add to Right",
                    "Border Top Color": "Border Top Color",
                    "Border Bottom Color": "Border Bottom Color",
                    "Border Left Color": "Border Left Color",
                    "Border Right Color": "Border Right Color",
                    "Snippets sidebar visibility": "Snippets sidebar visibility",
                    "You have reached the maximum number of columns": "You have reached the maximum number of columns",
                    "Width": "Width",
                    "Height": "Height",
                    "Names": "Names",
                    "Values": "Values",
                    "Border Top": "Border Top",
                    "Border Bottom": "Border Bottom",
                    "Border Left": "Border Left",
                    "Border Right": "Border Right",
                    "Individual Corners": "Individual Corners",
                    "Top Left": "Top Left",
                    "Top Right": "Top Right",
                    "Bottom Left": "Bottom Left",
                    "Bottom Right": "Bottom Right",
                    "Flex": "Flex",
                    "Direction": "Direction",
                    "Wrap": "Wrap",
                    "Justify Content": "Justify Content",
                    "Align Items": "Align Items",
                    "Align Content": "Align Content",
                    "Opacity": "Opacity",
                    "Filters": "Filters",
                    "Blur": "Blur",
                    "Brightness": "Brightness",
                    "Contrast": "Contrast",
                    "Grayscale": "Grayscale",
                    "Hue Rotate": "Hue Rotate",
                    "Invert": "Invert",
                    "Saturate": "Saturate",
                    "Sepia": "Sepia",
                    "Bottom": "Bottom",
                    "Float": "Float",
                    "x Offset": "x Offset",
                    "y Offset": "y Offset",
                    "Spread": "Spread",
                    "Shadow Color": "Shadow Color",
                    "Outer/Inner Shadow": "Outer/Inner Shadow",
                    "Margin": "Margin",
                    "Padding": "Padding",
                    "Text Align": "Text Align",
                    "Center": "Center",
                    "Full": "Full",
                    "Line Height": "Line Height",
                    "Font Weight": "Font Weight",
                    "Font Style": "Font Style",
                    "Text Transform": "Text Transform",
                    "Text Decoration": "Text Decoration",
                    "Word Spacing": "Word Spacing",
                    "Font Family": "Font Family",
                    "Normal": "Normal",
                    "Lowercase": "Lowercase",
                    "Capitalize": "Capitalize",
                    "None": "None",
                    "Line Through": "Line Through",
                    "Overline": "Overline",
                    "Hover": "Hover",
                    "Saved": "Saved",
                    "Templates": "Templates",
                    "No Border": "No Border",
                    "Border Radius": "Border Radius",
                    "Button Size": "Button Size",
                    "Upper/lower": "Upper/lower",
                    "Weight": "Weight",
                    "Save Current Button": "Save Current Button",
                    "Tags": "Tags",
                    "Snippet": "Snippet",
                    "Mono": "Mono",
                    "Zoom": "Zoom",
                    "Set theme": "Set theme",
                    "Open in a lightbox (for image, video or Youtube)": "Open in a lightbox (for image, video or Youtube)",
                    "Column Settings": "Column Settings",
                    "Lock": "Lock",
                    "General": "General",
                    "Content": "Content",
                    "On Click": "On Click",
                    "Background Image": "Background Image",
                    "Adjust": "Adjust",
                    "Dark": "Dark",
                    "Light": "Light",
                    "Enlarge Row": "Enlarge Row",
                    "Content Alignment": "Content Alignment",
                    "Top Center": "Top Center",
                    "Bottom Center": "Bottom Center",
                    "Center Left": "Center Left",
                    "Center Right": "Center Right",
                    "Open": "Open",
                    "Background Image Adjustments": "Background Image Adjustments",
                    "Scale": "Scale",
                    "Horizontal": "Horizontal",
                    "Vertical": "Vertical",
                    "Do you really want to leave?": "Do you really want to leave?",
                    "Two Button": "Two Button",
                    "Youtube": "Youtube",
                    "Video": "Video",
                    "Map": "Map",
                    "Show Controls": "Show Controls",
                    "Loop": "Loop",
                    "Autoplay": "Autoplay",
                    "Please select an image or video file.": "Please select an image or video file.",
                    "Please select an image file.": "Please select an image file.",
                    "Please select an mp4 file.": "Please select an mp4 file.",
                    "Social Links": "Social Links",
                    "HTML/JS": "HTML/JS",
                    "Drag image to change the position. Click image to edit the details.": "Drag slide to change the position. Click slide to edit the,details.",
                    "Add Image": "Add Image",
                    "Fit": "Fit",
                    "Type": "Type",
                    "Animation duration": "Animation duration",
                    "Per View": "Per View",
                    "Gap": "Gap",
                    "Arrow Navigation": "Arrow Navigation",
                    "Dots Navigation": "Dots Navigation",
                    "Fade": "Fade",
                    "Caption (HTML allowed)": "Caption (HTML allowed)",
                    "Placement": "Placement",
                    "Max Width": "Max Width",
                    "You can test the On-Click action on page if you lock the column by clicking the lock button": "You can test the On-Click action on,page if you lock the column by clicking the lock button",
                    "Remove": "Remove",
                    "All": "All",
                    "Transparent": "Transparent",
                    "Current": "Current",
                    "Padding X": "Padding X",
                    "Padding Y": "Padding Y",
                    "SM": "SM",
                    "MD": "MD",
                    "LG": "LG",
                    "XL": "XL",
                    "2XL": "2XL",
                    "3XL": "3XL",
                    "Margin Left": "Margin Left",
                    "Margin Right": "Margin Right",
                    "Margin Top": "Margin Top",
                    "Margin Bottom": "Margin Bottom",
                    "Reset": "Reset",
                    "Snippet Categories": "Snippet Categories",
                    "Snippets": "Snippets",
                    "Copy": "Copy",
                    "Cut": "Cut",
                    "Paste": "Paste",
                    "Insert Link": "Insert Link",
                    "Insert Image": "Insert Image",
                    "Show shortcut info": "Show shortcut info",
                    "Navigate to the next control": "Navigate to the next control",
                    "Navigate to the previous control": "Navigate to the previous control",
                    "Select control that has focus": "Select control that has focus",
                    "Select option that has focus (eg. checkbox)": "Select option that has focus (eg. checkbox)",
                    "Move up in selection list or menu": "Move up in selection list or menu",
                    "Move down in selection list or menu": "Move down in selection list or menu",
                    "Close modal or popup": "Close modal or popup",
                    "Shortcuts": "Shortcuts",
                    "Basic": "Basic",
                    "Editing": "Editing",
                    "Navigation": "Navigation",
                    "Tab": "Tab",
                    "Shift": "Shift",
                    "Esc": "Esc",
                    "Enter": "Enter",
                    "Up arrow": "Up arrow",
                    "Down arrow": "Down arrow",
                    "or": "or",
                    "Spacebar": "Spacebar",
                    "Min Width": "Min Width",
                    "Max Height": "Max Height",
                    "Min Height": "Min Height",
                    "Overflow x": "Overflow x",
                    "Overflow y": "Overflow y",
                    "Please enter <iframe> element.": "Please enter <iframe> element.",
                    "Add Slide": "Add Slide",
                    "Alternate Videos": "Alternate Videos",
                    "Add/Update Video": "Add/Update Video",
                    "Drag slide to change the position. Click slide to edit the details.": "Drag slide to change the position. Click slide to edit the,details.",
                    "URL": "URL",
                    "Delete Slide": "Delete Slide",
                    "Arrow Color": "Arrow Color",
                    "Dots Color": "Dots Color",
                    "Hide Column on Mobile": "Hide Column on Mobile",
                    "Padding Left/Right": "Padding Left/Right",
                    "Top (Full Width)": "Top (Full Width)",
                    "HTML View": "HTML View",
                    "Shorten HTML": "Shorten HTML",
                    "Actual": "Actual",
                    "Visibility": "Visibility",
                    "Visible": "Visible",
                    "Hidden": "Hidden",
                    "Text Slider": "Text Slider",
                    "Drag slide to change the position.": "Drag slide to change the position.",
                    "Show Arrow on Mobile": "Show Arrow on Mobile",
                    "Show Dots on Mobile": "Show Dots on Mobile",
                    "Pause on Hover": "Pause on Hover",
                    "Caption Animation": "Caption Animation",
                    "Slide Up": "Slide Up",
                    "Fade In": "Fade In",
                    "Add Row ID": "Add Row ID",
                    "Add Column ID": "Add Column ID",
                    "Add Element ID": "Add Element ID",
                    "Add Css Classes": "Add Css Classes",
                    "Laptop": "Laptop",
                    "Mobile": "Mobile",
                    "Tablet": "Tablet",
                    "Laptop/Tablet (Landscape)": "Laptop/Tablet (Landscape)",
                    "Tablet (Landscape)": "Tablet (Landscape)",
                    "Tablet (Portrait)": "Tablet (Portrait)",
                    "Laptop/Tablet": "Laptop/Tablet",
                    "Desktop": "Desktop",
                    "Live Preview": "Live Preview",
                    "Page Break": "Page Break",
                    "Add the products table": "Add the products table",
                    "Products": "Products",
                    "Products will be displayed in this section on document preview and PDF.": "Products will be displayed in this section on document preview and PDF.",
                    "Signatures": "Signatures",
                    "On document PDF, the signatures will be displayed in this section.": "On document PDF, the signatures will be displayed in this section."
                }
            },
            "country": {
                "country": "Country"
            },
            "dashboard": {
                "insights": "Insights",
                "dashboard": "Dashboard",
                "name": "Name",
                "default": "Default Dashboard",
                "new_dashboard": "New Dashboard",
                "create": "Create New Dashboard",
                "edit_current": "Edit Current Dashboard",
                "delete_current": "Delete Current Dashboard",
                "created": "Dashboard successfully created.",
                "updated": "Dashboard successfully updated.",
                "deleted": "Dashboard successfully deleted",
                "cards": {
                    "enabled": "Enabled"
                }
            },
            "dates": {
                "today": "Today",
                "tomorrow": "Tomorrow",
                "in_x_days": "In {count} Day|In {count} Days",
                "in_x_weeks": "In {count} Week|In {count} Weeks",
                "in_x_months": "In {count} Month|In {count} Months",
                "custom": "Custom",
                "range": "Date range",
                "minutes": "minutes",
                "hours": "hours",
                "days": "days",
                "weeks": "weeks",
                "duration": {
                    "seconds": "a few seconds",
                    "minutes": "minute|minutes",
                    "hours": "hour|hours",
                    "days": "day|days"
                },
                "due": {
                    "today": "Due today",
                    "tomorrow": "Due tomorrow",
                    "this_week": "Due this week",
                    "next_week": "Due next week",
                    "this_month": "Due this month",
                    "next_month": "Due next month",
                    "this_quarter": "Due this quarter"
                },
                "yesterday": "Yesterday",
                "next_day": "Next Day",
                "this_week": "This Week",
                "last_week": "Last Week",
                "next_week": "Next Week",
                "this_month": "This Month",
                "last_month": "Last Month",
                "next_month": "Next Month",
                "this_quarter": "This Quarter",
                "last_quarter": "Last Quarter",
                "next_quarter": "Next Quarter",
                "this_year": "This Year",
                "last_year": "Last Year",
                "next_year": "Next Year",
                "within": {
                    "last_7_days": "Within last 7 days",
                    "last_14_days": "Within last 14 days",
                    "last_30_days": "Within last 30 days",
                    "last_60_days": "Within last 60 days",
                    "last_90_days": "Within last 90 days",
                    "last_365_days": "Within last 365 days"
                },
                "periods": {
                    "7_days": "Last 7 Days",
                    "15_days": "Last 15 Days",
                    "30_days": "Last 30 Days",
                    "60_days": "Last 60 Days",
                    "90_days": "Last 90 Days",
                    "365_days": "Last 365 Days",
                    "last_3_months": "Last 3 Months",
                    "last_6_months": "Last 6 Month",
                    "last_12_months": "Last 12 months"
                }
            },
            "fields": {
                "add": "Add New",
                "fields": "Fields",
                "field": "Field",
                "updated": "Updated Fields",
                "hide_fields": "Hide {count} field|Hide {count} fields",
                "more_fields": "{count} more field|{count} more fields",
                "reseted": "Fields are set to initial state successfully",
                "all": "All Fields",
                "select": "Select Fields",
                "updated_field": "Updated Field",
                "update_field": "Update Field",
                "optional": "(optional)",
                "configured": "Fields configured successfully",
                "no_longer_available": "Field no longer available",
                "new_value": "New Value",
                "old_value": "Old Value",
                "manage": "Manage Fields",
                "hide_updated": "Hide Updated Fields",
                "view_updated": "View Updated Fields",
                "primary": "Primary Field",
                "visible": "Visible",
                "label": "Label",
                "is_readonly": "Read Only",
                "keep_existing_value": "Keep existing value",
                "replace_existing_value": "Replace existing value with..",
                "settings": {
                    "create": "Creation Fields",
                    "create_info": "Fields that will be displayed when any user creates a record.",
                    "update": "Edit Fields",
                    "update_info": "Fields that are available and will be displayed on record edit/preview view.",
                    "detail": "Detail Fields",
                    "detail_info": "Fields that are available and will be displayed on records detail.",
                    "list": "List Fields",
                    "list_info": "To adjust the fields that are displayed on the list view, when viewing the {resourceName} list, click the {icon} icon located at the navigation bar and choose \"List settings\"."
                },
                "collapsed_by_default": "Collapsed by default?",
                "is_required": "Required?",
                "option_enabled_will_propagate": "When enabled, propagates to \"{view_name}\" view too.",
                "option_disabled_will_propagate": "When disabled, propagates to \"{view_name}\" view too.",
                "options": "Options",
                "field_is_unique": "Unique",
                "mark_as_unique": "Do not allow duplicate values",
                "mark_as_unique_change_info": "The value of this option can be set only on field creation.",
                "unmark_as_unique_change_info": "This action is irreversible, after the field is unmarked as unique, cannot be marked as unique again.",
                "validation": {
                    "exist": "It looks like field with this ID already exists for the resource.",
                    "requires_options": "Add options for this field.",
                    "field_type_invalid": "Field type is not supported",
                    "field_id_invalid": "Only lowercase alpha characters (a-z) and underscore (_) are accepted.",
                    "refuses_options": "This field does not support options.",
                    "option_coma": "Comas are not allowed in option names."
                },
                "custom": {
                    "create_option_icon": "Click the {icon} icon to create new option.",
                    "or_add_options_via_text": "Or add options via text",
                    "convert_text_to_options": "Convert text to options",
                    "text_options_each_on_new_line": "Paste/enter each option on new line.",
                    "field": "Custom Field",
                    "create": "Create New Custom Field",
                    "update": "Update Custom Field",
                    "type": "Field Type",
                    "id": "Field ID",
                    "id_info": "Enter field ID in lowercase, only alpha characters (a-z) and underscore (_) accepted.",
                    "updated": "Custom field successfully updated",
                    "created": "Custom field successfully created",
                    "deleted": "Custom field successfully deleted"
                },
                "email_copied": "E-Mail address coppied to clipboard"
            },
            "filters": {
                "filters": "Filters",
                "apply": "Apply Filters",
                "save_and_apply": "Save and Apply",
                "create": "Create New Filter",
                "filter_by": "Filter by",
                "edit": "Edit",
                "save_as_new": "Save filter?",
                "available": "Available Filters",
                "not_available": "No filters available, get started by creating a filter.",
                "cannot_be_shared": "This filter consist of rules ({rules}) that may not be always available for all team members, for this reason, the filter cannot be shared with other team members.",
                "search": "Search filters...",
                "name": "Filter Name",
                "new": "New Filter",
                "clear_rules": "Clear Rules",
                "clear_applied": "Clear Filter",
                "static_rule_indicator": "Static Rule",
                "is_readonly": "This filter is read-only filter with ability to be marked as default, other modifications of the filter are disabled, if you need to extend this filter, create new a one instead.",
                "system_default_delete_info": "You cannot delete application default filter",
                "country": "Country",
                "share": {
                    "with": "Shared with",
                    "private": "Private",
                    "everyone": "Everyone",
                    "private_info": "Only the creator can see this filter",
                    "everyone_info": "All users can see and use this filter"
                },
                "placeholders": {
                    "enter": "Enter {label}",
                    "choose": "Choose {label}",
                    "choose_with_multiple": "Choose one or more {label}",
                    "select_date": "Select date"
                },
                "conditions": {
                    "or": "or",
                    "and": "and"
                },
                "show_matching_records_conditions": "Show records that match {match_type} of these conditions:",
                "or_match_any_conditions": "{condition} match {match_type} of these conditions:",
                "mark_as_default": "Mark as default",
                "unmark_as_default": "Unmark as default",
                "mark_as_default_for_current_account_only": "Applies only for your account.",
                "edit_filter": "Edit Filter",
                "match_type": "Match Type",
                "match_type_all": "All",
                "match_type_any": "Any",
                "add_filter": "Add Filter",
                "add_condition": "Add Condition",
                "add_another_condition": "Add Another Condition",
                "add_group": "Add Group",
                "add_group_info": "A group to nest more filters",
                "select_rule": "Select Rule",
                "operators": {
                    "is": "is",
                    "was": "was",
                    "equal": "is equal to",
                    "not_equal": "is not equal to",
                    "in": "is any of",
                    "not_in": "is none of",
                    "less": "is less than",
                    "less_or_equal": "is less or equal than",
                    "greater": "is greater than",
                    "greater_or_equal": "is greater or equal than",
                    "between": "is between",
                    "not_between": "is not between",
                    "begins_with": "begins with",
                    "not_begins_with": "not begins with",
                    "contains": "contains",
                    "not_contains": "not contains",
                    "ends_with": "ends with",
                    "not_ends_with": "not ends with",
                    "is_empty": "is empty",
                    "is_not_empty": "is not empty",
                    "is_null": "is unknown",
                    "is_not_null": "is known"
                },
                "me": "Me"
            },
            "import": {
                "import": "Import",
                "start": "Start Import",
                "import_records": "Import Records",
                "import_in_progress": "Import In Progress",
                "download_sample": "Download Sample",
                "history": "Import History",
                "no_history": "No import history found.",
                "spreadsheet_columns": "Spreadsheet columns",
                "column_will_not_import": "will not be imported",
                "records_being_imported_in_batches": "The records are being imported in a few batches, do not navigate from this window until this message dissapear.",
                "date": "Date",
                "file_name": "File name",
                "user": "User",
                "total_imported": "Imported",
                "total_duplicates": "Duplicates",
                "total_skipped": "Skipped",
                "progress": "Progress",
                "status": "Status",
                "imported": "Records successfully imported",
                "revert": "Revert",
                "revert_info": "Reverting an import will permanently delete all of the imported records.",
                "why_skipped": "Why?",
                "download_skip_file": "Download skip file",
                "skip_file": "Skip file",
                "total_rows_skipped": "Total rows skipped: {count}",
                "skip_file_generation_info": "A skip file is generated every time a spreadsheet row validation fails.",
                "skip_file_fix_and_continue": "Download the skip file to examine the failed rows and why they failed, after the rows are fixed, upload the fixed skip file below to continue the import process for the current import instance.",
                "upload_fixed_skip_file": "Upload fixed skip file",
                "steps": {
                    "step_1": {
                        "name": "Download Sample",
                        "description": "Spreadsheet formatting guide."
                    },
                    "step_2": {
                        "name": "Upload Spreadsheet",
                        "description": "Upload file for mapping."
                    },
                    "step_3": {
                        "name": "Map Columns",
                        "description": "Map columns with fields."
                    },
                    "step_4": {
                        "name": "Import",
                        "description": "Start the import process."
                    }
                },
                "from_file": "Import From {file_type} File"
            },
            "mail_template": {
                "mail_templates": "Mail Templates",
                "template": "Template",
                "subject": "Subject",
                "message": "Message",
                "updated": "Template successfully updated.",
                "choose_to_edit": "Choose a template to edit",
                "changes_not_saved_warning": "Your current changes have not been saved. If you proceed, you will lose any unsaved progress. Do you wish to continue without saving?",
                "placeholders": {
                    "view_record": "View Record",
                    "placeholders": "Placeholders",
                    "mentioned_user": "The mentioned user name.",
                    "user_that_mentions": "The user name that mentions.",
                    "mention_url": "The mention URL."
                }
            },
            "media": {
                "link_copied": "Link successfully copied",
                "no_preview_available": "Currently there is no preview available for this file, try to download the file instead."
            },
            "notifications": {
                "notifications": "Notifications",
                "notification": "Notification",
                "your": "Your Notifications",
                "no_notifications": "You don't have any notifications at this time.",
                "description": "Description",
                "mark_all_as_read": "Mark all as read",
                "no_more_notifications": "No more notifications.",
                "dismiss": "Dismiss",
                "channels": {
                    "mail": "Mail",
                    "database": "Bell"
                }
            },
            "oauth": {
                "connect": "Connect",
                "no_accounts": "You don't have any accounts connected.",
                "invalid_state": "Invalid request, please try again.",
                "connect_new_account": "Connect new account",
                "add": "Add new account",
                "or_choose_existing": "or choose a previously added account:",
                "stop_syncing": "Stop Syncing",
                "start_syncing": "Start Syncing",
                "deleted": "Account deleted successfully",
                "connected_accounts": "Connected Accounts",
                "requires_authentication": "This account requires re-authentication in order to re-connect with the application.",
                "re_authenticate": "Re-Authenticate",
                "re_authenticated": "Account re-authenticated successfully",
                "delete_warning": "Deleting a connected account will stop all related services which are provided by the account including any connected email accounts that are used for inbox."
            },
            "resource": {
                "all_resources": "All Resources",
                "created": "Record successfully created",
                "updated": "Record successfully updated",
                "deleted": "Record successfully deleted",
                "create": "Create {resource}",
                "edit": "Edit {resource}",
                "already_associated": "This record is already associated",
                "associate_with_records": "Associate with records",
                "associated": "Record associated successfully",
                "dissociated": "Record dissociated successfully",
                "associated_delete_warning": "The {resource} is already associated with records, hence, cannot be deleted",
                "primary_record_delete_info": "This is a primary {resource}, hence, cannot be deleted",
                "settings": {
                    "fields": "{resourceName} Fields"
                }
            },
            "role": {
                "permissions": "Permissions",
                "role": "Role",
                "roles": "Roles",
                "name": "Name",
                "create": "Create Role",
                "edit": "Edit Role",
                "created": "Role successfully created",
                "updated": "Role successfully updated",
                "deleted": "Role successfully deleted",
                "granted": "Granted",
                "revoked": "Revoked",
                "capabilities": {
                    "access": "Access",
                    "view": "View",
                    "delete": "Delete",
                    "bulk_delete": "Bulk Delete",
                    "edit": "Edit",
                    "all": "All {resourceName}",
                    "owning_only": "Owned Only"
                },
                "view_non_authorized_after_record_create": "Your account is not authorized to view this record as you are not the owner of the record, after redirecting from this page, you won't be able to access the record.",
                "empty_state": {
                    "title": "No roles",
                    "description": "Get started by creating a new role."
                }
            },
            "settings": {
                "settings": "Settings",
                "updated": "Settings Updated",
                "general_settings": "General Settings",
                "company_information": "Company Information",
                "update_user_account_info": "Updating these settings won't affect your user account settings as these settings are general, update the same settings in your user account instead if you are looking to update these options.",
                "general": "General",
                "system": "System",
                "system_email": "System Email Account",
                "system_email_configured": "Account configured by other user",
                "system_email_info": "Select Inbox connected email account that will be used to send system related mails like user assigned to contact, activity due reminder, user invites, etc...",
                "choose_logo": "Choose Logo",
                "date_format": "Date Format",
                "time_format": "Time Format",
                "go_to_settings": "Go to settings",
                "privacy_policy_info": "If you don't have privacy policy, you can configure one here, view the privacy policy at the following URL: {url}",
                "phones": {
                    "require_calling_prefix": "Require calling prefix on phone numbers",
                    "require_calling_prefix_info": "Most call integrations are requiring phone numbers to be in E.164 format. Enabling this option will make sure that no phone numbers are entered without a country-specific calling prefix."
                },
                "recaptcha": {
                    "recaptcha": "reCaptcha",
                    "site_key": "Site Key",
                    "secret_key": "Secret Key",
                    "ignored_ips": "Ignored IP Addresses",
                    "ignored_ips_info": "Enter coma separated IP addresses that you want the reCaptcha to skip validation.",
                    "dont_get_locked": "Don't get locked",
                    "ensure_recaptcha_works": "To ensure the reCaptcha configuration works well, always perform a test login via Incognito Mode while keeping the current window active."
                },
                "security": {
                    "security": "Security",
                    "disable_password_forgot": "Disable password forgot feature",
                    "disable_password_forgot_info": "When enabled, the password forgot feature will be disabled.",
                    "block_bad_visitors": "Block bad visitors",
                    "block_bad_visitors_info": "If enabled, a list of bad user agents, ip addresses and referrers will be checked for each guest visitor."
                },
                "tools": {
                    "tools": "Tools",
                    "run": "Run Tool",
                    "executed": "Action executed successfully",
                    "clear-cache": "Clear application cache.",
                    "storage-link": "Create a symbolic link from \"public/storage\" to \"storage/app/public\".",
                    "optimize": "Cache the application bootstrap files like config and routes.",
                    "seed-mailable-templates": "Seed the application mailable templates."
                }
            },
            "table": {
                "default_sort": "Default Sort",
                "per_page": "Per Page",
                "columns": "Columns",
                "wrap_column": "Wrap Column",
                "primary_column": "Primary Column",
                "empty": "No data available in table",
                "info": "Showing {from} to {to} of {total} entries",
                "previous": "Previous",
                "next": "Next",
                "max_height": "Max Height",
                "max_height_info": "Specifying table max height ensures that the table headings will be fixed on top while scrolling.",
                "list_settings": "List settings",
                "customize_list_view": "Customize the list view",
                "condensed": "Condensed Table",
                "bordered": "Bordered Table",
                "enable_polling": "Enable Polling",
                "polling_info": "The interval in seconds at which should poll for new records.",
                "length_menu": {
                    "show": "Show",
                    "entries": "entries"
                }
            },
            "tags": {
                "tags": "Tags",
                "search": "Search Tags",
                "add_new": "Add new tag",
                "tag_name": "Tag Name",
                "color": "Color",
                "edit_tag": "Edit Tag",
                "new_tag": "New Tag",
                "validation": {
                    "coma": "Comas are not allowed in tag names."
                }
            },
            "timeline": {
                "pin": "Pin on top",
                "unpin": "Unpin from top",
                "updated": "The record has been updated by {causer}",
                "association_restored": "The association {associationDisplayName} has been restored from trash by {user}",
                "association_permanently_deleted": "The association {associationDisplayName} has been permanently deleted",
                "deleted": "The record has been deleted by {causer}",
                "restored": "The record has been restored from trash by {causer}",
                "created": "The record has been created by {causer}",
                "imported": "The record has been imported by {causer}",
                "attached": "{user} associated",
                "detached": "{user} dissociated",
                "associate_trashed": "The associated {displayName} record has been moved to trash by {user}"
            },
            "update": {
                "system": "System Update",
                "update": "Update",
                "perform": "Perform Update",
                "installed_version": "Installed Version",
                "latest_version": "Latest Version",
                "not_available": "No new version available!",
                "using_latest_version": "You are using the latest version!",
                "update_in_progress": "Update in progress...",
                "patches": "Patches",
                "patch_applied": "Applied",
                "apply_oldest_first": "You must apply the oldest patches first.",
                "no_patches": "No patches available for your version, check back later.",
                "update_zip_is_required": "In order to use the 1 click update feature, you will need to enable the PHP \"zip\" extension.",
                "patch_zip_is_required": "In order to apply patches, you will need to enable the PHP \"zip\" extension.",
                "auto_apply_patches": "Automatically apply new patches"
            },
            "workflow": {
                "create": "Create Workflow",
                "workflows": "Workflows",
                "title": "Title",
                "description": "Description",
                "created": "Workflow successfully created.",
                "updated": "Workflow successfully updated.",
                "deleted": "Workflow successfully deleted",
                "when": "When",
                "then": "Then",
                "field_change_to": "To",
                "total_executions": "Executions: {total}",
                "info": "The workflows tool automates your sales processes. Internal processes that can be automated include creating activities, sending emails, triggering HTTP requests, etc.",
                "validation": {
                    "invalid_webhook_url": "The webhook URL must not start with \"https://\" or \"http://\""
                },
                "actions": {
                    "webhook": "Trigger Webhook",
                    "webhook_url_info": "Must be a full, valid, publicly accessible URL."
                },
                "fields": {
                    "with_header_name": "With header name (optional)",
                    "with_header_value": "With header value (optional)",
                    "for_owner": "For: Owner (Responsible person)",
                    "dates": {
                        "now": "With due date: at the moment",
                        "in_1_day": "With due date: in one day",
                        "in_2_days": "With due date: in two days",
                        "in_3_days": "With due date: in three days",
                        "in_4_days": "With due date: in four days",
                        "in_5_days": "With due date: in five days"
                    }
                }
            }
        }
    },
    "es": {
        "auth": {
            "failed": "Estas credenciales no coinciden con nuestros registros.",
            "password": "Contraseña",
            "throttle": "Demasiados intentos de conexión. Por favor, inténtelo de nuevo en {seconds} segundos.",
            "current_password": "Contraseña actual",
            "logout": "Cerrar sesión",
            "login": "Iniciar sesión",
            "login_subheading": "Welcome, please sign in to your dashboard",
            "forgot_password": "¿Ha olvidado su contraseña?",
            "email_address": "Correo electrónico",
            "confirm_password": "Confirmar contraseña",
            "new_password": "Nueva contraseña",
            "change_password": "Cambiar contraseña",
            "remember_me": "¿Se acuerda de mí?",
            "signing_in": "Iniciando sesión...",
            "sign_in_heading": "Acceder a su cuenta"
        },
        "pagination": {
            "previous": "Anterior",
            "next": "Siguiente"
        },
        "passwords": {
            "reset": "Tu contraseña ha sido restablecida.",
            "sent": "Te hemos enviado por correo electrónico el enlace para restablecer tu contraseña.",
            "throttled": "Por favor, espere antes de volver a intentarlo.",
            "token": "Esta contraseña no es válida.",
            "user": "No podemos encontrar un usuario con esa dirección de correo electrónico.",
            "reset_password": "Restablecer contraseña",
            "send_password_reset_link": "Enviar enlace para restablecer contraseña"
        },
        "validation": {
            "accepted": "El {attribute} debe ser aceptada",
            "accepted_if": "El {attribute} debe ser aceptada cuando {other} es {value}.",
            "active_url": "El {attribute} no es una URL válida",
            "after": "El {attribute} debe ser una fecha posterior a {date}.",
            "after_or_equal": "El {attribute} debe ser una fecha posterior o igual a {date}.",
            "alpha": "El {attribute} solo debe contener letras",
            "alpha_dash": "El {attribute} solo debe contener letras guiones y guiones bajos",
            "alpha_num": "El {attribute} solo debe contener letras y números",
            "array": "El {attribute} solo debe ser una matriz",
            "ascii": "The {attribute} field must only contain single-byte alphanumeric characters and symbols.",
            "before": "El {attribute} debe ser una fecha anterior a {date}.",
            "before_or_equal": "El {attribute} debe ser una fecha anterior o igual a {date}.",
            "between": {
                "array": "El {attribute} debe ser entre {min} y {max} elementos",
                "file": "El {attribute} debe estar entre {min} y {max} kilobytes.",
                "numeric": "El {attribute} debe ser entre {min} y {max}.",
                "string": "El {attribute} debe ser entre {min} y {max} caracteres"
            },
            "boolean": "El campo {attribute} debe ser verdadero o falso",
            "can": "The {attribute} field contains an unauthorized value.",
            "confirmed": "La confirmación de {attribute} no coincide",
            "current_password": "La contraseña es incorrecta",
            "date": "El {attribute} no es una fecha válida",
            "date_equals": "El {attribute} debe ser una fecha igual a {date}.",
            "date_format": "El {attribute} no coincide con el {format}.",
            "decimal": "El {attribute} debe tener decimales {decimal}",
            "declined": "El {attribute} debe ser rechazado",
            "declined_if": "El {attribute} debe ser rechazado cuando {other} es {value}.",
            "different": "El {attribute} y {other} debe ser diferente",
            "digits": "El {attribute} debe ser de {digits} dígitos.",
            "digits_between": "El {attributedebe} ser entre {min} y {max} dígitos.",
            "dimensions": "El {attribute} tiene dimensiones de imágenes no válidas.",
            "distinct": "El campo {attribute} tiene un valor duplicado",
            "doesnt_end_with": "El {attribute} no puede terminar con uno de los siguientes: {values}.",
            "doesnt_start_with": "El {attributeno} puede comenzar con uno de los siguientes: {values}.",
            "email": "El {attribute} debe tener un correo electrónico válido",
            "ends_with": "El {attribute} debe terminar con uno de los siguientes: {values}.",
            "enum": "El {attribute} seleccionado es inválido",
            "exists": "El {attribute} seleccionado es inválido",
            "extensions": "The {attribute} field must have one of the following extensions: {values}.",
            "file": "El {attribute} debe serun archivo",
            "filled": "El campo {attribute} debe tener un valor",
            "gt": {
                "array": "El {attribute} debe tener más elementos de {value}",
                "file": "El {attribute} debe ser mayor que {value} kilobytes.",
                "numeric": "El {attribute} debe ser mayor que {value}.",
                "string": "Los caracteres {attribute} deben ser mayores que {value}."
            },
            "gte": {
                "array": "El {attribute} debe tener elementos {value} o más",
                "file": "El {attribute} debe ser mayor o igual que {value} kilobytes.",
                "numeric": "El {attribute} debe ser mayor o igual que {value}.",
                "string": "Los caracteres {attribute} deben ser mayores o iguales que {value}."
            },
            "hex_color": "The {attribute} field must be a valid hexadecimal color.",
            "image": "El {attribute} debe ser una imagen",
            "in": "El {attribute} seleccionado is inválido",
            "in_array": "El campo {attribute} no existe en {other}.",
            "integer": "El {attribute} debe ser un número entero",
            "ip": "El {attribute} debe tener una dirección de IP válida.",
            "ipv4": "El {attribute} debe ser una dirección IPv4 válida.",
            "ipv6": "El {attribute} debe ser una dirección IPv6 válida.",
            "json": "El {attribute} debe ser una cadena JSON válida.",
            "lowercase": "The {attribute} field must be lowercase.",
            "lt": {
                "array": "El atributo {attribute} debe tener menos elementos {value}.",
                "file": "El {attribute} debe ser inferior a {value} kilobytes.",
                "numeric": "El {attribute} debe ser menor que {value}.",
                "string": "El {attribute} debe tener menos caracteres que {value}."
            },
            "lte": {
                "array": "El {attribute} no debe tener más elementos {value}",
                "file": "El {attributedebe} ser menor o igual que {value} kilobytes.",
                "numeric": "El {attribute} debe ser menor o igual que {value}.",
                "string": "El {attribute} debe ser menor o igual que los caracteres {value}"
            },
            "mac_address": "El {attribute} debe ser una dirección MAC válida.",
            "max": {
                "array": "El {attribute} no debe tener más elementos que {max}",
                "file": "El {attribute} no debe ser mayor que {max} kilobytes.",
                "numeric": "El {attribute} no debe ser mayor que {max}.",
                "string": "El {attribute} no debe tener más de {max} caracteres"
            },
            "max_digits": "The {attribute} field must not have more than {max} digits.",
            "mimes": "El {attribute} debe ser un archivo de tipo: {values}.",
            "mimetypes": "El {attribute} debe ser un archivo de tipo: {values}.",
            "min": {
                "array": "El {attribute} debe tener al menos {min} elementos",
                "file": "El {attribute} debe tener al menos {min} kilobytes.",
                "numeric": "El {attribute} debe ser al menos {min}.",
                "string": "El {attribute} debe tener al menos {min} caracteres."
            },
            "min_digits": "The {attribute} field must have at least {min} digits.",
            "missing": "The {attribute} field must be missing.",
            "missing_if": "The {attribute} field must be missing when {other} is {value}.",
            "missing_unless": "The {attribute} field must be missing unless {other} is {value}.",
            "missing_with": "The {attribute} field must be missing when {values} is present.",
            "missing_with_all": "The {attribute} field must be missing when {values} are present.",
            "multiple_of": "El {attribute} debe ser un múltiplo de {value}.",
            "not_in": "El {attribute} seleccionado no es válido.",
            "not_regex": "El formato de {attribute} no es válido.",
            "numeric": "El {attribute} debe ser un número.",
            "password": "La contraseña es incorrecta",
            "present": "El campo {attribute} debe estar presente.",
            "present_if": "The {attribute} field must be present when {other} is {value}.",
            "present_unless": "The {attribute} field must be present unless {other} is {value}.",
            "present_with": "The {attribute} field must be present when {values} is present.",
            "present_with_all": "The {attribute} field must be present when {values} are present.",
            "prohibited": "El campo {attribute} está prohibido.",
            "prohibited_if": "El campo {attribute} está prohibido cuando {other} es {value}.",
            "prohibited_unless": "El campo {attribute} está prohibido a menos que {other} esté en {values}.",
            "prohibits": "El campo {attribute} prohíbe la presencia de {other}.",
            "regex": "El formato {attribute} no es válido.",
            "required": "El campo {attribute} es obligatorio.",
            "required_array_keys": "El campo {attribute} debe contener entradas para: {values}.",
            "required_if": "El campo {attribute} es obligatorio cuando {other} es {value}.",
            "required_if_accepted": "The {attribute} field is required when {other} is accepted.",
            "required_unless": "El campo {attribute} es obligatorio a menos que {other} esté en {values}.",
            "required_with": "El campo {attribute} es obligatorio cuando {values} está presente.",
            "required_with_all": "El campo {attribute} es obligatorio cuando {values} están presentes.",
            "required_without": "El campo {attribute} es obligatorio cuando {values} no está presente.",
            "required_without_all": "El campo {attribute} es obligatorio cuando no está presente ninguno de los {values}.",
            "same": "{attribute} y {other} deben coincidir.",
            "size": {
                "array": "El {attribute} debe contener elementos {size}",
                "file": "El {attribute} debe ser {size} kilobytes.",
                "numeric": "El {attribute} debe ser {size}.",
                "string": "El {attribute} debe tener {size} characters."
            },
            "starts_with": "El {attribute} debe empezar por uno de los siguientes: {values}.",
            "string": "El {attribute} debe ser una cadena de texto.",
            "timezone": "El {attribute} debe ser una zona horaria válida.",
            "unique": "El {attribute} ya está ocupado.",
            "uploaded": "No se ha podido cargar el {attribute}",
            "uppercase": "The {attribute} field must be uppercase.",
            "url": "El {attribute} debe ser una URL válida.",
            "ulid": "The {attribute} field must be a valid ULID.",
            "uuid": "El {attribute} debe ser un UUID válido.",
            "recaptcha": "Falló la verificación ReCaptcha.",
            "numeric_field": "El {attribute} no es un número válido, introduzca un número válido por ejemplo 1200, 1200.00 o 1200.255.",
            "calling_prefix": "El {attribute} debe comenzar con un código de llamada de país válido, por ejemplo: +994",
            "required_file": "Por favor, añada un archivo.",
            "invalid_options": "The provided option \"{options}\" is invalid.|The provided options \"{options}\" are invalid.",
            "custom": {
                "notifications.*.email": "Enter valid email address.",
                "notifications.*.filled": "Enter email address.",
                "_privacy-policy.accepted": "You must accept the privacy policy",
                "notifications": {
                    "*": {
                        "email": "Introduzca una dirección de correo electrónico válida."
                    }
                },
                "_privacy-policy": {
                    "accepted": "Debe aceptar la política de privacidad"
                }
            },
            "import": {
                "user": {
                    "invalid": "Ha proporcionado un usuario que no existe. Debe agregar la identificación de usuario o el nombre completo del usuario."
                }
            },
            "attributes": [],
            "required_without_label": "Por favor, rellene este campo.",
            "number": "El {attribute} debe ser un número"
        },
        "activities": {
            "activity": {
                "activities": "Actividades",
                "activity": "Actividad",
                "add": "Agregar Actividad",
                "description": "Descripción",
                "description_info": "La descripción es visible para todos los invitados",
                "note": "Nota",
                "note_info": "Las notas son privadas y visibles solo para los representantes de ventas.",
                "title": "Título",
                "due_date": "Fecha de vencimiento",
                "end_date": "Fecha final",
                "create": "Crear actividad",
                "download_ics": "Descargar archivo .ics",
                "created": "Actividad creada correctamente",
                "updated": "Actividad actualizada correctamente",
                "deleted": "Actividad eliminada correctamente",
                "export": "Exportar actividades",
                "import": "Importar actividades",
                "guests": "Invitados",
                "guest": "Invitado",
                "count_guests": "1 invitado | {count} invitados",
                "create_follow_up_task": "Crear tarea de seguimiento",
                "follow_up_with_title": "Seguimiento de {with}",
                "title_via_create_message": "Con respecto al correo electrónico: {subject}",
                "reminder_update_info": "Debido a que el recordatorio de esta actividad ya ha sido enviado, deberá actualizar la fecha de vencimiento para que se envíe un nuevo recordatorio a la fila.",
                "owner_assigned_date": "Fecha de asignación del propietario",
                "reminder_sent_date": "Fecha de envío del recordatorio",
                "reminder": "Recordatorio",
                "owner": "Propietario",
                "mark_as_completed": "Marcar como completado",
                "mark_as_incomplete": "Marcar como incompleto",
                "is_completed": "Está completado",
                "completed_at": "Completado en",
                "overdue": "Atrasado",
                "doesnt_have_activities": "Sin actividades",
                "count": "Sin actividades | 1 Actividad | {count} Actividades",
                "incomplete_activities": "Actividades incompletas",
                "activity_was_due": "Esta actividad venció el {date}",
                "next_activity_date": "Fecha de la próxima actividad",
                "next_activity_date_info": "Este campo es de sólo lectura y se actualiza automáticamente en función de las próximas actividades del registro, indica cuándo debe realizarse la siguiente acción del representante de ventas.",
                "cards": {
                    "my_activities": "Mis actividades",
                    "my_activities_info": "Estas tarjetas reflejan las actividades que has agregado como propietario",
                    "created_by_agent": "Actividades creadas por el agente de ventas",
                    "created_by_agent_info": "Mira el número de actividades que crea cada agente de ventas. Mira quién crea más actividades y quién crea menos.",
                    "upcoming": "Próximas actividades",
                    "upcoming_info": "Esta tarjeta refleja las próximas actividades y la que está atendiendo."
                },
                "type": {
                    "default_type": "Tipo de actividad predeterminado",
                    "delete_primary_warning": "No se puede eliminar la clase de actividad primaria.",
                    "delete_usage_warning": "El tema ya está asociado a las actividades, por lo que no se puede eliminar.",
                    "delete_usage_calendars_warning": "Este formato se utiliza por defecto al crear actividades a través de calendarios conectados, por lo que no se puede eliminar.",
                    "delete_is_default": "Este es un tipo de evento predeterminado, por lo tanto, no se puede eliminar.",
                    "type": "Tipo de evento",
                    "types": "Tipos de eventos",
                    "name": "Nombre",
                    "icon": "Icono"
                },
                "filters": {
                    "activity_type_disabled": "La clase de actividad se utiliza en el filtro actual, por lo que no puede seleccionar la clase de actividad en esta sección.",
                    "open": "Actividades abiertas",
                    "due_today": "Vence hoy",
                    "due_this_week": "Vence esta semana",
                    "display": {
                        "has": "tiene eventos {value}:",
                        "overdue": "tiene {value}: eventos",
                        "doesnt_have_activities": "no tiene ningún evento"
                    },
                    "all": "Todos",
                    "today": "Hoy",
                    "tomorrow": "Mañana",
                    "this_week": "Esta semana",
                    "next_week": "Siguiente semana",
                    "done": "Realizado",
                    "done_empty_state": "Aquí se mostrarán las actividades realizadas."
                },
                "settings": {
                    "send_contact_email": "Se envió la plantilla de correo \"El contacto atiende a la actividad\" a los contactos",
                    "send_contact_email_info": "Si está habilitado, cuando el contacto se agrega como invitado en la actividad, se enviará una plantilla de correo con el archivo .ics adjunto y la información de la actividad."
                },
                "manage_activities": "Gestionar actividades",
                "info": "Programar y gestionar eventos con contactos y representantes de ventas.",
                "timeline": {
                    "heading": "Se ha creado un evento"
                },
                "permissions": {
                    "attends_and_owned": "Asistentes y propietarios únicamente"
                },
                "actions": {
                    "update_type": "Tipo de actualización"
                },
                "notifications": {
                    "due": "Tu {activity} actividad debe realizarse el {date}",
                    "assigned": "Se le ha asignado a la tarea  {name} por {user}",
                    "added_as_guest": "Ha sido añadido como invitado al evento"
                },
                "mail_placeholders": {
                    "assigneer": "Nombre del usuario que asignó el evento"
                },
                "validation": {
                    "end_date": {
                        "less_than_due": "La fecha final no debe ser inferior a la fecha de vencimiento."
                    },
                    "end_time": {
                        "required_when_end_date_is_in_future": "Debe especificar la hora de finalización cuando la fecha de finalización se encuentra en un día diferente."
                    }
                },
                "workflows": {
                    "actions": {
                        "create": "Crear evento"
                    },
                    "fields": {
                        "create": {
                            "title": "Título del evento",
                            "note": "Agregar nota (opcional)"
                        }
                    }
                },
                "metrics": {
                    "todays": "Eventos de hoy"
                },
                "empty_state": {
                    "title": "You have not created any activities.",
                    "description": "Get started by creating a new activity."
                }
            },
            "calendar": {
                "calendar": "Calendario",
                "calendar_sync": "Sincronización de calendarios",
                "reconfigure": "Reconfigurar",
                "choose_oauth_account": "Elige un tipo de cuenta para empezar a sincronizar los eventos del calendario",
                "account_being_connected": "Está a punto de conectar {email} account.",
                "save_events_as": "Guardar evento de calendario como:",
                "sync_activity_types": "Sincroniza los siguientes tipos de actividades con el calendario:",
                "sync_support_only_primary": "Es posible sincronizar solo el calendario principal de la cuenta.",
                "only_future_events_will_be_synced": "Sólo se sincronizarán los eventos futuros.",
                "events_will_sync_from": "Se sincronizarán los eventos creados a partir de {date}",
                "events_being_synced_from": "Los eventos creados a partir de {date} se están sincronizando.",
                "missing_outlook_integration": "Microsoft application not configured, you must configure your Microsoft application in order to sync Outlook calendar.",
                "missing_google_integration": "Google application project not configured, you must configure your Google application project in order to connect to sync Google calendar.",
                "timeline": {
                    "imported_via_calendar_attendee": "Contacto importado a través de {user} calendar porque fue añadido como asistente a un evento."
                },
                "fullcalendar": {
                    "locale": {
                        "buttonText": {
                            "prev": "Periodo anterior",
                            "next": "Siguiente periodo",
                            "prevYear": "Año anterior",
                            "nextYear": "Siguiente año",
                            "year": "año",
                            "today": "Hoy",
                            "month": "Mes",
                            "week": "Semana",
                            "day": "Día",
                            "list": "Lista"
                        },
                        "weekText": "W",
                        "allDayText": "Todo el día",
                        "moreLinkText": "Más",
                        "noEventsText": "No hay actividades que mostrar"
                    }
                }
            }
        },
        "billable": {
            "billable": {
                "total": "Total",
                "sub_total": "Subtotal",
                "includes_discount": "incluye descuento de {amount}",
                "tax_amount_is_inclusive": "inc.",
                "tax_types": {
                    "inclusive": "Impuestos incluidos",
                    "exclusive": "Impuesto exclusivo",
                    "no_tax": "Sin impuestos"
                }
            },
            "product": {
                "products": "Productos",
                "product": "Producto",
                "create": "Crear producto",
                "edit": "Editar producto",
                "export": "Exportar producto",
                "import": "Importar producto",
                "created": "Producto creado correctamente",
                "updated": "Producto actualizado correctamente",
                "deleted": "Producto eliminado correctamente",
                "related_products": "Related Products",
                "manage": "Administrar productos",
                "name": "Nombre",
                "description": "Descripción",
                "table_heading": "Producto",
                "tax": "Impuesto",
                "quantity": "Cantidad",
                "qty": "CANTIDAD",
                "unit_price": "Precio unitario",
                "direct_cost": "Costo directo",
                "unit": "Unidad (kg, lotes)",
                "sku": "CÓDIGO",
                "is_active": "Activo",
                "tax_rate": "Tasa de impuesto",
                "tax_label": "Etiqueta de impuestos",
                "tax_percent": "Porcentaje de impuestos",
                "discount": "Descuento",
                "amount": "Cantidad",
                "discount_percent": "Porcentaje de descuento",
                "discount_amount": "Cantidad de descuento",
                "will_be_added_as_new": "{name} se agregará como nuevo producto",
                "total_products": "Total de productos",
                "total_sold": "Total de ventas",
                "sold_amount_exc_tax": "Importe vendido (sin impuestos)",
                "interest_in_product": "Interés en el producto",
                "resource_has_no_products": "No hay productos creados, empiece por añadir productos",
                "exists_in_trash_by_name": "Ya existe un producto con el mismo nombre en la papelera, ¿desea restaurar el producto de la papelera?",
                "choose_or_enter": "Seleccione o introduzca un producto",
                "cards": {
                    "performance": "Rendimiento del producto",
                    "performance_info": "La columna \"Interés en el producto\" refleja todos los productos que se agregan a las ofertas, pero la columna \"Total vendido\" refleja los productos que se agregan a las ofertas y las ofertas se marcan como ganadas"
                },
                "count": "0 productos | 1 producto | {count} productos",
                "settings": {
                    "default_tax_type": "¿Venden sus productos con impuestos incluidos?",
                    "default_discount_type": "Tipo de descuento predeterminado"
                },
                "actions": {
                    "mark_as_active": "Marcar como activo",
                    "mark_as_inactive": "Marcar como inactivo",
                    "update_unit_price": "Actualizar precio",
                    "update_tax_rate": "Actualizar tasa de impuestos",
                    "update_tax_label": "Update tax label"
                },
                "validation": {
                    "sku": {
                        "unique": "Ya existe un producto con este SKU."
                    }
                },
                "empty_state": {
                    "title": "You have not created any products.",
                    "description": "Save time by using predefined products."
                }
            }
        },
        "brands": {
            "brand": {
                "brand": "Marca",
                "brands": "Marcas",
                "create": "Crear marca",
                "update": "Actualizar marca",
                "form": {
                    "sections": {
                        "general": "General",
                        "navigation": "Navegación",
                        "email": "Email",
                        "thank_you": "Gracias",
                        "signature": "Firma",
                        "pdf": "PDF"
                    },
                    "is_default": "¿Esta es la marca por defecto de la empresa?",
                    "name": "¿Cómo se refieren internamente a esta marca?",
                    "display_name": "¿Cómo quiere que se muestre a sus clientes?",
                    "primary_color": "Elija el color principal de la marca",
                    "upload_logo": "Cargue el logo de su empresa",
                    "navigation": {
                        "background_color": "Navigation background color",
                        "upload_logo_info": "Si tiene un fondo oscuro, utilice un logo claro. Si tiene un fondo claro, utilice un logo con texto oscuro."
                    },
                    "pdf": {
                        "default_font": "Familia de fuentes predeterminada",
                        "default_font_info": "La fuente {fontName} proporciona la cobertura de caracteres Unicode más decente por defecto, asegúrese de seleccionar una fuente adecuada si los caracteres especiales o Unicode no se muestran correctamente en el documento PDF.",
                        "size": "Tamaño",
                        "orientation": "Orientación",
                        "orientation_portrait": "Portrait",
                        "orientation_landscape": "Landspace"
                    },
                    "email": {
                        "upload_logo_info": "Asegúrese de que el logo es adecuado para un fondo blanco; si no se carga ningún logo, se utilizará en su lugar el logo oscuro cargado en Configuración general."
                    },
                    "document": {
                        "send": {
                            "info": "Al enviar un documento",
                            "subject": "Tema predeterminado",
                            "message": "Mensaje de correo electrónico predeterminado al enviar un documento",
                            "button_text": "Texto del botón Email"
                        },
                        "sign": {
                            "info": "Cuando alguien firma su documento",
                            "subject": "Asunto predeterminado del correo electrónico de agradecimiento",
                            "message": "Mensaje de correo electrónico para enviar cuando alguien firma su documento",
                            "after_sign_message": "Después de firmar, ¿qué debe decir el mensaje?"
                        },
                        "accept": {
                            "after_accept_message": "Después de aceptar (sin firma digital), ¿qué debe decir el mensaje?"
                        }
                    },
                    "signature": {
                        "bound_text": "Texto encuadernado legalmente"
                    }
                },
                "delete_documents_usage_warning": "La marca ya está asociada a los documentos, por lo que no puede eliminarse.",
                "created": "Marca creada con éxito.",
                "updated": "Marca actualizada con éxito.",
                "deleted": "Marca eliminada con éxito"
            }
        },
        "calls": {
            "call": {
                "calls": "Llamadas",
                "call": "Call",
                "add": "Registro de llamadas",
                "make": "Llamar por teléfono",
                "log": "Describa brevemente el resultado de la llamada...",
                "manage_calls": "Gestionar llamadas",
                "total_calls": "Total Calls",
                "activate_voip": "Activate",
                "voip_activated": "Activated",
                "info": "Puede registrar sus llamadas y las de su equipo, y realizar un seguimiento de todas las interacciones realizadas.",
                "info_created": "{user} registró una llamada en {date}",
                "follow_up_task_body": "Con respecto a un registro de llamadas: {content}",
                "created": "Llamada registrada correctamente",
                "updated": "Llamada actualizada correctamente",
                "deleted": "Llamada eliminada correctamente",
                "date": "Fecha de llamada",
                "read_outcome": "Read Outcome",
                "outcome": {
                    "outcomes": "Resultados de la llamada",
                    "outcome": "Resultados",
                    "call_outcome": "Resultado de la llamada",
                    "select_outcome": "Seleccione el resultado",
                    "delete_warning": "El resultado de la llamada ya está asociado a las llamadas, por lo que no puede eliminarse.",
                    "name": "Nombre"
                },
                "no_voip_permissions": "Tu cuenta no está autorizada para hacer llamadas",
                "voip_permissions": "Llamadas por VoIP",
                "new_from": "Nueva llamada desde {number}",
                "connected_with": "Conectado con {number}",
                "ended": "Llamada finalizada {number}",
                "speaker_volume": "Volumen del altavoz",
                "mic_volume": "Volumen del micrófono",
                "mute": "Mute",
                "unmute": "Unmute",
                "answer": "Responder llamada",
                "hangup": "Colgar llamada",
                "reject": "Rechazar llamada",
                "unknown_devices": "¿Ve dispositivos desconocidos?",
                "hide_bar": "Ocultar esta barra",
                "activation_required": "Calling feature activation required",
                "activation_gesture_required": "Most browsers require user gesture (click) to activate calling feature\n        like audio and microphone. This is handled on your first click when you\n        enter your dashboard, since, you did not click anything in\n        {askForActivationIn} minute, we ask you to activate the calling\n        functionality by clicking below.",
                "cards": {
                    "by_day": "Registro de llamadas por día",
                    "by_sale_agent": "Total de llamadas registradas por agente de ventas",
                    "logged_calls": "Logged calls",
                    "outcome_overview": "Resumen de los resultados de las llamadas"
                },
                "workflows": {
                    "triggers": {
                        "logged": "Llamada registrada",
                        "missed_incoming_call": "Llamada entrante perdida"
                    }
                },
                "timeline": {
                    "heading": "Se ha registrado una nueva llamada"
                },
                "capabilities": {
                    "use_voip": "Make and Answer Calls"
                },
                "take_notes": "Tome notas de las llamadas mientras habla..."
            },
            "twilio": {
                "create_app": "Crear aplicación",
                "disconnect": "Desconectar Integración",
                "number": "Seleccione el número Twilio de su cuenta que se utilizará para hacer y recibir llamadas.",
                "retrieve_numbers": "Retrieve Numbers",
                "app": "Crear una aplicación que se encargará de iniciar nuevas llamadas y llamadas entrantes."
            }
        },
        "comments": {
            "comment": {
                "add": "Agregar comentario",
                "comments": "Comentarios",
                "reply": "Respuesta",
                "created": "Comentario agregado correctamente",
                "updated": "Comentario actualizado correctamente",
                "user_left_comment": "{user} dejó un comentario",
                "total": "Comentarios ({total})",
                "no_comments": "No hay comentarios.",
                "add_placeholder": "Escribe un nuevo comentario, envía una notificación a tu equipo escribiendo {'@'} seguido de su nombre"
            }
        },
        "contacts": {
            "company": {
                "company": "Empresa",
                "companies": "Empresas",
                "add": "Agregar empresa",
                "dissociate": "Empresa disociada",
                "child": "Empresa infantil | Empresas infantiles",
                "create": "Crear empresa",
                "export": "Exportar empresas",
                "total": "Total de empresas",
                "import": "Importar empresas",
                "create_with": "Crear empresa con {name}",
                "associate_with": "Asociar empresa con {name}",
                "associate_field_info": "Utilice este campo para buscar y asociar empresas existentes en lugar de crear una nueva.",
                "no_contacts_associated": "La empresa no tiene contactos asociados.",
                "no_deals_associated": "La empresa no tiene acuerdos asociados.",
                "exists_in_trash_by_email": "La empresa con esta dirección de correo electrónico ya existe en la papelera, no podrá crear una nueva empresa con la misma dirección de correo electrónico, ¿desea restaurar la empresa eliminada?",
                "exists_in_trash_by_name": "Ya existe una empresa con el mismo nombre en la papelera, ¿desea restaurar la empresa eliminada?",
                "exists_in_trash_by_phone": "Company ({company}) with the following numbers: {phone_numbers}, already exists in the trash, would you like to restore the trashed company?",
                "possible_duplicate": "Possible duplicate company {display_name}.",
                "count": {
                    "all": "1 empresas | {count} empresas"
                },
                "notifications": {
                    "assigned": "Has sido asignado a una empresa {name} por {user}"
                },
                "cards": {
                    "by_source": "Empresas por procedencia",
                    "by_day": "Empresas por día"
                },
                "settings": {
                    "automatically_associate_with_contacts": "Crear y asociar automáticamente empresas a contactos",
                    "automatically_associate_with_contacts_info": "Asocie automáticamente contactos con empresas basándose en una dirección de correo electrónico de contacto y un dominio de empresa."
                },
                "industry": {
                    "industries": "Sectores",
                    "industry": "Sector"
                },
                "filters": {
                    "my": "Mis empresas",
                    "my_recently_assigned": "Mis empresas asignadas recientemente"
                },
                "mail_placeholders": {
                    "assigneer": "Nombre del usuario que asignó la empresa"
                },
                "workflows": {
                    "triggers": {
                        "created": "Empresa creada"
                    },
                    "actions": {
                        "fields": {
                            "email_to_company": "Correo electrónico de empresa",
                            "email_to_owner_email": "Correo electrónico del propietario",
                            "email_to_creator_email": "Correo electrónico del creador",
                            "email_to_contact": "Contacto principal de la empresa"
                        }
                    }
                },
                "validation": {
                    "email": {
                        "unique": "Ya existe una empresa con este correo electrónico."
                    }
                },
                "empty_state": {
                    "title": "You have not created any companies.",
                    "description": "Get started by creating a new company."
                }
            },
            "contact": {
                "contact": "Contacto",
                "contacts": "Contactos",
                "convert": "Convertir en contacto",
                "create": "Crear contacto",
                "add": "Agregar contacto",
                "total": "Total de contactos",
                "import": "Importar Contactos",
                "export": "Exportar Contactos",
                "no_companies_associated": "El contacto no tiene empresas asociadas.",
                "no_deals_associated": "El contacto no tiene ninguna oferta asociada.",
                "works_at": "{job_title} en {company}",
                "create_with": "Crear contacto con {name}",
                "associate_with": "Asociar contacto con {name}",
                "associated_company": "Empresa de contacto asociada",
                "dissociate": "Disociar el contacto",
                "exists_in_trash_by_email": "El contacto con esta dirección de correo electrónico ya existe en la papelera, no podrá crear un nuevo contacto con la misma dirección de correo electrónico, ¿desea restaurar el contacto eliminado?",
                "exists_in_trash_by_phone": "Contact ({contact}) with the following numbers: {phone_numbers}, already exists in the trash, would you like to restore the trashed contact?",
                "possible_duplicate": "Possible duplicate contact {display_name}.",
                "associate_field_info": "Utilice este campo para buscar y asociar un contacto existente en lugar de crear uno nuevo.",
                "cards": {
                    "recently_created": "Contactos creados recientemente",
                    "recently_created_info": "Muestra el {total} de contactos creados en los últimos {days}, ordenados por el más reciente en la parte superior.",
                    "by_day": "Contactos por día",
                    "by_source": "Contactos por origen"
                },
                "count": {
                    "all": "1 contacto | {count} contactos"
                },
                "notifications": {
                    "assigned": "Ha sido asignado a un contacto {name} por {user}"
                },
                "filters": {
                    "my": "Mis contactos",
                    "my_recently_assigned": "Mis contactos asignados recientemente"
                },
                "mail_placeholders": {
                    "assigneer": "Nombre del usuario que asignó el contacto"
                },
                "workflows": {
                    "triggers": {
                        "created": "Contacto creado"
                    },
                    "actions": {
                        "fields": {
                            "email_to_contact": "Correo electrónico de contacto",
                            "email_to_owner_email": "Correo electrónico del propietario",
                            "email_to_creator_email": "Correo electrónico del creador",
                            "email_to_company": "Contactar con la empresa principal"
                        }
                    }
                },
                "validation": {
                    "email": {
                        "unique": "Ya existe un contacto o miembro del equipo con este correo electrónico."
                    },
                    "phone": {
                        "unique": "Ya existe un contacto con este número de teléfono."
                    }
                },
                "empty_state": {
                    "title": "You have not created any contacts.",
                    "description": "Start organizing the persons now."
                }
            },
            "fields": {
                "phone": {
                    "add": "+ Añadir otro",
                    "copied": "Número de teléfono copiado en el portapapeles",
                    "types": {
                        "type": "Escribir",
                        "mobile": "Teléfono móvil",
                        "work": "Trabajo",
                        "other": "Otro"
                    }
                },
                "contacts": {
                    "first_name": "Nombre",
                    "last_name": "Apellido",
                    "email": "Dirección de correo electrónico",
                    "job_title": "Nombre del trabajo",
                    "phone": "Teléfono",
                    "street": "Dirección",
                    "city": "Ciudad",
                    "state": "Estado/Región",
                    "postal_code": "Código postal",
                    "owner_assigned_date": "Fecha de asignación del propietario",
                    "country": {
                        "name": "País"
                    },
                    "source": {
                        "name": "Fuente"
                    },
                    "user": {
                        "name": "Propietario"
                    }
                },
                "companies": {
                    "name": "Nombre",
                    "email": "Dirección de correo electrónico",
                    "parent": {
                        "name": "Empresa principal"
                    },
                    "phone": "Teléfono",
                    "street": "Dirección",
                    "city": "Ciudad",
                    "state": "Estado/Región",
                    "postal_code": "Código postal",
                    "domain": "Nombre de dominio de la empresa",
                    "owner_assigned_date": "Fecha de asignación del propietario",
                    "country": {
                        "name": "País"
                    },
                    "industry": {
                        "name": "Sector"
                    },
                    "user": {
                        "name": "Propietario"
                    },
                    "source": {
                        "name": "Fuente"
                    }
                }
            },
            "source": {
                "source": "Fuente",
                "sources": "Fuentes",
                "delete_primary_warning": "No se puede eliminar la fuente principal."
            }
        },
        "deals": {
            "board": {
                "board": "Tablero",
                "columns_sorted": "Columns successfully sorted"
            },
            "deal": {
                "deal": "Oferta",
                "deals": "Ofertas",
                "create": "Crear oferta",
                "add": "Agregar oferta",
                "sort_by": "Ordenar ofertas por",
                "name": "Nombre de la operación",
                "choose_or_create": "Escoger o crear oferta",
                "associate_with": "Asociar oferta con {name}",
                "add_products": "Agregar productos",
                "dont_add_products": "No agregar productos",
                "reopen": "Reabrir",
                "won_date": "Won Date",
                "lost_date": "Lost Date",
                "status_related_filter_notice": "This rule is applicable mostly when filtering deals with status \"{status}\".",
                "status": {
                    "status": "Estado",
                    "won": "Ganado",
                    "lost": "Perdido",
                    "open": "Abierto"
                },
                "been_in_stage_time": "Ha estado aquí por {time}",
                "hasnt_been_in_stage": "Este acuerdo aún no ha llegado a esta etapa",
                "total_created": "Total creados",
                "total_assigned": "Total asignados",
                "import": "Importar ofertas",
                "export": "Exportar ofertas",
                "import_in": "Importar ofertas en {pipeline}",
                "total": "Ofertas totales",
                "closed_deals": "Ofertas cerradas",
                "won_deals": "Ofertas ganadas",
                "open_deals": "Ofertas abiertas",
                "lost_deals": "Ofertas perdidas",
                "forecast_amount": "Importe previsto",
                "closed_amount": "Importe cerrado",
                "dissociate": "Disociar trato",
                "no_companies_associated": "La oferta no tiene empresas asociadas",
                "no_contacts_associated": "La oferta no tiene contactos asociados",
                "associate_field_info": "Utilice este campo para asociar una operación existente en lugar de crear una nueva.",
                "create_with": "Crear oferta con {name}",
                "already_associated": "Esta oferta ya está asociada con {with}.",
                "lost_reasons": {
                    "lost_reason": "Razón perdida",
                    "lost_reasons": "Razones perdidas",
                    "name": "Nombre",
                    "choose_lost_reason": "Elija un motivo perdido",
                    "choose_lost_reason_or_enter": "Elija un motivo perdido o ingrese manualmente"
                },
                "settings": {
                    "lost_reason_is_required": "Se requiere razón de pérdida",
                    "lost_reason_is_required_info": "Cuando se active esta opción, los agentes de ventas deberán elegir o introducir el motivo de la pérdida al marcar la operación como perdida.",
                    "allow_lost_reason_enter": "Permitir a los agentes de ventas introducir un motivo de pérdida personalizado",
                    "allow_lost_reason_enter_info": "Cuando se desactive, los agentes de ventas sólo podrán elegir de la lista predefinida de motivos de pérdida cuando marquen la operación como perdida."
                },
                "cards": {
                    "by_stage": "Ofertas por etapa",
                    "lost_in_stage": "Etapa de ofertas perdidas",
                    "lost_in_stage_info": "Visualiza en qué etapa se pierden más negocios. Las etapas que se muestran en los informes son las etapas a las que pertenecía la oferta en el momento en que se marcó como perdida.",
                    "won_in_stage": "Etapa de acuerdos ganados",
                    "won_in_stage_info": "Vea en qué etapa se ganan más los negocios. Las etapas que se muestran en los informes son las etapas a las que pertenecía el negocio en el momento en que se marcó como ganado.",
                    "closing": "Cerrar acuerdos",
                    "closing_info": "Vea los tratos que se prevé que se cerrarán en función del período seleccionado y la fecha de cierre prevista; los tratos marcados como \"Ganados\" o \"Perdidos\" se excluyen de la lista.",
                    "recently_created": "Ofertas creadas recientemente",
                    "recently_modified": "Ofertas modificadas recientemente",
                    "won_by_revenue_by_month": "Ingresos de negocios ganados por mes",
                    "won_by_date": "Acuerdos ganados por día",
                    "assigned_by_sale_agent": "Acuerdos asignados por el agente de ventas",
                    "assigned_by_sale_agent_info": "Vea el número total de acuerdos asignados para cada representante de ventas. Vea cuántos ingresos es probable que estas ofertas generen para su negocio. Y cuántos ingresos ya tiene de acuerdos cerrados.",
                    "created_by_sale_agent": "Operaciones creadas por el agente de ventas",
                    "created_by_sale_agent_info": "Vea qué representantes de ventas están creando la mayor cantidad de tratos. Vea cuántos ingresos es probable que estas ofertas generen para su negocio. Y cuántos ingresos ya tiene de acuerdos cerrados.",
                    "recently_created_info": "Mostrando el último {total} de tratos creados en los últimos {days} días, ordenados por los más nuevos en la parte superior",
                    "recently_modified_info": "Mostrando el último {total} de ofertas modificadas en los últimos {days} días.",
                    "won_by_month": "Contratos ganados por mes"
                },
                "notifications": {
                    "assigned": "Ha sido asignado a la operación {name} por {user}"
                },
                "stage": {
                    "weighted_value": "{weighted_total} - {win_probability} de {total}",
                    "changed_date": "Etapa de fecha de modificación",
                    "add": "Añadir nueva etapa",
                    "name": "Nombre de la etapa",
                    "win_probability": "Probabilidad de ganar",
                    "delete_usage_warning": "La etapa ya está asociada a las operaciones, por lo que no puede eliminarse."
                },
                "deal_amount": "Importe de la operación",
                "deal_expected_close_date": "Fecha prevista de cierre de la operación",
                "count": {
                    "all": "1 oferta| {count} ofertas",
                    "open": "recuento de operaciones abiertas {resource}",
                    "won": "recuento de operaciones ganadas {resource}",
                    "lost": "recuento de operaciones perdidas {resource}",
                    "closed": "recuento de operaciones cerradas {resource}"
                },
                "pipeline": {
                    "name": "Nombre del proyecto",
                    "pipeline": "Proyecto",
                    "pipelines": "Proyectos",
                    "create": "Crear proyecto",
                    "edit": "Editar proyecto",
                    "updated": "Proyecto actualizado correctamente",
                    "deleted": "Proyecto eliminado correctamente",
                    "delete_primary_warning": "No se puede eliminar el proyecto principal",
                    "delete_usage_warning_deals": "El proyecto ya está asociado a las operaciones, por lo que no se puede eliminar.",
                    "visibility_group": {
                        "primary_restrictions": "Este es el proyecto principal, por lo tanto, la visibilidad no se puede cambiar."
                    },
                    "reorder": "Reordenar proyectos",
                    "missing_stages": "The pipeline does not have any stages."
                },
                "actions": {
                    "change_stage": "Cambiar etapa",
                    "mark_as_open": "Marcar como abierto",
                    "mark_as_won": "Marcar como ganado",
                    "mark_as_lost": "Marcar como perdido"
                },
                "filters": {
                    "my": "Mis ofertas",
                    "my_recently_assigned": "Mis últimas ofertas asignadas",
                    "created_this_month": "Ofertas creadas este mes",
                    "won": "Acuerdos ganados",
                    "lost": "Acuerdos perdidos",
                    "open": "Ofertas abiertas"
                },
                "mail_placeholders": {
                    "assigneer": "El nombre de usuario que asignó la operación"
                },
                "workflows": {
                    "triggers": {
                        "status_changed": "Modificación del estado de la operación",
                        "stage_changed": "Etapa de la operación modificada",
                        "created": "Oferta creada"
                    },
                    "actions": {
                        "mark_associated_activities_as_complete": "Marcar las actividades asociadas como finalizadas",
                        "mark_associated_deals_as_won": "Marcar acuerdos asociados como ganados",
                        "mark_associated_deals_as_lost": "Marcar acuerdos asociados como perdidos",
                        "delete_associated_activities": "Eliminar actividades asociadas",
                        "fields": {
                            "email_to_contact": "Contacto principal de la operación",
                            "email_to_company": "Empresa principal de la operación",
                            "email_to_owner_email": "Correo electrónico del propietario de la operación",
                            "email_to_creator_email": "Correo electrónico del creador de la oferta",
                            "lost_reason": "Con el siguiente motivo de pérdida"
                        }
                    }
                },
                "timeline": {
                    "stage": {
                        "moved": "{user} movió trato de {previous} a {stage} etapa"
                    },
                    "marked_as_lost": "{user} marcó trato como perdido por el siguiente motivo: {reason}",
                    "marked_as_won": "{user} marcó la oferta como ganada",
                    "marked_as_open": "{user} marcó la oferta como abierta"
                },
                "metrics": {
                    "open": "Ofertas abiertas"
                },
                "empty_state": {
                    "title": "You have not created any deals.",
                    "description": "Get started by creating a new deal."
                }
            },
            "fields": {
                "deals": {
                    "name": "Nombre de la transacción",
                    "expected_close_date": "Fecha prevista de cierre",
                    "amount": "Importe",
                    "owner_assigned_date": "Fecha de asignación del propietario",
                    "user": {
                        "name": "Titular"
                    },
                    "stage": {
                        "name": "Etapa"
                    },
                    "pipeline": {
                        "name": "Proyecto"
                    }
                }
            }
        },
        "documents": {
            "document": {
                "document": "Documento",
                "documents": "Documentos",
                "create": "Crear documentos",
                "info": "Envíe cotizaciones, propuestas y contratos personalizables para cerrar negocios más rápido.",
                "view": "Vista",
                "manage_documents": "Gestionar documentos",
                "total_documents": "Total de documentos",
                "total_draft_documents": "Total de borradores de documentos",
                "deleted": "Documento eliminado correctamente",
                "document_details": "Detalles del documento",
                "document_activity": "Actividad del documento",
                "document_products": "Documento de productos",
                "download_pdf": "Descargar PDF",
                "view_pdf": "Ver PDF en el navegador",
                "accept": "Aceptar",
                "sign": "Registrar",
                "sent": "Documento enviado correctamente",
                "deal_description": "Cuando se selecciona una oferta, ésta se asocia automáticamente al documento, los contactos de la oferta se añaden como firmantes y todos los productos de la oferta se añaden al documento.",
                "settings": {
                    "inherits_setting_from_brand": "Inherits from brand"
                },
                "products_snippet_missing": "To ensure that the products appear in the document preview and PDF, make sure to add them to the content via the {icon} icon.",
                "signatures_snippet_missing": "To ensure that the signatures appear in the document PDF, make sure to add them to the content via the {icon} icon.",
                "will_use_placeholders_from_record": "The placeholders added in the document content related to the {resourceName} resource will be taken form this record",
                "placeholders_replacement_info": "The placeholders of the document related to resources are replaced based on the first associated record, make sure to add associations to the document.",
                "limited_editing": "Este documento es aceptado, las capacidades de edición son limitadas.",
                "title": "Título",
                "copy_url": "Copiar la URL pública del documento",
                "url_copied": "URL copiada al portapapeles",
                "count": {
                    "all": "1 documento | {count} documentos"
                },
                "sections": {
                    "details": "Más información",
                    "send": "Enviar",
                    "signature": "Firma",
                    "content": "Contenido",
                    "products": "Productos"
                },
                "status": {
                    "status": "Estado",
                    "draft": "Borrador",
                    "sent": "Enviado",
                    "accepted": "Aceptado",
                    "lost": "Perdido"
                },
                "send": {
                    "select_brand": "Seleccione primero una marca para enviar el documento.",
                    "connect_an_email_account": "Conecta una cuenta de correo para enviar documentos.",
                    "send_from_account": "Enviar el documento desde la siguiente cuenta",
                    "save_to_schedule": "Para programar el envío de documentos, primero deberá guardar el documento",
                    "send_subject": "Asunto del mensaje",
                    "send_body": "Mensaje de texto",
                    "send_later": "¿Enviar más tarde?",
                    "send": "Enviar documento",
                    "select_schedule_date": "Escoger fecha y hora",
                    "schedule": "Calendario",
                    "is_scheduled": "Este documento está programado para ser enviado el {date}",
                    "send_to_signers": "Enviar el documento a los siguientes participantes",
                    "send_to_signers_empty": "Para enviar el documento a los participantes, añada participantes a través de la sección \"Participante\"."
                },
                "sent_by": "Enviado por",
                "sent_at": "Enviado el {date}",
                "signers": {
                    "add": "Agregar nuevo titular",
                    "no_signers": "Sin participantes, agregue participantes para este documento",
                    "is_signed": "¿Firmado?",
                    "document_signers": "Documentos firmados",
                    "signer_name": "Nombre",
                    "signer_email": "Dirección de correo electrónico",
                    "signature_date": "Fecha",
                    "name": "Nombre del titular",
                    "email": "Correo electrónico del titular",
                    "enter_full_name": "Ingrese el nombre completo del titular",
                    "enter_email": "Por favor, ingrese su correo electrónico",
                    "confirm_email": "Confirme su correo electrónico"
                },
                "accepted_at": "Aceptado en",
                "signature": {
                    "no_signature": "Sin firma",
                    "no_signature_description": "Este documento no requiere una firma antes de su aceptación.",
                    "e_signature": "Usar la firma electrónica",
                    "e_signature_description": "Este documento requiere firma electrónica antes de su aceptación.",
                    "signature": "Firma",
                    "signatures": "Firmas",
                    "signed_on": "Firmado",
                    "sign_ip": "Dirección de IP",
                    "verification_failed": "No hemos podido verificar su dirección de correo electrónico como titular, póngase en contacto con la persona que le envió el documento para que le facilite información sobre la dirección de correo electrónico utilizada.",
                    "accept_name": "Para aceptar, escriba su nombre a continuación"
                },
                "reactivated": "Documento reactivado",
                "marked_as_lost": "Documento marcado correctamente como perdido",
                "marked_as_accepted": "Documento marcado correctamente como aceptado",
                "actions": {
                    "mark_as_lost": "Marcar como perdido",
                    "mark_as_lost_message": "Esta acción marcará este documento como perdido y ninguno de los destinatarios podrá acceder a él.",
                    "mark_as_accepted": "Marcar como aceptado",
                    "reactivate": "Reactivar",
                    "undo_acceptance": "Deshacer la confirmación"
                },
                "cards": {
                    "by_type": "Documentos por tipo",
                    "by_status": "Documentos por estado",
                    "sent_by_day": "Documentos enviados por día"
                },
                "recipients": {
                    "add": "Añadir nuevo destinatario",
                    "enter_full_name": "Introduzca el nombre completo del destinatario",
                    "enter_email": "Introduzca la dirección de correo electrónico del destinatario",
                    "no_recipients": "No hay destinatarios para enviar el documento.",
                    "is_sent": "¿Enviado?",
                    "recipients": "Destinatarios",
                    "additional_recipients": "Additional recipients",
                    "recipient_name": "Nombre",
                    "recipient_email": "Dirección de correo electrónico",
                    "name": "Nombre del destinatario",
                    "email": "Correo electrónico del destinatario"
                },
                "view_type": {
                    "html_view_type": "Vista HTML",
                    "template_info": "Cuando una plantilla tiene un tipo de vista, después de insertarse, el tipo de vista del documento se actualizará con el tipo de plantilla.",
                    "nav_top": {
                        "name": "Navegación hacia arriba",
                        "description": "Útil para documentos simples que no requieren navegación a través de encabezados."
                    },
                    "nav_left": {
                        "name": "Navegación a la izquierda",
                        "description": "Útil para documentos que requieren navegación a través de encabezados ({headingTagName})."
                    },
                    "nav_left_full_width": {
                        "name": "Navegación a la izquierda - Ancho completo",
                        "description": "La sección de contenido no tiene margen, útil para documentos de ancho completo con encabezados ({headingTagName})."
                    }
                },
                "type": {
                    "type": "Tipo de documento",
                    "types": "Tipos de documentos",
                    "name": "Nombre",
                    "default_type": "Tipo de documento predeterminado",
                    "delete_primary_warning": "No puede eliminar el tipo de documento principal.",
                    "delete_usage_warning": "Este tipo ya está asociado a los documentos, por lo que no puede eliminarse.",
                    "delete_is_default": "Este es un tipo de documento predeterminado, por lo tanto, no se puede eliminar.",
                    "cannot_change_visibility_on_default": "This is a default company wide type, hence, the visibility cannot be changed."
                },
                "template": {
                    "insert_template": "Insertar plantilla",
                    "save_as_template": "Guardar como plantilla",
                    "manage": "Gestionar plantillas",
                    "template": "Plantilla de documento",
                    "templates": "Plantillas de documento",
                    "create": "Crear plantilla",
                    "name": "Nombre de plantilla",
                    "deleted": "Plantilla eliminada correctamente",
                    "share_with_team_members": "¿Compartir esta plantilla con otros miembros del equipo?",
                    "is_shared": "Compartido",
                    "empty_state": {
                        "title": "You have not created any templates.",
                        "description": "Create documents faster by using predefined templates."
                    }
                },
                "workflows": {
                    "triggers": {
                        "status_changed": "Estado del documento modificado"
                    },
                    "actions": {
                        "fields": {
                            "email_to_contact": "Documento de contacto principal",
                            "email_to_company": "Documento de empresa principal",
                            "email_to_owner_email": "Correo electrónico del propietario del documento",
                            "email_to_creator_email": "Correo electrónico del creador del documento"
                        }
                    }
                },
                "timeline": {
                    "heading": "Documento creado"
                },
                "mail_placeholders": {
                    "assigneer": "Nombre del usuario que asignó el documento"
                },
                "notifications": {
                    "signed": "El documento {title} ha sido firmado",
                    "assigned": "Ha sido asignado al documento {title} por {user}",
                    "accepted": "El documento {title} ha sido aceptado",
                    "viewed": "El documento {title} ha sido visto"
                },
                "filters": {
                    "status_disabled": "El formato se utiliza en el filtro actual, por lo que no puede seleccionar el formato en esta sección."
                },
                "activity": {
                    "created": "El documento ha sido creado por {user}",
                    "sent": "El documento ha sido enviado {user}",
                    "marked_as_lost": "{user} marcó el documento como perdido",
                    "marked_as_accepted": "{user} marcó el documento como aceptado",
                    "marked_as_draft": "{user} marcó el documento como borrado",
                    "sent_recipient": "{name} - {email}",
                    "signed": "El documento ha sido firmado por {signer_name}",
                    "accepted": "El documento ha sido aceptado",
                    "viewed": "El documento ha sido revisado",
                    "downloaded": "El documento PDF fue descargado"
                },
                "empty_state": {
                    "title": "You have not created any documents.",
                    "description": "Close deals faster by sending good looking trackable documents."
                }
            },
            "fields": {
                "documents": {
                    "title": "Título del documento",
                    "owner_assigned_date": "Fecha de asignación del propietario",
                    "accepted_at": "Aceptado en",
                    "amount": "Importe",
                    "original_date_sent": "Fecha original de envío",
                    "last_date_sent": "Última fecha de envío",
                    "brand": {
                        "name": "Marca"
                    },
                    "user": {
                        "name": "Titular"
                    },
                    "type": {
                        "name": "Escribir"
                    }
                }
            },
            "pdf": {
                "default_font": "Default font family",
                "default_font_info": "The {fontName} font gives the most decent Unicode character coverage by default, make sure to select a proper font if special or unicode characters are not displayed properly on the PDF document.",
                "size": "Size",
                "orientation": "Orientation",
                "orientation_portrait": "Portrait",
                "orientation_landscape": "Landspace",
                "settings": "PDF Settings",
                "padding": "PDF padding",
                "no_padding": "No additional padding"
            }
        },
        "mailclient": {
            "inbox": {
                "inbox": "Bandeja",
                "shared": "Bandeja de entrada compartida",
                "new_message": "Mensaje nuevo",
                "trash": "Mover a papelera",
                "move_to": "Mover a",
                "forward": "Adelante",
                "reply": "Responder",
                "reply_all": "Responder a todos",
                "reply_to_message": "Responder a {subject}",
                "forward_message": "Reenviar {subject}",
                "forwarded_message_placeholder": "{pre} Forwarded message {after}<br />\n                                        From: {from}<br />\n                                        Date: {date}<br />\n                                        Subject: {subject}<br />\n                                        To: {to}",
                "message_sent": "Mensaje enviado con éxito.",
                "search_recipients": "Busque o introduzca una dirección de correo electrónico...",
                "send": "Enviar",
                "sync_in_progress": "El sistema actualmente está sincronizando las cuentas en segundo plano, inténtelo de nuevo más tarde.",
                "synchronize": "Sincronizar",
                "subject": "Asunto",
                "no_subject": "Sin asunto",
                "unknown_address": "Desconocido",
                "from": "De",
                "to": "Para",
                "cc": "Cc",
                "bcc": "Bcc",
                "reply_to": "Responder a",
                "date": "Fecha",
                "unread_count": "Total de mensajes no leídos",
                "pre_send_empty_placeholders_found": "You are about to send an email with empty placeholders. Before proceeding, please confirm that you really want to proceed with this action.",
                "will_use_placeholders_from_record": "The placeholders added in the message content related to the {resourceName} resource will be taken form this record",
                "filters": {
                    "is_read": "Es leído"
                }
            },
            "mail": {
                "compose": "Componer",
                "attachments": "Archivos adjuntos",
                "emails": "Correos electrónicos",
                "create": "Crear correo electrónico",
                "send": "Enviar correo electrónico",
                "view": "View Mail",
                "from_header": "Desde el encabezado",
                "from_name": "Desde el nombre",
                "messages": "Mensajes de correo",
                "message": "Mensaje de correo",
                "new_message_placeholder": "Compose your email here. Type \"{trigger}\" to search dynamic fields.",
                "signature": "Firma de correo electrónico",
                "signature_info": "Cree una firma que se agregará al final de sus mensajes.",
                "show_quoted_content": "Mostrar contenido citado",
                "trimmed_content": "Contenido recortado",
                "disable_sync": "Deshabilitar sincronización",
                "manage_emails": "Administrar correos electrónicos",
                "info": "Puede enviar y responder correos electrónicos directamente a través de esta sección.",
                "from_header_info": "Lo que las personas verán en la \"dirección de remitente\" cuando reciban un correo electrónico de esta dirección de correo electrónico.",
                "placeholders_info": "Use marcadores de posición {placeholders} para reemplazar dinámicamente el contenido, como el nombre de la empresa, el nombre del agente (usuario que envía el correo electrónico).",
                "mark_as_read": "Marcar como leído",
                "mark_as_unread": "Marcar como no leído",
                "message_queued_for_sending": "El mensaje se ha puesto en cola para su envío, se sincronizará en el siguiente grupo de sincronización.",
                "initial_sync_info": "Esta cuenta está en cola para la sincronización inicial y se realizará tan pronto como se ejecute la tarea programada. Para evitar interrupciones, asegúrese de haber configurado la tarea como se explica en la documentación.",
                "account": {
                    "create_contact": "Crear registro de contacto si el registro no existe.",
                    "use_aliass": "Use alias email address",
                    "use_aliass_info": "The address needs to be a valid alias that already exists in the mail server, useful when using Google Workspace aliases.",
                    "enter_alias": "Alias E-Mail Address",
                    "personal": "Personal",
                    "shared": "Compartido",
                    "accounts": "Cuentas de correo electrónico",
                    "sync_emails_from": "Sincronizar correos electrónicos de",
                    "sync_period_now": "Ahora",
                    "sync_period_1_month_ago": "hace 1 mes",
                    "sync_period_3_months_ago": "hace 3 meses",
                    "sync_period_6_months_ago": "hace 6 meses",
                    "sync_period_note": "En la mayoría de los casos no necesitará ni interactuará con todos los correos electrónicos de {date}, un periodo de sincronización inicial más bajo evitará la importación de cientos de correos electrónicos con archivos adjuntos y ayudará a ahorrar espacio de almacenamiento, por lo que siempre se recomienda elegir un periodo de sincronización inicial más bajo.",
                    "integration_not_configured": "No hay cuentas de correo electrónico configuradas, configure cuentas de correo personales o compartidas para poder enviar correos electrónicos.",
                    "already_connected": "Esta cuenta de correo electrónico ya está conectada.",
                    "select_type": "Seleccione el tipo de cuenta",
                    "no_active_folders": "Esta cuenta no tiene carpetas activas. Habilite las carpetas editando la cuenta de correo, las carpetas activas serán las que se sincronizarán con la aplicación.",
                    "activate_folders": "Activar carpetas",
                    "active_folders": "Carpetas activas",
                    "active_folders_info": "Select the folders you wish to synchronize.",
                    "sent_folder": "Carpeta de enviados",
                    "trash_folder": "Carpeta de papelera",
                    "test_connection": "Probar conexión",
                    "is_primary": "Cuenta principal",
                    "connection_error": "Error de prueba de conexión, verifique su configuración, consulte el error para obtener más información: {message}",
                    "create": "Crear cuenta de correo electrónico",
                    "edit": "Editar cuenta de correo electrónico",
                    "manage": "Administrar cuentas",
                    "connect": "Conectar cuenta",
                    "connect_shared": "Conectar cuenta compartida",
                    "connect_personal": "Conectar cuenta personal",
                    "created": "Cuenta de correo electrónico añadida correctamente.",
                    "updated": "Cuenta de correo electrónico actualizada correctamente.",
                    "deleted": "Cuenta de correo electrónico eliminada correctamente",
                    "no_accounts_configured": "No hay cuentas de correo electrónico configuradas",
                    "no_accounts_configured_info": "Conecte una cuenta para empezar a enviar y organizar correos electrónicos con el fin de cerrar acuerdos más rápidamente",
                    "create_shared_info": "Conecte una cuenta de correo electrónico de la empresa, como contact{'@'}company.com o sales{'@'}company.com",
                    "create_shared_confirmation_message": "Cuando conecte una cuenta de correo electrónico compartida, tenga en cuenta que todos los miembros del equipo a los que se les ha otorgado \"acceso a la bandeja de entrada compartida\" pueden acceder a las cuentas de correo electrónico compartidas. <br /> <br />\n        Esto significa que cada miembro del equipo podrá ver e interactuar con los correos.",
                    "missing_sent_folder": "Action required, select the sent folder for this account.",
                    "missing_trash_folder": "Action required, select the trash folder for this account.",
                    "missing_primary_account": "Action required, configure a primary account for sending emails.",
                    "type": "Tipo de cuenta",
                    "email_address": "Dirección de correo electrónico",
                    "password": "Contraseña",
                    "username": "Nombre de usuario",
                    "incoming_mail": "Correo entrante (IMAP)",
                    "outgoing_mail": "Correo saliente (SMTP)",
                    "server": "Servidor",
                    "port": "Puerto",
                    "allow_non_secure_certificate": "Permitir certificado no seguro",
                    "encryption": "Cifrado",
                    "without_encryption": "Sin cifrado",
                    "delete_warning": "Si está utilizando esta cuenta de correo electrónico como \"Cuenta de correo electrónico del sistema\" en la configuración, deberá seleccionar otra cuenta para enviar correos electrónicos relacionados con el sistema; además, deberá verificar sus flujos de trabajo, si algún flujo está configurado para usar \"Enviar correo electrónico\" con esta cuenta de correo electrónico en particular, deberá actualizar la cuenta de correo de acción para que el flujo de trabajo continúe enviando correos.",
                    "featured": {
                        "sync": "Sincronización bidireccional de correo electrónico con su proveedor de correo electrónico.",
                        "save_time": "Ahorre tiempo haciendo uso de plantillas predefinidas.",
                        "placeholders": "Redacte correos electrónicos y plantillas con marcadores de posición.",
                        "signature": "Agregue una firma personalizada para una apariencia más profesional.",
                        "associations": "Asocia correos electrónicos a muchos {resources} y {resource}.",
                        "types": "Conéctese a través de IMAP, su cuenta de Gmail o Outlook."
                    }
                },
                "templates": {
                    "select": "Sleccionar",
                    "create": "Crear plantilla",
                    "name": "Nombre",
                    "subject": "Asunto",
                    "is_shared": "¿Compartir esta plantilla con otros miembros del equipo?",
                    "body": "Cuerpo",
                    "templates": "Plantillas",
                    "created": "Plantilla de correo creada con éxito.",
                    "updated": "Plantilla de correo actualizada con éxito.",
                    "deleted": "Plantilla de correo eliminada con éxito."
                },
                "labels": {
                    "CATEGORY_PERSONAL": "Personal",
                    "CATEGORY_SOCIAL": "Social",
                    "CATEGORY_FORUMS": "Foros",
                    "IMPORTANT": "Importante",
                    "CATEGORY_UPDATES": "Actualizaciones",
                    "CATEGORY_PROMOTIONS": "Promociones",
                    "CHAT": "Chat",
                    "SENT": "Enviado",
                    "INBOX": "Bandeja",
                    "TRASH": "Papelera",
                    "DRAFT": "Borrador",
                    "DRAFTS": "BORRADORES",
                    "SPAM": "Spam",
                    "STARRED": "Destacado",
                    "UNREAD": "Sin leer"
                },
                "workflows": {
                    "actions": {
                        "send": "Enviar correo electrónico"
                    },
                    "fields": {
                        "from_account": "Desde la cuenta de correo electrónico",
                        "subject": "Con asunto",
                        "message": "Con mensaje",
                        "to": "Para",
                        "send_from_owner_primary_account": "Owner Primary Email Account"
                    }
                },
                "validation": {
                    "invalid_recipients": "Parece que algunos de sus destinatarios tienen una dirección no válida."
                }
            },
            "schedule": {
                "send_later": "Send Later",
                "choose_date": "Choose date",
                "schedule": "Schedule",
                "scheduled_emails": "Scheduled Emails",
                "cancel_and_delete": "Cancel and delete",
                "message_scheduled": "The message was scheduled to be sent later",
                "will_retry_at": "Will retry at: {date}",
                "send_now": "Send Now",
                "scheduled_at": "Date Scheduled",
                "sent_at": "Date Sent",
                "scheduled_by": "Scheduled By",
                "status": "Status",
                "statuses": {
                    "pending": "Pending",
                    "sent": "Sent",
                    "sending": "Sending",
                    "failed": "Failed"
                }
            }
        },
        "notes": {
            "note": {
                "notes": "Notas",
                "note": "Nota",
                "add": "Agregar nota",
                "create_notes": "Crear notas",
                "manage_notes": "Administrar notas",
                "info": "Puede crear notas para usted y su equipo, y realizar un seguimiento de la información importante aquí.",
                "info_created": "{user} dejó una nota el {date}",
                "follow_up_task_body": "Con respecto a una nota: {content}",
                "write": "Escribir una nota...",
                "created": "Nota creada correctamente",
                "updated": "Nota actualizada correctamente",
                "deleted": "Nota eliminada correctamente",
                "timeline": {
                    "heading": "Se ha creado una nueva nota"
                }
            }
        },
        "themestyle": {
            "style": {
                "theme_style": "Theme Style",
                "lightness_maximum": "Lightness Maximum",
                "lightness_minimum": "Lightness Minimum"
            }
        },
        "translator": {
            "translator": {
                "translator": "Traductor",
                "new_locale": "Nueva ubicación",
                "create_new_locale": "Crear nueva ubicación",
                "locale_name": "Nombre de la ubicación",
                "group_has_unsaved_translations": "The group has unsaved translations!",
                "changes_not_saved": "No ha guardado las traducciones para este grupo, para evitar perder sus traducciones, guarde el grupo haciendo clic en el botón \"Guardar\", ubicado en la parte inferior de la página.",
                "tools": {
                    "json-language": "Generar archivo de idioma JSON"
                }
            }
        },
        "users": {
            "profile": {
                "update": "Actualización del perfil",
                "profile": "Perfil",
                "updated": "Perfil actualizado correctamente",
                "password_updated": "Contraseña actualizada correctamente",
                "avatar_info": "Sube tu avatar para que los miembros de tu equipo puedan reconocer tu perfil fácilmente.",
                "profile_info": "Actualice su perfil, incluida la firma de correo electrónico y la dirección de correo electrónico de inicio de sesión.",
                "localization_info": "Adapte la localización de su perfil a sus necesidades.",
                "notifications_info": "Decide qué mensajes quieres recibir y cómo.",
                "password_info": "Actualice la contraseña de su cuenta, para obtener una contraseña más segura, utilice el generador de contraseñas."
            },
            "team": {
                "teams": "Equipos",
                "team": "Equipo",
                "add": "Agregar equipo",
                "create": "Crear nuevo equipo",
                "edit": "Editar equipo",
                "name": "Nombre del equipo",
                "members": "Miembros del equipo",
                "description": "Descripción del equipo",
                "owner_team": "Equipo propietario",
                "select": "Seleccionar equipos",
                "manager": "Gerente",
                "your_teams": "Your Team|Your Teams",
                "managing_teams": "All of the teams and people you are managing.",
                "capabilities": {
                    "team_only": "Solo equipo"
                },
                "empty_state": {
                    "title": "No teams",
                    "description": "Get started by creating a new team."
                }
            },
            "user": {
                "user": "Usuario",
                "users": "Usuarios",
                "not_found": "No se encontraron usuarios",
                "create": "Crear usuario",
                "invite": "Invitar usuario",
                "send_invitation": "Enviar invitación",
                "accept_invitation": "Aceptar invitación",
                "invited": "Invitación de usuario enviada",
                "admin_users_excluded": "Los usuarios administradores están excluidos",
                "select": "Seleccionar usuarios",
                "invitation_expires_after_info": "Se enviará un correo con un enlace de invitación al usuario para crear una cuenta, el enlace será válido por {total} de días y se invalidará después de que se cree la cuenta.",
                "edit": "Editar usuario",
                "sales_agent": "Agente de ventas",
                "name": "Nombre",
                "email": "Dirección de correo electrónico",
                "roles": "Funciones de los usuarios",
                "localization": "Ubicación",
                "enable_api": "Habilitar el acceso a la API",
                "super_admin": "Super Admin",
                "as_super_admin_info": "Habilitar el acceso de superadministrador para el usuario, esto le dará acceso completo a todas las funciones sin ninguna limitación.",
                "allow_api_info": "Permitir al usuario generar claves de API y utilizarlas para realizar solicitudes a los puntos finales de la aplicación.",
                "assign": "Asignar",
                "not_authorized": "Su cuenta no está autorizada para realizar esta acción",
                "delete_transfer_to_same_user_warning": "No puede transferir los datos al mismo usuario.",
                "delete_own_account_warning": "No puede eliminar su propia cuenta.",
                "transfer_data_info": "Los datos de este usuario deben transferirse a otro usuario. Seleccione el usuario al que desea transferir los datos.",
                "actions": {
                    "delete": "Eliminar usuario"
                },
                "notifications": {
                    "user_mentioned": "Usted ha sido mencionado por {name}"
                }
            }
        },
        "webforms": {
            "form": {
                "forms": "Formularios web",
                "form": "Formulario web",
                "created": "Formulario web añadido correctamente.",
                "updated": "Formulario web actualizado con éxito.",
                "deleted": "Formulario web eliminado con éxito.",
                "submission": "Envío de formularios web",
                "total_submissions": "Envíos: {total}",
                "editor": "Editor",
                "submit_options": "Opciones de envío",
                "info": "Crear formularios web personalizables que se pueden incrustar en su sitio web existente o compartir los formularios como enlace para crear automáticamente, ofertas, contactos y empresas.",
                "inactive_info": "Este formulario está inactivo, usted puede previsualizar el formulario porque ha iniciado sesión, si desea que esté disponible públicamente, asegúrese de establecer el formulario como activo.",
                "create": "Crear formulario web",
                "active": "Activo",
                "title": "Título",
                "title_visibility_info": "El título no es visible para los visitantes que rellenen el formulario.",
                "fields_action_required": "Acción adicional requerida",
                "required_fields_needed": "Para guardar nuevas ofertas, debe agregar al menos el campo de correo electrónico o teléfono de contacto.",
                "must_requires_fields": "Para guardar nuevas ofertas, su formulario web debe requerir al menos un campo de correo electrónico o teléfono de contacto.",
                "non_optional_fields_required": "Campos no opcionales obligatorios",
                "notifications": "Notificaciones",
                "notification_email_placeholder": "Ingresar correo electrónico",
                "new_notification": "+ Agregar Correo Electrónico",
                "no_sections": "Este formulario web no tiene secciones definidas.",
                "style": {
                    "style": "Estilo",
                    "primary_color": "Color principal",
                    "background_color": "Color de fondo",
                    "logo": "Display a logo on top of the form"
                },
                "success_page": {
                    "success_page": "Página de éxito",
                    "success_page_info": "¿Qué debe suceder después de que un visitante envíe este formulario?",
                    "thank_you_message": "Mostrar mensaje de agradecimiento",
                    "redirect": "Redirigir a otro sitio web",
                    "title": "Título",
                    "title_placeholder": "Escriba el texto del mensaje de éxito.",
                    "message": "Mensaje",
                    "redirect_url": "URL del sitio web",
                    "redirect_url_placeholder": "Ingrese la URL para redirigir después de enviar el formulario."
                },
                "saving_preferences": {
                    "saving_preferences": "Guardar preferencias",
                    "deal_title_prefix": "Prefijo del título",
                    "deal_title_prefix_info": "Para cada nueva operación creada a través del formulario, el nombre de la operación irá precedido del texto añadido en el campo para facilitar su reconocimiento."
                },
                "sections": {
                    "new": "Agregar nueva sección",
                    "type": "Tipo de sección",
                    "types": {
                        "input_field": "Campo de entrada",
                        "message": "Mensaje",
                        "file": "Archivo"
                    },
                    "field": {
                        "resourceName": "Campo para"
                    },
                    "introduction": {
                        "introduction": "Introducción",
                        "title": "Título",
                        "message": "Mensaje"
                    },
                    "message": {
                        "message": "Mensaje"
                    },
                    "file": {
                        "file": "Archivo",
                        "files": "Archivos",
                        "multiple": "¿Permitir la carga de varios archivos?"
                    },
                    "submit": {
                        "button": "Botó Enviar",
                        "default_text": "Enviar",
                        "button_text": "Texto del botón",
                        "spam_protected": "¿Protegido contra el spam?",
                        "require_privacy_policy": "Requerir consentimiento de política de privacidad",
                        "privacy_policy_url": "URL de la política de privacidad"
                    },
                    "embed": {
                        "embed": "Insertar"
                    }
                }
            }
        },
        "core": {
            "actions": {
                "action": "Acción",
                "actions": "Acciones",
                "select": "Selecciona la acción",
                "confirmation_message": "¿Estás seguro/a de querer realizar esta acción?",
                "run_successfully": "La acción se ejecuta correctamente.",
                "search_in_google": "Buscar en Google",
                "bulk_edit": "Bulk Edit",
                "records_count": "1 registro | {count} registros"
            },
            "api": {
                "api": "API",
                "access": "Acceso API",
                "access_tokens": "Access Tokens",
                "personal_access_tokens": "Identificadores de acceso personal",
                "personal_access_token": "Identificador de acceso personal",
                "create_token": "Crear nueva identificación",
                "no_tokens": "No ha creado ninguna clave de acceso personal.",
                "token_name": "Nombre",
                "revoke_token": "Revocar",
                "token_last_used": "Última vez",
                "after_token_created_info": "Aquí tienes tu nueva clave de acceso personal. Esta es la única vez que se mostrará, ¡así que no lo pierda! Ahora puede utilizar este token para realizar solicitudes a la API.",
                "empty_state": {
                    "description": "Use tokens to make API requests outside of the application."
                },
                "token_delete_warning": "Please note that if you delete your API token, it will immediately invalidate the token. This means any external services or code integrations using this token will stop to function. Ensure to remove or replace the token in all your implementations to prevent disruptions."
            },
            "app": {
                "delete": "Eliminar",
                "confirm": "Confirmar",
                "cancel": "Cancelar",
                "clear": "Limpiar",
                "save": "Guardar",
                "saved": "Guardado",
                "send": "Enviar",
                "save_and_exit": "Guardar & Salir",
                "exit": "Salir",
                "edit": "Editar",
                "copy": "Copiar",
                "copy_link": "Copy Link",
                "copy_api_key": "Copy API Key",
                "clone": "Clone",
                "create": "Crear",
                "change": "Cambiar",
                "remove": "Remover",
                "hide": "Esconder",
                "active": "Activo",
                "view_details": "Más información",
                "system_info": "Información del sistema",
                "add_note": "Agregar una nota",
                "add_another": "Add Another",
                "is_primary": "Primary",
                "is_default": "Default",
                "note_is_private": "Nota privada",
                "create_and_add_another": "Crear y añadir otro",
                "create_and_go_to_list": "Crear e ir a la lista",
                "purchase_key": "Clave de compra",
                "enter_purchase_key": "Introduce tu clave de compra",
                "privacy_policy": "Política de privacidad",
                "copied": "Texto copiado en el portapapeles",
                "insert_new_line": "Insertar nueva línea",
                "reset": "Reiniciar",
                "optional": "Opcional",
                "not_enough_data": "Datos insuficientes para mostrar",
                "no_search_results": "No hay resultados que coincidan con sus criterios de búsqueda",
                "recent_search_history": "Recent Search History",
                "discard_changes": "Descartar cambios",
                "agree_to_privacy_policy": "Al usar este formulario, usted acepta el almacenamiento y manejo de sus datos por parte de este sitio web de acuerdo con nuestra {privacyPolicyLink}",
                "id": "ID",
                "deleted_at": "Eliminado en",
                "apply": "Solicitar",
                "reload": "Recargar",
                "loading": "Cargando...",
                "please_wait": "Por favor, espere...",
                "preview": "Vista previa",
                "address": "Dirección",
                "continue": "Continuar",
                "open_in_app": "Abrir la aplicación",
                "locale": "Ubicación",
                "details": "Más información",
                "sort": "Ordenar",
                "expand": "Ampliar",
                "show_less": "Mostrar menos",
                "show_all": "Mostrar todo",
                "has_more": "+{count} more",
                "throttle_error": "Demasiadas solicitudes, inténtelo más tarde.",
                "file_preview": "Vista previa del archivo",
                "integrations": "Integraciones",
                "attachments": "Archivos adjuntos",
                "attach": "Adjuntar",
                "changelog": "Cambios en el sitio",
                "go_back": "Atrás",
                "back": "Back",
                "attach_files": "Adjuntar archivos",
                "file_too_large": "Archivo demasiado grande, aumente el tamaño máximo de carga.",
                "no_attachments": "No hay archivos adjuntos cargados.",
                "download": "Descargar",
                "remember_selection": "Recordar mi selección para la próxima vez",
                "token_expired": "Lo sentimos, su sesión ha caducado.",
                "all_caught_up": "¡Ya estás al día!",
                "view_record": "Vista",
                "list_view": "Lista",
                "reminder_set_for": "Recordatorio fijado para {value} {type} antes",
                "reminder_before_due": "antes de tiempo",
                "integration_not_configured": "La integración no está configurada",
                "associate_with_record": "Asociar a registros",
                "address_information": "Información de dirección",
                "search": "Buscar...",
                "type_to_search": "Escribir para buscar...",
                "type_more_to_search": "Escriba {characters} más caracteres para realizar la búsqueda...",
                "search_records": "Buscar registros",
                "allowed_extensions": "Extensiones de carga permitidas",
                "allowed_extensions_info": "Ingrese las extensiones, separadas por comas, que se incluirán en la lista blanca para el almacenamiento de archivos.",
                "last_modified_at": "Última modificación",
                "created_at": "Creado el",
                "updated_at": "Actualizando el",
                "created_by": "Creado por",
                "creation_date": "Fecha de creación",
                "drop_files": "Soltar archivos para cargar",
                "choose_image": "Elegir imagen",
                "ascending": "Subiendo",
                "descending": "Bajando",
                "sort_ascending": "Sort ascending",
                "sort_descending": "Sort descending",
                "upload": "Cargar",
                "upload_avatar": "Cargar Avatar",
                "avatar": "Avatar",
                "quick_create": "Creación rápida",
                "no_owner": "Sin propietario",
                "owner_email_address": "Email del propietario",
                "associate": "Asociado",
                "timezone": "Zona horaria",
                "currency": "Moneda",
                "system_default": "Sistema predeterminado",
                "auto_detect": "Detección automática",
                "all": "Todos",
                "see_all": "Ver todo",
                "select_file": "Seleccionar archivo",
                "file": "Archivo",
                "form_validation_failed": "Fallo de validación del formulario, compruebe todos los campos",
                "form_validation_failed_with_sections": "Form validation failed, check the all of the sections and fields",
                "advanced": "Avanzado",
                "yes": "Sí",
                "no": "No",
                "no_associations": "Sin asociaciones",
                "associated_with_total_records": "Asociado a {count} registro|Asociado a {count} registros",
                "action_not_authorized": "Su cuenta no está autorizada para realizar esta acción",
                "record_view": {
                    "manage_sidebar": "Gestionar las secciones de la barra lateral",
                    "sections": {
                        "edit_heading": "Administrar secciones",
                        "edit_subheading": "Reorganizar secciones o cambiar su visibilidad",
                        "details": "Detalles"
                    }
                },
                "soft_deletes": {
                    "trashed": "Papelera",
                    "trashed_records": "Registros eliminados",
                    "restore": "Restaurar",
                    "force_delete": "Borrar de manera permanente",
                    "move_to_trash": "Mover a la papelera",
                    "empty_trash": "Empty Trash",
                    "trashed_pruning_info": "Los registros eliminados se borrarán después de {total} días."
                },
                "logo": {
                    "light": "Light Logo",
                    "dark": "Dark Logo"
                },
                "cards": {
                    "creation_date_info": "Esta tarjeta solo refleja los registros que se crearon durante el intervalo de fechas seleccionado."
                },
                "theme": {
                    "switch_light": "Cambiar a modo claro",
                    "switch_system": "Cambiar al tema del sistema",
                    "switch_dark": "Cambiar a modo oscuro"
                },
                "menu": {
                    "metrics": {
                        "metrics": "Métrica",
                        "refresh_interval": "Las métricas se actualizan cada {interval} minutos."
                    }
                },
                "visibility_group": {
                    "visible_to": "Visible para",
                    "all": "Toda la empresa"
                },
                "export": {
                    "export": "Exportar",
                    "type": "Escribir",
                    "select_range": "Select Range",
                    "apply_filters": "¿Exportar registros en función de los filtros aplicados?"
                },
                "company": {
                    "name": "Nombre de la empresa",
                    "country": "País"
                },
                "password_generator": {
                    "heading": "Generar contraseña",
                    "strength": "Potencia",
                    "length": "Longitud",
                    "digits": "Dígitos",
                    "symbols": "Símbolos",
                    "weak": "Débil",
                    "average": "Medio",
                    "strong": "Fuerte",
                    "secure": "Segura",
                    "copied": "Contraseña copiada en el portapapeles"
                },
                "weekdays": {
                    "monday": "Lunes",
                    "tuesday": "Martes",
                    "wednesday": "Miércoles",
                    "thursday": "Jueves",
                    "friday": "Viernes",
                    "saturday": "Sábado",
                    "sunday": "Domingo"
                },
                "colors": {
                    "color": "Color",
                    "colors": "Colores",
                    "remove": "Eliminar color",
                    "palettes": "Paletas de colores"
                }
            },
            "contentbuilder": {
                "snippets": {
                    "basic": "Base",
                    "text": "Texto",
                    "headline": "Cabecera",
                    "buttons": "Botones",
                    "photos": "Fotos",
                    "profile": "Perfil",
                    "contact": "Contacto",
                    "products": "Productos",
                    "features": "Características",
                    "process": "Proceso",
                    "pricing": "Precios",
                    "skills": "Habilidades",
                    "achievements": "Logros",
                    "quotes": "Citas",
                    "partners": "Socios",
                    "as_featured_on": "Destacado en",
                    "help_and_faq": "Ayuda, Preguntas frecuentes"
                },
                "builder": {
                    "Bold": "Negrita",
                    "Italic": "Cursiva",
                    "Hyperlink": "Hipervínculo",
                    "Align": "Alinear",
                    "Paragraph": "Párrafo",
                    "Color": "Color",
                    "Formatting": "Formato",
                    "List": "Enumerar",
                    "Text Settings": "Configuración del texto",
                    "Icon": "Icono",
                    "Clean": "Limpiar",
                    "Font": "Fuente",
                    "Previous": "Anterior",
                    "Next": "Siguiente",
                    "More": {
                        "": {
                            "": {
                                "": "Más..."
                            }
                        }
                    },
                    "Move Up": "Ascender",
                    "Move Down": "Bajar",
                    "Move Left": "Mover a la izquierda",
                    "Move Right": "Mover a la derecha",
                    "Delete": "Eliminar",
                    "Add": "Agregar",
                    "Move": "Mover",
                    "Duplicate": "Duplicar",
                    "Decrease": "Disminuir",
                    "Increase": "Incrementar",
                    "HTML": "HTML",
                    "Headline": "Título",
                    "Image": "Imagen",
                    "Heading 1": "Título 1",
                    "Heading 2": "Título 2",
                    "Heading 3": "Título 3",
                    "Quote": "Cita",
                    "Preformatted": "Preformateado",
                    "Table": "Cuadro",
                    "Spacer": "Separador",
                    "Horizontal Line": "Línea Horizontal",
                    "More...": "More...",
                    "Enlarge": "Ampliar",
                    "Ok": "Ok",
                    "Align Left": "Alinear a la izquierda",
                    "Align Center": "Alinear Centro",
                    "Align Right": "Alinear a la derecha",
                    "Align Full": "Alinear todo",
                    "Bullets": "Viñetas",
                    "Numbering": "Numeración",
                    "Indent": "Sangría",
                    "Outdent": "Anular la sangría",
                    "Heading 4": "Título 4",
                    "Underline": "Subrayar",
                    "Strikethrough": "Tachado",
                    "Superscript": "Superíndice",
                    "Subscript": "Subtítulo",
                    "Uppercase": "Mayúsculas",
                    "Clear": "Despejar",
                    "Choose..": "Choose..",
                    "Forecolor": "Color primario",
                    "Backcolor": "Color de fondo",
                    "Apply": "Solicitar",
                    "Cancel": "Cancelar",
                    "Change Image": "Cambiar imagen",
                    "Link": "Link",
                    "Edit": "Editar",
                    "Source": "Fuente",
                    "Settings": "Ajustes",
                    "Change Icon": "Cambiar icono",
                    "Edit Table": "Editar tabla",
                    "Select": "Seleccionar",
                    "Open new window": "Abrir nueva ventana",
                    "Open New Window": "Abrir nueva ventana",
                    "Text": "Texto",
                    "Title": "Título",
                    "Free": "Gratis",
                    "Style": "Estilo",
                    "Layout": "Maquetación",
                    "Background": "Fondo",
                    "Select Color": "Seleccionar Color",
                    "Text Color": "Color de texto",
                    "Border Thickness": "Grosor del borde",
                    "Border Color": "Color del borde",
                    "Apply To": "Solicitar a",
                    "Current Row": "Fila actual",
                    "Current Column": "Columna actual",
                    "Even Rows": "Filas pares",
                    "Odd Rows": "Filas impares",
                    "Current Cell": "Móvil actual",
                    "Insert Row": "Insertar fila",
                    "Insert Column": "Insertar columna",
                    "Delete Row": "Borrar fila",
                    "Delete Column": "Borrar columna",
                    "Above": "Por encima de",
                    "Below": "Abajo",
                    "Left": "Izquierda",
                    "Right": "Derecha",
                    "Row": "Fila",
                    "Column": "Columna",
                    "Merge": "Fusionar",
                    "Merge Cell": "Fusionar celda",
                    "css": "css",
                    "Class": "Clase",
                    "Box": "Casilla",
                    "Spacing": "Espaciado",
                    "Border": "Frontera",
                    "Corners": "Esquinas",
                    "Shadow": "Sombra",
                    "Display": "Mostrar",
                    "Position": "Puesto",
                    "Effects": "Efectos",
                    "Attributes": "Atributos",
                    "Animation": "Animación",
                    "Background Color": "Color de fondo",
                    "Gradient": "Degradado",
                    "Dimension": "Dimensión",
                    "Responsive Positioning": "Posicionamiento receptivo",
                    "Reset margin left on small screen": "Restablecer margen izquierdo en pantalla pequeña",
                    "Reset margin right on small screen": "Restablecer margen derecho en pantalla pequeña",
                    "Individual Sides": "Lados individuales",
                    "Select Font": "Seleccionar fuente",
                    "Animate": "Animar",
                    "Delay": "Retraso",
                    "Duration": "Duración",
                    "Animate Once": "Animar una vez",
                    "Test": "Test",
                    "TEST": "TEST",
                    "Custom": "Personalizar",
                    "Module Settings": "Configuración del módulo",
                    "Drag and drop an image or click to browse.": "Drag and drop an image or click to browse.",
                    "Are you sure you want to delete this block?": "¿Seguro que quiere eliminar este bloque?",
                    "Back": "Atrás",
                    "Or Specify Image Source": "O especifique la fuente de la imagen",
                    "Preferences": "Preferencias",
                    "Hide element tool": "Ocultar elemento",
                    "Hide column tool": "Herramienta para ocultar columnas",
                    "Line": "Línea",
                    "Hide column HTML editor": "Ocultar la columna del editor HTML",
                    "Hide row HTML editor": "Ocultar el editor HTML de filas",
                    "Hide row move (up/down) buttons": "Ocultar botones de movimiento de filas (arriba/abajo)",
                    "HTML syntax highlighting": "Resaltado de sintaxis HTML",
                    "Scrollable Editing Toolbar": "Barra de herramientas de edición desplegable",
                    "Toolbar position": "Posición de la barra de herramientas",
                    "Top": "Arriba",
                    "Toolbar visibility": "Visibilidad de la barra de herramientas",
                    "Auto": "Auto",
                    "Always Visible": "Siempre visible",
                    "Paste result": "Pegar resultado",
                    "HTML (without styles)": "HTML (sin estilos)",
                    "HTML (with styles)": "HTML (con estilos)",
                    "Text only": "Solo texto",
                    "Add Snippet": "Agregar fragmento",
                    "Grid Tool": "Herramienta de cuadrícula",
                    "Element Tool": "Herramienta Elemento",
                    "Builder Mode": "Modo Constructor",
                    "Default": "Por defecto",
                    "Minimal": "Mínimo",
                    "Hide outline": "Ocultar esquema",
                    "Hide element highlight": "Ocultar elemento destacado",
                    "Row tool position": "Posición de la herramienta Fila",
                    "Add (+) button placement": "Agregar (+) ubicación de los botones",
                    "Between Blocks (left)": "Entre bloques (izquierda)",
                    "Between Blocks (center)": "Entre bloques (centro)",
                    "Outline Mode": "Modo de esquema",
                    "Row & column": "Filas y columnas",
                    "Row only": "Sólo filas",
                    "Draggable blocks without handle": "Bloques arrastrables sin asa",
                    "Animated drag to sort": "Arrastre animado para clasificar",
                    "Open snippets sidebar on start": "Abrir la barra lateral de fragmentos al inicio",
                    "Scrollable toolbar (top only)": "Barra desplazable (sólo en la parte superior)",
                    "Please select a block": "Por favor, seleccione un bloque",
                    "Open snippet sidebar on start": "Abrir barra lateral de fragmentos al inicio",
                    "Hide snippet handle": "Ocultar identificador de fragmento",
                    "Undo": "Deshacer",
                    "Redo": "Rehacer",
                    "Empty": "Vacío",
                    "+ Click to add content": "+ Clic para agregar comentario",
                    "B": "B",
                    "W": "W",
                    "Outline Style": "Estilo de esquema",
                    "Colored": "Coloreado",
                    "Gray": "Gris",
                    "Hide Outline": "Ocultar esquema",
                    "Hide Column Tool": "Ocultar columna",
                    "Row Tool Position": "Fila Posición herramienta",
                    "Tool Style": "Estilo de herramienta",
                    "Hide Snippet (+) Tool": "Herramienta Ocultar fragmento (+)",
                    "Tool Outline": "Perfil de herramienta",
                    "Button": "Botón",
                    "Button Editor": "Edición de botones",
                    "Edit Button": "Editar botón",
                    "Grid Editor": "Editor de cuadrícula",
                    "Outline": "Describir",
                    "Font Size": "Tamaño de fuente",
                    "Line Spacing": "Espacio entre líneas",
                    "Letter Spacing": "Espacio entre letras",
                    "Close": "Cerrar",
                    "Search & Replace": "Buscar y reemplazar",
                    "Word Count": "Número de palabras",
                    "words": "palabras",
                    "Characters": "Caracteres",
                    "Characters (no spaces)": "Caracteres (sin espacios)",
                    "Add to Left": "Agregar a la izquierda",
                    "Add to Right": "Agregar a la derecha",
                    "Border Top Color": "Color del borde superior",
                    "Border Bottom Color": "Color del borde inferior",
                    "Border Left Color": "Color del borde izquierdo",
                    "Border Right Color": "Color del borde derecho",
                    "Snippets sidebar visibility": "Visibilidad de la barra lateral de fragmentos",
                    "You have reached the maximum number of columns": "Ha alcanzado el número máximo de columnas",
                    "Width": "Ancho",
                    "Height": "Altura",
                    "Names": "Nombres",
                    "Values": "Valores",
                    "Border Top": "Borde superior",
                    "Border Bottom": "Borde inferior",
                    "Border Left": "Borde izquierdo",
                    "Border Right": "Frontera derecha",
                    "Individual Corners": "Esquinas individuales",
                    "Top Left": "Arriba a la izquierda",
                    "Top Right": "Arriba a la derecha",
                    "Bottom Left": "Inferior izquierda",
                    "Bottom Right": "Inferior derecha",
                    "Flex": "Doblar",
                    "Direction": "Dirección",
                    "Wrap": "Envolver",
                    "Justify Content": "Justificar el contenido",
                    "Align Items": "Alinear los elementos",
                    "Align Content": "Alinear contenido",
                    "Opacity": "Opacidad",
                    "Filters": "Filtros",
                    "Blur": "Desenfocar",
                    "Brightness": "Brillo",
                    "Contrast": "Contraste",
                    "Grayscale": "Escala de grises",
                    "Hue Rotate": "Rotación del tono",
                    "Invert": "Invertir",
                    "Saturate": "Saturar",
                    "Sepia": "Sepia",
                    "Bottom": "Inferior",
                    "Float": "Flotar",
                    "x Offset": "x Offset",
                    "y Offset": "y Offset",
                    "Spread": "Difundir",
                    "Shadow Color": "Color de sombra",
                    "Outer/Inner Shadow": "Sombra exterior/interior",
                    "Margin": "Margen",
                    "Padding": "Relleno",
                    "Text Align": "Alinear texto",
                    "Center": "Centro",
                    "Full": "Completo",
                    "Line Height": "Altura de línea",
                    "Font Weight": "Peso de la fuente",
                    "Font Style": "Estilo de fuente",
                    "Text Transform": "Transformación de texto",
                    "Text Decoration": "Decoración de texto",
                    "Word Spacing": "Espacio entre palabras",
                    "Font Family": "Familia de fuentes",
                    "Normal": "Normal",
                    "Lowercase": "Minúsculas",
                    "Capitalize": "Mayúsculas",
                    "None": "Ninguno",
                    "Line Through": "Línea a través de",
                    "Overline": "Línea superior",
                    "Hover": "Hover",
                    "Saved": "Guardar",
                    "Templates": "Plantillas",
                    "No Border": "Sin bordes",
                    "Border Radius": "Radio del borde",
                    "Button Size": "Tamaño de los botones",
                    "Upper/lower": "Superior/inferior",
                    "Weight": "Peso",
                    "Save Current Button": "Guardar botón actual",
                    "Tags": "Marcadores de posición",
                    "Snippet": "Fragmento",
                    "Mono": "Mono",
                    "Zoom": "Zoom",
                    "Set theme": "Fijar tema",
                    "Open in a lightbox (for image, video or Youtube)": "Open in a lightbox (for image, video or Youtube)",
                    "Column Settings": "Configuración de columnas",
                    "Lock": "Bloquear",
                    "General": "General",
                    "Content": "Contenido",
                    "On Click": "Hacer clic",
                    "Background Image": "Imagen de fondo",
                    "Adjust": "Ajustar",
                    "Dark": "Oscuro",
                    "Light": "Brillo",
                    "Enlarge Row": "Ampliar fila",
                    "Content Alignment": "Alineación de contenidos",
                    "Top Center": "Centro superior",
                    "Bottom Center": "Centro inferior",
                    "Center Left": "Centro izquierda",
                    "Center Right": "Centro derecha",
                    "Open": "Abrir",
                    "Background Image Adjustments": "Ajustes de la imagen de fondo",
                    "Scale": "Escala",
                    "Horizontal": "Horizontal",
                    "Vertical": "Vertical",
                    "Do you really want to leave?": "¿De verdad quieres irte?",
                    "Two Button": "Dos botones",
                    "Youtube": "Youtube",
                    "Video": "Video",
                    "Map": "Mapa",
                    "Show Controls": "Mostrar controles",
                    "Loop": "Bucle",
                    "Autoplay": "Reproducción automática",
                    "Please select an image or video file.": "Please select an image or video file.",
                    "Please select an image file.": "Please select an image file.",
                    "Please select an mp4 file.": "Please select an mp4 file.",
                    "Social Links": "Social Links",
                    "HTML/JS": "HTML/JS",
                    "Drag image to change the position. Click image to edit the details.": "Drag slide to change the position. Click slide to edit the,details.",
                    "Add Image": "Agregar imagen",
                    "Fit": "Ajustar",
                    "Type": "Tipo",
                    "Animation duration": "Duración de animación",
                    "Per View": "Por vista",
                    "Gap": "Brecha",
                    "Arrow Navigation": "Flecha de navegación",
                    "Dots Navigation": "Navegación por puntos",
                    "Fade": "Desvanecer",
                    "Caption (HTML allowed)": "Título (HTML permitido)",
                    "Placement": "Ubicación",
                    "Max Width": "Anchura máxima",
                    "You can test the On-Click action on page if you lock the column by clicking the lock button": "Puede probar la acción On-Click en la página si bloquea la columna haciendo clic en el botón de bloqueo",
                    "Remove": "Remover",
                    "All": "Todos",
                    "Transparent": "Transparencia",
                    "Current": "Actual",
                    "Padding X": "Relleno X",
                    "Padding Y": "Relleno Y",
                    "SM": "SM",
                    "MD": "MD",
                    "LG": "LG",
                    "XL": "XL",
                    "2XL": "2XL",
                    "3XL": "3XL",
                    "Margin Left": "Margen izquierdo",
                    "Margin Right": "Margen derecho",
                    "Margin Top": "Margen superior",
                    "Margin Bottom": "Margen inferior",
                    "Reset": "Restablecer",
                    "Snippet Categories": "Categorías de fragmentos",
                    "Snippets": "Fragmentos",
                    "Copy": "Copiar",
                    "Cut": "Cortar",
                    "Paste": "Pegar",
                    "Insert Link": "Insertar Link",
                    "Insert Image": "Insertar imagen",
                    "Show shortcut info": "Mostrar información de acceso directo",
                    "Navigate to the next control": "Navegar al siguiente control",
                    "Navigate to the previous control": "Navegar al control anterior",
                    "Select control that has focus": "Seleccionar control que tiene foco",
                    "Select option that has focus (eg. checkbox)": "Select option that has focus (eg. checkbox)",
                    "Move up in selection list or menu": "Subir en la lista de selección o en el menú",
                    "Move down in selection list or menu": "Desplazarse hacia abajo en la lista de selección o en el menú",
                    "Close modal or popup": "Cerrar modal o popup",
                    "Shortcuts": "Atajos",
                    "Basic": "Base",
                    "Editing": "Edición",
                    "Navigation": "Navegación",
                    "Tab": "Pestaña",
                    "Shift": "Shift",
                    "Esc": "Esc",
                    "Enter": "Ingresar",
                    "Up arrow": "Flecha arriba",
                    "Down arrow": "Flecha hacia abajo",
                    "or": "o",
                    "Spacebar": "Barra espaciadora",
                    "Min Width": "Anchura mínima",
                    "Max Height": "Altura máxima",
                    "Min Height": "Altura mínima",
                    "Overflow x": "Desbordamiento x",
                    "Overflow y": "Desbordamiento y",
                    "Please enter <iframe> element.": "Please enter <iframe> element.",
                    "Add Slide": "Add Slide",
                    "Alternate Videos": "Alternate Videos",
                    "Add/Update Video": "Add/Update Video",
                    "Drag slide to change the position. Click slide to edit the details.": "Drag slide to change the position. Click slide to edit the,details.",
                    "URL": "URL",
                    "Delete Slide": "Delete Slide",
                    "Arrow Color": "Arrow Color",
                    "Dots Color": "Dots Color",
                    "Hide Column on Mobile": "Hide Column on Mobile",
                    "Padding Left/Right": "Padding Left/Right",
                    "Top (Full Width)": "Top (Full Width)",
                    "HTML View": "HTML View",
                    "Shorten HTML": "Shorten HTML",
                    "Actual": "Actual",
                    "Visibility": "Visibility",
                    "Visible": "Visible",
                    "Hidden": "Hidden",
                    "Text Slider": "Text Slider",
                    "Drag slide to change the position.": "Drag slide to change the position.",
                    "Show Arrow on Mobile": "Show Arrow on Mobile",
                    "Show Dots on Mobile": "Show Dots on Mobile",
                    "Pause on Hover": "Pause on Hover",
                    "Caption Animation": "Caption Animation",
                    "Slide Up": "Slide Up",
                    "Fade In": "Fade In",
                    "Add Row ID": "Add Row ID",
                    "Add Column ID": "Add Column ID",
                    "Add Element ID": "Add Element ID",
                    "Add Css Classes": "Add Css Classes",
                    "Laptop": "Laptop",
                    "Mobile": "Mobile",
                    "Tablet": "Tablet",
                    "Laptop/Tablet (Landscape)": "Laptop/Tablet (Landscape)",
                    "Tablet (Landscape)": "Tablet (Landscape)",
                    "Tablet (Portrait)": "Tablet (Portrait)",
                    "Laptop/Tablet": "Laptop/Tablet",
                    "Desktop": "Desktop",
                    "Live Preview": "Live Preview",
                    "Page Break": "Salto de página",
                    "Add the products table": "Añadir la tabla de productos",
                    "Products": "Productos",
                    "Products will be displayed in this section on document preview and PDF.": "Products will be displayed in this section on document preview and PDF.",
                    "Signatures": "Firmas",
                    "On document PDF, the signatures will be displayed in this section.": "On document PDF, the signatures will be displayed in this section.",
                    "Choose": {
                        "": {
                            "": "Escoge.."
                        }
                    },
                    "Drag and drop an image or click to browse": {
                        "": "Arrastre y suelte una imagen o haga clic para navegar."
                    },
                    "Drag image to change the position": {
                        " Click image to edit the details": {
                            "": "Arrastre la imagen para cambiar la posición. Haga clic en la imagen para editar los detalles."
                        }
                    },
                    "Open in a lightbox (for image video or Youtube)": "Abrir en un recuadro (para imágenes de vídeo o Youtube)",
                    "Please select an image file": {
                        "": "Por favor, seleccione un archivo de imagen."
                    },
                    "Please select an image or video file": {
                        "": "Seleccione un archivo de imagen o vídeo."
                    },
                    "Please select an mp4 file": {
                        "": "Seleccione un archivo mp4."
                    },
                    "Select option that has focus (eg": {
                        " checkbox)": "Seleccionar la opción que tiene el foco (por ejemplo, casilla de verificación)"
                    },
                    "Products will be displayed in this section on document preview and PDF": {
                        "": "Los productos se mostrarán en esta sección en la vista previa del documento y PDF."
                    },
                    "On document PDF, the signatures will be displayed in this section": {
                        "": "En el documento PDF, las firmas se mostrarán en esta sección."
                    }
                }
            },
            "country": {
                "country": "País"
            },
            "dashboard": {
                "insights": "Estadisticas",
                "dashboard": "Tablero",
                "name": "Nombre",
                "default": "Tablero predeterminado",
                "new_dashboard": "Nuevo tablero",
                "create": "Crear nuevo tablero",
                "edit_current": "Editar el tablero actual",
                "delete_current": "Eliminar el tablero actual",
                "created": "Tablero creado correctamente",
                "updated": "Tablero actualizado correctamente",
                "deleted": "Tablero eliminado correctamente",
                "cards": {
                    "enabled": "Habilitado"
                }
            },
            "dates": {
                "today": "Hoy",
                "tomorrow": "Mañana",
                "in_x_days": "En {count} día|En {count} días",
                "in_x_weeks": "En {count} semana|En {count} semanas",
                "in_x_months": "En {count} mes|En {count} meses",
                "custom": "Personalizado",
                "range": "Rango de fechas",
                "minutes": "minutos",
                "hours": "horas",
                "days": "días",
                "weeks": "semanas",
                "duration": {
                    "seconds": "unos pocos segundos",
                    "minutes": "minuto|minutos",
                    "hours": "hora|horas",
                    "days": "día|días"
                },
                "due": {
                    "today": "Vence hoy",
                    "tomorrow": "Vence mañana",
                    "this_week": "Vence esta semana",
                    "next_week": "Vence la próxima semana",
                    "this_month": "Vence este mes",
                    "next_month": "Vence el próximo mes",
                    "this_quarter": "Vence este trimestre"
                },
                "yesterday": "Ayer",
                "next_day": "Siguiente día",
                "this_week": "Esta semana",
                "last_week": "Semana anterior",
                "next_week": "Próxima semana",
                "this_month": "Este mes",
                "last_month": "Mes anterior",
                "next_month": "Próximo mes",
                "this_quarter": "Este trimestre",
                "last_quarter": "Trimestre anterior",
                "next_quarter": "Próximo trimestre",
                "this_year": "Este año",
                "last_year": "Año anterior",
                "next_year": "Próximo año",
                "within": {
                    "last_7_days": "En los últimos 7 días",
                    "last_14_days": "En los últimos 14 días",
                    "last_30_days": "En los últimos 30 días",
                    "last_60_days": "En los últimos 60 días",
                    "last_90_days": "En los últimos 90 días",
                    "last_365_days": "En los últimos 365 días"
                },
                "periods": {
                    "7_days": "Últimos 7 días",
                    "15_days": "Últimos 15 días",
                    "30_days": "Últimos 30 días",
                    "60_days": "Últimos 60 días",
                    "90_days": "Últimos 90 días",
                    "365_days": "Últimos 365 días",
                    "last_3_months": "Últimos 3 meses",
                    "last_6_months": "Últimos 6 meses",
                    "last_12_months": "Últimos 12 meses"
                }
            },
            "fields": {
                "add": "Agregar nuevo",
                "fields": "Campos",
                "field": "Campo",
                "updated": "Campos actualizados",
                "hide_fields": "Hide {count} field|Hide {count} fields",
                "more_fields": "{count} more field|{count} more fields",
                "reseted": "Los campos se establecen correctamente en el estado inicial",
                "all": "All Fields",
                "select": "Select Fields",
                "updated_field": "Campo actualizado",
                "update_field": "Update Field",
                "optional": "(optional)",
                "configured": "Campos configurados correctamente",
                "no_longer_available": "Campo ya no disponible",
                "new_value": "Nuevo valor",
                "old_value": "Antiguo valor",
                "manage": "Administrar campos",
                "hide_updated": "Ocultar campos actualizados",
                "view_updated": "Ver campos actualizados",
                "primary": "Campo principal",
                "visible": "Visible",
                "label": "Etiqueta",
                "is_readonly": "Sólo lectura",
                "keep_existing_value": "Keep existing value",
                "replace_existing_value": "Replace existing value with..",
                "settings": {
                    "create": "Campos de creación",
                    "create_info": "Campos que se mostrarán cuando cualquier usuario cree un registro.",
                    "update": "Editar campos",
                    "update_info": "Los campos disponibles serán mostrados en la vista de edición/visualización de registros.",
                    "detail": "Campos detallados",
                    "detail_info": "Los campos disponibles serán mostrados en el detalle de los registros.",
                    "list": "Lista de campos",
                    "list_info": "Para ajustar los campos que se muestran en la vista de lista, cuando vea la lista {resourceName}, haga clic en el ícono {icon} ubicado en la barra de navegación y elija \"Configuración de la lista\"."
                },
                "collapsed_by_default": "¿Colapsado por defecto?",
                "is_required": "¿Es obligatorio?",
                "option_enabled_will_propagate": "When enabled, propagates to \"{view_name}\" view too.",
                "option_disabled_will_propagate": "When disabled, propagates to \"{view_name}\" view too.",
                "options": "Opciones",
                "field_is_unique": "Unique",
                "mark_as_unique": "No permitir valores duplicados",
                "mark_as_unique_change_info": "El valor de esta opción sólo puede establecerse al crear el campo.",
                "unmark_as_unique_change_info": "This action is irreversible, after the field is unmarked as unique, cannot be marked as unique again.",
                "validation": {
                    "exist": "Parece que el campo con este ID ya existe para el recurso.",
                    "requires_options": "Añadir opciones para este campo.",
                    "field_type_invalid": "El tipo de campo no es compatible",
                    "field_id_invalid": "Solo se aceptan caracteres alfabéticos en minúsculas (a-z) y guiones bajos (_).",
                    "refuses_options": "Este campo no admite opciones.",
                    "option_coma": "Comas are not allowed in option names.",
                    "invalid_name": "El ID de campo no puede tener el nombre \"{nombre}\". Intente usar una identificación diferente."
                },
                "custom": {
                    "create_option_icon": "Haga clic en el icono {icon} para crear una nueva opción.",
                    "or_add_options_via_text": "Or add options via text",
                    "convert_text_to_options": "Convert text to options",
                    "text_options_each_on_new_line": "Paste/enter each option on new line.",
                    "field": "Campo personalizado",
                    "create": "Crear nuevo campo personalizado",
                    "update": "Actualizar campo personalizado",
                    "type": "Tipo de campo",
                    "id": "ID de campo",
                    "id_info": "Ingrese el ID de campo en minúsculas, solo se aceptan caracteres alfabéticos (a-z) y guiones bajos (_).",
                    "updated": "Campo personalizado actualizado con éxito",
                    "created": "Campo personalizado creado con éxito",
                    "deleted": "Campo personalizado eliminado con éxito"
                },
                "email_copied": "Dirección de correo electrónico copiada en el portapapeles"
            },
            "filters": {
                "filters": "Filtros",
                "apply": "Aplicar filtros",
                "save_and_apply": "Guardar y aplicar",
                "create": "Crear nuevo filtro",
                "filter_by": "Filtrado por",
                "edit": "Editar",
                "save_as_new": "¿Guardar filtro?",
                "available": "Filtros disponibles",
                "not_available": "No hay filtros disponibles, comience creando un filtro.",
                "cannot_be_shared": "Este filtro consta de reglas ({rules}) que pueden no estar siempre disponibles para todos los miembros del equipo, por esta razón, el filtro no puede ser compartido con otros miembros del equipo.",
                "search": "Buscar filtros...",
                "name": "Nombre del filtro",
                "new": "Nuevo filtro",
                "clear_rules": "Reglas claras",
                "clear_applied": "Limpiar filtro",
                "static_rule_indicator": "Regla Estática",
                "is_readonly": "Este filtro es de sólo lectura y puede marcarse como predeterminado. Si necesita ampliar este filtro, cree uno nuevo.",
                "system_default_delete_info": "No puede eliminar el filtro predeterminado de la aplicación",
                "country": "Country",
                "share": {
                    "with": "Compartido con",
                    "private": "Privado",
                    "everyone": "A todos",
                    "private_info": "Solo el creador puede ver este filtro",
                    "everyone_info": "Todos los usuarios pueden ver y utilizar este filtro"
                },
                "placeholders": {
                    "enter": "Ingrese {label}",
                    "choose": "Elija {label}",
                    "choose_with_multiple": "Elija uno o varios {label}",
                    "select_date": "Seleccione la fecha"
                },
                "conditions": {
                    "or": "o",
                    "and": "y"
                },
                "show_matching_records_conditions": "Mostrar registros que coincidan con {match_type} de estas condiciones:",
                "or_match_any_conditions": "{condition} coincide con {match_type} de estas condiciones:",
                "mark_as_default": "Marcar como predeterminado",
                "unmark_as_default": "Desmarcar como predeterminado",
                "mark_as_default_for_current_account_only": "Applies only for your account.",
                "edit_filter": "Editar filtro",
                "match_type": "Tipo de coincidencia",
                "match_type_all": "Todos",
                "match_type_any": "Cualquiera",
                "add_filter": "Añadir filtro",
                "add_condition": "Añadir condición",
                "add_another_condition": "Add Another Condition",
                "add_group": "Añadir grupo",
                "add_group_info": "A group to nest more filters",
                "select_rule": "Select Rule",
                "operators": {
                    "is": "es",
                    "was": "era",
                    "equal": "es igual a",
                    "not_equal": "No es igual a",
                    "in": "es cualquiera de",
                    "not_in": "es ninguno de",
                    "less": "es menor que",
                    "less_or_equal": "es menor o igual que",
                    "greater": "es mayor que",
                    "greater_or_equal": "es mayor o igual que",
                    "between": "está entre",
                    "not_between": "no está entre",
                    "begins_with": "empieza con",
                    "not_begins_with": "no empieza con",
                    "contains": "contiene",
                    "not_contains": "no contiene",
                    "ends_with": "termina con",
                    "not_ends_with": "no termina con",
                    "is_empty": "está vacío",
                    "is_not_empty": "no está vacío",
                    "is_null": "es desconocido",
                    "is_not_null": "es conocido"
                },
                "me": "A mí"
            },
            "import": {
                "import": "Importar",
                "start": "Iniciar importación",
                "import_records": "Import Records",
                "import_in_progress": "Import In Progress",
                "download_sample": "Descargar modelo",
                "history": "Historial de importaciones",
                "no_history": "No se ha encontrado ningún historial de importación.",
                "spreadsheet_columns": "Columnas de la hoja de cálculo",
                "column_will_not_import": "no será importado",
                "records_being_imported_in_batches": "The records are being imported in a few batches, do not navigate from this window until this message dissapear.",
                "date": "Fecha",
                "file_name": "Nombre de archivo",
                "user": "Usuario",
                "total_imported": "Importado",
                "total_duplicates": "Duplicados",
                "total_skipped": "Omitido",
                "progress": "Progress",
                "status": "Estado",
                "imported": "Registros importados con éxito",
                "revert": "Revert",
                "revert_info": "Reverting an import will permanently delete all of the imported records.",
                "why_skipped": "¿Por qué?",
                "download_skip_file": "Descargar archivo omitido",
                "skip_file": "Saltar archivo",
                "total_rows_skipped": "Total de filas omitidas: {count}",
                "skip_file_generation_info": "Se genera un archivo omitido cada vez que falla la validación de una fila de la hoja de cálculo.",
                "skip_file_fix_and_continue": "Descargue el archivo omitido para examinar las filas que fallaron y por qué fallaron; una vez corregidas las filas, cargue el archivo omitido corregido a continuación para continuar el proceso de importación para la instancia de importación actual.",
                "upload_fixed_skip_file": "Subir archivo omitido fijo",
                "steps": {
                    "step_1": {
                        "name": "Descargar modelo",
                        "description": "Guía de formato de hojas de cálculo."
                    },
                    "step_2": {
                        "name": "Subir hoja de cálculo",
                        "description": "Subir archivo para el mapeo."
                    },
                    "step_3": {
                        "name": "Columnas del mapa",
                        "description": "Asignar columnas con campos."
                    },
                    "step_4": {
                        "name": "Importar",
                        "description": "Inicie el proceso de importación."
                    }
                },
                "from_file": "Import From {file_type} File"
            },
            "mail_template": {
                "mail_templates": "Plantillas de correo",
                "template": "Plantilla",
                "subject": "Asunto",
                "message": "Mensaje",
                "updated": "Plantilla actualizada correctamente.",
                "choose_to_edit": "Elija una plantilla para editar",
                "changes_not_saved_warning": "Your current changes have not been saved. If you proceed, you will lose any unsaved progress. Do you wish to continue without saving?",
                "placeholders": {
                    "view_record": "Ver registro",
                    "placeholders": "Marcadores",
                    "mentioned_user": "El nombre de usuario mencionado.",
                    "user_that_mentions": "El nombre de usuario que menciona.",
                    "mention_url": "La URL de la mención."
                }
            },
            "media": {
                "link_copied": "Enlace copiado correctamente",
                "no_preview_available": "Actualmente no hay vista previa disponible para este archivo, intente descargar el archivo en su lugar."
            },
            "notifications": {
                "notifications": "Notificaciones",
                "notification": "Notificación",
                "your": "Tus notificaciones",
                "no_notifications": "No tienes notificaciones en este momento.",
                "description": "Descripción",
                "mark_all_as_read": "Marcar todo como leído",
                "no_more_notifications": "No más notificaciones.",
                "dismiss": "Dismiss",
                "channels": {
                    "mail": "Correo",
                    "database": "Timbre"
                }
            },
            "oauth": {
                "connect": "Conectar",
                "no_accounts": "No tiene ninguna cuenta conectada.",
                "invalid_state": "Solicitud no válida, inténtelo de nuevo.",
                "connect_new_account": "Conectar una cuenta nueva",
                "add": "Agregar una cuenta nueva",
                "or_choose_existing": "o elija una cuenta añadida anteriormente:",
                "stop_syncing": "Detener sincronización",
                "start_syncing": "Iniciar sincronización",
                "deleted": "Cuenta eliminada correctamente",
                "connected_accounts": "Cuentas conectadas",
                "requires_authentication": "Esta cuenta requiere una nueva autenticación para volver a conectarse a la aplicación.",
                "re_authenticate": "Volver a autentificar",
                "re_authenticated": "Cuenta reautenticada correctamente",
                "delete_warning": "Eliminar una cuenta conectada detendrá todos los servicios relacionados que proporciona la cuenta, incluidas las cuentas de correo electrónico conectadas que se utilizan para la bandeja de entrada."
            },
            "resource": {
                "all_resources": "All Resources",
                "created": "Registro creado correctamente",
                "updated": "Registro actualizado correctamente",
                "deleted": "Registro eliminado correctamente",
                "create": "Crear {resource}",
                "edit": "Editar {resource}",
                "already_associated": "Este registro ya está asociado",
                "associate_with_records": "Asociar con registros",
                "associated": "Registro asociado correctamente",
                "dissociated": "Registro disociado con éxito",
                "associated_delete_warning": "El {resource} ya está asociado a registros, por lo que no puede eliminarse.",
                "primary_record_delete_info": "Se trata de un {resource} primario, por lo que no puede suprimirse",
                "settings": {
                    "fields": "{resourceName} Campos"
                }
            },
            "role": {
                "permissions": "Permisos",
                "role": "Función",
                "roles": "Funciones",
                "name": "Nombre",
                "create": "Crear función",
                "edit": "Editar funciones",
                "created": "Función creada correctamente",
                "updated": "Función actualizada correctamente",
                "deleted": "Función eliminada correctamente",
                "granted": "Concedido",
                "revoked": "Revocado",
                "capabilities": {
                    "access": "Acceso",
                    "view": "Ver",
                    "delete": "Eliminar",
                    "bulk_delete": "Eliminación masiva",
                    "edit": "Editar",
                    "all": "Todo {resourceName}",
                    "owning_only": "Solo propiedad",
                    "use_voip": "Hacer y contestar llamadas"
                },
                "view_non_authorized_after_record_create": "Su cuenta no está autorizada para ver este registro, ya que usted no es el propietario, después de redirigir desde esta página, no podrá acceder al registro.",
                "empty_state": {
                    "title": "No roles",
                    "description": "Get started by creating a new role."
                }
            },
            "settings": {
                "settings": "Ajustes",
                "updated": "Configuración actualizada",
                "general_settings": "Configuración general",
                "company_information": "Información de la empresa",
                "update_user_account_info": "La actualización de esta configuración no afectará la configuración de su cuenta de usuario, ya que esta configuración es general. Actualice la misma configuración en su cuenta de usuario si desea actualizar estas opciones.",
                "general": "General",
                "system": "Sistema",
                "system_email": "Cuenta de correo electrónico del sistema",
                "system_email_configured": "Cuenta configurada por otro usuario",
                "system_email_info": "Seleccione la cuenta de correo electrónico conectada a la bandeja de entrada que se utilizará para enviar correos relacionados con el sistema, como el usuario asignado al contacto, recordatorio de actividad, invitaciones de usuario, etc.",
                "choose_logo": "Elegir logo",
                "date_format": "Formato de fecha",
                "time_format": "Formato de la hora",
                "go_to_settings": "Go to settings",
                "privacy_policy_info": "Si no tienes política de privacidad, puedes configurarla aquí, consulta la política de privacidad en la siguiente URL: {url}",
                "phones": {
                    "require_calling_prefix": "Exigir prefijo en los números de teléfono",
                    "require_calling_prefix_info": "La mayoría de las integraciones de llamadas requieren que los números de teléfono estén en formato E.164. Al habilitar esta opción, se asegurará de que no se ingresen números de teléfono sin un prefijo de llamada específico del país."
                },
                "recaptcha": {
                    "recaptcha": "reCaptcha",
                    "site_key": "Clave de acceso",
                    "secret_key": "Clave secreta",
                    "ignored_ips": "Ignorar direcciones IP",
                    "ignored_ips_info": "Ingrese las direcciones IP separadas por comas que desea que el reCaptcha omita la validación.",
                    "dont_get_locked": "Don't get locked",
                    "ensure_recaptcha_works": "To ensure the reCaptcha configuration works well, always perform a test login via Incognito Mode while keeping the current window active."
                },
                "security": {
                    "security": "Seguridad",
                    "disable_password_forgot": "Desactivar la función de olvido de contraseña",
                    "disable_password_forgot_info": "Cuando está habilitada, la función de contraseña olvidada estará deshabilitada.",
                    "block_bad_visitors": "Bloquea a los visitantes no deseados",
                    "block_bad_visitors_info": "Si está habilitado, se verificará una lista de agentes de usuario, direcciones IP y referentes incorrectos para cada visitante invitado."
                },
                "tools": {
                    "tools": "Herramientas",
                    "run": "Ejecutar herramienta",
                    "executed": "Acción ejecutada con éxito",
                    "clear-cache": "Borrar la memoria caché de la aplicación",
                    "storage-link": "Crear un enlace simbólico de \"public/storage\" a \"storage/app/public\".",
                    "optimize": "Guarde en caché los archivos de arranque de la aplicación, como la configuración y las rutas.",
                    "seed-mailable-templates": "Sembrar las plantillas de correo de la aplicación"
                }
            },
            "table": {
                "default_sort": "Clasificación predeterminada",
                "per_page": "Por página",
                "columns": "Columnas",
                "wrap_column": "Wrap Column",
                "primary_column": "Columna principal",
                "empty": "No hay datos disponibles en la tabla",
                "info": "Mostrando {total} de entradas {from} hasta {to}",
                "previous": "Anterior",
                "next": "Siguiente",
                "max_height": "Altura máxima",
                "max_height_info": "Especificar la altura máxima de la tabla garantiza que los encabezados de la tabla se fijarán en la parte superior mientras se desplaza.",
                "list_settings": "Configuración de la lista",
                "customize_list_view": "Personalizar la vista de lista",
                "condensed": "Condensed Table",
                "bordered": "Bordered Table",
                "enable_polling": "Enable Polling",
                "polling_info": "The interval in seconds at which should poll for new records.",
                "length_menu": {
                    "show": "Mostrar",
                    "entries": "entradas"
                }
            },
            "tags": {
                "tags": "Tags",
                "search": "Search Tags",
                "add_new": "Add new tag",
                "tag_name": "Tag Name",
                "color": "Color",
                "edit_tag": "Edit Tag",
                "new_tag": "New Tag",
                "validation": {
                    "coma": "Comas are not allowed in tag names."
                }
            },
            "timeline": {
                "pin": "Fijar en la parte superior",
                "unpin": "Quitar de la parte superior",
                "updated": "Los datos se han actualizado",
                "association_restored": "La asociación {associationDisplayName} ha sido restaurada de la papelera por {user}",
                "association_permanently_deleted": "La asociación {associationDisplayName} se ha eliminado de forma permanente",
                "deleted": "The record has been deleted by {causer}",
                "restored": "The record has been restored from trash by {causer}",
                "created": "The record has been created by {causer}",
                "imported": "The record has been imported by {causer}",
                "attached": "{user} associated",
                "detached": "{user} dissociated",
                "associate_trashed": "The associated {displayName} record has been moved to trash by {user}"
            },
            "update": {
                "system": "Actualización del sistema",
                "update": "Actualización",
                "perform": "Realizar actualización",
                "installed_version": "Versión instalada",
                "latest_version": "Última versión",
                "not_available": "No hay nueva versión disponible.",
                "using_latest_version": "Está utilizando la última versión.",
                "update_in_progress": "Actualización en proceso...",
                "patches": "Parches",
                "patch_applied": "Aplicada",
                "apply_oldest_first": "Debe aplicar primero las actualizaciones más antiguas.",
                "no_patches": "No hay actualizaciones disponibles para tu versión, compruébalo más tarde.",
                "update_zip_is_required": "Para utilizar la función de actualización en 1 clic, deberá activar la extensión \"zip\" de PHP.",
                "patch_zip_is_required": "Para aplicar los parches, deberá activar la extensión \"zip\" de PHP.",
                "auto_apply_patches": "Automatically apply new patches"
            },
            "workflow": {
                "create": "Crear flujo de trabajo",
                "workflows": "Flujos de trabajo",
                "title": "Título",
                "description": "Descripción",
                "created": "Flujo de trabajo creado correctamente",
                "updated": "Flujo de trabajo actualizado correctamente",
                "deleted": "Flujo de trabajo eliminado correctamente",
                "when": "Cuando",
                "then": "Luego",
                "field_change_to": "Para",
                "total_executions": "Ejecuciones: {total}",
                "info": "La herramienta de flujos de trabajo automatiza sus procesos de ventas. Los procesos internos que se pueden automatizar incluyen la creación de actividades, el envío de correos electrónicos, la activación de solicitudes HTTP, etc.",
                "validation": {
                    "invalid_webhook_url": "La URL del webhook no debe comenzar con \"https://\" o \"http://\""
                },
                "actions": {
                    "webhook": "Activar webhook",
                    "webhook_url_info": "Debe ser una URL completa, válida y de acceso público."
                },
                "fields": {
                    "with_header_name": "Con nombre de encabezado (opcional)",
                    "with_header_value": "Con valor de encabezado (opcional)",
                    "for_owner": "Para: Titular (persona responsable)",
                    "dates": {
                        "now": "Con fecha de vencimiento: en este momento",
                        "in_1_day": "Con fecha de vencimiento: en un día",
                        "in_2_days": "Con fecha de vencimiento: en dos días",
                        "in_3_days": "Con fecha de vencimiento: en tres días",
                        "in_4_days": "Con fecha de vencimiento: en cuatro días",
                        "in_5_days": "Con fecha de vencimiento: en cinco días"
                    }
                }
            }
        }
    },
    "pt_BR": {
        "auth": {
            "failed": "Essas credenciais não correspondem aos nossos registros.",
            "password": "Senha",
            "throttle": "Muitas tentativas de login. Tente novamente em {seconds} segundos.",
            "current_password": "Senha Atual",
            "logout": "Sair",
            "login": "Entrar",
            "login_subheading": "Welcome, please sign in to your dashboard",
            "forgot_password": "Esqueceu sua Senha?",
            "email_address": "Endereço de E-Mail",
            "confirm_password": "Confirmar Senha",
            "new_password": "Nova Senha",
            "change_password": "Alterar Senha",
            "remember_me": "Lembrar de mim?",
            "signing_in": "Entrando...",
            "sign_in_heading": "Entre na sua conta"
        },
        "pagination": {
            "previous": "Anterior",
            "next": "Próximo"
        },
        "passwords": {
            "reset": "Sua senha foi redefinida!",
            "sent": "Enviamos um link para redefinir sua senha por e-mail!",
            "throttled": "Por favor, aguarde antes de tentar novamente.",
            "token": "Este token de redefinição de senha é inválido.",
            "user": "Não conseguimos encontrar um usuário com esse endereço de e-mail.",
            "reset_password": "Redefinir Senha",
            "send_password_reset_link": "Enviar Link de Redefinição de Senha"
        },
        "validation": {
            "accepted": "O {attribute} deve ser aceito.",
            "accepted_if": "O {attribute} deve ser aceito quando {other} for {value}.",
            "active_url": "O {attribute} não é um URL válido.",
            "after": "O {attribute} deve ser uma data posterior a {date}.",
            "after_or_equal": "O {attribute} deve ser uma data após ou igual a {date}.",
            "alpha": "O {attribute} deve conter apenas letras.",
            "alpha_dash": "O {attribute} deve conter apenas letras, números, traços e sublinhados.",
            "alpha_num": "O {attribute} deve conter apenas letras e números.",
            "array": "O {attribute} deve ser uma matriz.",
            "ascii": "The {attribute} field must only contain single-byte alphanumeric characters and symbols.",
            "before": "O {attribute} deve ser uma data anterior a {date}.",
            "before_or_equal": "O {attribute} deve ser uma data anterior ou igual a {date}.",
            "between": {
                "array": "O {attribute} deve ter entre {min} e {max} itens.",
                "file": "O {attribute} deve ter entre {min} e {max} kilobytes.",
                "numeric": "O {attribute} deve estar entre {min} e {max}.",
                "string": "O {attribute} deve ter entre {min} e {max} caracteres."
            },
            "boolean": "O campo {attribute} deve ser verdadeiro ou falso.",
            "can": "The {attribute} field contains an unauthorized value.",
            "confirmed": "A confirmação do {attribute} não corresponde.",
            "current_password": "A senha está incorreta.",
            "date": "O {attribute} não é uma data válida.",
            "date_equals": "O {attribute} deve ser uma data igual a {date}.",
            "date_format": "O {attribute} não corresponde ao formato {format}.",
            "decimal": "O {attribute} deve ter {decimal} casas decimais.",
            "declined": "O {attribute} deve ser recusado.",
            "declined_if": "O {attribute} deve ser recusado quando {other} for {value}.",
            "different": "O {attribute} e {other} devem ser diferentes.",
            "digits": "O {attribute} deve ter {digits} dígitos.",
            "digits_between": "O {attribute} deve ter entre {min} e {max} dígitos.",
            "dimensions": "O {attribute} tem dimensões de imagem inválidas.",
            "distinct": "O campo {attribute} tem um valor duplicado.",
            "doesnt_end_with": "O {attribute} não pode terminar com um dos seguintes: {values}.",
            "doesnt_start_with": "O {attribute} não pode começar com um dos seguintes: {values}.",
            "email": "O {attribute} deve ser um endereço de e-mail válido.",
            "ends_with": "O {attribute} deve terminar com um dos seguintes: {values}.",
            "enum": "O {attribute} selecionado é inválido.",
            "exists": "O {attribute} selecionado é inválido.",
            "extensions": "The {attribute} field must have one of the following extensions: {values}.",
            "file": "O {attribute} deve ser um arquivo.",
            "filled": "O campo {attribute} deve ter um valor.",
            "gt": {
                "array": "O {attribute} deve ter mais de {value} itens.",
                "file": "O {attribute} deve ser maior que {value} kilobytes.",
                "numeric": "O {attribute} deve ser maior que {value}.",
                "string": "O {attribute} deve ter mais de {value} caracteres."
            },
            "gte": {
                "array": "O {attribute} deve ter {value} itens ou mais.",
                "file": "O {attribute} deve ser maior ou igual a {value} kilobytes.",
                "numeric": "O {attribute} deve ser maior ou igual a {value}.",
                "string": "O {attribute} deve ser maior ou igual a {value} caracteres."
            },
            "hex_color": "The {attribute} field must be a valid hexadecimal color.",
            "image": "O {attribute} deve ser uma imagem.",
            "in": "O {attribute} selecionado é inválido.",
            "in_array": "O campo {attribute} não existe em {other}.",
            "integer": "O {attribute} deve ser um número inteiro.",
            "ip": "O {attribute} deve ser um endereço de IP válido.",
            "ipv4": "O {attribute} deve ser um endereço IPv4 válido.",
            "ipv6": "O {attribute} deve ser um endereço IPv6 válido.",
            "json": "O {attribute} deve ser uma sequência JSON válida.",
            "lowercase": "The {attribute} field must be lowercase.",
            "lt": {
                "array": "O {attribute} deve ter menos de {value} itens.",
                "file": "O {attribute} deve ser menor que {value} kilobytes.",
                "numeric": "O {attribute} deve ser menor que {value}.",
                "string": "O {attribute} deve ter menos de {value} caracteres."
            },
            "lte": {
                "array": "O {attribute} não deve ter mais de {value} itens.",
                "file": "O {attribute} deve ser menor ou igual a {value} kilobytes.",
                "numeric": "O {attribute} deve ser menor ou igual a {value}.",
                "string": "O {attribute} deve ser menor ou igual a {value} caracteres."
            },
            "mac_address": "O {attribute} deve ser um endereço MAC válido.",
            "max": {
                "array": "O {attribute} não deve ter mais de {max} itens.",
                "file": "O {attribute} não deve ser maior que {max} kilobytes.",
                "numeric": "O {attribute} não deve ser maior que {max}.",
                "string": "O {attribute} não deve ser maior que {max} caracteres."
            },
            "max_digits": "The {attribute} field must not have more than {max} digits.",
            "mimes": "O {attribute} deve ser um arquivo do tipo: {values}.",
            "mimetypes": "O {attribute} deve ser um arquivo do tipo: {values}.",
            "min": {
                "array": "O {attribute} deve ter pelo menos {min} itens.",
                "file": "O {attribute} deve ter pelo menos {min} kilobytes.",
                "numeric": "O {attribute} deve ser no mínimo {min}.",
                "string": "O {attribute} deve ter pelo menos {min} caracteres."
            },
            "min_digits": "The {attribute} field must have at least {min} digits.",
            "missing": "The {attribute} field must be missing.",
            "missing_if": "The {attribute} field must be missing when {other} is {value}.",
            "missing_unless": "The {attribute} field must be missing unless {other} is {value}.",
            "missing_with": "The {attribute} field must be missing when {values} is present.",
            "missing_with_all": "The {attribute} field must be missing when {values} are present.",
            "multiple_of": "O {attribute} deve ser um múltiplo de {value}.",
            "not_in": "O {attribute} selecionado é inválido.",
            "not_regex": "O formato do {attribute} é inválido.",
            "numeric": "O {attribute} deve ser um número.",
            "password": "A senha está incorreta.",
            "present": "O campo {attribute} deve estar presente.",
            "present_if": "The {attribute} field must be present when {other} is {value}.",
            "present_unless": "The {attribute} field must be present unless {other} is {value}.",
            "present_with": "The {attribute} field must be present when {values} is present.",
            "present_with_all": "The {attribute} field must be present when {values} are present.",
            "prohibited": "O campo {attribute} é proibido.",
            "prohibited_if": "O campo {attribute} é proibido quando {other} é {value}.",
            "prohibited_unless": "O campo {attribute} é proibido a menos que {other} esteja em {values}.",
            "prohibits": "O campo {attribute} proíbe que {other} esteja presente.",
            "regex": "O formato do {attribute} é inválido.",
            "required": "O campo {attribute} é obrigatório.",
            "required_array_keys": "O campo {attribute} deve conter entradas para: {values}.",
            "required_if": "O campo {attribute} é obrigatório quando {other} é {value}.",
            "required_if_accepted": "The {attribute} field is required when {other} is accepted.",
            "required_unless": "O campo {attribute} é obrigatório a menos que {other} esteja em {values}.",
            "required_with": "O campo {attribute} é obrigatório quando {values} está presente.",
            "required_with_all": "O campo {attribute} é obrigatório quando {values} estão presentes.",
            "required_without": "O campo {attribute} é obrigatório quando {values} não está presente.",
            "required_without_all": "O campo {attribute} é obrigatório quando nenhum dos {values} estão presentes.",
            "same": "O {attribute} e {other} devem ser iguais.",
            "size": {
                "array": "O {attribute} deve ter exatamente {size} itens.",
                "file": "O {attribute} deve ser {size} kilobytes.",
                "numeric": "O {attribute} deve ser {size}.",
                "string": "O {attribute} deve ter {size} caracteres."
            },
            "starts_with": "O {attribute} deve começar com um dos seguintes valores: {values}.",
            "string": "O {attribute} deve ser uma sequência de caracteres.",
            "timezone": "O {attribute} deve ser uma timezone válida.",
            "unique": "O {attribute} já foi utilizado.",
            "uploaded": "O {attribute} falhou ao fazer o upload.",
            "uppercase": "The {attribute} field must be uppercase.",
            "url": "O formato do {attribute} é inválido.",
            "ulid": "The {attribute} field must be a valid ULID.",
            "uuid": "O {attribute} deve ser um UUID válido.",
            "recaptcha": "Falha na verificação ReCaptcha.",
            "numeric_field": "O {attribute} não é um número válido, digite um número válido como por exemplo 1200, 1200.00 ou 1200.255.",
            "calling_prefix": "O {attribute} deve começar com o código de chamada de país válido, por exemplo: +994",
            "required_file": "Adicione um arquivo.",
            "invalid_options": "The provided option \"{options}\" is invalid.|The provided options \"{options}\" are invalid.",
            "custom": {
                "notifications.*.email": "Enter valid email address.",
                "notifications.*.filled": "Enter email address.",
                "_privacy-policy.accepted": "You must accept the privacy policy",
                "notifications": {
                    "*": {
                        "email": "Digite um endereço de email válido."
                    }
                },
                "_privacy-policy": {
                    "accepted": "Você deve aceitar a política de privacidade."
                }
            },
            "import": {
                "user": {
                    "invalid": "Você forneceu um usuário que não existe. Você deve adicionar o ID do usuário ou o nome completo do usuário."
                }
            },
            "attributes": [],
            "required_without_label": "Preencha este campo obrigatório.",
            "number": "O {attribute} deve ser um número."
        },
        "activities": {
            "activity": {
                "activities": "Atividades",
                "activity": "Atividade",
                "add": "Adicionar Atividade",
                "description": "Descrição",
                "description_info": "A descrição é visível para todos os convidados",
                "note": "Nota",
                "note_info": "As notas são privadas e visíveis apenas para os representantes de vendas.",
                "title": "Título",
                "due_date": "Data de Vencimento",
                "end_date": "Data Final",
                "create": "Criar Atividade",
                "download_ics": "Baixar Arquivo .ics",
                "created": "Atividade criada com sucesso",
                "updated": "Atividade atualizada com sucesso",
                "deleted": "Atividade excluída com sucesso",
                "export": "Exportar Atividades",
                "import": "Importar Atividades",
                "guests": "Convidados",
                "guest": "Convidado",
                "count_guests": "1 convidado | {count} convidados",
                "create_follow_up_task": "Criar tarefa de follow up",
                "follow_up_with_title": "Follow up com {with}",
                "title_via_create_message": "Sobre um e-mail: {subject}",
                "reminder_update_info": "Como o lembrete para esta atividade já foi enviado, você precisará atualizar a data de vencimento para um novo lembrete ser enviado para a fila.",
                "owner_assigned_date": "Data de Atribuição ao Proprietário",
                "reminder_sent_date": "Data de Envio do Lembrete",
                "reminder": "Lembrete",
                "owner": "Proprietário",
                "mark_as_completed": "Marcar como concluído",
                "mark_as_incomplete": "Marcar como incompleto",
                "is_completed": "Está Concluído",
                "completed_at": "Concluído em",
                "overdue": "Atrasado",
                "doesnt_have_activities": "Nenhuma Atividade",
                "count": "Nenhuma Atividade | 1 Atividade | {count} Atividades",
                "incomplete_activities": "Atividades Incompletas",
                "activity_was_due": "Essa atividade venceu em {date}",
                "next_activity_date": "Data da Próxima Atividade",
                "next_activity_date_info": "Este campo é somente leitura e é atualizado automaticamente com base nas atividades futuras do registro, indica quando a próxima ação do representante de vendas deve ser tomada.",
                "cards": {
                    "my_activities": "Minhas atividades",
                    "my_activities_info": "Este card reflete as atividades que você é adicionado como proprietário",
                    "created_by_agent": "Atividades criadas pelo vendedor",
                    "created_by_agent_info": "Veja o número de atividades que cada vendedor criou. Veja quem está criando mais atividades e quem está criando menos.",
                    "upcoming": "Próximas atividades",
                    "upcoming_info": "Este card reflete as atividades que estão por vir e aquela que você está participando."
                },
                "type": {
                    "default_type": "Tipo de Atividade Padrão",
                    "delete_primary_warning": "Você não pode excluir o tipo de atividade principal.",
                    "delete_usage_warning": "O tipo já está associado a atividades, portanto, não pode ser excluído.",
                    "delete_usage_calendars_warning": "Este tipo é usado como tipo padrão ao criar atividades por meio de calendários conectados e, portanto, não pode ser excluído.",
                    "delete_is_default": "Este é um tipo de atividade padrão, portanto, não pode ser excluído.",
                    "type": "Tipo de Atividade",
                    "types": "Tipos de Atividade",
                    "name": "Nome",
                    "icon": "Ícone"
                },
                "filters": {
                    "activity_type_disabled": "O tipo de atividade é usado no filtro atual, portanto, você não pode selecionar o tipo de atividade nesta seção",
                    "open": "Atividades Abertas",
                    "due_today": "Vence Hoje",
                    "due_this_week": "Vence Esta Semana",
                    "display": {
                        "has": "tem atividades {value}:",
                        "overdue": "tem {value}: atividades",
                        "doesnt_have_activities": "não possui qualquer atividade"
                    },
                    "all": "Todos",
                    "today": "Hoje",
                    "tomorrow": "Amanhã",
                    "this_week": "Esta Semana",
                    "next_week": "Próxima Semana",
                    "done": "Concluído",
                    "done_empty_state": "As atividades concluídas serão mostradas aqui."
                },
                "settings": {
                    "send_contact_email": "Enviar modelo de e-mail \"Contato atende a atividade\" para contatos",
                    "send_contact_email_info": "Se ativado, quando o contato é adicionado como convidado na atividade, um modelo de e-mail será enviado com arquivo .ics anexado e informações da atividade."
                },
                "manage_activities": "Gerenciar Atividades",
                "info": "Agende e gerencie atividades com contatos e vendedores.",
                "timeline": {
                    "heading": "Uma atividade foi criada"
                },
                "permissions": {
                    "attends_and_owned": "Participantes e proprietários apenas"
                },
                "actions": {
                    "update_type": "Atualizar tipo"
                },
                "notifications": {
                    "due": "Sua atividade {activity} vence em {date}",
                    "assigned": "Você foi atribuído à atividade {name} por {user}",
                    "added_as_guest": "Você foi adicionado como convidado à atividade"
                },
                "mail_placeholders": {
                    "assigneer": "O nome de usuário que atribuiu a atividade"
                },
                "validation": {
                    "end_date": {
                        "less_than_due": "A data final não deve ser inferior à data de vencimento."
                    },
                    "end_time": {
                        "required_when_end_date_is_in_future": "Você deve especificar a hora de término quando a data de término for em um dia diferente."
                    }
                },
                "workflows": {
                    "actions": {
                        "create": "Criar Atividade"
                    },
                    "fields": {
                        "create": {
                            "title": "Com título da atividade",
                            "note": "Adicionar nota (opcional)"
                        }
                    }
                },
                "metrics": {
                    "todays": "Atividades de Hoje"
                },
                "empty_state": {
                    "title": "Você não criou nenhuma atividade.",
                    "description": "Comece criando uma nova atividade."
                }
            },
            "calendar": {
                "calendar": "Calendário",
                "calendar_sync": "Sincronização do Calendário",
                "reconfigure": "Reconfigurar",
                "choose_oauth_account": "Escolha um tipo de conta para começar a sincronizar os eventos do calendário",
                "account_being_connected": "Você está prestes a conectar a conta {email}.",
                "save_events_as": "Salvar evento do calendário como:",
                "sync_activity_types": "Sincronize os seguintes tipos de atividade com o calendário:",
                "sync_support_only_primary": "É possível sincronizar apenas o calendário principal da conta.",
                "only_future_events_will_be_synced": "Apenas eventos futuros serão sincronizados.",
                "events_will_sync_from": "Os eventos criados a partir de {date} serão sincronizados.",
                "events_being_synced_from": "Os eventos criados a partir de {date} estão sendo sincronizados.",
                "missing_outlook_integration": "Microsoft application not configured, you must configure your Microsoft application in order to sync Outlook calendar.",
                "missing_google_integration": "Google application project not configured, you must configure your Google application project in order to connect to sync Google calendar.",
                "timeline": {
                    "imported_via_calendar_attendee": "Contato importado via calendário do {user} porque foi adicionado como participante de um evento."
                },
                "fullcalendar": {
                    "locale": {
                        "buttonText": {
                            "prev": "Período anterior",
                            "next": "Próximo período",
                            "prevYear": "Ano anterior",
                            "nextYear": "Próximo ano",
                            "year": "Ano",
                            "today": "Hoje",
                            "month": "Mês",
                            "week": "Semana",
                            "day": "Dia",
                            "list": "Lista"
                        },
                        "weekText": "S",
                        "allDayText": "Dia todo",
                        "moreLinkText": "mais",
                        "noEventsText": "Nenhuma atividade para mostrar"
                    }
                }
            }
        },
        "billable": {
            "billable": {
                "total": "Total",
                "sub_total": "Subtotal",
                "includes_discount": "Inclui desconto de {amount}",
                "tax_amount_is_inclusive": "inc",
                "tax_types": {
                    "inclusive": "Com impostos inclusos",
                    "exclusive": "Sem impostos inclusos",
                    "no_tax": "Sem impostos"
                }
            },
            "product": {
                "products": "Produtos",
                "product": "Produto",
                "create": "Criar Produto",
                "edit": "Editar Produto",
                "export": "Exportar Produtos",
                "import": "Importar Produtos",
                "created": "Produto criado com sucesso",
                "updated": "Produto atualizado com sucesso",
                "deleted": "Produto excluído com sucesso",
                "related_products": "Produtos Relacionados",
                "manage": "Gerenciar Produtos",
                "name": "Nome",
                "description": "Descrição",
                "table_heading": "Produto",
                "tax": "Taxa",
                "quantity": "Quantidade",
                "qty": "QTD",
                "unit_price": "Preço Unitário",
                "direct_cost": "Custo Direto",
                "unit": "Unidade (kg, lots)",
                "sku": "SKU",
                "is_active": "Ativo",
                "tax_rate": "Taxa de Imposto",
                "tax_label": "Rótulo da Taxa",
                "tax_percent": "Porcentagem da Taxa",
                "discount": "Desconto",
                "amount": "Valor",
                "discount_percent": "Porcentagem de Desconto",
                "discount_amount": "Quantia de Desconto",
                "will_be_added_as_new": "{name} será adicionado como novo produto",
                "total_products": "Total de Produtos",
                "total_sold": "Total Vendido",
                "sold_amount_exc_tax": "Valor Vendido (tax exl.)",
                "interest_in_product": "Interesse no Produto",
                "resource_has_no_products": "Nenhum produto criado, comece adicionando produtos",
                "exists_in_trash_by_name": "Já existe um produto com o mesmo nome na lixeira. Deseja restaurar o produto descartado?",
                "choose_or_enter": "Escolha ou insira um produto",
                "cards": {
                    "performance": "Desempenho do produto",
                    "performance_info": "A coluna \"Interesse no produto\" reflete todos os produtos que são adicionados aos negócios, mas a coluna \"Total vendido\" reflete os produtos que são adicionados aos negócios e os negócios são marcados como ganhos"
                },
                "count": "0 produtos | 1 produto | {count} produtos",
                "settings": {
                    "default_tax_type": "Você vende seus produtos a taxas que incluem impostos?",
                    "default_discount_type": "Tipo de desconto padrão"
                },
                "actions": {
                    "mark_as_active": "Marcar como ativo",
                    "mark_as_inactive": "Marcar como inativo",
                    "update_unit_price": "Atualizar preço",
                    "update_tax_rate": "Atualizar taxa de imposto",
                    "update_tax_label": "Update tax label"
                },
                "validation": {
                    "sku": {
                        "unique": "Um produto com este SKU já existe."
                    }
                },
                "empty_state": {
                    "title": "Você não criou nenhum produto.",
                    "description": "Economize tempo usando produtos predefinidos."
                }
            }
        },
        "brands": {
            "brand": {
                "brand": "Marca",
                "brands": "Marcas",
                "create": "Criar marca",
                "update": "Atualizar marca",
                "form": {
                    "sections": {
                        "general": "Em geral",
                        "navigation": "Navegação",
                        "email": "E-mail",
                        "thank_you": "Obrigado",
                        "signature": "Assinatura",
                        "pdf": "PDF"
                    },
                    "is_default": "Esta é a marca padrão da empresa?",
                    "name": "Como você se refere a esta marca internamente?",
                    "display_name": "Como você quer que seja exibido para seus clientes?",
                    "primary_color": "Escolha a cor primária da marca",
                    "upload_logo": "Envie o logotipo da sua empresa",
                    "navigation": {
                        "background_color": "Navigation background color",
                        "upload_logo_info": "Se você tiver um fundo escuro, use um logotipo claro. Se você estiver usando uma cor de fundo clara, use um logotipo com texto escuro."
                    },
                    "pdf": {
                        "default_font": "Família de fontes padrão",
                        "default_font_info": "The {fontName} fonte fornece a cobertura de caracteres Unicode mais decente por padrão, certifique-se de selecionar uma fonte adequada se caracteres especiais ou unicode não forem exibidos corretamente no documento PDF.",
                        "size": "Tamanho",
                        "orientation": "Orientação",
                        "orientation_portrait": "Portrait",
                        "orientation_landscape": "Landspace"
                    },
                    "email": {
                        "upload_logo_info": "Certifique-se de que o logotipo é adequado para um fundo branco, se nenhum logotipo for carregado, o logotipo escuro carregado nas configurações gerais será usado."
                    },
                    "document": {
                        "send": {
                            "info": "Ao enviar um documento",
                            "subject": "Assunto padrão",
                            "message": "Mensagem de e-mail padrão quando você está enviando um documento",
                            "button_text": "Texto do botão de e-mail"
                        },
                        "sign": {
                            "info": "Quando alguém assina seu documento",
                            "subject": "Linha de assunto padrão para e-mail de agradecimento",
                            "message": "Mensagem de e-mail a ser enviada quando alguém assinar seu documento",
                            "after_sign_message": "Depois de assinar, o que a mensagem deve dizer?"
                        },
                        "accept": {
                            "after_accept_message": "Depois de aceitar (sem assinatura digital), o que a mensagem deve dizer?"
                        }
                    },
                    "signature": {
                        "bound_text": "Limite legal do texto"
                    }
                },
                "delete_documents_usage_warning": "A marca já está associada a documentos, portanto, não pode ser excluída.",
                "created": "Marca criada com sucesso.",
                "updated": "Marca atualizada com sucesso.",
                "deleted": "Marca excluída com sucesso."
            }
        },
        "calls": {
            "call": {
                "calls": "Chamadas",
                "call": "Call",
                "add": "Registrar Chamada",
                "make": "Fazer uma Ligação",
                "log": "Descreva resumidamente o resultado da chamada...",
                "manage_calls": "Gerenciar Chamadas",
                "total_calls": "Total de Chamadas",
                "activate_voip": "Activate",
                "voip_activated": "Activated",
                "info": "Você pode registrar chamadas e acompanhar todas as interações realizadas por você e sua equipe.",
                "info_created": "{user} registrou uma chamada em {date}",
                "follow_up_task_body": "Referente ao registro de chamada: {content}",
                "created": "Chamada registrada com sucesso",
                "updated": "Chamada atualizada com sucesso",
                "deleted": "Chamada excluída com sucesso",
                "date": "Data da Chamada",
                "read_outcome": "Read Outcome",
                "outcome": {
                    "outcomes": "Resultados de Chamadas",
                    "outcome": "Resultado",
                    "call_outcome": "Resultado da Chamada",
                    "select_outcome": "Selecionar Resultado",
                    "delete_warning": "O resultado da chamada já está associado a chamadas, portanto, não pode ser excluído.",
                    "name": "Nome"
                },
                "no_voip_permissions": "Sua conta não está autorizada a fazer chamadas",
                "voip_permissions": "Chamadas VoIP",
                "new_from": "Nova chamada de {number}",
                "connected_with": "Conectado com {number}",
                "ended": "Chamada com {number} finalizada",
                "speaker_volume": "Volume do Alto-falante",
                "mic_volume": "Volume do Microfone",
                "mute": "Mudo",
                "unmute": "Desativar Mudo",
                "answer": "Responder Chamada",
                "hangup": "Desligar Chamada",
                "reject": "Rejeitar Chamada",
                "unknown_devices": "Vendo dispositivos desconhecidos?",
                "hide_bar": "Ocultar esta barra",
                "activation_required": "Calling feature activation required",
                "activation_gesture_required": "Most browsers require user gesture (click) to activate calling feature\n        like audio and microphone. This is handled on your first click when you\n        enter your dashboard, since, you did not click anything in\n        {askForActivationIn} minute, we ask you to activate the calling\n        functionality by clicking below.",
                "cards": {
                    "by_day": "Chamadas registradas por dia",
                    "by_sale_agent": "Total de chamadas registradas por agente de vendas",
                    "logged_calls": "Logged calls",
                    "outcome_overview": "Visão geral do resultado da chamada"
                },
                "workflows": {
                    "triggers": {
                        "logged": "Chamada Registrada",
                        "missed_incoming_call": "Chamada Recebida Perdida"
                    }
                },
                "timeline": {
                    "heading": "Nova chamada foi registrada"
                },
                "capabilities": {
                    "use_voip": "Fazer e Atender Chamadas"
                },
                "take_notes": "Faça anotações durante a chamada..."
            },
            "twilio": {
                "create_app": "Criar Aplicativo",
                "disconnect": "Desconectar Integração",
                "number": "Selecione o número Twilio da sua conta que será usado para fazer e receber chamadas.",
                "retrieve_numbers": "Retrieve Numbers",
                "app": "Crie um aplicativo que lidará com o início de novas chamadas e chamadas recebidas."
            }
        },
        "comments": {
            "comment": {
                "add": "Adicionar comentário",
                "comments": "Comentários",
                "reply": "Responder",
                "created": "Comentário adicionado com sucesso.",
                "updated": "Comentário arualizado com sucesso.",
                "user_left_comment": "{user} deixou um comentário",
                "total": "Comentários ({total})",
                "no_comments": "Nenhum comentário aqui.",
                "add_placeholder": "Escreva um novo comentário, envie uma notificação para sua equipe digitando {'@'} seguido do nome"
            }
        },
        "contacts": {
            "company": {
                "company": "Empresa",
                "companies": "Empresas",
                "add": "Adicionar Empresa",
                "dissociate": "Dissociar Empresa",
                "child": "Empresa Filha | Empresas Filha",
                "create": "Criar Empresa",
                "export": "Exportar Empresas",
                "total": "Total de Empresas",
                "import": "Importar Empresas",
                "create_with": "Criar Empresa com {name}",
                "associate_with": "Associar Empresa com {name}",
                "associate_field_info": "Use este campo para localizar e associar uma empresa existente em vez de criar uma nova.",
                "no_contacts_associated": "A empresa não possui contatos associados.",
                "no_deals_associated": "A empresa não tem negócios associados.",
                "exists_in_trash_by_email": "A empresa com este endereço de e-mail já existe na lixeira, você não poderá criar uma nova empresa com o mesmo endereço de e-mail, gostaria de restaurar a empresa na lixeira?",
                "exists_in_trash_by_name": "Já existe uma empresa com o mesmo nome na lixeira. Deseja restaurar a empresa descartada?",
                "exists_in_trash_by_phone": "Company ({company}) with the following numbers: {phone_numbers}, already exists in the trash, would you like to restore the trashed company?",
                "possible_duplicate": "Possível duplicata de empresa {display_name}.",
                "count": {
                    "all": "1 empresa | {count} empresas"
                },
                "notifications": {
                    "assigned": "Você foi atribuído a empresa {name} por {user}"
                },
                "cards": {
                    "by_source": "Empresas por fonte",
                    "by_day": "Empresas por dia"
                },
                "settings": {
                    "automatically_associate_with_contacts": "Crie e associe automaticamente empresas a contatos",
                    "automatically_associate_with_contacts_info": "Associe automaticamente contatos a empresas com base em um endereço de e-mail de contato e um domínio da empresa."
                },
                "industry": {
                    "industries": "Indústrias",
                    "industry": "Indústria"
                },
                "filters": {
                    "my": "Minhas Empresas",
                    "my_recently_assigned": "Minhas Empresas Recentemente Designadas"
                },
                "mail_placeholders": {
                    "assigneer": "O nome de usuário que atribuiu a empresa"
                },
                "workflows": {
                    "triggers": {
                        "created": "Empresa Criada"
                    },
                    "actions": {
                        "fields": {
                            "email_to_company": "E-mail da empresa",
                            "email_to_owner_email": "E-mail do proprietário da empresa",
                            "email_to_creator_email": "E-mail do criador da empresa",
                            "email_to_contact": "Contato principal da empresa"
                        }
                    }
                },
                "validation": {
                    "email": {
                        "unique": "Já existe uma empresa com este e-mail."
                    }
                },
                "empty_state": {
                    "title": "Você não criou nenhuma empresa.",
                    "description": "Comece criando uma nova empresa."
                },
                "timeline": {
                    "deleted": "A empresa foi excluída por {causer}",
                    "restored": "A empresa foi restaurada da lixeira por {causer}",
                    "created": "A empresa foi criada por {causer}",
                    "updated": "A empresa foi atualizada por {causer}",
                    "attached": "Empresa associada a {user}",
                    "detached": "Empresa dissociada de {user}",
                    "associate_trashed": "O {companyName} associado da empresa foi movido para a lixeira por {user}"
                }
            },
            "contact": {
                "contact": "Contato",
                "contacts": "Contatos",
                "convert": "Converter para Contato",
                "create": "Criar Contato",
                "add": "Adicionar Contato",
                "total": "Total de Contatos",
                "import": "Importar Contatos",
                "export": "Exportar Contatos",
                "no_companies_associated": "O contato não possui empresas associadas.",
                "no_deals_associated": "O contato não tem negócios associados.",
                "works_at": "{job_title} na {company}",
                "create_with": "Criar contato com {name}",
                "associate_with": "Associar contato com {name}",
                "associated_company": "Empresa de contato associada",
                "dissociate": "Dissociar contato",
                "exists_in_trash_by_email": "O contato com este endereço de e-mail já existe na lixeira, você não poderá criar um novo contato com o mesmo endereço de e-mail, gostaria de restaurar o contato na lixeira?",
                "exists_in_trash_by_phone": "Contact ({contact}) with the following numbers: {phone_numbers}, already exists in the trash, would you like to restore the trashed contact?",
                "possible_duplicate": "Possível duplicata de contato {display_name}.",
                "associate_field_info": "Use este campo para localizar e associar um contato existente em vez de criar um novo.",
                "cards": {
                    "recently_created": "Contatos criados recentemente",
                    "recently_created_info": "Mostrando os últimos {total} de contatos criados nos últimos {days} dias, classificados por mais novos no topo.",
                    "by_day": "Contatos por dia",
                    "by_source": "Contatos por fonte"
                },
                "count": {
                    "all": "1 contato | {count} contatos"
                },
                "notifications": {
                    "assigned": "Você foi atribuído ao contato {name} por {user}"
                },
                "filters": {
                    "my": "Meus Contatos",
                    "my_recently_assigned": "Meus Contatos Recentemente Atribuídos"
                },
                "mail_placeholders": {
                    "assigneer": "O nome de usuário que atribuiu o contato"
                },
                "workflows": {
                    "triggers": {
                        "created": "Contato Criado"
                    },
                    "actions": {
                        "fields": {
                            "email_to_contact": "E-mail do Contato",
                            "email_to_owner_email": "Contato de e-mail do proprietário",
                            "email_to_creator_email": "Contato de e-mail do criador",
                            "email_to_company": "Empresa principal do contato"
                        }
                    }
                },
                "validation": {
                    "email": {
                        "unique": "Já existe um contato ou membro da equipe com este e-mail."
                    },
                    "phone": {
                        "unique": "Já existe um contato com este número de telefone."
                    }
                },
                "empty_state": {
                    "title": "Você não criou nenhum contato.",
                    "description": "Comece a organizar as pessoas agora."
                },
                "timeline": {
                    "deleted": "O contato foi deletado por {causer}",
                    "restored": "O contato foi restaurado da lixeira por {causer}",
                    "created": "O contato foi criado por {causer}",
                    "updated": "O contato foi atualizado por {causer}",
                    "imported_via_calendar_attendee": "Contato importado via calendário de {user} porque foi adicionado como participante de um evento.",
                    "attached": "{user} associou um contato",
                    "detached": "{user} dissociou um contato",
                    "associate_trashed": "O contato {contactName} associado foi movido para a lixeira por {user}"
                }
            },
            "fields": {
                "phone": {
                    "add": "+ Adicionar outro",
                    "copied": "Número de telefone copiado para a área de transferência",
                    "types": {
                        "type": "Tipo",
                        "mobile": "Móvel",
                        "work": "Trabalho",
                        "other": "Outro"
                    }
                },
                "contacts": {
                    "first_name": "Primeiro nome",
                    "last_name": "Sobrenome",
                    "email": "Endereço de E-mail",
                    "job_title": "Nome do trabalho",
                    "phone": "Telefone",
                    "street": "Endereço da Rua",
                    "city": "Cidade",
                    "state": "Estado/Região",
                    "postal_code": "Código postal",
                    "owner_assigned_date": "Data de Atribuição do Proprietário",
                    "country": {
                        "name": "País"
                    },
                    "source": {
                        "name": "Fonte"
                    },
                    "user": {
                        "name": "Proprietário"
                    }
                },
                "companies": {
                    "name": "Nome",
                    "email": "Endereço de e-mail",
                    "parent": {
                        "name": "Empresa Matriz"
                    },
                    "phone": "Telefone",
                    "street": "Endereço da Rua",
                    "city": "Cidade",
                    "state": "Estado/Região",
                    "postal_code": "Código postal",
                    "domain": "Nome de domínio da empresa",
                    "owner_assigned_date": "Data de Atribuição do Proprietário",
                    "country": {
                        "name": "País"
                    },
                    "industry": {
                        "name": "Indústria"
                    },
                    "user": {
                        "name": "Proprietário"
                    },
                    "source": {
                        "name": "Fonte"
                    }
                }
            },
            "source": {
                "source": "Fonte",
                "sources": "Fontes",
                "delete_primary_warning": "Você não pode excluir a fonte principal."
            }
        },
        "deals": {
            "board": {
                "board": "Quadro",
                "columns_sorted": "Columns successfully sorted",
                "sort_by": "Ordem do Quadro"
            },
            "deal": {
                "deal": "Negócio",
                "deals": "Negócios",
                "create": "Criar Negócio",
                "add": "Adicionar Negócio",
                "sort_by": "Ordenar negócios por",
                "name": "Nome do Negócio",
                "choose_or_create": "Escolha ou crie um negócio",
                "associate_with": "Associar negócio com {name}",
                "add_products": "Adicionar produtos",
                "dont_add_products": "Não adicionar produtos",
                "reopen": "Reabrir",
                "won_date": "Data do Ganho",
                "lost_date": "Data da Perda",
                "status_related_filter_notice": "Esta regra é aplicável principalmente ao filtrar negócios com o status \"{status}\".",
                "status": {
                    "status": "Status",
                    "won": "Ganho",
                    "lost": "Perdido",
                    "open": "Aberto"
                },
                "been_in_stage_time": "Esteve aqui por {time}",
                "hasnt_been_in_stage": "Este negócio ainda não está nesta fase",
                "total_created": "Total Criado",
                "total_assigned": "Total Associado",
                "import": "Importar Negócios",
                "export": "Exportar Negócios",
                "import_in": "Importar Negócios em {pipeline}",
                "total": "Total de Negócios",
                "closed_deals": "Negócios Fechados",
                "won_deals": "Negócios Ganhos",
                "open_deals": "Negócios Abertos",
                "lost_deals": "Negócios Perdidos",
                "forecast_amount": "Valor Previsto",
                "closed_amount": "Valor Fechado",
                "dissociate": "Acordo Dissociado",
                "no_companies_associated": "O negócio não tem empresas associadas.",
                "no_contacts_associated": "O negócio não tem contatos associados.",
                "associate_field_info": "Use este campo para associar um negócio existente em vez de criar um novo.",
                "create_with": "Criar Negócio com {name}",
                "already_associated": "Este negócio já está associado a {with}.",
                "lost_reasons": {
                    "lost_reason": "Motivo da Perda",
                    "lost_reasons": "Motivos da Perda",
                    "name": "Nome",
                    "choose_lost_reason": "Escolha um motivo da perda",
                    "choose_lost_reason_or_enter": "Escolha um motivo da perda ou insira manualmente"
                },
                "settings": {
                    "lost_reason_is_required": "O motivo da perda é obrigatório",
                    "lost_reason_is_required_info": "Quando ativado, os agentes de vendas deverão escolher ou inserir o motivo da perda ao marcar o negócio como perdido.",
                    "allow_lost_reason_enter": "Permitir que os agentes de vendas insiram o motivo de perda personalizado",
                    "allow_lost_reason_enter_info": "Quando desativado, os agentes de vendas poderão escolher apenas na lista predefinida de motivos de perda ao marcar o negócio como perdido."
                },
                "cards": {
                    "by_stage": "Negócios por etapa",
                    "lost_in_stage": "Etapa de negócios perdidos",
                    "lost_in_stage_info": "Veja em que estágio os negócios estão mais perdidos. As etapas mostradas nos relatórios são as etapas a que o negócio pertencia no momento em que foi marcado como perdido.",
                    "won_in_stage": "Etapa de negócios ganhos",
                    "won_in_stage_info": "Veja em que estágio os negócios são mais fechados. As etapas mostradas nos relatórios são as etapas às quais o negócio pertencia no momento em que foi marcado como ganho.",
                    "closing": "Fechando negócios",
                    "closing_info": "Veja os negócios que estão previstos para serem fechados com base no período selecionado e na data de fechamento esperada, os negócios marcados como \"ganhos\" ou \"perdidos\" são excluídos da lista.",
                    "recently_created": "Ofertas criadas recentemente",
                    "recently_modified": "Ofertas modificadas recentemente",
                    "won_by_revenue_by_month": "Receita de negócios ganhos por mês",
                    "won_by_date": "Negócios ganhos por dia",
                    "assigned_by_sale_agent": "Negócios atribuídos por agente de vendas",
                    "assigned_by_sale_agent_info": "Visualize o número total de negócios atribuídos a cada representante de vendas. Veja quanta receita esses negócios provavelmente trarão para sua empresa. E quanta receita você já tem de negócios fechados.",
                    "created_by_sale_agent": "Negócios criados por agente de vendas",
                    "created_by_sale_agent_info": "Veja quais representantes de vendas estão criando mais negócios. Veja quanta receita esses negócios provavelmente trarão para sua empresa. E quanta receita você já tem de negócios fechados.",
                    "recently_created_info": "Mostrando os últimos {total} negócios criados nos últimos {days} dias, classificados pelos mais novos no topo.",
                    "recently_modified_info": "Mostrando os últimos {total} negócios modificados nos últimos {days} dias.",
                    "won_by_month": "Negócios ganhos por mês"
                },
                "notifications": {
                    "assigned": "Você foi atribuído ao negócio {name} por {user}"
                },
                "stage": {
                    "weighted_value": "{weighted_total} - {win_probability} de {total}",
                    "changed_date": "Data de Mudança da Etapa",
                    "add": "Adicionar Nova Etapa",
                    "name": "Nome da Etapa",
                    "win_probability": "Probabilidade de Ganhar",
                    "delete_usage_warning": "O estágio já está associado a negócios, portanto, não pode ser excluído."
                },
                "deal_amount": "Valor do negócio",
                "deal_expected_close_date": "Data prevista para fechamento do negócio",
                "count": {
                    "all": "1 negócio | {count} negócios",
                    "open": "{resource} contagem de negócios abertos",
                    "won": "{resource} contagem de negócios ganhos",
                    "lost": "{resource} contagem de negócios perdidos",
                    "closed": "{resource} contagem de negócios fechados"
                },
                "pipeline": {
                    "name": "Nome da Pipeline",
                    "pipeline": "Pipeline",
                    "pipelines": "Pipelines",
                    "create": "Criar Pipeline",
                    "edit": "Editar Pipeline",
                    "updated": "Pipeline atualizado com sucesso",
                    "deleted": "Pipeline excluído com sucesso",
                    "delete_primary_warning": "Você não pode excluir o pipeline primário.",
                    "delete_usage_warning_deals": "O pipeline já está associado a negócios, portanto, não pode ser excluído.",
                    "visibility_group": {
                        "primary_restrictions": "Este é o pipeline principal, portanto, a visibilidade não pode ser alterada."
                    },
                    "reorder": "Reordenar pipelines",
                    "missing_stages": "The pipeline does not have any stages.",
                    "remember_sorting_info": "A classificação será lembrada para o pipeline {name}.",
                    "previous_remember_sorting_note": "Observe que suas opções de classificação lembradas anteriormente para o pipeline {name} serão substituídas."
                },
                "actions": {
                    "change_stage": "Mudar Etapa",
                    "mark_as_open": "Marcar como aberto",
                    "mark_as_won": "Marcar como ganho",
                    "mark_as_lost": "Marcar como perdido"
                },
                "filters": {
                    "my": "Meus Negócios",
                    "my_recently_assigned": "Meus Negócios Recentemente Atribuídos",
                    "created_this_month": "Negócios Criados Este Mês",
                    "won": "Negócios Ganhos",
                    "lost": "Negócios Perdidos",
                    "open": "Negócios Abertos"
                },
                "mail_placeholders": {
                    "assigneer": "O nome do usuário que atribuiu o negócio"
                },
                "workflows": {
                    "triggers": {
                        "status_changed": "Status do Negócio Alterado",
                        "stage_changed": "Etapa do Negócio Alterada",
                        "created": "Negócio Criado"
                    },
                    "actions": {
                        "mark_associated_activities_as_complete": "Marcar Atividades Associadas Como Concluídas",
                        "mark_associated_deals_as_won": "Marcar Negócios Associados Como Ganhos",
                        "mark_associated_deals_as_lost": "Marcar Negócios Associados Como Perdidos",
                        "delete_associated_activities": "Excluir Atividades Associadas",
                        "fields": {
                            "email_to_contact": "Contato primário do negócio",
                            "email_to_company": "Empresa primária do negócio",
                            "email_to_owner_email": "E-mail do proprietário do negócio",
                            "email_to_creator_email": "E-mail do criador do negócio",
                            "lost_reason": "Com a seguinte razão da perda"
                        }
                    }
                },
                "timeline": {
                    "stage": {
                        "moved": "{user} moveu o negócio da etapa {previous} para {stage}"
                    },
                    "marked_as_lost": "{user} marcou o negócio com perdido pelo seguinte motivo: {reason}",
                    "marked_as_won": "{user} marcou o negócio como ganho",
                    "marked_as_open": "{user} marcou o negócio como aberto",
                    "deleted": "O negócio foi excluído por {causer}",
                    "restored": "O negócio foi restaurado da lixeira por {causer}",
                    "created": "Negócio foi criado por {causer}",
                    "updated": "Negócio foi atualizado por {causer}",
                    "attached": "Negócio associado a {user}",
                    "detached": "Negócio dissociado de {user}",
                    "associate_trashed": "O negócio {dealName} associado foi movido para a lixeira por {user}"
                },
                "metrics": {
                    "open": "Negócios Abertos"
                },
                "empty_state": {
                    "title": "Você não criou nenhum negócio.",
                    "description": "Comece criando um novo negócio."
                }
            },
            "fields": {
                "deals": {
                    "name": "Nome do negócio",
                    "expected_close_date": "Data prevista de fechamento",
                    "amount": "Quantia",
                    "owner_assigned_date": "Data de Atribuição do Proprietário",
                    "user": {
                        "name": "Proprietário"
                    },
                    "stage": {
                        "name": "Estágio"
                    },
                    "pipeline": {
                        "name": "Pipeline"
                    }
                }
            }
        },
        "documents": {
            "document": {
                "document": "Documento",
                "documents": "Documentos",
                "create": "Criar Documento",
                "info": "Envie cotações, propostas e contratos personalizáveis para fechar negócios mais rapidamente.",
                "view": "Ver",
                "manage_documents": "Gerenciar Documentos",
                "total_documents": "Total de Documentos",
                "total_draft_documents": "Total de Rascunhos de Documentos",
                "deleted": "Documento excluído com sucesso",
                "document_details": "Detalhes do Documento",
                "document_activity": "Atividade do Documento",
                "document_products": "Produtos do Documento",
                "download_pdf": "PDF",
                "view_pdf": "Ver PDF no Navegador",
                "accept": "Aceitar",
                "sign": "Assinar",
                "sent": "Documento envado com sucesso",
                "deal_description": "Quando o negócio é selecionado, o negócio será automaticamente associado ao documento, os contatos do negócio serão adicionados como signatários e todos os produtos do negócio serão adicionados ao documento.",
                "settings": {
                    "inherits_setting_from_brand": "Inherits from brand"
                },
                "products_snippet_missing": "To ensure that the products appear in the document preview and PDF, make sure to add them to the content via the {icon} icon.",
                "signatures_snippet_missing": "To ensure that the signatures appear in the document PDF, make sure to add them to the content via the {icon} icon.",
                "will_use_placeholders_from_record": "The placeholders added in the document content related to the {resourceName} resource will be taken form this record",
                "placeholders_replacement_info": "The placeholders of the document related to resources are replaced based on the first associated record, make sure to add associations to the document.",
                "limited_editing": "Este documento está aceito, as habilidades de edição são limitadas.",
                "title": "Título",
                "copy_url": "Copiar URL público do documento",
                "url_copied": "URL copiado para a área de transferência",
                "count": {
                    "all": "1 documento | {count} documentos"
                },
                "sections": {
                    "details": "Detalhes",
                    "send": "Enviar",
                    "signature": "Assinatura",
                    "content": "Conteúdo",
                    "products": "Produtos"
                },
                "status": {
                    "status": "Status",
                    "draft": "Rascunho",
                    "sent": "Enviado",
                    "accepted": "Aceito",
                    "lost": "Perdido"
                },
                "send": {
                    "select_brand": "Selecione primeiro uma marca para enviar o documento.",
                    "connect_an_email_account": "Conecte uma conta de e-mail para enviar documentos.",
                    "send_from_account": "Envie o documento da seguinte conta",
                    "save_to_schedule": "Para agendar o envio do documento, você precisará primeiro salvar o documento",
                    "send_subject": "Assunto da Mensagem",
                    "send_body": "Texto da Mensagem",
                    "send_later": "Enviar depois?",
                    "send": "Enviar Documento",
                    "select_schedule_date": "Selecione data e hora",
                    "schedule": "Agendar",
                    "is_scheduled": "Este documento está programado para ser enviado em {date}",
                    "send_to_signers": "Envie o documento para os seguintes signatários",
                    "send_to_signers_empty": "Para enviar o documento aos signatários, adicione os signatários na seção \"Assinatura\"."
                },
                "sent_by": "Enviado por",
                "sent_at": "Enviado em {date}",
                "signers": {
                    "add": "Adicionar novo signatário",
                    "no_signers": "Nenhum signatário, adicione signatários para este documento.",
                    "is_signed": "Assinou?",
                    "document_signers": "Assinantes do Documento",
                    "signer_name": "Nome",
                    "signer_email": "Endereço de e-mail",
                    "signature_date": "Data",
                    "name": "Nome do signatário",
                    "email": "E-mail do signatário",
                    "enter_full_name": "Digite o nome completo do signatário",
                    "enter_email": "Por favor, indique o seu endereço de e-mail",
                    "confirm_email": "Confirme seu endereço de e-mail"
                },
                "accepted_at": "Aceito em",
                "signature": {
                    "no_signature": "Sem Assinatura",
                    "no_signature_description": "Este documento não requer uma assinatura antes da aceitação.",
                    "e_signature": "Usar assinatura eletrônica",
                    "e_signature_description": "Este documento requer assinatura eletrônica antes da aceitação.",
                    "signature": "Assinatura",
                    "signatures": "Assinaturas",
                    "signed_on": "Assinado em",
                    "sign_ip": "Endereço IP",
                    "verification_failed": "Não foi possível verificar seu endereço de e-mail como signatário, entre em contato com a pessoa que lhe enviou o documento para fornecer informações sobre o endereço de e-mail usado.",
                    "accept_name": "Para aceitar, digite seu nome abaixo"
                },
                "reactivated": "Documento reativado",
                "marked_as_lost": "Documento marcado com sucesso como perdido",
                "marked_as_accepted": "Documento marcado com sucesso como aceito",
                "actions": {
                    "mark_as_lost": "Marcar como Perdido",
                    "mark_as_lost_message": "Esta ação marcará este documento como perdido e nenhum dos destinatários não poderá mais acessá-lo",
                    "mark_as_accepted": "Marcar como Aceito",
                    "reactivate": "Reativar",
                    "undo_acceptance": "Desfazer aceitação"
                },
                "cards": {
                    "by_type": "Documentos por tipo",
                    "by_status": "Documentos por status",
                    "sent_by_day": "Documentos enviados por dia"
                },
                "recipients": {
                    "add": "Adicionar novo destinatário",
                    "enter_full_name": "Digite o nome completo do destinatário",
                    "enter_email": "Digite o endereço de e-mail do destinatário",
                    "no_recipients": "Nenhum destinatário para enviar ao documento.",
                    "is_sent": "Enviado?",
                    "recipients": "Destinatários",
                    "additional_recipients": "Additional recipients",
                    "recipient_name": "Nome",
                    "recipient_email": "Endereço de e-mail",
                    "name": "Nome do Destinatário",
                    "email": "E-mail do Destinatário"
                },
                "view_type": {
                    "html_view_type": "Tipo de visualização HTML",
                    "template_info": "Quando um modelo tiver um tipo de visão, depois de inserido, o tipo de visão do documento será atualizado com o tipo de modelo.",
                    "nav_top": {
                        "name": "Navegação no Topo",
                        "description": "Útil para documentos simples que não requerem navegação por títulos."
                    },
                    "nav_left": {
                        "name": "Navegação Esquerda",
                        "description": "Útil para documentos que requerem navegação por cabeçalhos ({headingTagName})."
                    },
                    "nav_left_full_width": {
                        "name": "Navegação Esquerda - Largura Total",
                        "description": "A seção de conteúdo não tem margem, útil para documentos de largura total com cabeçalhos ({headingTagName})."
                    }
                },
                "type": {
                    "type": "Tipo de Documento",
                    "types": "Tipo de Documento",
                    "name": "Nome",
                    "default_type": "Tipo de Documento Padrão",
                    "delete_primary_warning": "Você não pode excluir o tipo de documento principal.",
                    "delete_usage_warning": "O tipo já está associado a documentos, portanto, não pode ser excluído.",
                    "delete_is_default": "Este é um tipo de documento padrão, portanto, não pode ser excluído.",
                    "cannot_change_visibility_on_default": "Este é um tipo padrão para toda a empresa, portanto, a visibilidade não pode ser alterada."
                },
                "template": {
                    "insert_template": "Inserir Modelo",
                    "save_as_template": "Salvar como Modelo",
                    "manage": "Gerenciar Modelos",
                    "template": "Modelo de Documento",
                    "templates": "Modelos de Documento",
                    "create": "Criar Modelo",
                    "name": "Nome do Modelo",
                    "deleted": "Modelo excluído com sucesso",
                    "share_with_team_members": "Compartilhar este modelo com outros membros da equipe?",
                    "is_shared": "Compartilhado",
                    "empty_state": {
                        "title": "Você não criou nenhum modelo.",
                        "description": "Crie documentos mais rápido usando modelos predefinidos."
                    }
                },
                "workflows": {
                    "triggers": {
                        "status_changed": "Status do Documento Alterado"
                    },
                    "actions": {
                        "fields": {
                            "email_to_contact": "Contato principal do documento",
                            "email_to_company": "Empresa principal do documento",
                            "email_to_owner_email": "E-mail do proprietário do documento",
                            "email_to_creator_email": "E-mail do criador do documento"
                        }
                    }
                },
                "timeline": {
                    "heading": "Documento Criado"
                },
                "mail_placeholders": {
                    "assigneer": "O nome de usuário que atribuiu o documento"
                },
                "notifications": {
                    "signed": "O documento {title} foi assinado",
                    "assigned": "Você foi atribuído ao documento {title} por {user}",
                    "accepted": "O documento {title} foi aceito",
                    "viewed": "O documento {title} foi visualizado"
                },
                "filters": {
                    "status_disabled": "O status é usado no filtro atual, portanto, você não pode selecionar o status nesta seção"
                },
                "activity": {
                    "created": "O documento foi criado por {user}",
                    "sent": "O documento foi enviado por {user}",
                    "marked_as_lost": "{user} marcou o documento como perdido",
                    "marked_as_accepted": "{user} marcou o documento como aceito",
                    "marked_as_draft": "{user} marcou o documento como rascunho",
                    "sent_recipient": "{name} - {email}",
                    "signed": "O documento assinado por {signer_name}",
                    "accepted": "O documento foi aceito",
                    "viewed": "O documento foi visualizado",
                    "downloaded": "O documento PDF foi baixado"
                },
                "empty_state": {
                    "title": "Você não criou nenhum documento.",
                    "description": "Feche negócios mais rápido enviando documentos rastreáveis bem apresentados."
                },
                "export": "Exportar Documentos"
            },
            "fields": {
                "documents": {
                    "title": "Título do documento",
                    "owner_assigned_date": "Data de Atribuição do Proprietário",
                    "accepted_at": "Aceito em",
                    "amount": "Quantia",
                    "original_date_sent": "Data original de envio",
                    "last_date_sent": "Última data de envio",
                    "brand": {
                        "name": "Marca"
                    },
                    "user": {
                        "name": "Proprietária"
                    },
                    "type": {
                        "name": "Tipo"
                    }
                }
            },
            "pdf": {
                "default_font": "Default font family",
                "default_font_info": "The {fontName} font gives the most decent Unicode character coverage by default, make sure to select a proper font if special or unicode characters are not displayed properly on the PDF document.",
                "size": "Size",
                "orientation": "Orientation",
                "orientation_portrait": "Portrait",
                "orientation_landscape": "Landspace",
                "settings": "PDF Settings",
                "padding": "PDF padding",
                "no_padding": "No additional padding"
            }
        },
        "mailclient": {
            "inbox": {
                "inbox": "Caixa de entrada",
                "shared": "Caixa de entrada compartilhada",
                "new_message": "Nova mensagem",
                "trash": "Mover para a lixeira",
                "move_to": "Mover para",
                "forward": "Encaminhar",
                "reply": "Responder",
                "reply_all": "Responder a todos",
                "reply_to_message": "Responder para {subject}",
                "forward_message": "Encaminhar {subject}",
                "forwarded_message_placeholder": "{pre} Mensagem encaminhada {after}<br />\n                                        De: {from}<br />\n                                        Data: {date}<br />\n                                        Assunto: {subject}<br />\n                                        Para: {to}",
                "message_sent": "Mensagem enviada com sucesso.",
                "search_recipients": "Pesquisar ou digitar um endereço de email...",
                "send": "Enviar",
                "sync_in_progress": "O sistema está sincronizando as contas em segundo plano, tente novamente mais tarde.",
                "synchronize": "Sincronizar",
                "subject": "Assunto",
                "no_subject": "Sem assunto",
                "unknown_address": "Desconhecido",
                "from": "De",
                "to": "Para",
                "cc": "Cc",
                "bcc": "Cco",
                "reply_to": "Responder para",
                "date": "Data",
                "unread_count": "Total de emails não lidos",
                "pre_send_empty_placeholders_found": "You are about to send an email with empty placeholders. Before proceeding, please confirm that you really want to proceed with this action.",
                "will_use_placeholders_from_record": "The placeholders added in the message content related to the {resourceName} resource will be taken form this record",
                "filters": {
                    "is_read": "Lido"
                }
            },
            "mail": {
                "compose": "Compor",
                "attachments": "Anexos",
                "emails": "E-mails",
                "create": "Criar E-mail",
                "send": "Enviar E-mail",
                "view": "Ver E-mail",
                "from_header": "Cabeçalho De",
                "from_name": "Nome De",
                "messages": "Mensagens de correio",
                "message": "Mensagem de correio",
                "new_message_placeholder": "Compose your email here. Type \"{trigger}\" to search dynamic fields.",
                "signature": "Assinatura de E-mail",
                "signature_info": "Crie uma assinatura que será adicionada ao final de suas mensagens.",
                "show_quoted_content": "Mostrar conteúdo citado",
                "trimmed_content": "Conteúdo Cortado",
                "disable_sync": "Desativar Sincronização",
                "manage_emails": "Gerenciar E-mails",
                "info": "Você pode enviar e responder e-mails diretamente através desta seção.",
                "from_header_info": "O que as pessoas verão no \"endereço do remetente\" quando receberem um e-mail deste endereço de e-mail.",
                "placeholders_info": "Use espaços reservados {placeholders} para substituir dinamicamente o conteúdo como nome da empresa, nome do agente (usuário que envia o e-mail).",
                "mark_as_read": "Marcar como Lido",
                "mark_as_unread": "Marcar como Não Lido",
                "message_queued_for_sending": "A mensagem foi colocada na fila para envio e será sincronizada no próximo lote de sincronização.",
                "initial_sync_info": "Esta conta está na fila para sincronização inicial e a sincronização será realizada assim que o cron job for executado, para evitar interrupções de sincronização, certifique-se de ter configurado o cron job conforme explicado na documentação.",
                "account": {
                    "create_contact": "Criar registro de Contato se o registro não existir.",
                    "use_aliass": "Use alias email address",
                    "use_aliass_info": "The address needs to be a valid alias that already exists in the mail server, useful when using Google Workspace aliases.",
                    "enter_alias": "Alias E-Mail Address",
                    "personal": "Pessoal",
                    "shared": "Compartilhada",
                    "accounts": "Contas de E-mail",
                    "sync_emails_from": "Sincronizar e-mails de",
                    "sync_period_now": "Agora",
                    "sync_period_1_month_ago": "1 mês atrás",
                    "sync_period_3_months_ago": "3 meses atrás",
                    "sync_period_6_months_ago": "6 meses atrás",
                    "sync_period_note": "Na maioria dos casos, você não precisará interagir com todos os e-mails de {date}, um período de sincronização inicial mais baixo evitará a importação de centenas de e-mails com anexos e ajudará a economizar espaço de armazenamento. Sempre é recomendável escolher um período de sincronização inicial mais baixo.",
                    "integration_not_configured": "Não há contas de e-mail configuradas, configure contas de e-mail pessoais ou compartilhadas para enviar e-mails.",
                    "already_connected": "Esta conta de e-mail já está conectada.",
                    "select_type": "Selecione o tipo de conta",
                    "no_active_folders": "Esta conta não tem pastas ativas. Ative as pastas ativas editando a conta de e-mail, as pastas ativas serão as pastas que serão sincronizadas com o aplicativo.",
                    "activate_folders": "Ativar Pastas",
                    "active_folders": "Pastas ativas",
                    "active_folders_info": "Select the folders you wish to synchronize.",
                    "sent_folder": "Pasta de Enviados",
                    "trash_folder": "Pasta da Lixeira",
                    "test_connection": "Testar Conexão",
                    "is_primary": "Conta Primária",
                    "connection_error": "Erro de teste de conexão, verifique sua configuração, consulte o erro para obter mais informações: {mensagem}",
                    "create": "Editar conta de e-mail",
                    "edit": "Editar Conta de E-mail",
                    "manage": "Gerenciar Contas",
                    "connect": "Conectar Conta",
                    "connect_shared": "Conectar Conta Compartilhada",
                    "connect_personal": "Conectar Conta Pessoal",
                    "created": "Conta de e-mail adicionada com sucesso.",
                    "updated": "Conta de e-mail atualizada com sucesso.",
                    "deleted": "Conta de e-mail excluída com sucesso",
                    "no_accounts_configured": "Nenhuma conta de e-mail configurada",
                    "no_accounts_configured_info": "Conecte uma conta para começar a enviar e organizar e-mails para fechar negócios mais rapidamente",
                    "create_shared_info": "Conecte uma conta de e-mail da empresa, como contato{'@'}empresa.com.br ou vendas{'@'}empresa.com.br",
                    "create_shared_confirmation_message": "Ao conectar uma conta de e-mail compartilhada, esteja ciente de que as contas de e-mail compartilhadas podem ser acessadas por todos os membros da equipe que receberam \"acesso à caixa de entrada compartilhada\".\nIsso significa que cada membro da equipe poderá visualizar e interagir com os e-mails.",
                    "missing_sent_folder": "Action required, select the sent folder for this account.",
                    "missing_trash_folder": "Action required, select the trash folder for this account.",
                    "missing_primary_account": "Action required, configure a primary account for sending emails.",
                    "type": "Tipo de Conta",
                    "email_address": "Endereço de e-mail",
                    "password": "Senha",
                    "username": "Nome de usuário",
                    "incoming_mail": "Recebimento de E-mail (IMAP)",
                    "outgoing_mail": "Envio de E-mail (SMTP)",
                    "server": "Servidor",
                    "port": "Porta",
                    "allow_non_secure_certificate": "Permitir certificado não seguro",
                    "encryption": "Criptografia",
                    "without_encryption": "Sem Criptografia",
                    "delete_warning": "Se você estiver usando esta conta de e-mail como \"Conta de e-mail do sistema\" nas configurações, será necessário selecionar outra conta para enviar e-mails relacionados ao sistema, além disso, você precisará verificar seus fluxos de trabalho, se algum fluxo de trabalho estiver configurado para usar a ação \"Enviar E-mail\" com esta conta de e-mail específica, você precisará atualizar a conta de ação para que o fluxo de trabalho continue enviando e-mails.",
                    "featured": {
                        "sync": "Sincronização de e-mail bidirecional com seu provedor de e-mail.",
                        "save_time": "Economize tempo fazendo uso de modelos predefinidos.",
                        "placeholders": "Componha e-mails e modelos com espaços reservados.",
                        "signature": "Adicione assinatura personalizada para uma aparência mais profissional.",
                        "associations": "Associe e-mails a muitos {resources} e {resource}.",
                        "types": "Conecte-se via IMAP, sua conta do Gmail ou Outlook."
                    }
                },
                "templates": {
                    "select": "Selecione",
                    "create": "Criar Modelo",
                    "name": "Nome",
                    "subject": "Assunto",
                    "is_shared": "Compartilhar este modelo com outros membros da equipe?",
                    "body": "Corpo",
                    "templates": "Modelos",
                    "created": "Modelo de e-mail criado com sucesso.",
                    "updated": "Modelo de e-mail atualizado com sucesso.",
                    "deleted": "Modelo de e-mail excluído com sucesso"
                },
                "labels": {
                    "CATEGORY_PERSONAL": "Pessoal",
                    "CATEGORY_SOCIAL": "Compartilhada",
                    "CATEGORY_FORUMS": "Fóruns",
                    "IMPORTANT": "Importante",
                    "CATEGORY_UPDATES": "Atualizações",
                    "CATEGORY_PROMOTIONS": "Promoções",
                    "CHAT": "Chat",
                    "SENT": "Enviados",
                    "INBOX": "Inbox",
                    "TRASH": "Lixeira",
                    "DRAFT": "Rascunho",
                    "DRAFTS": "Rascunhos",
                    "SPAM": "Spam",
                    "STARRED": "Marcados",
                    "UNREAD": "Não Lidos"
                },
                "workflows": {
                    "actions": {
                        "send": "Enviar E-mail"
                    },
                    "fields": {
                        "from_account": "Da conta de e-mail",
                        "subject": "Com assunto",
                        "message": "Com mensagem",
                        "to": "Para",
                        "send_from_owner_primary_account": "Owner Primary Email Account"
                    }
                },
                "validation": {
                    "invalid_recipients": "Parece que alguns de seus destinatários têm endereços inválidos."
                }
            },
            "schedule": {
                "send_later": "Send Later",
                "choose_date": "Choose date",
                "schedule": "Schedule",
                "scheduled_emails": "Scheduled Emails",
                "cancel_and_delete": "Cancel and delete",
                "message_scheduled": "The message was scheduled to be sent later",
                "will_retry_at": "Will retry at: {date}",
                "send_now": "Send Now",
                "scheduled_at": "Date Scheduled",
                "sent_at": "Date Sent",
                "scheduled_by": "Scheduled By",
                "status": "Status",
                "statuses": {
                    "pending": "Pending",
                    "sent": "Sent",
                    "sending": "Sending",
                    "failed": "Failed"
                }
            }
        },
        "notes": {
            "note": {
                "notes": "Notas",
                "note": "Nota",
                "add": "Adicionar Nota",
                "create_notes": "Criar Notas",
                "manage_notes": "Gerenciar Notas",
                "info": "Você pode criar notas para você e sua equipe e acompanhar informações importantes aqui.",
                "info_created": "{user} deixou uma nota em {date}",
                "follow_up_task_body": "Sobre uma nota: {content}",
                "write": "Escreva uma nota...",
                "created": "Nota criada com sucesso",
                "updated": "Nota atualizada com sucesso",
                "deleted": "Nota excluída com sucesso",
                "timeline": {
                    "heading": "Uma nova nota foi criada"
                }
            }
        },
        "themestyle": {
            "style": {
                "theme_style": "Estilo do Tema",
                "lightness_maximum": "Claridade Máxima",
                "lightness_minimum": "Claridade Mínima"
            }
        },
        "translator": {
            "translator": {
                "translator": "Tradutor",
                "new_locale": "Nova localidade",
                "create_new_locale": "Criar nova localidade",
                "locale_name": "Nome do local",
                "group_has_unsaved_translations": "The group has unsaved translations!",
                "changes_not_saved": "Você não salvou as traduções para este grupo. Para evitar perder suas traduções, salve o grupo clicando no botão Salvar localizado na parte inferior da página.",
                "tools": {
                    "json-language": "Gerar arquivos de idioma JSON"
                }
            }
        },
        "users": {
            "profile": {
                "update": "Atualizar Perfil",
                "profile": "Perfil",
                "updated": "Perfil atualizado com sucesso",
                "password_updated": "Senha atualizada com sucesso",
                "avatar_info": "Carregue seu avatar para que os membros da equipe possam reconhecer seu perfil facilmente.",
                "profile_info": "Atualize seu perfil, incluindo a assinatura de e-mail e o endereço de e-mail de login.",
                "localization_info": "Adapte a localização do seu perfil conforme necessário.",
                "notifications_info": "Decida quais comunicações você gostaria de receber e como.",
                "password_info": "Atualize a senha da sua conta, para uma senha mais segura, use o gerador de senhas."
            },
            "team": {
                "teams": "Equipes",
                "team": "Equipe",
                "add": "Adicionar Equipe",
                "create": "Criar Nova Equipe",
                "edit": "Editar Equipe",
                "name": "Nome da Equipe",
                "members": "Membros da Equipe",
                "description": "Descrição da Equipe",
                "owner_team": "Proprietário da Equipe",
                "select": "Selecionar Equipes",
                "manager": "Gerente",
                "your_teams": "Your Team|Your Teams",
                "managing_teams": "All of the teams and people you are managing.",
                "capabilities": {
                    "team_only": "Somente Equipe"
                },
                "empty_state": {
                    "title": "Nenhuma equipe",
                    "description": "Comece criando uma nova equipe."
                }
            },
            "user": {
                "user": "Usuário",
                "users": "Usuários",
                "not_found": "Nenhum usuário encontrado",
                "create": "Criar Usuário",
                "invite": "Convidar Usuário",
                "send_invitation": "Enviar Convite",
                "accept_invitation": "Aceitar Convite",
                "invited": "Convite do usuário enviado",
                "admin_users_excluded": "Usuários administradores estão excluídos",
                "select": "Selecionar usuários",
                "invitation_expires_after_info": "Um e-mail com link de convite será enviado ao usuário para criar uma conta, o link será válido por {total} dias e será invalidado após a criação da conta.",
                "edit": "Editar Usuário",
                "sales_agent": "Vendedor",
                "name": "Nome",
                "email": "Endereço de E-Mail",
                "roles": "Funções de Usuário",
                "localization": "Localização",
                "enable_api": "Ativar Acesso da API",
                "super_admin": "Super Administrador",
                "as_super_admin_info": "Habilitar o acesso de superadministrador para o usuário dará acesso total a todos os recursos sem quaisquer limitações.",
                "allow_api_info": "Permita que o usuário gere tokens de API e use os tokens para fazer solicitações aos endpoints do aplicativo.",
                "assign": "Atribuir",
                "not_authorized": "Sua conta não está autorizada a realizar esta ação.",
                "delete_transfer_to_same_user_warning": "Você não pode transferir os dados para o mesmo usuário.",
                "delete_own_account_warning": "Você não pode excluir sua própria conta.",
                "transfer_data_info": "Os dados deste usuário precisam ser transferidos para outro usuário. Selecione o usuário para onde deseja transferir os dados.",
                "actions": {
                    "delete": "Excluir Usuário"
                },
                "notifications": {
                    "user_mentioned": "Você foi mencionado por {name}"
                }
            }
        },
        "webforms": {
            "form": {
                "forms": "Formulários web",
                "form": "Formulário da Web",
                "created": "Formulário da Web adicionado com sucesso.",
                "updated": "Formulário da Web atualizado com sucesso.",
                "deleted": "Formulário da Web excluído com sucesso.",
                "submission": "Submissão do Formulário da Web",
                "total_submissions": "Submissões: {total}",
                "editor": "Editor",
                "submit_options": "Opções de envio",
                "info": "Crie formulários da web personalizáveis que podem ser incorporados em seu site existente ou compartilhe os formulários como link para criar automaticamente negócios, contatos e empresas.",
                "inactive_info": "Este formulário está inativo. Você pode visualizar o formulário porque está conectado. Se quiser que o formulário seja publicamente disponibilizado, certifique-se de defini-lo como ativo.",
                "create": "Criar Formulário da Web",
                "active": "Ativo",
                "title": "Título",
                "title_visibility_info": "O título não é visível para os visitantes que preencherão o formulário.",
                "fields_action_required": "Ação adicional necessária",
                "required_fields_needed": "Para salvar novos negócios, é necessário adicionar pelo menos o campo de e-mail ou telefone de contato.",
                "must_requires_fields": "Para salvar novos negócios, seu formulário da web deve exigir pelo menos o campo de e-mail ou telefone de contato.",
                "non_optional_fields_required": "Campos não opcionais necessários",
                "notifications": "Notificações",
                "notification_email_placeholder": "Digite o endereço de e-mail",
                "new_notification": "+ Adicionar Email",
                "no_sections": "Este formulário da web não tem seções definidas.",
                "style": {
                    "style": "Estilo",
                    "primary_color": "Cor Primária",
                    "background_color": "Cor de Fundo",
                    "logo": "Exibir um logotipo no topo do formulário."
                },
                "success_page": {
                    "success_page": "Página de Sucesso",
                    "success_page_info": "O que deve acontecer depois que um visitante enviar este formulário?",
                    "thank_you_message": "Exibir mensagem de agradecimento",
                    "redirect": "Redirecionar para outro site",
                    "title": "Título",
                    "title_placeholder": "Digite o texto para a mensagem de sucesso.",
                    "message": "Mensagem",
                    "redirect_url": "URL do site",
                    "redirect_url_placeholder": "Digite a URL para redirecionar após o envio do formulário."
                },
                "saving_preferences": {
                    "saving_preferences": "Salvando preferências",
                    "deal_title_prefix": "Prefixo do título do negócio",
                    "deal_title_prefix_info": "Para cada novo negócio criado por meio do formulário, o nome do negócio será prefixado com o texto adicionado no campo para facilitar o reconhecimento."
                },
                "sections": {
                    "new": "Adicionar nova seção",
                    "type": "Tipo de Seção",
                    "types": {
                        "input_field": "Campo de Entrada",
                        "message": "Mensagem",
                        "file": "Arquivo"
                    },
                    "field": {
                        "resourceName": "Campo para"
                    },
                    "introduction": {
                        "introduction": "Introdução",
                        "title": "Título",
                        "message": "Mensagem"
                    },
                    "message": {
                        "message": "Mensagem"
                    },
                    "file": {
                        "file": "Arquivo",
                        "files": "Arquivos",
                        "multiple": "Permitir upload de múltiplos arquivos?"
                    },
                    "submit": {
                        "button": "Botão de envio",
                        "default_text": "Enviar",
                        "button_text": "Texto do botão",
                        "spam_protected": "Protegido contra spam?",
                        "require_privacy_policy": "Requer consentimento de política de privacidade",
                        "privacy_policy_url": "URL da política de privacidade"
                    },
                    "embed": {
                        "embed": "Incorporar"
                    }
                }
            }
        },
        "core": {
            "actions": {
                "action": "Ação",
                "actions": "Ações",
                "select": "Selecionar Ação",
                "confirmation_message": "Tem certeza de que deseja executar essa ação?",
                "run_successfully": "A ação foi executada com sucesso.",
                "search_in_google": "Buscar no Google",
                "bulk_edit": "Bulk Edit",
                "records_count": "1 registro | {count} registros"
            },
            "api": {
                "api": "API",
                "access": "Acesso API",
                "access_tokens": "Access Tokens",
                "personal_access_tokens": "Tokens de Acesso Pessoal",
                "personal_access_token": "Token de Acesso Pessoal",
                "create_token": "Criar Novo Token",
                "no_tokens": "Você não criou nenhum token de acesso pessoal.",
                "token_name": "Nome",
                "revoke_token": "Revogar",
                "token_last_used": "Usado por Último",
                "after_token_created_info": "Aqui está seu novo token de acesso pessoal. Esta é a única vez que será mostrado, então não perca!\n     Agora você pode usar esse token para fazer solicitações de API.",
                "empty_state": {
                    "description": "Use tokens para fazer solicitações de API fora do aplicativo."
                },
                "token_delete_warning": "Please note that if you delete your API token, it will immediately invalidate the token. This means any external services or code integrations using this token will stop to function. Ensure to remove or replace the token in all your implementations to prevent disruptions."
            },
            "app": {
                "delete": "Excluir",
                "confirm": "Confirmar",
                "cancel": "Cancelar",
                "clear": "Limpar",
                "save": "Salvar",
                "saved": "Salvo.",
                "send": "Enviar",
                "save_and_exit": "Salvar & Sair",
                "exit": "Sair",
                "edit": "Editar",
                "copy": "Copiar",
                "copy_link": "Copy Link",
                "copy_api_key": "Copy API Key",
                "clone": "Duplicar",
                "create": "Criar",
                "change": "Alterar",
                "remove": "Remover",
                "hide": "Ocultar",
                "active": "Ativo",
                "view_details": "Detalhes",
                "system_info": "Informações do Sistema",
                "add_note": "Adicionar Nota",
                "add_another": "Adicionar Outro",
                "is_primary": "Primary",
                "is_default": "Default",
                "note_is_private": "Nota privada",
                "create_and_add_another": "Criar & Adicionar Outro",
                "create_and_go_to_list": "Criar & Ir Para Lista",
                "purchase_key": "Código de Compra",
                "enter_purchase_key": "Insira sua chave de compra",
                "privacy_policy": "Política de Privacidade",
                "copied": "Texto copiado para área de transferência",
                "insert_new_line": "Inserir nova linha",
                "reset": "Redefinir",
                "optional": "Opcional",
                "not_enough_data": "Não há dados o suficiente para mostrar",
                "no_search_results": "Não há resultados correspondentes aos seus critérios de pesquisa",
                "recent_search_history": "Recent Search History",
                "discard_changes": "Descartar Mudanças",
                "agree_to_privacy_policy": "Ao usar este formulário, você concorda com o armazenamento e manuseio de seus dados por este site de acordo com nosso {privacyPolicyLink}",
                "id": "ID",
                "deleted_at": "Excluído Em",
                "apply": "Aplicar",
                "reload": "Recarregar",
                "loading": "Carregando...",
                "please_wait": "Por favor, aguarde...",
                "preview": "Pré-visualizar",
                "address": "Endereço",
                "continue": "Continuar",
                "open_in_app": "Abrir no Aplicativo",
                "locale": "Localidade",
                "details": "Detalhes",
                "sort": "Ordenar",
                "expand": "Expandir",
                "show_less": "Mostrar Menos",
                "show_all": "Mostrar Tudo",
                "has_more": "+{count} mais",
                "throttle_error": "Muitos pedidos, tente novamente mais tarde.",
                "file_preview": "Visualização do Arquivo",
                "integrations": "Integrações",
                "attachments": "Anexos",
                "attach": "Anexar",
                "changelog": "Registro de Alterações",
                "go_back": "Voltar",
                "back": "Back",
                "attach_files": "Anexar Arquivos",
                "file_too_large": "Arquivo muito grande, aumente o tamanho máximo de upload.",
                "no_attachments": "Não há anexos carregados.",
                "download": "Download",
                "remember_selection": "Lembre-se da minha seleção para a próxima vez",
                "token_expired": "Desculpe, sua sessão expirou.",
                "all_caught_up": "Você está em dia.",
                "view_record": "Ver",
                "list_view": "Lista",
                "reminder_set_for": "Lembrete definido para {value} {type} antes",
                "reminder_before_due": "antes do prazo",
                "integration_not_configured": "A integração não está configurada",
                "associate_with_record": "Associar com registros",
                "address_information": "Informação de Endereço",
                "search": "Pesquisar...",
                "type_to_search": "Digite para pesquisar...",
                "type_more_to_search": "Digite {characters} caracteres a mais para realizar a pesquisa...",
                "search_records": "Pesquisar registros",
                "allowed_extensions": "Extensões permitidas para  upload",
                "allowed_extensions_info": "Digite as extensões separadas por vírgula para serem colocadas na lista de permissões para armazenamento de arquivos.",
                "last_modified_at": "Última Modificação",
                "created_at": "Criado Em",
                "updated_at": "Atualizado Em",
                "created_by": "Criado Por",
                "creation_date": "Data da Criação",
                "drop_files": "Solte os arquivos para enviar",
                "choose_image": "Escolher Imagem",
                "ascending": "Ascendente",
                "descending": "Descendente",
                "sort_ascending": "Sort ascending",
                "sort_descending": "Sort descending",
                "upload": "Enviar",
                "upload_avatar": "Enviar Avatar",
                "avatar": "Avatar",
                "quick_create": "Criação Rápida",
                "no_owner": "Nenhum Proprietário",
                "owner_email_address": "Endereço de E-mail do Proprietário",
                "associate": "Associar",
                "timezone": "Fuso horário",
                "currency": "Moeda",
                "system_default": "Padrão do Sistema",
                "auto_detect": "Detecção automática",
                "all": "Todos",
                "see_all": "Ver Todos",
                "select_file": "Selecionar Arquivo",
                "file": "Arquivo",
                "form_validation_failed": "A validação do formulário falhou, verifique todos os campos",
                "form_validation_failed_with_sections": "A validação do formulário falhou, verifique todas as seções e campos",
                "advanced": "Avançado",
                "yes": "Sim",
                "no": "Não",
                "no_associations": "Sem associações",
                "associated_with_total_records": "Associado a {count} registro|Associado a {count} registros",
                "action_not_authorized": "Sua conta não está autorizada a realizar esta ação",
                "record_view": {
                    "manage_sidebar": "Gerenciar seções da barra lateral",
                    "sections": {
                        "edit_heading": "Gerenciar Seções",
                        "edit_subheading": "Reordenar as seções ou alternar a visibilidade",
                        "details": "Detalhes"
                    }
                },
                "soft_deletes": {
                    "trashed": "Na Lixeira",
                    "trashed_records": "Registros na Lixeira",
                    "restore": "Restaurar",
                    "force_delete": "Excluir Permanentemente",
                    "move_to_trash": "Mover para Lixeira",
                    "empty_trash": "Empty Trash",
                    "trashed_pruning_info": "Os registros descartados serão excluídos após {total} dias."
                },
                "logo": {
                    "light": "Logomarca clara",
                    "dark": "Logomarca escura"
                },
                "cards": {
                    "creation_date_info": "Este card reflete apenas os registros que foram criados durante o intervalo de datas selecionado."
                },
                "theme": {
                    "switch_light": "Alternar para o modo claro",
                    "switch_system": "Alternar para o tema do sistema",
                    "switch_dark": "Alternar para o modo escuro"
                },
                "menu": {
                    "metrics": {
                        "metrics": "Métricas",
                        "refresh_interval": "As métricas são atualizadas a cada {interval} minutos."
                    }
                },
                "visibility_group": {
                    "visible_to": "Visível para",
                    "all": "Toda a empresa"
                },
                "export": {
                    "export": "Exportar",
                    "type": "Tipo",
                    "select_range": "Select Range",
                    "apply_filters": "Exportar registros com base nos filtros aplicados?"
                },
                "company": {
                    "name": "Nome da Empresa",
                    "country": "País"
                },
                "password_generator": {
                    "heading": "Gerar Senha",
                    "strength": "Força",
                    "length": "Comprimento",
                    "digits": "Dígitos",
                    "symbols": "Símbolos",
                    "weak": "Fraca",
                    "average": "Média",
                    "strong": "Forte",
                    "secure": "Segura",
                    "copied": "Senha copiada para a área de transferência"
                },
                "weekdays": {
                    "monday": "Segunda-feira",
                    "tuesday": "Terça-feira",
                    "wednesday": "Quarta-feira",
                    "thursday": "Quinta-feira",
                    "friday": "Sexta-feira",
                    "saturday": "Sábado",
                    "sunday": "Domingo"
                },
                "colors": {
                    "color": "Cor",
                    "colors": "Cores",
                    "remove": "Remover Cor",
                    "palettes": "Paletas de Cor"
                },
                "oauth": {
                    "connect": "Conectar",
                    "no_accounts": "Você não tem nenhuma conta conectada.",
                    "invalid_state": "Pedido inválido, por favor, tente novamente.",
                    "connect_new_account": "Conectar nova conta",
                    "add": "Adicionar nova conta",
                    "or_choose_existing": "ou escolha uma conta adicionada anteriormente:",
                    "stop_syncing": "Parar Sincronização",
                    "start_syncing": "Começar Sincronização",
                    "deleted": "Conta excluída com sucesso",
                    "connected_accounts": "Contas Conectadas",
                    "requires_authentication": "Esta conta requer nova autenticação para se reconectar com o aplicativo.",
                    "re_authenticate": "Reautenticar",
                    "re_authenticated": "Conta reautenticada com sucesso",
                    "delete_warning": "A exclusão de uma conta conectada interromperá todos os serviços relacionados fornecidos pela conta, incluindo todas as contas de e-mail conectadas usadas para a caixa de entrada."
                }
            },
            "contentbuilder": {
                "snippets": {
                    "basic": "Básico",
                    "text": "Texto",
                    "headline": "Título",
                    "buttons": "Botões",
                    "photos": "Imagens",
                    "profile": "Perfil",
                    "contact": "Contato",
                    "products": "Produtos",
                    "features": "Funcionalidades",
                    "process": "Processo",
                    "pricing": "Preço",
                    "skills": "Habilidades",
                    "achievements": "Conquistas",
                    "quotes": "Citações",
                    "partners": "Parceiros",
                    "as_featured_on": "Como Destacado Em",
                    "help_and_faq": "Ajuda, perguntas frequentes, FAQ"
                },
                "builder": {
                    "Bold": "Negrito",
                    "Italic": "Itálico",
                    "Hyperlink": "Hiperlink",
                    "Align": "Alinhar",
                    "Paragraph": "Parágrafo",
                    "Color": "Cor",
                    "Formatting": "Formatação",
                    "List": "Lista",
                    "Text Settings": "Configurações de Texto",
                    "Icon": "Ícone",
                    "Clean": "Limpar",
                    "Font": "Fonte",
                    "Previous": "Anterior",
                    "Next": "Próximo",
                    "More": "Mais",
                    "Move Up": "Mover para Cima",
                    "Move Down": "Mover para Baixo",
                    "Move Left": "Mover para Esquerda",
                    "Move Right": "Mover para Direita",
                    "Delete": "Excluir",
                    "Add": "Adicionar",
                    "Move": "Mover",
                    "Duplicate": "Duplicar",
                    "Decrease": "Diminuir",
                    "Increase": "Aumentar",
                    "HTML": "HTML",
                    "Headline": "Título",
                    "Image": "Imagem",
                    "Heading 1": "Título 1",
                    "Heading 2": "Título 2",
                    "Heading 3": "Título 3",
                    "Quote": "Citação",
                    "Preformatted": "Pré-formatado",
                    "Table": "Tabela",
                    "Spacer": "Espaçador",
                    "Horizontal Line": "Linha Horizontal",
                    "More...": "Mais...",
                    "Enlarge": "Aumentar",
                    "Ok": "Ok",
                    "Align Left": "Alinhar à Esquerda",
                    "Align Center": "Alinhar ao Centro",
                    "Align Right": "Alinhar à Direita",
                    "Align Full": "Alinhar Tudo",
                    "Bullets": "Pontos",
                    "Numbering": "Numeração",
                    "Indent": "Aumentar recuo",
                    "Outdent": "Diminuir recuo",
                    "Heading 4": "Título 4",
                    "Underline": "Sublinhado",
                    "Strikethrough": "Tachado",
                    "Superscript": "Sobrescrito",
                    "Subscript": "Subscrito",
                    "Uppercase": "Maiúsculas",
                    "Clear": "Limpar",
                    "Choose..": "Escolher...",
                    "Forecolor": "Cor do Texto",
                    "Backcolor": "Cor de fundo",
                    "Apply": "Aplicar",
                    "Cancel": "Cancelar",
                    "Change Image": "Alterar Imagem",
                    "Link": "Link",
                    "Edit": "Editar",
                    "Source": "Fonte",
                    "Settings": "Configurações",
                    "Change Icon": "Mudar Ícone",
                    "Edit Table": "Editar Tabela",
                    "Select": "Selecionar",
                    "Open new window": "Abrir nova janela",
                    "Open New Window": "Abrir Nova Janela",
                    "Text": "Texto",
                    "Title": "Título",
                    "Free": "Livre",
                    "Style": "Estilo",
                    "Layout": "Layout",
                    "Background": "Fundo",
                    "Select Color": "Selecionar Cor",
                    "Text Color": "Cor do Texto",
                    "Border Thickness": "Espessura da Borda",
                    "Border Color": "Cor da Borda",
                    "Apply To": "Aplicar Para",
                    "Current Row": "Linha Atual",
                    "Current Column": "Coluna Atual",
                    "Even Rows": "Linhas Pares",
                    "Odd Rows": "Linhas Ímpares",
                    "Current Cell": "Célula Atual",
                    "Insert Row": "Inserir Linha",
                    "Insert Column": "Inserir Coluna",
                    "Delete Row": "Excluir Linha",
                    "Delete Column": "Excluir Coluna",
                    "Above": "Acima",
                    "Below": "Abaixo",
                    "Left": "Esquerda",
                    "Right": "Direita",
                    "Row": "Linha",
                    "Column": "Coluna",
                    "Merge": "Mesclar",
                    "Merge Cell": "Mesclar Célula",
                    "css": "css",
                    "Class": "Classe",
                    "Box": "Caixa",
                    "Spacing": "Espaçamento",
                    "Border": "Borda",
                    "Corners": "Cantos",
                    "Shadow": "Sombra",
                    "Display": "Mostrar",
                    "Position": "Posição",
                    "Effects": "Efeitos",
                    "Attributes": "Atributos",
                    "Animation": "Animação",
                    "Background Color": "Cor do Fundo",
                    "Gradient": "Degradê",
                    "Dimension": "Dimensão",
                    "Responsive Positioning": "Posicionamento Responsivo",
                    "Reset margin left on small screen": "Redefinir margem esquerda na tela pequena",
                    "Reset margin right on small screen": "Redefinir margem à direita na tela pequena",
                    "Individual Sides": "Lados Individuais",
                    "Select Font": "Selecionar Fonte",
                    "Animate": "Animar",
                    "Delay": "Atraso",
                    "Duration": "Duração",
                    "Animate Once": "Animar Uma Vez",
                    "Test": "Teste",
                    "TEST": "TESTE",
                    "Custom": "Personalizado",
                    "Module Settings": "Configurações do Módulo",
                    "Drag and drop an image or click to browse.": "Arraste e solte uma imagem ou clique para navegar.",
                    "Are you sure you want to delete this block?": "Tem certeza de que deseja excluir este bloco?",
                    "Back": "Voltar",
                    "Or Specify Image Source": "Ou especifique a fonte da imagem",
                    "Preferences": "Preferências",
                    "Hide element tool": "Ocultar ferramenta do elemento",
                    "Hide column tool": "Ocultar ferramenta da coluna",
                    "Line": "Linha",
                    "Hide column HTML editor": "Ocultar editor de HTML da coluna",
                    "Hide row HTML editor": "Ocultar editor de HTML da linha",
                    "Hide row move (up/down) buttons": "Ocultar botões de mover linha (para cima/para baixo)",
                    "HTML syntax highlighting": "Destaque de sintaxe HTML",
                    "Scrollable Editing Toolbar": "Barra de Ferramentas de Edição Rolável",
                    "Toolbar position": "Posição da barra de ferramentas",
                    "Top": "Superior",
                    "Toolbar visibility": "Visibilidade da barra de ferramentas",
                    "Auto": "Auto",
                    "Always Visible": "Sempre Visível",
                    "Paste result": "Colar resultado",
                    "HTML (without styles)": "HTML (sem estilos)",
                    "HTML (with styles)": "HTML (com estilos)",
                    "Text only": "Somente texto",
                    "Add Snippet": "Adicionar Snippet",
                    "Grid Tool": "Ferramenta de Grade",
                    "Element Tool": "Ferramenta Elemento",
                    "Builder Mode": "Modo Construtor",
                    "Default": "Padrão",
                    "Minimal": "Mínimo",
                    "Hide outline": "Ocultar contorno",
                    "Hide element highlight": "Ocultar destaque do elemento",
                    "Row tool position": "Posição da ferramenta de linha",
                    "Add (+) button placement": "Adicionar (+) posicionamento do botão",
                    "Between Blocks (left)": "Entre Blocos (esquerda)",
                    "Between Blocks (center)": "Entre Blocos (centro)",
                    "Outline Mode": "Modo do Contorno",
                    "Row & column": "Linha & coluna",
                    "Row only": "Apenas linha",
                    "Draggable blocks without handle": "Blocos arrastáveis sem alça",
                    "Animated drag to sort": "Arraste animado para classificar",
                    "Open snippets sidebar on start": "Abra a barra lateral de snippets no início",
                    "Scrollable toolbar (top only)": "Barra de ferramentas rolável (apenas topo)",
                    "Please select a block": "Selecione um bloco",
                    "Open snippet sidebar on start": "Abra a barra lateral do snippet no início",
                    "Hide snippet handle": "Ocultar alça do snippet",
                    "Undo": "Desfazer",
                    "Redo": "Refazer",
                    "Empty": "Vazio",
                    "+ Click to add content": "+ Clique para adicionar conteúdo",
                    "B": "B",
                    "W": "W",
                    "Outline Style": "Estilo do Contorno",
                    "Colored": "Colorido",
                    "Gray": "Cinza",
                    "Hide Outline": "Ocultar Contorno",
                    "Hide Column Tool": "Ocultar Ferramenta de Coluna",
                    "Row Tool Position": "Posição da Ferramenta de Linha",
                    "Tool Style": "Estilo da Ferramenta",
                    "Hide Snippet (+) Tool": "Ocultar Ferramenta de Snippet (+)",
                    "Tool Outline": "Contorno da Ferramenta",
                    "Button": "Botão",
                    "Button Editor": "Editor do Botão",
                    "Edit Button": "Editar Botão",
                    "Grid Editor": "Editor de Grade",
                    "Outline": "Contorno",
                    "Font Size": "Tamanho da Fonte",
                    "Line Spacing": "Espaçamento da Linha",
                    "Letter Spacing": "Espaçamento entre Letras",
                    "Close": "Fechar",
                    "Search & Replace": "Pesquisar e substituir",
                    "Word Count": "Contagem de Palavras",
                    "words": "palavras",
                    "Characters": "Caracteres",
                    "Characters (no spaces)": "Caracteres (sem espaços)",
                    "Add to Left": "Adicionar à Esquerda",
                    "Add to Right": "Adicionar à Direita",
                    "Border Top Color": "Cor da Borda Superior",
                    "Border Bottom Color": "Cor da Borda Inferior",
                    "Border Left Color": "Cor da Borda Esquerda",
                    "Border Right Color": "Cor da Borda Direita",
                    "Snippets sidebar visibility": "Visibilidade da barra lateral de snippets",
                    "You have reached the maximum number of columns": "Você atingiu o número máximo de colunas",
                    "Width": "Largura",
                    "Height": "Altura",
                    "Names": "Nomes",
                    "Values": "Valores",
                    "Border Top": "Borda Superior",
                    "Border Bottom": "Borda Inferior",
                    "Border Left": "Borda Esquerda",
                    "Border Right": "Borda Direita",
                    "Individual Corners": "Cantos Individuais",
                    "Top Left": "Superior Esquerdo",
                    "Top Right": "Superior Direito",
                    "Bottom Left": "Inferior Esquerda",
                    "Bottom Right": "Inferior Direita",
                    "Flex": "Flexível",
                    "Direction": "Direção",
                    "Wrap": "Quebra",
                    "Justify Content": "Justificar Conteúdo",
                    "Align Items": "Alinhar Itens",
                    "Align Content": "Alinhar Conteúdo",
                    "Opacity": "Opacidade",
                    "Filters": "Filtros",
                    "Blur": "Desfoque",
                    "Brightness": "Brilho",
                    "Contrast": "Contraste",
                    "Grayscale": "Escala de Cinza",
                    "Hue Rotate": "Girar Tonalidade",
                    "Invert": "Inverter",
                    "Saturate": "Saturar",
                    "Sepia": "Sépia",
                    "Bottom": "Inferior",
                    "Float": "Flutuar",
                    "x Offset": "x Offset",
                    "y Offset": "y Offset",
                    "Spread": "Espalhar",
                    "Shadow Color": "Cor da Sombra",
                    "Outer/Inner Shadow": "Sombra externa/interna",
                    "Margin": "Margem",
                    "Padding": "Padding",
                    "Text Align": "Alinhamento do Texto",
                    "Center": "Centralizar",
                    "Full": "Total",
                    "Line Height": "Altura da Linha",
                    "Font Weight": "Peso da Fonte",
                    "Font Style": "Estilo da Fonte",
                    "Text Transform": "Transformação do Texto",
                    "Text Decoration": "Decoração do Texto",
                    "Word Spacing": "Espaçamento entre Palavras",
                    "Font Family": "Família da Fonte",
                    "Normal": "Normal",
                    "Lowercase": "Minúsculas",
                    "Capitalize": "Capitalizar",
                    "None": "Nenhum",
                    "Line Through": "Tachado",
                    "Overline": "Sobrelinha",
                    "Hover": "Pairar",
                    "Saved": "Salvo",
                    "Templates": "Modelos",
                    "No Border": "Sem Bordas",
                    "Border Radius": "Arredondamento das Bordas",
                    "Button Size": "Tamanho do Botão",
                    "Upper/lower": "Maiúsculas/minúsculas",
                    "Weight": "Peso",
                    "Save Current Button": "Salvar Botão Atual",
                    "Tags": "Espaços reservados",
                    "Snippet": "Snippet",
                    "Mono": "Mono",
                    "Zoom": "Zoom",
                    "Set theme": "Definir tema",
                    "Open in a lightbox (for image, video or Youtube)": "Abrir em uma caixa de luz (para imagem, vídeo ou YouTube)",
                    "Column Settings": "Configurações da Coluna",
                    "Lock": "Bloquear",
                    "General": "Geral",
                    "Content": "Conteúdo",
                    "On Click": "Ao Clicar",
                    "Background Image": "Imagem de Fundo",
                    "Adjust": "Ajustar",
                    "Dark": "Escuro",
                    "Light": "Claro",
                    "Enlarge Row": "Aumentar Linha",
                    "Content Alignment": "Alinhamento do Conteúdo",
                    "Top Center": "Centro Superior",
                    "Bottom Center": "Inferior Centralizado",
                    "Center Left": "Centralizar à Esquerda",
                    "Center Right": "Centralizar à Direita",
                    "Open": "Abrir",
                    "Background Image Adjustments": "Ajustes da Imagem de Fundo",
                    "Scale": "Escalar",
                    "Horizontal": "Horizontal",
                    "Vertical": "Vertical",
                    "Do you really want to leave?": "Você realmente quer sair?",
                    "Two Button": "Dois Botões",
                    "Youtube": "YouTube",
                    "Video": "Vídeo",
                    "Map": "Mapa",
                    "Show Controls": "Mostrar Controles",
                    "Loop": "Loop",
                    "Autoplay": "Reprodução automática",
                    "Please select an image or video file.": "Selecione um arquivo de imagem ou vídeo.",
                    "Please select an image file.": "Selecione um arquivo de imagem.",
                    "Please select an mp4 file.": "Selecione um arquivo mp4.",
                    "Social Links": "Links Sociais",
                    "HTML/JS": "HTML/JS",
                    "Drag image to change the position. Click image to edit the details.": "Arraste a imagem para alterar a posição. Clique na imagem para editar os detalhes.",
                    "Add Image": "Adicionar Imagem",
                    "Fit": "Ajustar",
                    "Type": "Tipo",
                    "Animation duration": "Duração da animação",
                    "Per View": "Por Visualização",
                    "Gap": "Lacuna",
                    "Arrow Navigation": "Navegação de Seta",
                    "Dots Navigation": "Navegação por Pontos",
                    "Fade": "Desaparecer",
                    "Caption (HTML allowed)": "Citação (HTML permitido)",
                    "Placement": "Posicionamento",
                    "Max Width": "Largura Máxima",
                    "You can test the On-Click action on page if you lock the column by clicking the lock button": "Você pode testar a ação Ao Clicar na página se bloquear a coluna clicando no botão de bloqueio",
                    "Remove": "Remover",
                    "All": "Todos",
                    "Transparent": "Transparente",
                    "Current": "Atual",
                    "Padding X": "Padding X",
                    "Padding Y": "Padding Y",
                    "SM": "SM",
                    "MD": "MD",
                    "LG": "LG",
                    "XL": "XL",
                    "2XL": "2XL",
                    "3XL": "3XL",
                    "Margin Left": "Margem Esquerda",
                    "Margin Right": "Margem Direita",
                    "Margin Top": "Margem Superior",
                    "Margin Bottom": "Margem Inferior",
                    "Reset": "Redefinir",
                    "Snippet Categories": "Categorias de Snippet",
                    "Snippets": "Snippets",
                    "Copy": "Copiar",
                    "Cut": "Cortar",
                    "Paste": "Colar",
                    "Insert Link": "Inserir Link",
                    "Insert Image": "Inserir Imagem",
                    "Show shortcut info": "Mostrar informações de atalho",
                    "Navigate to the next control": "Navegar para o próximo controle",
                    "Navigate to the previous control": "Navegar para o controle anterior",
                    "Select control that has focus": "Selecionar controle que está em foco",
                    "Select option that has focus (eg. checkbox)": "Selecionar opção que está em foco (ex. caixa de seleção)",
                    "Move up in selection list or menu": "Mover para cima na lista de seleção ou menu",
                    "Move down in selection list or menu": "Mover para baixo na lista de seleção ou menu",
                    "Close modal or popup": "Fechar modal ou pop-up",
                    "Shortcuts": "Atalhos",
                    "Basic": "Básico",
                    "Editing": "Editando",
                    "Navigation": "Navegação",
                    "Tab": "Aba",
                    "Shift": "Shift",
                    "Esc": "Esc",
                    "Enter": "Enter",
                    "Up arrow": "Seta para cima",
                    "Down arrow": "Seta para baixo",
                    "or": "ou",
                    "Spacebar": "Barra de espaço",
                    "Min Width": "Largura Mínima",
                    "Max Height": "Altura Máxima",
                    "Min Height": "Altura Mínima",
                    "Overflow x": "Overflow x",
                    "Overflow y": "Overflow y",
                    "Please enter <iframe> element.": "Por favor, insira o elemento <iframe>.",
                    "Add Slide": "Adicionar Slide",
                    "Alternate Videos": "Vídeos Alternativos",
                    "Add/Update Video": "Adicionar/Atualizar Vídeo",
                    "Drag slide to change the position. Click slide to edit the details.": "Arraste o slide para mudar a posição. Clique no slide para editar os detalhes.",
                    "URL": "URL",
                    "Delete Slide": "Excluir Slide",
                    "Arrow Color": "Cor da Setas",
                    "Dots Color": "Cor dos Pontos",
                    "Hide Column on Mobile": "Ocultar Coluna em Dispositivos Móveis",
                    "Padding Left/Right": "Preenchimento Esquerda/Direita",
                    "Top (Full Width)": "Topo (Largura Total)",
                    "HTML View": "Visualização HTML",
                    "Shorten HTML": "Encurtar HTML",
                    "Actual": "Atual",
                    "Visibility": "Visibilidade",
                    "Visible": "Visível",
                    "Hidden": "Oculto",
                    "Text Slider": "Slider de Texto",
                    "Drag slide to change the position.": "Arraste o slide para mudar a posição.",
                    "Show Arrow on Mobile": "Mostrar Setas em Dispositivos Móveis",
                    "Show Dots on Mobile": "Mostrar Pontos em Dispositivos Móveis",
                    "Pause on Hover": "Pausar ao Passar o Mouse",
                    "Caption Animation": "Animação da Legenda",
                    "Slide Up": "Deslizar para Cima",
                    "Fade In": "Desaparecer",
                    "Add Row ID": "Adicionar ID de Linha",
                    "Add Column ID": "Adicionar ID de Coluna",
                    "Add Element ID": "Adicionar ID de Elemento",
                    "Add Css Classes": "Adicionar Classes CSS",
                    "Laptop": "Notebook",
                    "Mobile": "Celular",
                    "Tablet": "Tablet",
                    "Laptop/Tablet (Landscape)": "Notebook/Tablet (Paisagem)",
                    "Tablet (Landscape)": "Tablet (Paisagem)",
                    "Tablet (Portrait)": "Tablet (Retrato)",
                    "Laptop/Tablet": "Notebook/Tablet",
                    "Desktop": "Desktop",
                    "Live Preview": "Visualização ao Vivo",
                    "Page Break": "Quebra de Página",
                    "Add the products table": "Adicionar a tabela de produtos",
                    "Products": "Produtos",
                    "Products will be displayed in this section on document preview and PDF.": "Os produtos serão exibidos nesta seção em visualização de documento e PDF.",
                    "Signatures": "Assinaturas",
                    "On document PDF, the signatures will be displayed in this section.": "No documento PDF, as assinaturas serão exibidas nesta seção.",
                    "Open in a lightbox (for image video or Youtube)": "Abra em um lightbox (para vídeo de imagem ou YouTube)"
                }
            },
            "country": {
                "country": "País"
            },
            "dashboard": {
                "insights": "Insights",
                "dashboard": "Dashboard",
                "name": "Nome",
                "default": "Dashboard Padrão",
                "new_dashboard": "Novo Dashboard",
                "create": "Criar Novo Dashboard",
                "edit_current": "Editar Dashboard Atual",
                "delete_current": "Excluir Dashboard Atual",
                "created": "Dashboard criado com sucesso.",
                "updated": "Dashboard atualizado com sucesso.",
                "deleted": "Dashboard excluído com sucesso",
                "cards": {
                    "enabled": "Ativado"
                }
            },
            "dates": {
                "today": "Hoje",
                "tomorrow": "Amanhã",
                "in_x_days": "En {count} dia|En {count} dias",
                "in_x_weeks": "En {count} semana|En {count} semanas",
                "in_x_months": "En {count} mês|En {count} meses",
                "custom": "Personalizado",
                "range": "Date range",
                "minutes": "minutos",
                "hours": "horas",
                "days": "dias",
                "weeks": "semanas",
                "duration": {
                    "seconds": "alguns segundos",
                    "minutes": "minuto|minutos",
                    "hours": "hora|horas",
                    "days": "día|días"
                },
                "due": {
                    "today": "Vence hoje",
                    "tomorrow": "Vence amanhã",
                    "this_week": "Vence esta semana",
                    "next_week": "Vence na próxima semana",
                    "this_month": "Vence este mês",
                    "next_month": "Vence no próximo mês",
                    "this_quarter": "Vence este trimestre"
                },
                "yesterday": "Ontem",
                "next_day": "Próximo Dia",
                "this_week": "Esta Semana",
                "last_week": "Última Semana",
                "next_week": "Próxima Semana",
                "this_month": "Este Mês",
                "last_month": "Último Mês",
                "next_month": "Próximo Mês",
                "this_quarter": "Este Trimestre",
                "last_quarter": "Último Trimestre",
                "next_quarter": "Próximo Trimestre",
                "this_year": "Este Ano",
                "last_year": "Último Ano",
                "next_year": "Próximo Ano",
                "within": {
                    "last_7_days": "Nos últimos 7 dias",
                    "last_14_days": "Nos últimos 14 dias",
                    "last_30_days": "Nos últimos 30 dias",
                    "last_60_days": "Nos últimos 60 dias",
                    "last_90_days": "Nos últimos 90 dias",
                    "last_365_days": "Nos últimos 365 dias"
                },
                "periods": {
                    "7_days": "Últimos 7 Dias",
                    "15_days": "Últimos 15 Dias",
                    "30_days": "Últimos 30 Dias",
                    "60_days": "Últimos 60 Dias",
                    "90_days": "Últimos 90 Dias",
                    "365_days": "Últimos 365 Dias",
                    "last_3_months": "Últimos 3 Meses",
                    "last_6_months": "Últimos 6 Meses",
                    "last_12_months": "Últimos 12 Meses"
                }
            },
            "fields": {
                "add": "Adicionar Novo",
                "fields": "Campos",
                "field": "Campo",
                "updated": "Campos Atualizados",
                "hide_fields": "Hide {count} field|Hide {count} fields",
                "more_fields": "{count} more field|{count} more fields",
                "reseted": "Os campos foram redefinidos com sucesso",
                "all": "All Fields",
                "select": "Select Fields",
                "updated_field": "Campo Atualizado",
                "update_field": "Update Field",
                "optional": "(opcional)",
                "configured": "Campos configurados com sucesso",
                "no_longer_available": "Campo não está mais disponível",
                "new_value": "Novo Valor",
                "old_value": "Valor Antigo",
                "manage": "Gerenciar Campos",
                "hide_updated": "Esconder Campos Atualizados",
                "view_updated": "Ver Campos Atualizados",
                "primary": "Campo Primário",
                "visible": "Visível",
                "label": "Rótulo",
                "is_readonly": "Somente Leitura",
                "keep_existing_value": "Keep existing value",
                "replace_existing_value": "Replace existing value with..",
                "settings": {
                    "create": "Campos de Criação",
                    "create_info": "Campos que serão exibidos quando algum usuário criar um registro.",
                    "update": "Campos de Edição",
                    "update_info": "Campos que estão disponíveis e serão exibidos na visualização de edição/visualização do registro.",
                    "detail": "Detalhar Campos",
                    "detail_info": "Campos que estão disponíveis e serão exibidos no detalhe dos registros.",
                    "list": "Campos de Lista",
                    "list_info": "Para ajustar os campos exibidos na exibição de lista, ao visualizar a lista {resourceName}, clique no ícone {icon} localizado na barra de navegação e escolha \"Configurações da lista\"."
                },
                "collapsed_by_default": "Recolhido por padrão?",
                "is_required": "Obrigatório?",
                "option_enabled_will_propagate": "Quando ativado, propaga-se também para a visualização \"{view_name}\".",
                "option_disabled_will_propagate": "When disabled, propagates to \"{view_name}\" view too.",
                "options": "Opções",
                "field_is_unique": "Unique",
                "mark_as_unique": "Não permitir valores duplicados",
                "mark_as_unique_change_info": "O valor desta opção pode ser definido apenas na criação do campo.",
                "unmark_as_unique_change_info": "This action is irreversible, after the field is unmarked as unique, cannot be marked as unique again.",
                "validation": {
                    "exist": "Parece que o campo com este ID já existe para o recurso.",
                    "requires_options": "Adicione opções para este campo.",
                    "field_type_invalid": "O tipo de campo não é suportado",
                    "field_id_invalid": "Somente caracteres alfabéticos minúsculos (a-z) e sublinhado (_) são aceitos.",
                    "refuses_options": "Este campo não suporta opções.",
                    "option_coma": "Comas are not allowed in option names."
                },
                "custom": {
                    "create_option_icon": "Clique no ícone {icon} para criar uma nova opção.",
                    "or_add_options_via_text": "Or add options via text",
                    "convert_text_to_options": "Convert text to options",
                    "text_options_each_on_new_line": "Paste/enter each option on new line.",
                    "field": "Campo Customizado",
                    "create": "Criar Novo Campo Customizado",
                    "update": "Atualizar Campo Customizado",
                    "type": "Tipo do Campo",
                    "id": "ID do Campo",
                    "id_info": "Digite o ID do campo em letras minúsculas, apenas caracteres alfabéticos (a-z) e sublinhado (_) são aceitos.",
                    "updated": "Campo personalizado atualizado com sucesso",
                    "created": "Campo personalizado criado com sucesso",
                    "deleted": "Campo personalizado excluído com sucesso"
                },
                "email_copied": "Endereço de e-mail copiado para a área de transferência",
                "next_activity_date": "Data da Próxima Atividade",
                "next_activity_date_info": "Este campo é somente leitura e é atualizado automaticamente com base nas atividades futuras do registro, indica quando a próxima ação do representante de vendas deve ser tomada.",
                "phones": {
                    "add": "+ Adicionar outro",
                    "copied": "Número de telefone copiado para a área de transferência",
                    "types": {
                        "type": "Tipo",
                        "mobile": "Celular",
                        "work": "Trabalho",
                        "other": "Outro"
                    }
                },
                "contacts": {
                    "first_name": "Primeiro Nome",
                    "last_name": "Último Nome",
                    "email": "Endereço de E-mail",
                    "job_title": "Cargo",
                    "phone": "Telefone",
                    "street": "Endereço",
                    "city": "Cidade",
                    "state": "Estado",
                    "postal_code": "CEP",
                    "owner_assigned_date": "Data de Atribuição do Proprietário",
                    "country": {
                        "name": "País"
                    },
                    "source": {
                        "name": "Fonte"
                    },
                    "user": {
                        "name": "Proprietário"
                    }
                },
                "companies": {
                    "name": "Nome",
                    "email": "Endereço de E-mail",
                    "parent": {
                        "name": "Matriz"
                    },
                    "phone": "Telefone",
                    "street": "Endereço da Rua",
                    "city": "Cidade",
                    "state": "Estado",
                    "postal_code": "CEP",
                    "domain": "Nome de domínio da empresa",
                    "owner_assigned_date": "Data de Atribuição do Proprietário",
                    "country": {
                        "name": "País"
                    },
                    "industry": {
                        "name": "Indústria"
                    },
                    "user": {
                        "name": "Proprietário"
                    },
                    "source": {
                        "name": "Fonte"
                    }
                },
                "deals": {
                    "name": "Nome do Negócio",
                    "expected_close_date": "Data Prevista de Fechamento",
                    "amount": "Quantia",
                    "owner_assigned_date": "Data de Atribuição do Proprietário",
                    "user": {
                        "name": "Proprietário"
                    },
                    "stage": {
                        "name": "Etapa"
                    },
                    "pipeline": {
                        "name": "Pipeline"
                    }
                },
                "documents": {
                    "title": "Título do Documento",
                    "owner_assigned_date": "Data de Atribuição do Proprietário",
                    "accepted_at": "Aceito em",
                    "amount": "Quantia",
                    "original_date_sent": "Data Original de Envio",
                    "last_date_sent": "Última Data de Envio",
                    "brand": {
                        "name": "Marca"
                    },
                    "user": {
                        "name": "Proprietário"
                    },
                    "type": {
                        "name": "Tipo"
                    }
                }
            },
            "filters": {
                "filters": "Filtros",
                "apply": "Aplicar Filtros",
                "save_and_apply": "Salvar e Aplicar",
                "create": "Criar novo filtro",
                "filter_by": "Filtrar por",
                "edit": "Editar",
                "save_as_new": "Salvar filtro?",
                "available": "Filtros Disponíveis",
                "not_available": "Nenhum filtro disponível, comece criando um filtro.",
                "cannot_be_shared": "Este filtro consiste em regras ({rules}) que podem nem sempre estar disponíveis para todos os membros da equipe, por este motivo, o filtro não pode ser compartilhado com outros membros da equipe.",
                "search": "Buscar filtros...",
                "name": "Nome do Filtro",
                "new": "Novo Filtro",
                "clear_rules": "Limpar Regras",
                "clear_applied": "Limpar Filtro",
                "static_rule_indicator": "Regra Estática",
                "is_readonly": "Este filtro é um filtro somente leitura com capacidade de ser marcado como padrão, outras modificações do filtro estão desativadas, se você precisar estender este filtro, crie um novo.",
                "system_default_delete_info": "Você não pode excluir o filtro padrão do aplicativo",
                "country": "País",
                "share": {
                    "with": "Compartilhado com",
                    "private": "Privado",
                    "everyone": "Todos",
                    "private_info": "Apenas o criador pode ver este filtro",
                    "everyone_info": "Todos os usuários podem ver e usar este filtro"
                },
                "placeholders": {
                    "enter": "Insira {label}",
                    "choose": "Escolha {label}",
                    "choose_with_multiple": "Escolha um ou mais {label}",
                    "select_date": "Selecionar data"
                },
                "conditions": {
                    "or": "ou",
                    "and": "e"
                },
                "show_matching_records_conditions": "Mostrar registros que correspondem a {match_type} destas condições:",
                "or_match_any_conditions": "{condition} corresponde {match_type} destas condições:",
                "mark_as_default": "Marcar como padrão",
                "unmark_as_default": "Desmarcar como padrão",
                "mark_as_default_for_current_account_only": "Applies only for your account.",
                "edit_filter": "Editar filtro",
                "match_type": "Tipo de Correspondência",
                "match_type_all": "Todos",
                "match_type_any": "Qualquer",
                "add_filter": "Adicionar Filtro",
                "add_condition": "Adicionar Condição",
                "add_another_condition": "Add Another Condition",
                "add_group": "Adicionar Grupo",
                "add_group_info": "A group to nest more filters",
                "select_rule": "Select Rule",
                "operators": {
                    "is": "é",
                    "was": "foi",
                    "equal": "é igual a",
                    "not_equal": "não é igual a",
                    "in": "é qualquer um de",
                    "not_in": "não é nenhum de",
                    "less": "é menor que",
                    "less_or_equal": "é menor ou igual a",
                    "greater": "é maior que",
                    "greater_or_equal": "é maior ou igual a",
                    "between": "é etre",
                    "not_between": "não é entre",
                    "begins_with": "começa com",
                    "not_begins_with": "não começa com",
                    "contains": "contém",
                    "not_contains": "não contém",
                    "ends_with": "termina com",
                    "not_ends_with": "não termina com",
                    "is_empty": "está vazio",
                    "is_not_empty": "não está vazio",
                    "is_null": "é desconhecido",
                    "is_not_null": "é conhecido"
                },
                "me": "Eu"
            },
            "import": {
                "import": "Importar",
                "start": "Começar Importação",
                "import_records": "Importar Registros",
                "import_in_progress": "Import In Progress",
                "download_sample": "Baixar exemplo",
                "history": "Histórico de importação",
                "no_history": "Nenhum histórico de importação encontrado.",
                "spreadsheet_columns": "Colunas da planilha",
                "column_will_not_import": "não será importado",
                "records_being_imported_in_batches": "The records are being imported in a few batches, do not navigate from this window until this message dissapear.",
                "date": "Data",
                "file_name": "Nome do arquivo",
                "user": "Usuário",
                "total_imported": "Importados",
                "total_duplicates": "Duplicatas",
                "total_skipped": "Ignorados",
                "progress": "Progress",
                "status": "Status",
                "imported": "Registros importados com sucesso",
                "revert": "Revert",
                "revert_info": "Reverting an import will permanently delete all of the imported records.",
                "why_skipped": "Por quê?",
                "download_skip_file": "Baixar arquivo de ignorados",
                "skip_file": "Arquivo de ignorados",
                "total_rows_skipped": "Total de linhas ignoradas: {count}",
                "skip_file_generation_info": "Um arquivo de ignorados é gerado sempre que uma validação de linha de planilha falha.",
                "skip_file_fix_and_continue": "Baixe o arquivo de ignorados para examinar as linhas que falharam e por que falharam. Depois que as linhas forem corrigidas, faça o upload do arquivo corrigido abaixo para continuar o processo de importação para a instância de importação atual.",
                "upload_fixed_skip_file": "Carregar arquivo de ignorados corrigido",
                "steps": {
                    "step_1": {
                        "name": "Baixar exemplo",
                        "description": "Guia de formatação da planilha."
                    },
                    "step_2": {
                        "name": "Carregar planilha",
                        "description": "Faça o upload do arquivo para mapeamento."
                    },
                    "step_3": {
                        "name": "Mapear colunas",
                        "description": "Mapeie as colunas com os campos."
                    },
                    "step_4": {
                        "name": "Importar",
                        "description": "Inicie o processo de importação."
                    }
                },
                "from_file": "Importar do arquivo {file_type}"
            },
            "mail_template": {
                "mail_templates": "Modelos de E-mail",
                "template": "Modelo",
                "subject": "Assunto",
                "message": "Mensagem",
                "updated": "Modelo atualizado com sucesso.",
                "choose_to_edit": "Escolha um modelo para editar",
                "changes_not_saved_warning": "Your current changes have not been saved. If you proceed, you will lose any unsaved progress. Do you wish to continue without saving?",
                "placeholders": {
                    "view_record": "Exibir Registro",
                    "placeholders": "Espaços reservados",
                    "mentioned_user": "O nome de usuário mencionado.",
                    "user_that_mentions": "O nome de usuário que menciona.",
                    "mention_url": "A URL da menção."
                }
            },
            "media": {
                "link_copied": "Link copiado com sucesso",
                "no_preview_available": "No momento, não há visualização disponível para este arquivo. Em vez disso, tente baixar o arquivo."
            },
            "notifications": {
                "notifications": "Notificações",
                "notification": "Notificação",
                "your": "Suas Notificações",
                "no_notifications": "Você não tem nenhuma notificação no momento.",
                "description": "Descrição",
                "mark_all_as_read": "Marcar tudo como lido",
                "no_more_notifications": "Não há mais notificações.",
                "dismiss": "Dismiss",
                "channels": {
                    "mail": "E-mail",
                    "database": "Sino"
                },
                "user_mentioned": "Você foi mencionado por {name}"
            },
            "oauth": {
                "connect": "Conectar",
                "no_accounts": "Você não tem nenhuma conta conectada.",
                "invalid_state": "Pedido inválido. Por favor, tente novamente.",
                "connect_new_account": "Conectar nova conta",
                "add": "Adicionar nova conta",
                "or_choose_existing": "ou escolha uma conta adicionada anteriormente:",
                "stop_syncing": "Parar Sincronização",
                "start_syncing": "Iniciar Sincronização",
                "deleted": "Conta excluída com sucesso",
                "connected_accounts": "Contas conectadas",
                "requires_authentication": "Esta conta requer uma nova autenticação para se reconectar com o aplicativo.",
                "re_authenticate": "Autentique novamente",
                "re_authenticated": "Conta reautenticada com sucesso",
                "delete_warning": "A exclusão de uma conta conectada interromperá todos os serviços relacionados fornecidos pela conta, incluindo todas as contas de e-mail conectadas que são usadas para a caixa de entrada."
            },
            "resource": {
                "all_resources": "All Resources",
                "created": "Registro criado com sucesso",
                "updated": "Registro atualizado com sucesso",
                "deleted": "Registro excluído com sucesso",
                "create": "Criar {resource}",
                "edit": "Editar {resource}",
                "already_associated": "Este registro já está associado",
                "associate_with_records": "Associar com registros",
                "associated": "Registro associado com sucesso",
                "dissociated": "Registro dissociado com sucesso",
                "associated_delete_warning": "O {resource} já está associado a registros, portanto, não pode ser excluído",
                "primary_record_delete_info": "Este é um {resource} primário, portanto, não pode ser excluído",
                "settings": {
                    "fields": "Campos do {resourceName}"
                }
            },
            "role": {
                "permissions": "Permissões",
                "role": "Cargo",
                "roles": "Cargos",
                "name": "Nome",
                "create": "Criar Cargo",
                "edit": "Editar Cargo",
                "created": "Cargo criado com sucesso",
                "updated": "Cargo atualizado com sucesso",
                "deleted": "Cargo excluído com sucesso",
                "granted": "Concedido",
                "revoked": "Revogado",
                "capabilities": {
                    "access": "Acesso",
                    "view": "Visualizar",
                    "delete": "Excluir",
                    "bulk_delete": "Exclusão em massa",
                    "edit": "Editar",
                    "all": "Todos {resourceName}",
                    "owning_only": "Somente proprietário"
                },
                "view_non_authorized_after_record_create": "Sua conta não está autorizada a visualizar este registro, pois você não é o proprietário do registro. Após ser redirecionado desta página, você não poderá acessar o registro.",
                "empty_state": {
                    "title": "Sem cargos",
                    "description": "Comece criando um novo cargo."
                }
            },
            "settings": {
                "settings": "Configurações",
                "updated": "Configurações Atualizadas",
                "general_settings": "Configurações Gerais",
                "company_information": "Informações da Empresa",
                "update_user_account_info": "A atualização dessas configurações não afetará as configurações de sua conta de usuário, pois essas configurações são gerais. Atualize as mesmas configurações em sua conta de usuário se desejar atualizar essas opções.",
                "general": "Geral",
                "system": "Sistema",
                "system_email": "Conta de E-mail do Sistema",
                "system_email_configured": "Conta configurada por outro usuário",
                "system_email_info": "Selecione a conta de e-mail conectada à caixa de entrada que será usada para enviar e-mails relacionados ao sistema, como usuário atribuído ao contato, lembrete de vencimento da atividade, convites do usuário etc.",
                "choose_logo": "Escolha a logomarca",
                "date_format": "Formato de Data",
                "time_format": "Formato de Horário",
                "go_to_settings": "Go to settings",
                "privacy_policy_info": "Se você não possui política de privacidade, pode configurar uma aqui, veja a política de privacidade no seguinte URL: {url}",
                "phones": {
                    "require_calling_prefix": "Exigir prefixo de chamada em números de telefone",
                    "require_calling_prefix_info": "A maioria das integrações de chamadas exige que os números de telefone estejam no formato E.164. A ativação dessa opção garantirá que nenhum número de telefone seja inserido sem um prefixo de chamada específico do país."
                },
                "recaptcha": {
                    "recaptcha": "reCaptcha",
                    "site_key": "Chave do Site",
                    "secret_key": "Chave Secreta",
                    "ignored_ips": "Endereços IP Ignorados",
                    "ignored_ips_info": "Digite os endereços IP separados por vírgula que você deseja que o reCaptcha ignore a validação.",
                    "dont_get_locked": "Don't get locked",
                    "ensure_recaptcha_works": "To ensure the reCaptcha configuration works well, always perform a test login via Incognito Mode while keeping the current window active."
                },
                "security": {
                    "security": "Segurança",
                    "disable_password_forgot": "Desativar recurso de esquecimento de senha",
                    "disable_password_forgot_info": "Quando ativado, o recurso de senha esquecida será desativado.",
                    "block_bad_visitors": "Bloquear visitantes ruins",
                    "block_bad_visitors_info": "Se ativado, uma lista de agentes de usuário, endereços IP e referenciadores inválidos será verificada para cada visitante convidado."
                },
                "tools": {
                    "tools": "Ferramentas",
                    "run": "Executar ferramenta",
                    "executed": "Ação executada com sucesso",
                    "clear-cache": "Limpar o cache do aplicativo",
                    "storage-link": "Crie um link simbólico de \"public/storage\" para \"storage/app/public\"",
                    "optimize": "Armazene em cache os arquivos de inicialização do aplicativo, como configuração e rotas.",
                    "seed-mailable-templates": "Distribua os modelos de e-mail do aplicativo"
                }
            },
            "table": {
                "default_sort": "Classificação Padrão",
                "per_page": "Por Página",
                "columns": "Colunas",
                "wrap_column": "Wrap Column",
                "primary_column": "Coluna Primária",
                "empty": "Sem dados disponíveis na tabela",
                "info": "Mostrando de {from} a {to} de {total} entradas",
                "previous": "Anterior",
                "next": "Próximo",
                "max_height": "Altura Máxima",
                "max_height_info": "Especificar a altura máxima da tabela garante que os cabeçalhos da tabela sejam fixados na parte superior durante a rolagem.",
                "list_settings": "Configurações da lista",
                "customize_list_view": "Personalizar a exibição de lista",
                "condensed": "Tabela Condensada",
                "bordered": "Bordered Table",
                "enable_polling": "Enable Polling",
                "polling_info": "The interval in seconds at which should poll for new records.",
                "length_menu": {
                    "show": "Mostrar",
                    "entries": "entradas"
                }
            },
            "tags": {
                "tags": "Tags",
                "search": "Search Tags",
                "add_new": "Add new tag",
                "tag_name": "Tag Name",
                "color": "Color",
                "edit_tag": "Edit Tag",
                "new_tag": "New Tag",
                "validation": {
                    "coma": "Comas are not allowed in tag names."
                }
            },
            "timeline": {
                "pin": "Fixar no topo",
                "unpin": "Soltar do topo",
                "updated": "Os dados foram atualizados",
                "association_restored": "A associação {associationDisplayName} foi restaurada da lixeira por {user}",
                "association_permanently_deleted": "A associação {associationDisplayName} foi excluída permanentemente",
                "deleted": "O registro foi excluído por {causer}.",
                "restored": "O registro foi restaurado da lixeira por {causer}.",
                "created": "O registro foi criado por {causer}.",
                "imported": "The record has been imported by {causer}",
                "attached": "{user} associado",
                "detached": "{user} desassociado",
                "associate_trashed": "O registro associado {displayName} foi movido para a lixeira por {user}."
            },
            "update": {
                "system": "Atualização do Sistema",
                "update": "Atualizar",
                "perform": "Realizar Atualização",
                "installed_version": "Versão Instalada",
                "latest_version": "Última Versão",
                "not_available": "Nenhuma nova versão disponível.",
                "using_latest_version": "Você está usando a última versão.",
                "update_in_progress": "Atualização em progresso...",
                "patches": "Correções",
                "patch_applied": "Aplicada",
                "apply_oldest_first": "Você deve aplicar as correções mais antigas primeiro.",
                "no_patches": "Nenhuma correção disponível para sua versão, volte mais tarde.",
                "update_zip_is_required": "Para usar o recurso de atualização com 1 clique, você precisará habilitar a extensão \"zip\" do PHP.",
                "patch_zip_is_required": "Para aplicar patches, você precisará habilitar a extensão \"zip\" do PHP.",
                "auto_apply_patches": "Automatically apply new patches"
            },
            "workflow": {
                "create": "Criar Workflow",
                "workflows": "Workflows",
                "title": "Título",
                "description": "Descrição",
                "created": "Workflow criado com sucesso.",
                "updated": "Workflow atualizado com sucesso.",
                "deleted": "Workflow excluído com sucesso.",
                "when": "Quando",
                "then": "Então",
                "field_change_to": "Para",
                "total_executions": "Execuções: {total}",
                "info": "A ferramenta de fluxos de trabalho automatiza seus processos de vendas. Os processos internos que podem ser automatizados incluem a criação de atividades, envio de e-mails, acionamento de solicitações HTTP, etc.",
                "validation": {
                    "invalid_webhook_url": "O URL do webhook não deve começar com \"https://\" ou \"http://\""
                },
                "actions": {
                    "webhook": "Acionar Webhook",
                    "webhook_url_info": "Deve ser um URL completo, válido e acessível publicamente."
                },
                "fields": {
                    "with_header_name": "Com o nome do cabeçalho (opcional)",
                    "with_header_value": "Com valor de cabeçalho (opcional)",
                    "for_owner": "Para: Proprietário (Responsável)",
                    "dates": {
                        "now": "Com data de vencimento: no momento",
                        "in_1_day": "Com data de vencimento: em um dia",
                        "in_2_days": "Com data de vencimento: em dois dias",
                        "in_3_days": "Com data de vencimento: em três dias",
                        "in_4_days": "Com data de vencimento: em quatro dias",
                        "in_5_days": "Com data de vencimento: em cinco dias"
                    }
                }
            }
        }
    },
    "ru": {
        "auth": {
            "failed": "Данные не соответствуют нашим записям.",
            "password": "Пароль",
            "throttle": "Слишком много попыток входа. Пожалуйста, повторите попытку через {seconds} seconds.",
            "current_password": "Текущий пароль",
            "logout": "Выход",
            "login": "Войти",
            "login_subheading": "Продуктивного рабочего дня!",
            "forgot_password": "Забыли пароль?",
            "email_address": "E-Mail",
            "confirm_password": "Подтвердить пароль",
            "new_password": "Новый пароль",
            "change_password": "Изменить пароль",
            "remember_me": "Запомнить пароль?",
            "signing_in": "Вход в систему...",
            "sign_in_heading": "Войдите в систему"
        },
        "pagination": {
            "previous": "Предыдущая",
            "next": "Следующая"
        },
        "passwords": {
            "reset": "Ваш пароль был сброшен!",
            "sent": "Мы отправили вам по электронной почте ссылку для сброса пароля!",
            "throttled": "Пожалуйста, подождите, прежде чем повторить попытку.",
            "token": "Этот токен сброса пароля недействителен.",
            "user": "Мы не можем найти пользователя с таким адресом электронной почты.",
            "reset_password": "Сброс пароля",
            "send_password_reset_link": "Отправить ссылку для сброса пароля"
        },
        "validation": {
            "accepted": "{attribute} должен быть принят.",
            "accepted_if": "{attribute} должен быть принят, когда {other} равно {value}.",
            "active_url": "{attribute} не является допустимым URL.",
            "after": "{attribute} должен быть датой после {date}.",
            "after_or_equal": "{attribute} должен быть датой после {date} или равным ей.",
            "alpha": "{attribute} должен содержать только буквы.",
            "alpha_dash": "{attribute} должен содержать только буквы, цифры, дефисы и символы подчеркивания.",
            "alpha_num": "{attribute} должен содержать только буквы и цифры.",
            "array": "{attribute} должен быть массивом.",
            "ascii": "The {attribute} field must only contain single-byte alphanumeric characters and symbols.",
            "before": "{attribute} должен быть датой до {date}.",
            "before_or_equal": "{attribute} должен быть датой, предшествующей {date} или равной ей.",
            "between": {
                "array": "{attribute} должен иметь элементы от {min} до {max}.",
                "file": "{attribute} должен быть между {min} и {max} килобайтами.",
                "numeric": "{attribute} должен быть между {min} и {max}.",
                "string": "{attribute} должен находиться между символами {min} и {max}."
            },
            "boolean": "Поле {attribute} должно быть истинным или ложным.",
            "can": "The {attribute} field contains an unauthorized value.",
            "confirmed": "Подтверждение {attribute} не совпадает.",
            "current_password": "Неправильный пароль.",
            "date": "{attribute} не является действительной датой.",
            "date_equals": "{attribute} должен быть датой, равной {date}.",
            "date_format": "{attribute} не соответствует формату {format}.",
            "decimal": "{attribute} должен иметь десятичные разряды {decimal}.",
            "declined": "{attribute} должен быть отклонен.",
            "declined_if": "{attribute} должен быть отклонен, если {other} равно {value}.",
            "different": "{attribute} и {other} должны быть разными.",
            "digits": "{attribute} должен быть {digits} цифры.",
            "digits_between": "{attribute} должен быть между цифрами {min} и {max}.",
            "dimensions": "{attribute} имеет недопустимые размеры изображения.",
            "distinct": "Поле {attribute} имеет повторяющееся значение.",
            "doesnt_end_with": "{attribute} не может заканчиваться одним из следующих: {values}.",
            "doesnt_start_with": "{attribute} не может начинаться с одного из следующих: {values}.",
            "email": "{attribute} должен быть действительным адресом электронной почты.",
            "ends_with": "{attribute} должен заканчиваться одним из следующих: {values}.",
            "enum": "Выбранный {attribute} недействителен.",
            "exists": "Выбранный {attribute} недействителен.",
            "extensions": "The {attribute} field must have one of the following extensions: {values}.",
            "file": "{attribute} должен быть файлом.",
            "filled": "Поле {attribute} должно иметь значение.",
            "gt": {
                "array": "{attribute} должен иметь больше, чем {value} элементов.",
                "file": "{attribute} должен быть больше {value} килобайт.",
                "numeric": "{attribute} должен быть больше {value}.",
                "string": "{attribute} должен быть больше символов {value}."
            },
            "gte": {
                "array": "{attribute} должен иметь элементы {value} или более.",
                "file": "{attribute} должен быть больше или равен {value} килобайтам.",
                "numeric": "{attribute} должен быть больше или равен {value}.",
                "string": "{attribute} должен быть больше или равен {value} символов."
            },
            "hex_color": "The {attribute} field must be a valid hexadecimal color.",
            "image": "{attribute} должен быть изображением.",
            "in": "Выбранный {attribute} недействителен.",
            "in_array": "Поле {attribute} не существует в {other}.",
            "integer": "{attribute} должен быть целым числом.",
            "ip": "{attribute} должен быть действительным IP-адресом.",
            "ipv4": "{attribute} должен быть действительным адресом IPv4.",
            "ipv6": "{attribute} должен быть действительным адресом IPv6.",
            "json": "{attribute} должен быть допустимой строкой JSON.",
            "lowercase": "The {attribute} field must be lowercase.",
            "lt": {
                "array": "Элемент {attribute} должен содержать меньше элементов {value}.",
                "file": "Размер {attribute} должен быть меньше {value} килобайт.",
                "numeric": "{attribute} должен быть меньше {value}.",
                "string": "{attribute} должен быть меньше символов {value}."
            },
            "lte": {
                "array": "{attribute} не должен содержать более {value} элементов.",
                "file": "{attribute} должен быть меньше или равен {value} килобайтам.",
                "numeric": "{attribute} должен быть меньше или равен {value}.",
                "string": "{attribute} должен быть меньше или равен {value} символов."
            },
            "mac_address": "{attribute} должен быть действительным MAC-адресом.",
            "max": {
                "array": "{attribute} не должен содержать более {max} элементов.",
                "file": "{attribute} не должен превышать {max} килобайт.",
                "numeric": "{attribute} не должен быть больше {max}.",
                "string": "{attribute} не должен превышать {max} символов."
            },
            "max_digits": "The {attribute} field must not have more than {max} digits.",
            "mimes": "{attribute} должен быть файлом типа: {values}.",
            "mimetypes": "{attribute} должен быть файлом типа: {values}.",
            "min": {
                "array": "{attribute} должен иметь как минимум {min} элементов.",
                "file": "Размер {attribute} должен быть не менее {min} килобайт.",
                "numeric": "{attribute} должен быть как минимум {min}.",
                "string": "{attribute} должен содержать не менее {min} символов."
            },
            "min_digits": "The {attribute} field must have at least {min} digits.",
            "missing": "The {attribute} field must be missing.",
            "missing_if": "The {attribute} field must be missing when {other} is {value}.",
            "missing_unless": "The {attribute} field must be missing unless {other} is {value}.",
            "missing_with": "The {attribute} field must be missing when {values} is present.",
            "missing_with_all": "The {attribute} field must be missing when {values} are present.",
            "multiple_of": "{attribute} должен быть кратен {value}.",
            "not_in": "Выбранный {attribute} недействителен.",
            "not_regex": "Недопустимый формат {attribute}.",
            "numeric": "{attribute} должен быть числом.",
            "password": "Неправильный пароль.",
            "present": "Поле {attribute} должно присутствовать.",
            "present_if": "The {attribute} field must be present when {other} is {value}.",
            "present_unless": "The {attribute} field must be present unless {other} is {value}.",
            "present_with": "The {attribute} field must be present when {values} is present.",
            "present_with_all": "The {attribute} field must be present when {values} are present.",
            "prohibited": "Поле {attribute} запрещено.",
            "prohibited_if": "Поле {attribute} запрещено, когда {other} равно {value}.",
            "prohibited_unless": "Поле {attribute} запрещено, если только {other} не находится в {values}.",
            "prohibits": "Поле {attribute} запрещает присутствие {other}.",
            "regex": "Недопустимый формат {attribute}.",
            "required": "Поле {attribute} является обязательным.",
            "required_array_keys": "Поле {attribute} должно содержать записи для: {values}.",
            "required_if": "Поле {attribute} является обязательным, если {other} равно {value}.",
            "required_if_accepted": "The {attribute} field is required when {other} is accepted.",
            "required_unless": "Поле {attribute} является обязательным, если только {other} не находится в {values}.",
            "required_with": "Поле {attribute} обязательно, когда присутствует {values}.",
            "required_with_all": "Поле {attribute} обязательно, когда присутствуют {values}.",
            "required_without": "Поле {attribute} является обязательным, если {values} отсутствует.",
            "required_without_all": "Поле {attribute} является обязательным, если ни одно из значений {value} не присутствует.",
            "same": "{attribute} и {other} должны совпадать.",
            "size": {
                "array": "{attribute} должен содержать элементы {size}.",
                "file": "{attribute} должен быть {size} килобайт.",
                "numeric": "{attribute} должен быть {size}.",
                "string": "{attribute} должен состоять из символов {size}."
            },
            "starts_with": "{attribute} должен начинаться с одного из следующих: {values}.",
            "string": "{attribute} должен быть строкой.",
            "timezone": "{attribute} должен быть действительным часовым поясом.",
            "unique": "{attribute} уже занят.",
            "uploaded": "Не удалось загрузить {attribute}.",
            "uppercase": "The {attribute} field must be uppercase.",
            "url": "{attribute} должен быть допустимым URL.",
            "ulid": "The {attribute} field must be a valid ULID.",
            "uuid": "{attribute} должен быть допустимым UUID.",
            "recaptcha": "Проверка ReCaptcha не удалась.",
            "numeric_field": "{attribute} не является допустимым числом, введите допустимое число, например 1200, 1200,00 или 1200,255.",
            "calling_prefix": "{attribute} должен начинаться с действительного телефонного кода страны, например: +7.",
            "required_file": "Пожалуйста, добавьте файл.",
            "invalid_options": "The provided option \"{options}\" is invalid.|The provided options \"{options}\" are invalid.",
            "custom": {
                "notifications.*.email": "Enter valid email address.",
                "notifications.*.filled": "Enter email address.",
                "_privacy-policy.accepted": "You must accept the privacy policy",
                "notifications": {
                    "*": {
                        "email": "Введите действующий адрес электронной почты."
                    }
                },
                "_privacy-policy": {
                    "accepted": "Вы должны принять политику конфиденциальности"
                }
            },
            "import": {
                "user": {
                    "invalid": "Вы указали несуществующего пользователя. Вы должны добавить идентификатор пользователя или полное имя пользователя."
                }
            },
            "attributes": [],
            "required_without_label": "Пожалуйста, заполните это обязательное поле.",
            "number": "{attribute} должен быть числом."
        },
        "activities": {
            "activity": {
                "activities": "Задачи",
                "activity": "Задача",
                "add": "Создать задачу",
                "description": "Описание",
                "description_info": "Описание доступно всем",
                "note": "Примечание",
                "note_info": "Примечания являются конфиденциальными и видны только менеджерам",
                "title": "Название",
                "due_date": "Срок закрытия",
                "end_date": "Дата окончания",
                "create": "Создать задачу",
                "download_ics": "Скачать файл .ics",
                "created": "Задача успешно создана",
                "updated": "Задача успешно изменена",
                "deleted": "Задача успешно удалена",
                "export": "Экспорт задач",
                "import": "Импорт задач",
                "guests": "Гости",
                "guest": "Гость",
                "count_guests": "1 гость | {count} гостя",
                "create_follow_up_task": "Создать связанную задачу",
                "follow_up_with_title": "Связать с {with}",
                "title_via_create_message": "Связана с письмом: {subject}",
                "reminder_update_info": "Поскольку напоминание для это1 задачи уже отправлено, вам нужно будет обновить дату выполнения, чтобы новое напоминание было помещено в очередь.",
                "owner_assigned_date": "Дата, назначенная ответственным",
                "reminder_sent_date": "Дата отправки напоминания",
                "reminder": "Напоминание",
                "owner": "Ответственный",
                "mark_as_completed": "Отметить как Выполненная",
                "mark_as_incomplete": "Отметить как Незавершенная",
                "is_completed": "Завершено",
                "completed_at": "Завершено в",
                "overdue": "Просроченная",
                "doesnt_have_activities": "Нет задач",
                "count": "Нет задач | 1 задача | {count} задачи",
                "incomplete_activities": "Незавершенные задачи",
                "activity_was_due": "Задача должна быть закрыта {date}",
                "next_activity_date": "Следующая дата задачи",
                "next_activity_date_info": "Это поле доступно только для чтения и автоматически обновляется на основе записи предстоящих действий, указывает, когда менеджеру следует предпринять следующее действие.",
                "cards": {
                    "my_activities": "Мои задачи",
                    "my_activities_info": "Эти карточки отражают действия, которые вы добавили в качестве ответственного",
                    "created_by_agent": "Задачи, созданные менеджером",
                    "created_by_agent_info": "Просмотрите количество действий, созданных каждым менеджером. Посмотрите, кто создает больше всего активности, а кто - меньше всего.",
                    "upcoming": "Предстоящие задачи",
                    "upcoming_info": "Эта карточка отражает предстоящие ваши задачи и задачи, на которых вас отметили"
                },
                "type": {
                    "default_type": "Тип задачи по умолчанию",
                    "delete_primary_warning": "Вы не можете удалить тип задачи по умолчанию",
                    "delete_usage_warning": "Этот тип уже связан с задачами, поэтому, не может быть удален.",
                    "delete_usage_calendars_warning": "Этот тип используется по умолчанию при создании задач через подключенные календари, поэтому, не может быть удален.",
                    "delete_is_default": "Это тип задачи стоит по умолчанию, поэтому, он не может быть удален.",
                    "type": "Тип задачи",
                    "types": "Типы задач",
                    "name": "Имя",
                    "icon": "Иконка"
                },
                "filters": {
                    "activity_type_disabled": "Тип задачи используется в текущем фильтре, поэтому, вы не можете выбрать тип задачи в этом разделе",
                    "open": "Открытые задачи",
                    "due_today": "Дата закрытия сегодня",
                    "due_this_week": "Дата закрытия эта неделя",
                    "display": {
                        "has": "есть задачи {value}:",
                        "overdue": "есть {value}: задачи",
                        "doesnt_have_activities": "нет открытых задач"
                    },
                    "all": "Все",
                    "today": "Сегодня",
                    "tomorrow": "Завтра",
                    "this_week": "Эта неделя",
                    "next_week": "Следующая неделя",
                    "done": "Закрытые",
                    "done_empty_state": "Выполненные задачи будут показаны здесь."
                },
                "settings": {
                    "send_contact_email": "Отправил контактам шаблон письма \"Контакт следит за активностью\"",
                    "send_contact_email_info": "Если включено, то при добавлении контакта в качестве гостя в задачу будет отправлен шаблон электронного письма  с прикрепленным файлом .ics и информацией о задачи."
                },
                "manage_activities": "Управление задачами",
                "info": "Планируйте и управляйте задачами с контактами и менеджерами.",
                "timeline": {
                    "heading": "Задача была создана"
                },
                "permissions": {
                    "attends_and_owned": "Посещает и принадлежит только"
                },
                "actions": {
                    "update_type": "Изменить тип"
                },
                "notifications": {
                    "due": "Ваша {activity} задача должна быть закрыта {date}",
                    "assigned": "Вам пришла задача {name} от {user}",
                    "added_as_guest": "Вы были добавлены в качестве гостя к задаче"
                },
                "mail_placeholders": {
                    "assigneer": "Пользователь, который поставил задачу"
                },
                "validation": {
                    "end_date": {
                        "less_than_due": "Дата окончания не должна быть меньше даты выполнения."
                    },
                    "end_time": {
                        "required_when_end_date_is_in_future": "Вы должны указать время окончания, если дата окончания приходится на другой день."
                    }
                },
                "workflows": {
                    "actions": {
                        "create": "Создать задачу"
                    },
                    "fields": {
                        "create": {
                            "title": "С названием задачи",
                            "note": "Добавить примечание (необязательно)"
                        }
                    }
                },
                "metrics": {
                    "todays": "Сегодняшние задачи"
                },
                "empty_state": {
                    "title": "Вы не создавали задачи",
                    "description": "Создайте новую задачу"
                }
            },
            "calendar": {
                "calendar": "Календарь",
                "calendar_sync": "Синхронизация календаря",
                "reconfigure": "Переконфигурировать",
                "choose_oauth_account": "Выберите тип учетной записи, чтобы начать синхронизацию событий календаря",
                "account_being_connected": "Вы собираетесь подключиться к {email}",
                "save_events_as": "Сохранить событие календаря как:",
                "sync_activity_types": "Синхронизируйте следующие типы задач с календарем:",
                "sync_support_only_primary": "Синхронизировать можно только основной календарь учетной записи.",
                "only_future_events_will_be_synced": "Будут синхронизированы только будущие события.",
                "events_will_sync_from": "События, созданные с {date}, будут синхронизированы.",
                "events_being_synced_from": "События, созданные с {date}, были синхронизированы.",
                "missing_outlook_integration": "Приложение Microsoft не настроено, необходимо настроить приложение Microsoft для синхронизации календаря Outlook.",
                "missing_google_integration": "Проект приложения Google не настроен, необходимо настроить проект приложения Google, чтобы подключиться к синхронизации календаря Google.",
                "timeline": {
                    "imported_via_calendar_attendee": "Контакт импортирован через календарь {user}, так как был добавлен в качестве участника мероприятия."
                },
                "fullcalendar": {
                    "locale": {
                        "buttonText": {
                            "prev": "Предыдущий период",
                            "next": "Следующий период",
                            "prevYear": "Предыдущий год",
                            "nextYear": "Следующий год",
                            "year": "год",
                            "today": "Сегодня",
                            "month": "Месяй",
                            "week": "Неделя",
                            "day": "День",
                            "list": "Список"
                        },
                        "weekText": "Н",
                        "allDayText": "Все дни",
                        "moreLinkText": "больше",
                        "noEventsText": "Нет задач для показа"
                    }
                }
            }
        },
        "billable": {
            "billable": {
                "total": "Итого",
                "sub_total": "Подытог",
                "includes_discount": "включает скидку {amount}",
                "tax_amount_is_inclusive": "вкл.",
                "tax_types": {
                    "inclusive": "С учетом налогов",
                    "exclusive": "Без учета налогов",
                    "no_tax": "Без налога"
                }
            },
            "product": {
                "products": "Товары",
                "product": "Товар",
                "create": "Создать товар",
                "edit": "Изменить товар",
                "export": "Экспорт товаров",
                "import": "Импорт товаров",
                "created": "Товар успешно создан",
                "updated": "Товар успешно изменен",
                "deleted": "Товар успешно удален",
                "related_products": "Связанные товары",
                "manage": "Управление товарами",
                "name": "Название",
                "description": "Описание",
                "table_heading": "Товар",
                "tax": "Налог",
                "quantity": "Количество",
                "qty": "КОЛ-ВО",
                "unit_price": "Цена за 1 единицу",
                "direct_cost": "Стоимость от поставщика",
                "unit": "Единица (м2, п.м.)",
                "sku": "Артикул",
                "is_active": "Активный",
                "tax_rate": "Ставка налога",
                "tax_label": "Налоговая этикетка",
                "tax_percent": "Налоговый процент",
                "discount": "Скидка",
                "amount": "Сумма",
                "discount_percent": "Процент скидки",
                "discount_amount": "Сумма скидки",
                "will_be_added_as_new": "{name} будет добавлено как новый товар",
                "total_products": "Всего товаров",
                "total_sold": "Всего продано",
                "sold_amount_exc_tax": "Сумма продажи (без учета налогов)",
                "interest_in_product": "Интерес к товару",
                "resource_has_no_products": "Товары не созданы, начните с добавления товаров",
                "exists_in_trash_by_name": "Товар с таким названием уже находится в корзине. Восстановить удаленный товар?",
                "choose_or_enter": "Выберите или введите товар",
                "cards": {
                    "performance": "Характеристика товара",
                    "performance_info": "Столбец «Интерес к товару» отражает все товары, добавленные к сделкам, а столбец «Всего продано» отражает товары, добавленные к сделкам, и сделки отмечены как завершенные."
                },
                "count": "0 товаров | 1 товар | {count} товара",
                "settings": {
                    "default_tax_type": "Вы продаете свою продукцию по ставкам, включающим налог?",
                    "default_discount_type": "Тип скидки по умолчанию"
                },
                "actions": {
                    "mark_as_active": "Отметить как активный",
                    "mark_as_inactive": "Отметить как неактивный",
                    "update_unit_price": "Обновить цену",
                    "update_tax_rate": "Обновить налоговую ставку",
                    "update_tax_label": "Обновить налоговую метку"
                },
                "validation": {
                    "sku": {
                        "unique": "Товар с таким артикулом уже существует."
                    }
                },
                "empty_state": {
                    "title": "Вы не создали ни одного товара.",
                    "description": "Экономьте время, используя предустановленные товары."
                }
            }
        },
        "brands": {
            "brand": {
                "brand": "Компания",
                "brands": "Компании",
                "create": "Создать компанию",
                "update": "Обновить компанию",
                "form": {
                    "sections": {
                        "general": "Основная",
                        "navigation": "Навигация",
                        "email": "Email",
                        "thank_you": "Спасибо",
                        "signature": "Подпись",
                        "pdf": "PDF"
                    },
                    "is_default": "Это компания по умолчанию?",
                    "name": "Как вы относитесь к этой компании внутри организации?",
                    "display_name": "Как вы хотите, чтобы это отображалось для ваших клиентов?",
                    "primary_color": "Выберите основной цвет компании",
                    "upload_logo": "Загрузите логотип вашей компании",
                    "navigation": {
                        "background_color": "Цвет фона навигации",
                        "upload_logo_info": "Если у вас темный фон, используйте светлый логотип. Если вы используете светлый цвет фона, используйте логотип с темным текстом."
                    },
                    "pdf": {
                        "default_font": "Семейство шрифтов по умолчанию",
                        "default_font_info": "Шрифт {fontName} обеспечивает наиболее приличное покрытие символов Unicode по умолчанию, обязательно выберите правильный шрифт, если специальные символы или символы Unicode не отображаются должным образом в документе PDF.",
                        "size": "Размер",
                        "orientation": "Ориентация",
                        "orientation_portrait": "Книжный",
                        "orientation_landscape": "Альбомный"
                    },
                    "email": {
                        "upload_logo_info": "Убедитесь, что логотип подходит для белого фона, если логотип не загружен, вместо него будет использоваться темный логотип, загруженный в общих настройках."
                    },
                    "document": {
                        "send": {
                            "info": "Когда вы отправляете документ",
                            "subject": "Тема по умолчанию",
                            "message": "Сообщение электронной почты по умолчанию при отправке документа",
                            "button_text": "Текст кнопки электронной почты"
                        },
                        "sign": {
                            "info": "Когда кто-то подписывает ваш документ",
                            "subject": "Строка темы по умолчанию для благодарственного письма",
                            "message": "Сообщение электронной почты для отправки, когда кто-то подписывает ваш документ",
                            "after_sign_message": "Что должно быть в сообщении после подписания?"
                        },
                        "accept": {
                            "after_accept_message": "Что должно быть в сообщении после принятия (без ЭЦП)?"
                        }
                    },
                    "signature": {
                        "bound_text": "Юридический связанный текст"
                    }
                },
                "delete_documents_usage_warning": "Компания уже связана с документами, поэтому ее нельзя удалить.",
                "created": "Компания успешно создана.",
                "updated": "Компания успешно изменена.",
                "deleted": "Компания успешно удалена."
            }
        },
        "calls": {
            "call": {
                "calls": "Звонки",
                "call": "Call",
                "add": "История звонков",
                "make": "Позвонить",
                "log": "Кратко о результатах звонка...",
                "manage_calls": "Управление звонками",
                "total_calls": "Всего звонков",
                "activate_voip": "Activate",
                "voip_activated": "Activated",
                "info": "Вы можете записывать свои звонки и звонки вашей команды, а также отслеживать все совершенные взаимодействия.",
                "info_created": "{user} записал вызов {date}",
                "follow_up_task_body": "Относительно журнала вызовов: {content}",
                "created": "Звонок успешно записан",
                "updated": "Звонок успешно изменен",
                "deleted": "Звонок успешно удален",
                "date": "Дата звонка",
                "read_outcome": "Read Outcome",
                "outcome": {
                    "outcomes": "Результаты звонков",
                    "outcome": "Результат",
                    "call_outcome": "Результаты звонка",
                    "select_outcome": "Выберите результат",
                    "delete_warning": "Результат вызова уже связан с вызовами, поэтому его нельзя удалить.",
                    "name": "Имя"
                },
                "no_voip_permissions": "Ваша учетная запись не авторизована для совершения звонков",
                "voip_permissions": "VoIP-звонки",
                "new_from": "Новый звонок от {number}",
                "connected_with": "Соединение с {number}",
                "ended": "Вызов закончен {number}",
                "speaker_volume": "Громкость динамика",
                "mic_volume": "Громкость микрофона",
                "mute": "Беззвучный режим",
                "unmute": "Включить звук",
                "answer": "Ответить на звонок",
                "hangup": "Сбросить вызов",
                "reject": "Отклонить вызов",
                "unknown_devices": "Видите неизвестные устройства?",
                "hide_bar": "Скрыть эту панель",
                "activation_required": "Calling feature activation required",
                "activation_gesture_required": "Most browsers require user gesture (click) to activate calling feature\n        like audio and microphone. This is handled on your first click when you\n        enter your dashboard, since, you did not click anything in\n        {askForActivationIn} minute, we ask you to activate the calling\n        functionality by clicking below.",
                "cards": {
                    "by_day": "Записанные звонки по дням",
                    "by_sale_agent": "Всего записанных звонков менеджеров",
                    "logged_calls": "Logged calls",
                    "outcome_overview": "Обзор результатов звонка"
                },
                "workflows": {
                    "triggers": {
                        "logged": "Вызов записан",
                        "missed_incoming_call": "Пропущенный входящий вызов"
                    }
                },
                "timeline": {
                    "heading": "Зарегистрирован новый вызов"
                },
                "capabilities": {
                    "use_voip": "Совершать и отвечать на звонки"
                }
            },
            "twilio": {
                "create_app": "Создать приложение",
                "disconnect": "Отключить интеграцию",
                "number": "Выберите номер Twilio в своей учетной записи, который будет использоваться для совершения и приема вызовов.",
                "retrieve_numbers": "Retrieve Numbers",
                "app": "Создайте приложение, которое будет обрабатывать инициирование новых вызовов и входящие вызовы."
            }
        },
        "comments": {
            "comment": {
                "add": "Добавить комментарий",
                "comments": "Комментарии",
                "reply": "Ответить",
                "created": "Комментарий успешно добавлен",
                "updated": "Комментарий успешно изменен",
                "user_left_comment": "{user} оставил комментарий",
                "total": "Комментарии ({total})",
                "no_comments": "Нет комментариев",
                "add_placeholder": "Напишите новый комментарий, отправьте уведомление своей команде, набрав {'@'}, а затем их имя."
            }
        },
        "contacts": {
            "company": {
                "company": "Компания",
                "companies": "Компании",
                "add": "Добавить компанию",
                "dissociate": "Отвязать компанию",
                "child": "Дочерняя компания | Дочерние компании",
                "create": "Создать компанию",
                "export": "Экспорт компаний",
                "total": "Всего компаний",
                "import": "Импорт компаний",
                "create_with": "Создать компанию с {name}",
                "associate_with": "Связать компанию с {name}",
                "associate_field_info": "Используйте это поле, чтобы найти и связать существующую компанию вместо создания новой.",
                "no_contacts_associated": "Компания не имеет связанных контактов.",
                "no_deals_associated": "Компания не имеет связанных сделок.",
                "exists_in_trash_by_email": "Компания с таким адресом электронной почты уже существует в корзине, вы не сможете создать новую компанию с таким же адресом электронной почты, вы хотите восстановить удаленную компанию?",
                "exists_in_trash_by_name": "Компания с таким названием уже существует в корзине, восстановить удаленную компанию?",
                "exists_in_trash_by_phone": "Компания ({company}) со следующими номерами: {phone_numbers}, уже есть в корзине, восстановить удаленную компанию?",
                "possible_duplicate": "Возможный дубликат компании {display_name}.",
                "count": {
                    "all": "1 компания | {count} компании"
                },
                "notifications": {
                    "assigned": "Вы были назначены компании {name} пользователем {user}"
                },
                "cards": {
                    "by_source": "Компании по источнику",
                    "by_day": "Компании по дням"
                },
                "settings": {
                    "automatically_associate_with_contacts": "Автоматически создавать и связывать компании с контактами",
                    "automatically_associate_with_contacts_info": "Автоматически связывайте контакты с компаниями на основе контактного адреса электронной почты и домена компании."
                },
                "industry": {
                    "industries": "Отрасли",
                    "industry": "Отрасль"
                },
                "filters": {
                    "my": "Мои компании",
                    "my_recently_assigned": "Мои недавно назначенные компании"
                },
                "mail_placeholders": {
                    "assigneer": "Имя пользователя, которому присвоена компания"
                },
                "workflows": {
                    "triggers": {
                        "created": "Компания создана"
                    },
                    "actions": {
                        "fields": {
                            "email_to_company": "Компания email",
                            "email_to_owner_email": "Компания ответственный email",
                            "email_to_creator_email": "Компания создать email",
                            "email_to_contact": "Компания основной контакт"
                        }
                    }
                },
                "validation": {
                    "email": {
                        "unique": "A company with this email already exist."
                    }
                },
                "empty_state": {
                    "title": "Вы не создали ни одной компании.",
                    "description": "Начните с создания новой компании."
                }
            },
            "contact": {
                "contact": "Контакт",
                "contacts": "Контакты",
                "convert": "Преобразовать в контакт",
                "create": "Создать контакт",
                "add": "Добавить контакт",
                "total": "Всего контактов",
                "import": "Импорт контактов",
                "export": "Экспорт контактов",
                "no_companies_associated": "Контакт не имеет связанных компаний.",
                "no_deals_associated": "Контакт не имеет связанных сделок.",
                "works_at": "{job_title} в {company}",
                "create_with": "Создать контакт с {name}",
                "associate_with": "Связать контакт с {name}",
                "associated_company": "Связанные с контактом компании",
                "dissociate": "Отвязать контакт",
                "exists_in_trash_by_email": "Контакт с этим адресом электронной почты уже существует в корзине, вы не сможете создать новый контакт с таким же адресом электронной почты, вы хотите восстановить удаленный контакт?",
                "exists_in_trash_by_phone": "Контакт ({contact}) со следующими номерами: {phone_numbers}, уже есть в корзине, восстановить удаленный контакт?",
                "possible_duplicate": "Возможен дубликат контакта {display_name}.",
                "associate_field_info": "Используйте это поле, чтобы найти и связать существующий контакт вместо создания нового.",
                "cards": {
                    "recently_created": "Недавно созданные контакты",
                    "recently_created_info": "Отображение последних {total} созданных контактов за последние {days} дней, отсортированных сверху по самым новым.",
                    "by_day": "Контакты по дням",
                    "by_source": "Контакты по источнику"
                },
                "count": {
                    "all": "1 контакт | {count} контакта"
                },
                "notifications": {
                    "assigned": "Вы были назначены контакту {name} пользователем {user}"
                },
                "filters": {
                    "my": "Мои контакты",
                    "my_recently_assigned": "Мои недавно назначенные контакты"
                },
                "mail_placeholders": {
                    "assigneer": "Имя пользователя, назначившего контакт"
                },
                "workflows": {
                    "triggers": {
                        "created": "Контакт создан"
                    },
                    "actions": {
                        "fields": {
                            "email_to_contact": "Контакт email",
                            "email_to_owner_email": "Контакт email ответственного",
                            "email_to_creator_email": "Контакт email создателя",
                            "email_to_company": "Контакт основная компания"
                        }
                    }
                },
                "validation": {
                    "email": {
                        "unique": "Контакт или член команды с таким адресом электронной почты уже существует."
                    },
                    "phone": {
                        "unique": "Контакт с таким номером телефона уже существует."
                    }
                },
                "empty_state": {
                    "title": "Вы не создали ни одного контакта.",
                    "description": "Начните организовывать людей сейчас."
                }
            },
            "fields": {
                "phone": {
                    "add": "+ Добавить еще",
                    "copied": "Номер телефона скопирован в буфер обмена",
                    "types": {
                        "type": "Тип",
                        "mobile": "Мобильный",
                        "work": "Рабочий",
                        "other": "Другой"
                    }
                },
                "contacts": {
                    "first_name": "Имя",
                    "last_name": "Фамилия",
                    "email": "E-Mail",
                    "job_title": "Должность",
                    "phone": "Телефон",
                    "street": "Улица",
                    "city": "Город",
                    "state": "Район",
                    "postal_code": "Индекс",
                    "owner_assigned_date": "Дата назначения ответственного",
                    "country": {
                        "name": "Страна"
                    },
                    "source": {
                        "name": "Источник"
                    },
                    "user": {
                        "name": "Ответственный"
                    }
                },
                "companies": {
                    "name": "Имя",
                    "email": "E-Mail",
                    "parent": {
                        "name": "Дочерняя компания"
                    },
                    "phone": "Телефон",
                    "street": "Улица",
                    "city": "Город",
                    "state": "Район",
                    "postal_code": "Индекс",
                    "domain": "Доменное имя компании",
                    "owner_assigned_date": "Дата назначения ответственного",
                    "country": {
                        "name": "Страна"
                    },
                    "industry": {
                        "name": "Отрасль"
                    },
                    "user": {
                        "name": "Ответственный"
                    },
                    "source": {
                        "name": "Источник"
                    }
                }
            },
            "source": {
                "source": "Источник",
                "sources": "Источники",
                "delete_primary_warning": "Вы не можете удалить первоисточник."
            }
        },
        "deals": {
            "board": {
                "board": "Доска",
                "columns_sorted": "Columns successfully sorted"
            },
            "deal": {
                "deal": "Сделка",
                "deals": "Сделки",
                "create": "Создать сделку",
                "add": "Добавить сделку",
                "sort_by": "Сортировать сделки по",
                "name": "Название сделки",
                "choose_or_create": "Выберите или создайте сделку",
                "associate_with": "Связать сделку с {name}",
                "add_products": "Добавить товары",
                "dont_add_products": "Не добавлять товары",
                "reopen": "Открыть заново",
                "won_date": "Дата завершения",
                "lost_date": "Дата потери",
                "status_related_filter_notice": "Это правило применимо в основном, когда фильтрация имеет дело со статусом \"{status}\".",
                "status": {
                    "status": "Статус",
                    "won": "Завершена",
                    "lost": "Потеряна",
                    "open": "Открыта"
                },
                "been_in_stage_time": "Был на стадии {time}",
                "hasnt_been_in_stage": "Эта сделка еще не была на этой стадии",
                "total_created": "Всего создано",
                "total_assigned": "Всего назначено",
                "import": "Импорт сделок",
                "export": "Экспорт сделок",
                "import_in": "Импорт сделок в {pipeline}",
                "total": "Всего сделок",
                "closed_deals": "Закрытые сделки",
                "won_deals": "Завершенные сделки",
                "open_deals": "Открытые сделки",
                "lost_deals": "Потерянные сделки",
                "forecast_amount": "Прогноз суммы",
                "closed_amount": "Закрытая сумма",
                "dissociate": "Отвязать сделку",
                "no_companies_associated": "Сделка не имеет связанных компаний.",
                "no_contacts_associated": "Сделка не имеет связанных контактов.",
                "associate_field_info": "Используйте это поле, чтобы связать существующую сделку вместо создания новой.",
                "create_with": "Создать сделку с {name}",
                "already_associated": "Эта сделка уже связана с {with}.",
                "lost_reasons": {
                    "lost_reason": "Причина потери",
                    "lost_reasons": "Причины потери",
                    "name": "Название",
                    "choose_lost_reason": "Выберите причину потери",
                    "choose_lost_reason_or_enter": "Выберите причину потери или введите вручную"
                },
                "settings": {
                    "lost_reason_is_required": "Укажите причину потери",
                    "lost_reason_is_required_info": "Когда эта функция включена, менеджеры должны будут выбрать или ввести причину потери при отметке сделки как потеряно.",
                    "allow_lost_reason_enter": "Разрешить менеджерам вводить пользовательскую причину потери",
                    "allow_lost_reason_enter_info": "Если этот параметр отключен, менеджеры смогут выбирать только из предопределенного списка причин потери при отметке сделки как потеряно."
                },
                "cards": {
                    "by_stage": "Сделки по стадиям",
                    "lost_in_stage": "Стадия потерянных сделок",
                    "lost_in_stage_info": "Посмотреть, на каком этапе сделки теряются больше всего. Стадии, показанные в отчетах, — это стадии, к которым принадлежала сделка на момент ее пометки как потеряно.",
                    "won_in_stage": "Этап завершенных сделок",
                    "won_in_stage_info": "Посмотреть, на каком этапе чаще всего закрывают сделки. Этапы, показанные в отчетах, — это этапы, к которым принадлежала сделка на момент ее пометки как завершена.",
                    "closing": "Закрытие сделок",
                    "closing_info": "Просмотрите сделки, закрытие которых прогнозируется на основе выбранного периода и ожидаемой даты закрытия, сделки, помеченные как «Завершено» или «Потеряно», исключаются из списка.",
                    "recently_created": "Недавно созданные сделки",
                    "recently_modified": "Недавно измененные сделки",
                    "won_by_revenue_by_month": "Доход от завершенных сделок по месяцам",
                    "won_by_date": "Завершенные сделки по дням",
                    "assigned_by_sale_agent": "Назначенные сделки менеджерами",
                    "assigned_by_sale_agent_info": "Просмотрите общее количество назначенных сделок для менеджера. Посмотрите, какой доход эти сделки могут принести вашему бизнесу. И сколько у вас уже есть выручки от закрытых сделок.",
                    "created_by_sale_agent": "Сделки, созданные мнеджерами",
                    "created_by_sale_agent_info": "Посмотрите, какие менеджеры заключают больше всего сделок. Посмотрите, какой доход эти сделки могут принести вашему бизнесу. И сколько у вас уже есть выручки от закрытых сделок.",
                    "recently_created_info": "Показаны последние {total} созданные сделки за последние {days} дней, отсортированные сверху по самым новым.",
                    "recently_modified_info": "Показаны последние {total} измененные сделки за последние {days} дней.",
                    "won_by_month": "Завершенные сделки по месяцам"
                },
                "notifications": {
                    "assigned": "Вы были назначены на сделку {name} пользователем {user}"
                },
                "stage": {
                    "weighted_value": "{weighted_total} - {win_probability} из {total}",
                    "changed_date": "Дата изменения стадии",
                    "add": "Добавить новую стадию",
                    "name": "Название стадии",
                    "win_probability": "Вероятность закрытия",
                    "delete_usage_warning": "Стадия уже связан со сделками, поэтому её нельзя удалить."
                },
                "deal_amount": "Сумма сделки",
                "deal_expected_close_date": "Ожидаемая дата закрытия сделки",
                "count": {
                    "all": "1 сделка | {count} сделки",
                    "open": "{resource} количество открытых сделок",
                    "won": "{resource} количество завершенных сделок",
                    "lost": "{resource} число потерянных сделок",
                    "closed": "{resource} количество закрытых сделок"
                },
                "pipeline": {
                    "name": "Название воронки",
                    "pipeline": "Воронка",
                    "pipelines": "Воронки",
                    "create": "Создать воронку",
                    "edit": "Изменить воронку",
                    "updated": "Воронка успешно обновлена",
                    "deleted": "Воронка успешно удалена",
                    "delete_primary_warning": "Вы не можете удалить основную воронку.",
                    "delete_usage_warning_deals": "Воронка уже связана со сделками, поэтому ее нельзя удалить.",
                    "visibility_group": {
                        "primary_restrictions": "Это основная воронка, поэтому видимость изменить нельзя."
                    },
                    "reorder": "Переупорядочить воронку",
                    "missing_stages": "The pipeline does not have any stages."
                },
                "actions": {
                    "change_stage": "Изменить стадию",
                    "mark_as_open": "Отметить как открытая",
                    "mark_as_won": "Отметить как завершенная",
                    "mark_as_lost": "Отметить как потерянная"
                },
                "filters": {
                    "my": "Мои сделки",
                    "my_recently_assigned": "Мои недавно назначенные сделки",
                    "created_this_month": "Сделки, созданные в этом месяце",
                    "won": "Закрытые сделки",
                    "lost": "Потерянные сделки",
                    "open": "Открытые сделки"
                },
                "mail_placeholders": {
                    "assigneer": "Имя пользователя, назначившего сделку"
                },
                "workflows": {
                    "triggers": {
                        "status_changed": "Статус сделки изменен",
                        "stage_changed": "Стадия сделки изменена",
                        "created": "Сделка создана"
                    },
                    "actions": {
                        "mark_associated_activities_as_complete": "Отметить связанные действия как выполненные",
                        "mark_associated_deals_as_won": "Отметить связанные сделки как завершенные",
                        "mark_associated_deals_as_lost": "Отметить связанные сделки как потерянные",
                        "delete_associated_activities": "Удалить связанные действия",
                        "fields": {
                            "email_to_contact": "Основное контактное лицо сделки",
                            "email_to_company": "Сделка с основной компанией",
                            "email_to_owner_email": "Электронная почта владельца сделки",
                            "email_to_creator_email": "Электронная почта создателя сделки",
                            "lost_reason": "Со следующей причиной потери"
                        }
                    }
                },
                "timeline": {
                    "stage": {
                        "moved": "{user} переместил сделку с {previous} на {stage} стадию"
                    },
                    "marked_as_lost": "{user} пометил сделку как потерянная по следующей причине: {reason}",
                    "marked_as_won": "{user} отметил сделку как завершенная",
                    "marked_as_open": "{user} отметил сделку как открытую"
                },
                "metrics": {
                    "open": "Открытые сделки"
                },
                "empty_state": {
                    "title": "Вы не создали ни одной сделки.",
                    "description": "Начните с создания новой сделки."
                }
            },
            "fields": {
                "deals": {
                    "name": "Название сделки",
                    "expected_close_date": "Дата договора",
                    "amount": "Бюджет",
                    "owner_assigned_date": "Дата назначения ответственного",
                    "user": {
                        "name": "Ответственный"
                    },
                    "stage": {
                        "name": "Стадия"
                    },
                    "pipeline": {
                        "name": "Воронка"
                    }
                }
            }
        },
        "documents": {
            "document": {
                "document": "Документ",
                "documents": "Документы",
                "create": "Создать документ",
                "info": "Отправляйте настраиваемые котировки, предложения и контракты, чтобы быстрее заключать сделки.",
                "view": "Просмотр",
                "manage_documents": "Управление документами",
                "total_documents": "Всего документов",
                "total_draft_documents": "Всего черновиков документов",
                "deleted": "Документ успешно удален",
                "document_details": "Сведения о документе",
                "document_activity": "Действия с документами",
                "document_products": "Товары в документе",
                "download_pdf": "Скачать PDF",
                "view_pdf": "Просмотр PDF в браузере",
                "accept": "Принять",
                "sign": "Подписать",
                "sent": "Документ успешно отправлен",
                "deal_description": "Когда сделка выбрана, сделка будет автоматически связана с документом, контакты сделки будут добавлены в качестве подписантов, а все продукты сделки будут добавлены в документ.",
                "settings": {
                    "inherits_setting_from_brand": "Inherits from brand"
                },
                "products_snippet_missing": "To ensure that the products appear in the document preview and PDF, make sure to add them to the content via the {icon} icon.",
                "signatures_snippet_missing": "To ensure that the signatures appear in the document PDF, make sure to add them to the content via the {icon} icon.",
                "will_use_placeholders_from_record": "Заполнители, добавленные в содержимое документа, связанное с ресурсом {resourceName}, будут взяты из этой записи.",
                "placeholders_replacement_info": "Заполнители документа, связанного с ресурсами, заменяются на основе первой связанной записи, обязательно добавьте связки в документ.",
                "limited_editing": "Этот документ принят, возможности редактирования ограничены.",
                "title": "Название",
                "copy_url": "Скопировать общедоступный URL-адрес документа",
                "url_copied": "URL скопирован в буфер обмена",
                "count": {
                    "all": "1 документ | {count} документа"
                },
                "sections": {
                    "details": "Детали",
                    "send": "Отправить",
                    "signature": "Подпись",
                    "content": "Контент",
                    "products": "Товары"
                },
                "status": {
                    "status": "Статус",
                    "draft": "Черновик",
                    "sent": "Отправил",
                    "accepted": "Принял",
                    "lost": "Потеряно"
                },
                "send": {
                    "select_brand": "Сначала выберите компанию, чтобы отправить документ.",
                    "connect_an_email_account": "Подключите учетную запись почты для отправки документов.",
                    "send_from_account": "Отправить документ из следующего аккаунта",
                    "save_to_schedule": "Чтобы запланировать отправку документа, вам необходимо сначала сохранить документ.",
                    "send_subject": "Тема сообщения",
                    "send_body": "Текст сообщения",
                    "send_later": "Отправить позже?",
                    "send": "Отправить документ",
                    "select_schedule_date": "Выберите дату и время",
                    "schedule": "Расписание",
                    "is_scheduled": "Отправка этого документа запланирована на {date}",
                    "send_to_signers": "Отправить документ следующим клиентам",
                    "send_to_signers_empty": "Чтобы отправить документ клиентам, добавьте клиентов через раздел «Подпись»."
                },
                "sent_by": "Отправлено от",
                "sent_at": "Отправлено {date}",
                "signers": {
                    "add": "Добавить нового клиента",
                    "no_signers": "Нет подписантов, добавьте клиента для этого документа.",
                    "is_signed": "Подписано?",
                    "document_signers": "Подписанты документов",
                    "signer_name": "Имя",
                    "signer_email": "E-Mail",
                    "signature_date": "Дата",
                    "name": "Имя подписанта",
                    "email": "Email подписанта",
                    "enter_full_name": "Введите полное имя клиента",
                    "enter_email": "Пожалуйста, введите Ваш адрес электронной почты",
                    "confirm_email": "Подтвердите Ваш электронный адрес"
                },
                "accepted_at": "Принято в",
                "signature": {
                    "no_signature": "Нет подписи",
                    "no_signature_description": "Этот документ не требует подписи перед принятием.",
                    "e_signature": "Использовать электронную подпись",
                    "e_signature_description": "Этот документ требует электронной подписи перед принятием.",
                    "signature": "Подпись",
                    "signatures": "Подписи",
                    "signed_on": "Подписано",
                    "sign_ip": "IP адрес",
                    "verification_failed": "We were unable to verify your email address as a signer, contact the person that sent you the document to give information about the email address that is used.",
                    "accept_name": "Чтобы принять, введите свое имя ниже"
                },
                "reactivated": "Документ повторно активирован",
                "marked_as_lost": "Документ успешно помечен как утерянный",
                "marked_as_accepted": "Документ успешно помечен как принятый",
                "actions": {
                    "mark_as_lost": "Отметить как потеряно",
                    "mark_as_lost_message": "Это действие пометит этот документ как утерянный, и ни один из получателей больше не сможет получить к нему доступ.",
                    "mark_as_accepted": "Отметить как принято",
                    "reactivate": "Повторно активировать",
                    "undo_acceptance": "Отменить принятие"
                },
                "cards": {
                    "by_type": "Документы по типу",
                    "by_status": "Документы по статусу",
                    "sent_by_day": "Отправленные документы по дням"
                },
                "recipients": {
                    "add": "Добавить нового получателя",
                    "enter_full_name": "Введите полное имя получателя",
                    "enter_email": "Введите адрес электронной почты получателя",
                    "no_recipients": "Нет получателей для отправки документа.",
                    "is_sent": "Отправил?",
                    "recipients": "Получатели",
                    "additional_recipients": "Additional recipients",
                    "recipient_name": "Имя",
                    "recipient_email": "E-Mail",
                    "name": "Имя получателя",
                    "email": "Email получателя"
                },
                "view_type": {
                    "html_view_type": "Тип представления HTML",
                    "template_info": "Когда шаблон имеет тип представления, после вставки тип представления документа будет обновлен типом шаблона.",
                    "nav_top": {
                        "name": "Верх навигации",
                        "description": "Полезно для простых документов, не требующих навигации по заголовкам."
                    },
                    "nav_left": {
                        "name": "Навигация слева",
                        "description": "Полезно для документов, требующих навигации по заголовкам ({headingTagName})."
                    },
                    "nav_left_full_width": {
                        "name": "Навигация слева — полная ширина",
                        "description": "Раздел содержимого не имеет полей, что полезно для полноразмерных документов с заголовками ({headingTagName})."
                    }
                },
                "type": {
                    "type": "Тип документа",
                    "types": "Типы документов",
                    "name": "Имя",
                    "default_type": "Тип документа по умолчанию",
                    "delete_primary_warning": "Вы не можете удалить первичный тип документа.",
                    "delete_usage_warning": "Тип уже связан с документами, поэтому его нельзя удалить.",
                    "delete_is_default": "Это тип документа по умолчанию, поэтому его нельзя удалить.",
                    "cannot_change_visibility_on_default": "Это общекорпоративный тип по умолчанию, поэтому его видимость изменить нельзя."
                },
                "template": {
                    "insert_template": "Вставить шаблон",
                    "save_as_template": "Сохранить как шаблон",
                    "manage": "Управление шаблонами",
                    "template": "Шаблон документа",
                    "templates": "Шаблоны документов",
                    "create": "Создать шаблон",
                    "name": "Имя шаблона",
                    "deleted": "Шаблон успешно удален",
                    "share_with_team_members": "Поделиться этим шаблоном с другими членами команды?",
                    "is_shared": "Общий",
                    "empty_state": {
                        "title": "Вы не создали ни одного шаблона.",
                        "description": "Создавайте документы быстрее, используя готовые шаблоны."
                    }
                },
                "workflows": {
                    "triggers": {
                        "status_changed": "Статус документа изменен"
                    },
                    "actions": {
                        "fields": {
                            "email_to_contact": "Документ основное контактное лицо",
                            "email_to_company": "Документ основная компания",
                            "email_to_owner_email": "Электронная почта владельца документа",
                            "email_to_creator_email": "Электронная почта создателя документа"
                        }
                    }
                },
                "timeline": {
                    "heading": "Документ создан"
                },
                "mail_placeholders": {
                    "assigneer": "Имя пользователя, назначившего документ"
                },
                "notifications": {
                    "signed": "Документ {title} был подписан",
                    "assigned": "Вы были назначены на документ {title} пользователем {user}",
                    "accepted": "Документ {title} принят",
                    "viewed": "Документ {title} был просмотрен"
                },
                "filters": {
                    "status_disabled": "Статус используется в текущем фильтре, поэтому вы не можете выбрать статус из этого раздела."
                },
                "activity": {
                    "created": "Документ создан пользователем {user}",
                    "sent": "Документ отправлен пользователем {user}",
                    "marked_as_lost": "{user} пометил документ как утерянный",
                    "marked_as_accepted": "{user} пометил документ как принятый",
                    "marked_as_draft": "{user} пометил документ как черновик",
                    "sent_recipient": "{name} - {email}",
                    "signed": "Документ подписан {signer_name}",
                    "accepted": "Документ был принят",
                    "viewed": "Документ был просмотрен",
                    "downloaded": "Документ PDF был загружен"
                },
                "empty_state": {
                    "title": "Вы не создали ни одного документа.",
                    "description": "Закрывайте сделки быстрее, отправляя хорошо выглядящие отслеживаемые документы."
                },
                "add_pdf_padding": "Добавить отступ {px} PDF"
            },
            "fields": {
                "documents": {
                    "title": "Заголовок документа",
                    "owner_assigned_date": "Дата назначения ответственного",
                    "accepted_at": "Принято в",
                    "amount": "Сумма",
                    "original_date_sent": "Исходная дата отправки",
                    "last_date_sent": "Последняя дата отправки",
                    "brand": {
                        "name": "Компания"
                    },
                    "user": {
                        "name": "Ответственный"
                    },
                    "type": {
                        "name": "Тип"
                    }
                }
            },
            "pdf": {
                "default_font": "Default font family",
                "default_font_info": "The {fontName} font gives the most decent Unicode character coverage by default, make sure to select a proper font if special or unicode characters are not displayed properly on the PDF document.",
                "size": "Size",
                "orientation": "Orientation",
                "orientation_portrait": "Portrait",
                "orientation_landscape": "Landspace",
                "settings": "PDF Settings",
                "padding": "PDF padding",
                "no_padding": "No additional padding"
            }
        },
        "mailclient": {
            "inbox": {
                "inbox": "Почта",
                "shared": "Общий почтовый ящик",
                "new_message": "Новое сообщение",
                "trash": "Переместить в корзину",
                "move_to": "Переместить в",
                "forward": "Поделиться",
                "reply": "Ответить",
                "reply_all": "Ответить всем",
                "reply_to_message": "Ответить {subject}",
                "forward_message": "Поделиться {subject}",
                "forwarded_message_placeholder": "{pre} Переадресованное сообщение {after}<br />\n                                         Откуда: {from}<br />\n                                         Дата: {date}<br />\n                                         Тема: :{subject}<br />\n                                         Кому: {to}",
                "message_sent": "Сообщение успешно отправлено.",
                "search_recipients": "Найдите или введите адрес электронной почты...",
                "send": "Отправить",
                "sync_in_progress": "В настоящее время система синхронизирует учетные записи в фоновом режиме. Повторите попытку позже.",
                "synchronize": "Синхронизировать",
                "subject": "Тема",
                "no_subject": "Без темы",
                "unknown_address": "Неизвестно",
                "from": "От",
                "to": "Кому",
                "cc": "Cc",
                "bcc": "Bcc",
                "reply_to": "Ответить",
                "date": "Дата",
                "unread_count": "Всего непрочитанных писем",
                "pre_send_empty_placeholders_found": "You are about to send an email with empty placeholders. Before proceeding, please confirm that you really want to proceed with this action.",
                "will_use_placeholders_from_record": "The placeholders added in the message content related to the {resourceName} resource will be taken form this record",
                "filters": {
                    "is_read": "Прочитано"
                }
            },
            "mail": {
                "compose": "Написать",
                "attachments": "Вложения",
                "emails": "Email",
                "create": "Создать Email",
                "send": "Отправить Email",
                "view": "Просмотр почты",
                "from_header": "Из заголовка",
                "from_name": "От имени",
                "messages": "Почтовые сообщения",
                "message": "Почтовое сообщение",
                "new_message_placeholder": "Compose your email here. Type \"{trigger}\" to search dynamic fields.",
                "signature": "Электронная подпись",
                "signature_info": "Создайте подпись, которая будет добавлена в конец ваших сообщений.",
                "show_quoted_content": "Показать цитируемый контент",
                "trimmed_content": "Обрезанный контент",
                "disable_sync": "Отключить синхронизацию",
                "manage_emails": "Управление электронной почтой",
                "info": "Вы можете отправлять электронные письма и отвечать на них непосредственно через этот раздел.",
                "from_header_info": "Что клиенты увидят в поле «От кого», когда получат электронное письмо с этого адреса электронной почты.",
                "placeholders_info": "Используйте заполнители {placeholders} для динамической замены содержимого, такого как название компании, имя агента (пользователь, отправляющий электронное письмо).",
                "mark_as_read": "Пометить, как прочитанное",
                "mark_as_unread": "Отметить как непрочитанное",
                "message_queued_for_sending": "Сообщение поставлено в очередь на отправку, будет синхронизировано в следующем пакете синхронизации.",
                "initial_sync_info": "Эта учетная запись поставлена в очередь на первоначальную синхронизацию, и синхронизация будет выполнена, как только запустится задание cron, чтобы предотвратить любые прерывания синхронизации, убедитесь, что вы настроили задание cron, как описано в документации.",
                "account": {
                    "create_contact": "Создайте запись контакта, если запись не существует.",
                    "use_aliass": "Use alias email address",
                    "use_aliass_info": "The address needs to be a valid alias that already exists in the mail server, useful when using Google Workspace aliases.",
                    "enter_alias": "Alias E-Mail Address",
                    "personal": "Личная",
                    "shared": "Общая",
                    "accounts": "Учетные записи Email",
                    "sync_emails_from": "Синхронизировать электронные письма от",
                    "sync_period_now": "Сейчас",
                    "sync_period_1_month_ago": "1 месяц назад",
                    "sync_period_3_months_ago": "3 месяца назад",
                    "sync_period_6_months_ago": "6 месяцев назад",
                    "sync_period_note": "В большинстве случаев вам не нужно будет взаимодействовать со всеми электронными письмами с {date}, более низкий начальный период синхронизации позволит избежать импорта сотен электронных писем с вложениями и поможет сэкономить место для хранения, всегда рекомендуется выбирать более низкий начальный период синхронизации.",
                    "integration_not_configured": "Учетные записи электронной почты не настроены, настройте личные или общие учетные записи электронной почты для отправки электронных писем.",
                    "already_connected": "Эта учетная запись электронной почты уже подключена.",
                    "select_type": "Выберите тип учетной записи",
                    "no_active_folders": "В этой учетной записи нет активных папок. Включите активные папки, отредактировав учетную запись почты, активными папками будут папки, которые будут синхронизированы с приложением.",
                    "activate_folders": "Активные папки",
                    "active_folders": "Активные папки",
                    "active_folders_info": "Select the folders you wish to synchronize.",
                    "sent_folder": "Папку отправленные",
                    "trash_folder": "Папка для мусора",
                    "test_connection": "Тестовое соединение",
                    "is_primary": "Основная учетная запись",
                    "connection_error": "Ошибка проверки соединения, проверьте конфигурацию, дополнительную информацию см. в сообщении об ошибке: {message}",
                    "create": "Создать учетную запись Email",
                    "edit": "Изменить учетную запись Email",
                    "manage": "Управление учетными записями",
                    "connect": "Подключить аккаунт",
                    "connect_shared": "Подключить общий аккаунт",
                    "connect_personal": "Подключить личный аккаунт",
                    "created": "Учетная запись Email успешно добавлена.",
                    "updated": "Учетная запись Email успешно изменена.",
                    "deleted": "Учетная запись Email успешно удалена.",
                    "no_accounts_configured": "Учетные записи электронной почты не настроены",
                    "no_accounts_configured_info": "Подключите учетную запись, чтобы начать отправлять и систематизировать электронные письма, чтобы быстрее заключать сделки",
                    "create_shared_info": "Подключите учетную запись электронной почты компании, например contact{'@'}company.com или sales{'@'}company.com.",
                    "create_shared_confirmation_message": "При подключении общей учетной записи электронной почты имейте в виду, что доступ к общим учетным записям электронной почты могут получить все члены команды, которым предоставлен «доступ к общей папке «Входящие». <br /> <br />\n         Это означает, что каждый член команды сможет просматривать почту и взаимодействовать с ней.",
                    "missing_sent_folder": "Требуется действие, выберите отправленную папку для этой учетной записи.",
                    "missing_trash_folder": "Требуется действие, выберите папку корзины для этого аккаунта.",
                    "missing_primary_account": "Action required, configure a primary account for sending emails.",
                    "type": "Тип аккаунта",
                    "email_address": "Адрес электронной почты",
                    "password": "Пароль",
                    "username": "Имя пользователя",
                    "incoming_mail": "Входящая почта (IMAP)",
                    "outgoing_mail": "Исходящая почта (SMTP)",
                    "server": "Server",
                    "port": "Порт",
                    "allow_non_secure_certificate": "Разрешить незащищенный сертификат",
                    "encryption": "Шифрование",
                    "without_encryption": "Без шифрования",
                    "delete_warning": "Если вы используете эту учетную запись электронной почты в качестве «Системной учетной записи электронной почты» в настройках, вам нужно будет выбрать другую учетную запись для отправки сообщений, связанных с системой, кроме того, вам нужно будет проверить свои рабочие процессы, если какой-либо рабочий процесс настроен на использование «Отправить электронную почту». \" с этой конкретной учетной записью электронной почты, вам нужно будет обновить учетную запись электронной почты действия, чтобы рабочий процесс продолжал отправлять письма.",
                    "featured": {
                        "sync": "Двусторонняя синхронизация электронной почты с вашим почтовым провайдером.",
                        "save_time": "Экономьте время, используя готовые шаблоны.",
                        "placeholders": "Создавайте электронные письма и шаблоны с заполнителями.",
                        "signature": "Добавьте индивидуальную подпись для более профессионального вида.",
                        "associations": "Свяжите электронные письма со многими {resources} и {resource}.",
                        "types": "Подключитесь через IMAP, свою учетную запись Gmail или Outlook."
                    }
                },
                "templates": {
                    "select": "Выбрать",
                    "create": "Создать шаблон",
                    "name": "Имя",
                    "subject": "Тема",
                    "is_shared": "Поделиться этим шаблоном с другими членами команды?",
                    "body": "Тело",
                    "templates": "Шаблоны",
                    "created": "Почтовый шаблон успешно создан.",
                    "updated": "Почтовый шаблон успешно изменен.",
                    "deleted": "Почтовый шаблон успешно удален."
                },
                "labels": {
                    "CATEGORY_PERSONAL": "Личный",
                    "CATEGORY_SOCIAL": "Общий",
                    "CATEGORY_FORUMS": "Форумы",
                    "IMPORTANT": "Важный",
                    "CATEGORY_UPDATES": "Обновления",
                    "CATEGORY_PROMOTIONS": "Акции",
                    "CHAT": "Чат",
                    "SENT": "Отправил",
                    "INBOX": "Входящие",
                    "TRASH": "Корзина",
                    "DRAFT": "Черновики",
                    "DRAFTS": "ЧЕРНОВИКИ",
                    "SPAM": "Спам",
                    "STARRED": "Помечено",
                    "UNREAD": "Не прочитано"
                },
                "workflows": {
                    "actions": {
                        "send": "Отправить письмо"
                    },
                    "fields": {
                        "from_account": "Из учетной записи электронной почты",
                        "subject": "С предметом",
                        "message": "С сообщением",
                        "to": "Кому",
                        "send_from_owner_primary_account": "Owner Primary Email Account"
                    }
                },
                "validation": {
                    "invalid_recipients": "Похоже, что некоторые из ваших получателей имеют неверный адрес."
                }
            },
            "schedule": {
                "send_later": "Send Later",
                "choose_date": "Choose date",
                "schedule": "Schedule",
                "scheduled_emails": "Scheduled Emails",
                "cancel_and_delete": "Cancel and delete",
                "message_scheduled": "The message was scheduled to be sent later",
                "will_retry_at": "Will retry at: {date}",
                "send_now": "Send Now",
                "scheduled_at": "Date Scheduled",
                "sent_at": "Date Sent",
                "scheduled_by": "Scheduled By",
                "status": "Status",
                "statuses": {
                    "pending": "Pending",
                    "sent": "Sent",
                    "sending": "Sending",
                    "failed": "Failed"
                }
            }
        },
        "notes": {
            "note": {
                "notes": "Примечания",
                "note": "Примечание",
                "add": "Добавить примечание",
                "create_notes": "Создать примечания",
                "manage_notes": "Управление примечаниями",
                "info": "Здесь вы можете создавать примечания для себя и своей команды и отслеживать важную информацию.",
                "info_created": "{user} оставил заметку {date}",
                "follow_up_task_body": "Относительно примечания: {content}",
                "write": "Напишите примечание...",
                "created": "Примечание успешно создана",
                "updated": "Примечание успешно изменено",
                "deleted": "Примечание успешно удалено",
                "timeline": {
                    "heading": "Новое примечание создано"
                }
            }
        },
        "themestyle": {
            "style": {
                "theme_style": "Стиль темы",
                "lightness_maximum": "Максимум легкости",
                "lightness_minimum": "Минимум легкости"
            }
        },
        "translator": {
            "translator": {
                "translator": "Переводчик",
                "new_locale": "Новая локаль",
                "create_new_locale": "Создать новую локаль",
                "locale_name": "Имя локали",
                "group_has_unsaved_translations": "The group has unsaved translations!",
                "changes_not_saved": "Вы не сохранили переводы для этой группы, чтобы не потерять переводы, сохраните группу, нажав кнопку Сохранить внизу страницы.",
                "tools": {
                    "json-language": "Создать языковой файл JSON"
                }
            }
        },
        "users": {
            "profile": {
                "update": "Обновить профиль",
                "profile": "Профиль",
                "updated": "Профиль успешно обновлен",
                "password_updated": "Пароль успешно обновлен",
                "avatar_info": "Загрузите свой аватар, чтобы члены вашей команды могли легко узнать ваш профиль.",
                "profile_info": "Обновите свой профиль, включая подпись электронной почты и адрес электронной почты для входа.",
                "localization_info": "Настройте локализацию своего профиля по своему усмотрению.",
                "notifications_info": "Решите, какие сообщения вы хотели бы получать и как.",
                "password_info": "Обновите пароль своей учетной записи, чтобы получить более надежный пароль, воспользуйтесь генератором паролей."
            },
            "team": {
                "teams": "Команды",
                "team": "Команда",
                "add": "Добавить команду",
                "create": "Создать новую команду",
                "edit": "Редактировать команду",
                "name": "Название команды",
                "members": "Члены команды",
                "description": "Описание команды",
                "owner_team": "Владелец команды",
                "select": "Выберите команды",
                "manager": "Менеджер",
                "your_teams": "Your Team|Your Teams",
                "managing_teams": "All of the teams and people you are managing.",
                "capabilities": {
                    "team_only": "Только команда"
                },
                "empty_state": {
                    "title": "Нет команд",
                    "description": "Начните с создания новой команды."
                }
            },
            "user": {
                "user": "Пользователь",
                "users": "Пользователи",
                "not_found": "Пользователи не найдены",
                "create": "Создать пользователя",
                "invite": "Пригласить пользователя",
                "send_invitation": "Отправить приглашение",
                "accept_invitation": "Принять приглашение",
                "invited": "Приглашение пользователя отправлено",
                "admin_users_excluded": "Пользователи с правами администратора исключены",
                "select": "Выберите пользователей",
                "invitation_expires_after_info": "Пользователю будет отправлено письмо со ссылкой-приглашением для создания учетной записи, ссылка будет действительна в течение {total} дней и станет недействительной после создания учетной записи.",
                "edit": "Редактировать пользователя",
                "sales_agent": "Менеджер",
                "name": "Имя",
                "email": "E-Mail",
                "roles": "Роли пользователей",
                "localization": "Локализация",
                "enable_api": "Включить доступ к API",
                "super_admin": "Суперадминистратор",
                "as_super_admin_info": "Включение доступа суперадминистратора для пользователя даст полный доступ ко всем функциям без каких-либо ограничений.",
                "allow_api_info": "Разрешить пользователю создавать токены API и использовать токены для отправки запросов к конечным точкам приложения.",
                "assign": "Назначить",
                "not_authorized": "Ваша учетная запись не авторизована для выполнения этого действия.",
                "delete_transfer_to_same_user_warning": "Вы не можете передавать данные одному и тому же пользователю.",
                "delete_own_account_warning": "Вы не можете удалить свою учетную запись.",
                "transfer_data_info": "Данные этого пользователя необходимо передать другому пользователю. Выберите пользователя, которому вы хотите передать данные.",
                "actions": {
                    "delete": "Удалить пользователя"
                },
                "notifications": {
                    "user_mentioned": "Вас упомянул пользователь {name}"
                }
            }
        },
        "webforms": {
            "form": {
                "forms": "Веб-формы",
                "form": "Веб-форма",
                "created": "Веб-форма успешно добавлена.",
                "updated": "Веб-форма успешно изменена.",
                "deleted": "Веб-форма успешно удалена.",
                "submission": "Отправка веб-формы",
                "total_submissions": "Отправлено: {total}",
                "editor": "Редактор",
                "submit_options": "Опции отправки",
                "info": "Создавайте настраиваемые веб-формы, которые можно встроить в существующий веб-сайт, или делитесь формами в виде ссылок для автоматического создания сделок, контактов и компаний.",
                "inactive_info": "Эта форма неактивна, вы можете просмотреть форму, потому что вы вошли в систему, если вы хотите, чтобы форма была общедоступной, убедитесь, что форма активна.",
                "create": "Создать веб-форму",
                "active": "Активная",
                "title": "Название",
                "title_visibility_info": "Заголовок не виден посетителям, которые будут заполнять форму.",
                "fields_action_required": "Требуется дополнительное действие",
                "required_fields_needed": "Для сохранения новых сделок необходимо добавить как минимум контактный адрес электронной почты или телефон.",
                "must_requires_fields": "Чтобы сохранить новые сделки, ваша веб-форма должна содержать как минимум контактный адрес электронной почты или телефон.",
                "non_optional_fields_required": "Обязательные необязательные поля",
                "notifications": "Уведомления",
                "notification_email_placeholder": "Введите адрес электронной почты",
                "new_notification": "+ Добавить Email",
                "no_sections": "Эта веб-форма не имеет определенных разделов.",
                "style": {
                    "style": "Стиль",
                    "primary_color": "Основной цвет",
                    "background_color": "Фоновый цвет",
                    "logo": "Отображение логотипа поверх формы"
                },
                "success_page": {
                    "success_page": "Страница успеха",
                    "success_page_info": "Что должно произойти после того, как посетитель отправит эту форму?",
                    "thank_you_message": "Показать сообщение с благодарностью",
                    "redirect": "Перенаправить на другой сайт",
                    "title": "Заголовок",
                    "title_placeholder": "Введите текст сообщения об успешном завершении.",
                    "message": "Сообщение (необязательно)",
                    "redirect_url": "URL веб-сайта",
                    "redirect_url_placeholder": "Введите URL для перенаправления после отправки формы."
                },
                "saving_preferences": {
                    "saving_preferences": "Сохранение настроек",
                    "deal_title_prefix": "Префикс названия сделки",
                    "deal_title_prefix_info": "Для каждой новой сделки, созданной через форму, имя сделки будет иметь префикс с текстом, добавленным в поле для облегчения распознавания."
                },
                "sections": {
                    "new": "Добавить новый раздел",
                    "type": "Тип раздела",
                    "types": {
                        "input_field": "Поле ввода",
                        "message": "Сообщение",
                        "file": "Файл"
                    },
                    "field": {
                        "resourceName": "Поле для"
                    },
                    "introduction": {
                        "introduction": "Введение",
                        "title": "Заголовок",
                        "message": "Сообщение"
                    },
                    "message": {
                        "message": "Сообщение"
                    },
                    "file": {
                        "file": "Файл",
                        "files": "Файлы",
                        "multiple": "Разрешить загрузку нескольких файлов?"
                    },
                    "submit": {
                        "button": "Кнопка отправки",
                        "default_text": "Отправить",
                        "button_text": "Текст кнопки",
                        "spam_protected": "Защита от спама?",
                        "require_privacy_policy": "Требовать согласия с политикой конфиденциальности",
                        "privacy_policy_url": "URL политики конфиденциальности"
                    },
                    "embed": {
                        "embed": "Встроить"
                    }
                }
            }
        },
        "core": {
            "actions": {
                "action": "Действие",
                "actions": "Действия",
                "select": "Выберите действие",
                "confirmation_message": "Вы уверены, что хотите выполнить это действие?",
                "run_successfully": "Действие выполнено успешно.",
                "search_in_google": "Поиск в гугле",
                "bulk_edit": "Bulk Edit",
                "records_count": "1 запись | {count} записи"
            },
            "api": {
                "api": "API",
                "access": "Доступ к API",
                "access_tokens": "Access Tokens",
                "personal_access_tokens": "Токены личного доступа",
                "personal_access_token": "Токен личного доступа",
                "create_token": "Создать новый токен",
                "no_tokens": "Вы не создавали личных токенов доступа.",
                "token_name": "Название",
                "revoke_token": "Удалить",
                "token_last_used": "Последний используемый",
                "after_token_created_info": "Вот ваш новый токен личного доступа. Это единственный раз, когда он будет показан, так что не теряйте его!\n     Теперь вы можете использовать этот токен для выполнения запросов к API.",
                "empty_state": {
                    "description": "Используйте токены для выполнения запросов API вне приложения."
                },
                "token_delete_warning": "Please note that if you delete your API token, it will immediately invalidate the token. This means any external services or code integrations using this token will stop to function. Ensure to remove or replace the token in all your implementations to prevent disruptions."
            },
            "app": {
                "delete": "Удалить",
                "confirm": "Подтвердить",
                "cancel": "Отменить",
                "clear": "Очистить",
                "save": "Сохранить",
                "saved": "Сохранено.",
                "send": "Отправить",
                "save_and_exit": "Сохранить и выйти",
                "exit": "Выйти",
                "edit": "Изменить",
                "copy": "Копировать",
                "copy_link": "Copy Link",
                "copy_api_key": "Copy API Key",
                "clone": "Дублировать",
                "create": "Создать",
                "change": "Изменить",
                "remove": "Удалить",
                "hide": "Скрыть",
                "active": "Активировать",
                "view_details": "Детали",
                "system_info": "Системная информация",
                "add_note": "Добавить примечание",
                "add_another": "Добавить еще",
                "is_primary": "Primary",
                "is_default": "Default",
                "note_is_private": "Приватное примечание",
                "create_and_add_another": "Создать и добавить еще",
                "create_and_go_to_list": "Создать и перейти к списку",
                "purchase_key": "Ключ покупки",
                "enter_purchase_key": "Введите ключ покупки",
                "privacy_policy": "Политика конфиденциальности",
                "copied": "Текст скопирован в буфер обмена",
                "insert_new_line": "Вставить новую строку",
                "reset": "Сбросить",
                "optional": "Необязательно",
                "not_enough_data": "Недостаточно данных для отображения",
                "no_search_results": "Нет результатов, соответствующих вашим критериям поиска",
                "recent_search_history": "Recent Search History",
                "discard_changes": "Отменить изменения",
                "agree_to_privacy_policy": "Используя эту форму, вы соглашаетесь с хранением и обработкой ваших данных на этом веб-сайте в соответствии с нашей {privacyPolicyLink}",
                "id": "ID",
                "deleted_at": "Удалено в",
                "apply": "Применить",
                "reload": "Перезагрузить",
                "loading": "Загрузка...",
                "please_wait": "Пожалуйста, подождите...",
                "preview": "Просмотр",
                "address": "Адрес",
                "continue": "Продолжить",
                "open_in_app": "Открыть в приложении",
                "locale": "Регион",
                "details": "Детали",
                "sort": "Сортировка",
                "expand": "Расширить",
                "show_less": "Показать меньше",
                "show_all": "Показать всё",
                "has_more": "+{count} больше",
                "throttle_error": "Слишком много запросов, повторите попытку позже.",
                "file_preview": "Просмотр файла",
                "integrations": "Интеграции",
                "attachments": "Вложения",
                "attach": "Прикрепить",
                "changelog": "Список изменений",
                "go_back": "Вернуться обратно",
                "back": "Back",
                "attach_files": "Прикрепить файлы",
                "file_too_large": "Файл слишком большой",
                "no_attachments": "Нет загруженных вложений.",
                "download": "Скачать",
                "remember_selection": "Запомнить мой выбор",
                "token_expired": "Ваша сессия истекла.",
                "all_caught_up": "Вы всё сделали!",
                "view_record": "Посмотреть",
                "list_view": "Список",
                "reminder_set_for": "Напоминание установлено для {value} {type} перед",
                "reminder_before_due": "раньше срока",
                "integration_not_configured": "Интеграция не настроена",
                "associate_with_record": "Связать с записями",
                "address_information": "Информация об адресе",
                "search": "Поиск...",
                "type_to_search": "Введите для поиска...",
                "type_more_to_search": "Введите {characters} больше символов для поиска...",
                "search_records": "Поиск записей",
                "allowed_extensions": "Разрешенные расширения загрузки",
                "allowed_extensions_info": "Введите расширения, разделенные запятыми, которые будут добавлены в белый список для хранения файлов.",
                "last_modified_at": "Последнее изменение",
                "created_at": "Создан в",
                "updated_at": "Обновлено в",
                "created_by": "Сделано",
                "creation_date": "Дата создания",
                "drop_files": "Перетащите файлы для загрузки",
                "choose_image": "Выберите изображение",
                "ascending": "Восходящий",
                "descending": "Нисходящий",
                "sort_ascending": "Sort ascending",
                "sort_descending": "Sort descending",
                "upload": "Загрузить",
                "upload_avatar": "Загрузить аватар",
                "avatar": "Аватар",
                "quick_create": "Быстрое создание",
                "no_owner": "Нет ответственного",
                "owner_email_address": "Адрес электронной почты ответственного",
                "associate": "Связать",
                "timezone": "Часовой пояс",
                "currency": "Валюта",
                "system_default": "Системные установки по умолчанию",
                "auto_detect": "Автоматически определять",
                "all": "Всё",
                "see_all": "Показать всё",
                "select_file": "Выбрать файл",
                "file": "Файл",
                "form_validation_failed": "Ошибка проверки формы, проверьте все поля",
                "form_validation_failed_with_sections": "Ошибка проверки формы, проверьте все разделы и поля",
                "advanced": "Расширенный",
                "yes": "Да",
                "no": "Нет",
                "no_associations": "Нет связок",
                "associated_with_total_records": "Связано с {count} запись|Связано с {count} записей",
                "action_not_authorized": "Ваша учетная запись не авторизована для выполнения этого действия",
                "record_view": {
                    "manage_sidebar": "Управление разделами боковой панели",
                    "sections": {
                        "edit_heading": "Управление разделами",
                        "edit_subheading": "Изменить порядок разделов или переключить видимость",
                        "details": "Детали"
                    }
                },
                "soft_deletes": {
                    "trashed": "Удалено",
                    "trashed_records": "Удаленные записи",
                    "restore": "Восстановить",
                    "force_delete": "Удалить навсегда",
                    "move_to_trash": "Переместить в корзину",
                    "empty_trash": "Empty Trash",
                    "trashed_pruning_info": "Записи в корзине будут удалены через {total} дн."
                },
                "logo": {
                    "light": "Светлый логотип",
                    "dark": "Тёмный логотип"
                },
                "cards": {
                    "creation_date_info": "На этой карточке отображаются только записи, созданные в течение выбранного диапазона дат."
                },
                "theme": {
                    "switch_light": "Переключиться на светлый режим",
                    "switch_system": "Переключиться на системную тему",
                    "switch_dark": "Переключиться в темный режим"
                },
                "menu": {
                    "metrics": {
                        "metrics": "Metrics",
                        "refresh_interval": "Метрики обновляются каждые {interval} минут.",
                        "highlights": "Метрики"
                    }
                },
                "visibility_group": {
                    "visible_to": "Виден",
                    "all": "Вся компания"
                },
                "export": {
                    "export": "Экспорт",
                    "type": "Тип",
                    "select_range": "Select Range",
                    "apply_filters": "Экспортировать записи на основе примененных фильтров?"
                },
                "company": {
                    "name": "Название компании",
                    "country": "Страна"
                },
                "password_generator": {
                    "heading": "Сгенерировать пароль",
                    "strength": "Сила",
                    "length": "Длина",
                    "digits": "Цифры",
                    "symbols": "Символы",
                    "weak": "Слабый",
                    "average": "Средний",
                    "strong": "Сильный",
                    "secure": "Безопасный",
                    "copied": "Пароль скопирован в буфер обмена"
                },
                "weekdays": {
                    "monday": "Понедельник",
                    "tuesday": "Вторник",
                    "wednesday": "Среда",
                    "thursday": "Четверг",
                    "friday": "Пятница",
                    "saturday": "Суббота",
                    "sunday": "Воскресенье"
                },
                "colors": {
                    "color": "Цвет",
                    "colors": "Цвета",
                    "remove": "Удалить цвет",
                    "palettes": "Цветовые палитры"
                }
            },
            "contentbuilder": {
                "snippets": {
                    "basic": "Базовые",
                    "text": "Текст",
                    "headline": "Заголовок",
                    "buttons": "Кнопки",
                    "photos": "Фото",
                    "profile": "Профиль",
                    "contact": "Контакт",
                    "products": "Товары",
                    "features": "Функции",
                    "process": "Процесс",
                    "pricing": "Цены",
                    "skills": "Навыки",
                    "achievements": "Достижения",
                    "quotes": "Кавычки",
                    "partners": "Партнеры",
                    "as_featured_on": "Как показано на",
                    "help_and_faq": "Помощь, FAQ"
                },
                "builder": {
                    "Bold": "Жирный",
                    "Italic": "Курсив",
                    "Hyperlink": "Гиперссылка",
                    "Align": "Выравнивание",
                    "Paragraph": "Параграф",
                    "Color": "Цвет",
                    "Formatting": "Форматирование",
                    "List": "Список",
                    "Text Settings": "Настройки текстаа",
                    "Icon": "Иконка",
                    "Clean": "Очистить",
                    "Font": "Шрифт",
                    "Previous": "Предыдущий",
                    "Next": "Следующий",
                    "More": "Больше",
                    "Move Up": "Вверх",
                    "Move Down": "Вниз",
                    "Move Left": "Влево",
                    "Move Right": "Вправо",
                    "Delete": "Удалить",
                    "Add": "Добавить",
                    "Move": "Передвинуть",
                    "Duplicate": "Дублировать",
                    "Decrease": "Уменьшить",
                    "Increase": "Увеличить",
                    "HTML": "HTML",
                    "Headline": "Заголовок",
                    "Image": "Картинка",
                    "Heading 1": "Заголовок 1",
                    "Heading 2": "Заголовок 2",
                    "Heading 3": "Заголовок 3",
                    "Quote": "Цитата",
                    "Preformatted": "Предформатирование",
                    "Table": "Таблица",
                    "Spacer": "Промежуток",
                    "Horizontal Line": "Горизонтальная линия",
                    "More...": "Более...",
                    "Enlarge": "Увеличить",
                    "Ok": "Ok",
                    "Align Left": "Выровнять по левому краю",
                    "Align Center": "Выровнять по центру",
                    "Align Right": "Выровнять по правому краю",
                    "Align Full": "Выровнять по ширине",
                    "Bullets": "Точки",
                    "Numbering": "Цифры",
                    "Indent": "Отступ",
                    "Outdent": "Выступающий",
                    "Heading 4": "Заголовок 4",
                    "Underline": "Подчеркивание",
                    "Strikethrough": "Зачеркнуть",
                    "Superscript": "Верхний индекс",
                    "Subscript": "Подстрочный индекс",
                    "Uppercase": "Верхний регистр",
                    "Clear": "Очистить",
                    "Choose..": "Выбрать..",
                    "Forecolor": "Передний цвет",
                    "Backcolor": "Задний цвет",
                    "Apply": "Применить",
                    "Cancel": "Отменить",
                    "Change Image": "Изменить изображение",
                    "Link": "Ссылка",
                    "Edit": "Редактировать",
                    "Source": "Источник",
                    "Settings": "Настройки",
                    "Change Icon": "Изменить иконку",
                    "Edit Table": "Изменить таблицу",
                    "Select": "Выбрать",
                    "Open new window": "Открыть в новом окне",
                    "Open New Window": "Открыть в новом окне",
                    "Text": "Текст",
                    "Title": "Заголовок",
                    "Free": "Свободно",
                    "Style": "Стиль",
                    "Layout": "Макет",
                    "Background": "Фон",
                    "Select Color": "Выбрать цвет",
                    "Text Color": "Цвет текста",
                    "Border Thickness": "Толщина границы",
                    "Border Color": "Цвет границы",
                    "Apply To": "Применить к",
                    "Current Row": "Текущая строка",
                    "Current Column": "Текущий столбец",
                    "Even Rows": "Чётные строки",
                    "Odd Rows": "Нечётные строки",
                    "Current Cell": "Текущая ячейка",
                    "Insert Row": "Вставить строку",
                    "Insert Column": "Вставить столбец",
                    "Delete Row": "Удалить строку",
                    "Delete Column": "Удалить столбец",
                    "Above": "Выше",
                    "Below": "Ниже",
                    "Left": "Левее",
                    "Right": "Правее",
                    "Row": "Строка",
                    "Column": "Столбец",
                    "Merge": "Объединить",
                    "Merge Cell": "Объединить ячейку",
                    "css": "css",
                    "Class": "Класс",
                    "Box": "Box",
                    "Spacing": "Расстояние",
                    "Border": "Граница",
                    "Corners": "Углы",
                    "Shadow": "Тень",
                    "Display": "Показать",
                    "Position": "Позиция",
                    "Effects": "Эффекты",
                    "Attributes": "Атрибуты",
                    "Animation": "Анимация",
                    "Background Color": "Цвет фона",
                    "Gradient": "Градиент",
                    "Dimension": "Размер",
                    "Responsive Positioning": "Отзывчивое позиционирование",
                    "Reset margin left on small screen": "Сбросить поле слева на маленьком экране",
                    "Reset margin right on small screen": "Сбросить поле справа на маленьком экране",
                    "Individual Sides": "Отдельные стороны",
                    "Select Font": "Выбрать шрифт",
                    "Animate": "Анимация",
                    "Delay": "Задержка",
                    "Duration": "Продолжительность",
                    "Animate Once": "Анимировать один раз",
                    "Test": "Тест",
                    "TEST": "ТЕСТ",
                    "Custom": "Пользовательское",
                    "Module Settings": "Настройки модуля",
                    "Drag and drop an image or click to browse.": "Перетащите изображение или нажмите, чтобы просмотреть.",
                    "Are you sure you want to delete this block?": "Вы уверены, что хотите удалить этот блок?",
                    "Back": "Обратно",
                    "Or Specify Image Source": "Или укажите источник изображения",
                    "Preferences": "Настройки",
                    "Hide element tool": "Скрыть элемент инструментов",
                    "Hide column tool": "Скрыть столбец с инструментами",
                    "Line": "Линия",
                    "Hide column HTML editor": "Скрыть столбец с HTML редактором",
                    "Hide row HTML editor": "Скрыть строку с HTML редактором",
                    "Hide row move (up/down) buttons": "Скрыть кнопки перемещения строки (вверх/вниз)",
                    "HTML syntax highlighting": "Подсветка синтаксиса HTML",
                    "Scrollable Editing Toolbar": "Прокручиваемая панель инструментов редактирования",
                    "Toolbar position": "Положение панели инструментов",
                    "Top": "Верх",
                    "Toolbar visibility": "Видимость панели инструментов",
                    "Auto": "Авто",
                    "Always Visible": "Всегда видно",
                    "Paste result": "Вставить результат",
                    "HTML (without styles)": "HTML (без стилей)",
                    "HTML (with styles)": "HTML (со стилями)",
                    "Text only": "Только текст",
                    "Add Snippet": "Добавить фрагмент",
                    "Grid Tool": "Инструмент «Сетка»",
                    "Element Tool": "Инструмент «Элемент»",
                    "Builder Mode": "Режим строителя",
                    "Default": "По умолчанию",
                    "Minimal": "Минимальный",
                    "Hide outline": "Скрыть контур",
                    "Hide element highlight": "Скрыть выделение элемента",
                    "Row tool position": "Положение инструмента строки",
                    "Add (+) button placement": "Добавить размещение кнопки (+)",
                    "Between Blocks (left)": "Между блоками (слева)",
                    "Between Blocks (center)": "Между блоками (в центре)",
                    "Outline Mode": "Контурный режим",
                    "Row & column": "Строка и столбец",
                    "Row only": "Только строка",
                    "Draggable blocks without handle": "Перетаскиваемые блоки без ручки",
                    "Animated drag to sort": "Анимированное перетаскивание для сортировки",
                    "Open snippets sidebar on start": "Открывать боковую панель фрагментов при запуске",
                    "Scrollable toolbar (top only)": "Прокручиваемая панель инструментов (только сверху)",
                    "Please select a block": "Пожалуйста, выберите блок",
                    "Open snippet sidebar on start": "Открывать боковую панель фрагмента при запуске",
                    "Hide snippet handle": "Скрыть дескриптор фрагмента",
                    "Undo": "Отменить",
                    "Redo": "Повторить",
                    "Empty": "Пусто",
                    "+ Click to add content": "+ Нажмите, чтобы добавить контент",
                    "B": "B",
                    "W": "W",
                    "Outline Style": "Стиль контура",
                    "Colored": "Цветной",
                    "Gray": "Серый",
                    "Hide Outline": "Скрыть контур",
                    "Hide Column Tool": "Скрыть  инструмент столбца",
                    "Row Tool Position": "Положение инструмента строки",
                    "Tool Style": "Стиль инструмента",
                    "Hide Snippet (+) Tool": "Инструмент «Скрыть фрагмент (+)»",
                    "Tool Outline": "Контур инструмента",
                    "Button": "Кнопка",
                    "Button Editor": "Редактор кнопки",
                    "Edit Button": "Редактировать кнопку",
                    "Grid Editor": "Редактор сетки",
                    "Outline": "Контур",
                    "Font Size": "Размер шрифта",
                    "Line Spacing": "Межстрочный интервал",
                    "Letter Spacing": "Межбуквенное расстояние",
                    "Close": "Закрыть",
                    "Search & Replace": "Искать и заменить",
                    "Word Count": "Количество слов",
                    "words": "слова",
                    "Characters": "Символы",
                    "Characters (no spaces)": "Символы (без пробелов)",
                    "Add to Left": "Добавить слева",
                    "Add to Right": "Добавить справа",
                    "Border Top Color": "Цвет верхней границы",
                    "Border Bottom Color": "Цвет нижней границы",
                    "Border Left Color": "Цвет границы слева",
                    "Border Right Color": "Цвет границы вправа",
                    "Snippets sidebar visibility": "Видимость боковой панели фрагментов",
                    "You have reached the maximum number of columns": "Вы достигли максимального количества столбцов",
                    "Width": "Ширина",
                    "Height": "Высота",
                    "Names": "Названия",
                    "Values": "Значения",
                    "Border Top": "Граница сверху",
                    "Border Bottom": "Граница снизу",
                    "Border Left": "Граница слева",
                    "Border Right": "Граница справа",
                    "Individual Corners": "Отдельные углы",
                    "Top Left": "Top Left",
                    "Top Right": "Top Right",
                    "Bottom Left": "Bottom Left",
                    "Bottom Right": "Bottom Right",
                    "Flex": "Flex",
                    "Direction": "Направление",
                    "Wrap": "Сворачивать",
                    "Justify Content": "Выровнять содержание",
                    "Align Items": "Выровнять элементы",
                    "Align Content": "Выровнять содержимое",
                    "Opacity": "Непрозрачность",
                    "Filters": "Фильтры",
                    "Blur": "Размытие",
                    "Brightness": "Яркость",
                    "Contrast": "Контраст",
                    "Grayscale": "Оттенки серого",
                    "Hue Rotate": "Оттенок Поворот",
                    "Invert": "Инвертировать",
                    "Saturate": "Насыщенность",
                    "Sepia": "Сепия",
                    "Bottom": "Нижние",
                    "Float": "Всплывавающие",
                    "x Offset": "x Offset",
                    "y Offset": "y Offset",
                    "Spread": "Spread",
                    "Shadow Color": "Цвет тени",
                    "Outer/Inner Shadow": "Внешняя/внутренняя тень",
                    "Margin": "Margin",
                    "Padding": "Padding",
                    "Text Align": "Выравнивание текста",
                    "Center": "Центр",
                    "Full": "Full",
                    "Line Height": "Высота линии",
                    "Font Weight": "Вес шрифта",
                    "Font Style": "Стиль шрифта",
                    "Text Transform": "Преобразование текста",
                    "Text Decoration": "Оформление текста",
                    "Word Spacing": "Расстояние между словами",
                    "Font Family": "Семейство шрифтов",
                    "Normal": "Нормальный",
                    "Lowercase": "Нижний регистр",
                    "Capitalize": "Использовать заглавные буквы",
                    "None": "Нет",
                    "Line Through": "Зачеркивание",
                    "Overline": "Надчеркивание",
                    "Hover": "Hover",
                    "Saved": "Сохранено",
                    "Templates": "Шаблоны",
                    "No Border": "Без границ",
                    "Border Radius": "Радиус границы",
                    "Button Size": "Размер кнопки",
                    "Upper/lower": "Верхний/нижний",
                    "Weight": "Вес",
                    "Save Current Button": "Сохранить текущую кнопку",
                    "Tags": "Тэги",
                    "Snippet": "Фрагмент",
                    "Mono": "Mono",
                    "Zoom": "Zoom",
                    "Set theme": "Установить тему",
                    "Open in a lightbox (for image, video or Youtube)": "Открыть в лайтбоксе (для изображения, видео или Youtube)",
                    "Column Settings": "Настройки столбца",
                    "Lock": "Закрыть",
                    "General": "Общие",
                    "Content": "Контент",
                    "On Click": "По клику",
                    "Background Image": "Фоновое изображение",
                    "Adjust": "Регулировать",
                    "Dark": "Тёмный",
                    "Light": "Светлый",
                    "Enlarge Row": "Увеличить строку",
                    "Content Alignment": "Выравнивание контента",
                    "Top Center": "Верх Центр",
                    "Bottom Center": "Низ Центр",
                    "Center Left": "Лево Центр",
                    "Center Right": "Право  Центр",
                    "Open": "Открыть",
                    "Background Image Adjustments": "Настройка фонового изображения",
                    "Scale": "Масштаб",
                    "Horizontal": "Горизонтально",
                    "Vertical": "Вертикально",
                    "Do you really want to leave?": "Вы действительно хотите уйти?",
                    "Two Button": "Две кнопки",
                    "Youtube": "Youtube",
                    "Video": "Видео",
                    "Map": "Карта",
                    "Show Controls": "Показать элементы управления",
                    "Loop": "Loop",
                    "Autoplay": "Автовоспроизведение",
                    "Please select an image or video file.": "Выберите изображение или видеофайл.",
                    "Please select an image file.": "Выберите файл изображения.",
                    "Please select an mp4 file.": "Пожалуйста, выберите файл mp4.",
                    "Social Links": "Соц сети ссылки",
                    "HTML/JS": "HTML/JS",
                    "Drag image to change the position. Click image to edit the details.": "Перетащите слайд, чтобы изменить положение. Щелкните слайд, чтобы отредактировать детали.",
                    "Add Image": "Добавить изображение",
                    "Fit": "Соответствовать",
                    "Type": "Тип",
                    "Animation duration": "Продолжительность анимации",
                    "Per View": "Per View",
                    "Gap": "Gap",
                    "Arrow Navigation": "Стрелочная навигация",
                    "Dots Navigation": "Точки навигации",
                    "Fade": "Тускнеет",
                    "Caption (HTML allowed)": "Заголовок (разрешен HTML)",
                    "Placement": "Размещение",
                    "Max Width": "Максимальная ширина",
                    "You can test the On-Click action on page if you lock the column by clicking the lock button": "Вы можете протестировать действие On-Click на странице, если заблокируете столбец, нажав кнопку блокировки.",
                    "Remove": "Удалить",
                    "All": "Все",
                    "Transparent": "Прозрачный",
                    "Current": "Текущий",
                    "Padding X": "Padding X",
                    "Padding Y": "Padding Y",
                    "SM": "SM",
                    "MD": "MD",
                    "LG": "LG",
                    "XL": "XL",
                    "2XL": "2XL",
                    "3XL": "3XL",
                    "Margin Left": "Margin Left",
                    "Margin Right": "Margin Right",
                    "Margin Top": "Margin Top",
                    "Margin Bottom": "Margin Bottom",
                    "Reset": "Сброс",
                    "Snippet Categories": "Категории сниппетов",
                    "Snippets": "Сниппеты",
                    "Copy": "Копировать",
                    "Cut": "Вырезать",
                    "Paste": "Вставить",
                    "Insert Link": "Вставить ссылку",
                    "Insert Image": "Вставить изображение",
                    "Show shortcut info": "Показать информацию о ярлыке",
                    "Navigate to the next control": "Перейти к следующему элементу управления",
                    "Navigate to the previous control": "Перейти к предыдущему элементу управления",
                    "Select control that has focus": "Выберите элемент управления, который имеет фокус",
                    "Select option that has focus (eg. checkbox)": "Выберите вариант, который имеет фокус (например, флажок)",
                    "Move up in selection list or menu": "Перейти вверх по списку выбора или меню",
                    "Move down in selection list or menu": "Перейти вниз по списку выбора или меню",
                    "Close modal or popup": "Закрыть модальное или всплывающее окно",
                    "Shortcuts": "Ярлыки",
                    "Basic": "Базовый",
                    "Editing": "Редактирование",
                    "Navigation": "Навигация",
                    "Tab": "Tab",
                    "Shift": "Shift",
                    "Esc": "Esc",
                    "Enter": "Enter",
                    "Up arrow": "Стрелка вверх",
                    "Down arrow": "Стрелка вниз",
                    "or": "или",
                    "Spacebar": "Пробел",
                    "Min Width": "Min Width",
                    "Max Height": "Max Height",
                    "Min Height": "Min Height",
                    "Overflow x": "Overflow x",
                    "Overflow y": "Overflow y",
                    "Please enter <iframe> element.": "Введите элемент <iframe>.",
                    "Add Slide": "Добавить слайд",
                    "Alternate Videos": "Альтернативные видео",
                    "Add/Update Video": "Добавить/обновить видео",
                    "Drag slide to change the position. Click slide to edit the details.": "Перетащите слайд, чтобы изменить положение. Щелкните слайд, чтобы отредактировать детали.",
                    "URL": "URL",
                    "Delete Slide": "Удалить слайд",
                    "Arrow Color": "Цвет стрелки",
                    "Dots Color": "Цвет точек",
                    "Hide Column on Mobile": "Скрыть столбец на мобильном устройстве",
                    "Padding Left/Right": "Отступ слева/справа",
                    "Top (Full Width)": "Сверху (полная ширина)",
                    "HTML View": "HTML-просмотр",
                    "Shorten HTML": "Сократить HTML",
                    "Actual": "Действительный",
                    "Visibility": "Видимость",
                    "Visible": "Видимый",
                    "Hidden": "Hidden",
                    "Text Slider": "Текст слайдер",
                    "Drag slide to change the position.": "Перетащите слайд, чтобы изменить положение.",
                    "Show Arrow on Mobile": "Показать стрелку на мобильном телефоне",
                    "Show Dots on Mobile": "Показать точки на мобильном телефоне",
                    "Pause on Hover": "Пауза при наведении",
                    "Caption Animation": "Анимация титров",
                    "Slide Up": "Slide Up",
                    "Fade In": "Fade In",
                    "Add Row ID": "Добавить идентификатор строки",
                    "Add Column ID": "Добавить идентификатор столбца",
                    "Add Element ID": "Добавить идентификатор элемента",
                    "Add Css Classes": "Добавить классы CSS",
                    "Laptop": "ПК",
                    "Mobile": "Телефон",
                    "Tablet": "Планшет",
                    "Laptop/Tablet (Landscape)": "Ноутбук/планшет (горизонт)",
                    "Tablet (Landscape)": "Планшет (горизонт)",
                    "Tablet (Portrait)": "Планшет (вертикаль)",
                    "Laptop/Tablet": "Ноутбук/планшет",
                    "Desktop": "Компьютер",
                    "Live Preview": "Предварительный просмотр",
                    "Page Break": "Разрыв страницы",
                    "Add the products table": "Добавьте таблицу товаров",
                    "Products": "Товары",
                    "Products will be displayed in this section on document preview and PDF.": "Продукты будут отображаться в этом разделе при предварительном просмотре документа и в формате PDF.",
                    "Signatures": "Подписи",
                    "On document PDF, the signatures will be displayed in this section.": "В документе PDF подписи будут отображаться в этом разделе."
                }
            },
            "country": {
                "country": "Страна"
            },
            "dashboard": {
                "insights": "Отчеты",
                "dashboard": "Панель мониторинга",
                "name": "Название",
                "default": "Панель мониторинга по умолчанию",
                "new_dashboard": "Новая панель мониторинга",
                "create": "Создать новую панель мониторинга",
                "edit_current": "Изменить текущую панель мониторинга",
                "delete_current": "Удалить текущую панель мониторинга",
                "created": "Панель мониторинга успешно создана",
                "updated": "Панель мониторинга успешно изменена",
                "deleted": "Панель мониторинга успешно удалена",
                "cards": {
                    "enabled": "Включено"
                }
            },
            "dates": {
                "today": "Сегодня",
                "tomorrow": "Завтра",
                "in_x_days": "Через {count} день|Через {count} дня",
                "in_x_weeks": "Через {count} неделю|Через {count} недели",
                "in_x_months": "Через {count} месяц|Через {count} месяца",
                "custom": "Пользовательская",
                "range": "Диапазон дат",
                "minutes": "минуты",
                "hours": "часы",
                "days": "дни",
                "weeks": "недели",
                "duration": {
                    "seconds": "несколько секунд",
                    "minutes": "минута|минуты",
                    "hours": "час|часы",
                    "days": "день|дни"
                },
                "due": {
                    "today": "Срок закрытия сегодня",
                    "tomorrow": "Срок закрытия завтра",
                    "this_week": "Срок закрытия на этой недели",
                    "next_week": "Срок закрытия на следующей недели",
                    "this_month": "Срок закрытия в этом месяце",
                    "next_month": "Срок закрытия в следующем месяце",
                    "this_quarter": "Срок закрытия этот квартал"
                },
                "yesterday": "Вчера",
                "next_day": "На следующий день",
                "this_week": "На этой неделе",
                "last_week": "На прошлой неделе",
                "next_week": "На следующей неделе",
                "this_month": "Этот месяц",
                "last_month": "Прошлый месяц",
                "next_month": "В следующем месяце",
                "this_quarter": "Этот квартал",
                "last_quarter": "Прошлый квартал",
                "next_quarter": "Следующий квартал",
                "this_year": "Этот год",
                "last_year": "Прошлый год",
                "next_year": "Следующий год",
                "within": {
                    "last_7_days": "За последние 7 дней",
                    "last_14_days": "За последние 14 дней",
                    "last_30_days": "За последние 30 дней",
                    "last_60_days": "За последние 60 дней",
                    "last_90_days": "За последние 90 дней",
                    "last_365_days": "За последние 365 дней"
                },
                "periods": {
                    "7_days": "Последние 7 дней",
                    "15_days": "Последние 15 дней",
                    "30_days": "Последние 30 дней",
                    "60_days": "Последние 60 дней",
                    "90_days": "Последние 90 дней",
                    "365_days": "Последние 365 дней",
                    "last_3_months": "Последние 3 месяца",
                    "last_6_months": "Последние 6 месяцев",
                    "last_12_months": "Последние 12 месяцев"
                }
            },
            "fields": {
                "add": "Добавить новое",
                "fields": "Поля",
                "field": "Поле",
                "updated": "Поля изменены",
                "hide_fields": "Hide {count} field|Hide {count} fields",
                "more_fields": "{count} more field|{count} more fields",
                "reseted": "Поля успешно установлены в начальное состояние",
                "all": "All Fields",
                "select": "Select Fields",
                "updated_field": "Поле изменено",
                "update_field": "Update Field",
                "optional": "(необязательное)",
                "configured": "Поля настроены успешно",
                "no_longer_available": "Поле больше недоступно",
                "new_value": "Новое значение",
                "old_value": "Старое значение",
                "manage": "Управление полями",
                "hide_updated": "Скрыть измененные поля",
                "view_updated": "Показать измененные поля",
                "primary": "Основное поле",
                "visible": "Видимое",
                "label": "Название",
                "is_readonly": "Только чтение",
                "keep_existing_value": "Keep existing value",
                "replace_existing_value": "Replace existing value with..",
                "settings": {
                    "create": "Поля создания",
                    "create_info": "Поля, которые будут отображаться, когда пользователь создает запись.",
                    "update": "Поля редактирования просмотра",
                    "update_info": "Доступные поля, которые будут отображаться при редактировании/предварительном просмотре записи.",
                    "detail": "Поля сведений",
                    "detail_info": "Доступные поля, которые будут отображаться в деталях записей.",
                    "list": "Список полей",
                    "list_info": "Чтобы настроить поля, отображаемые в представлении списка, при просмотре списка {resourceName} щелкните значок {icon}, расположенный на панели навигации, и выберите «Настройки списка»."
                },
                "collapsed_by_default": "Свернуто по умолчанию?",
                "is_required": "Обязательное?",
                "option_enabled_will_propagate": "When enabled, propagates to \"{view_name}\" view too.",
                "option_disabled_will_propagate": "When disabled, propagates to \"{view_name}\" view too.",
                "options": "Параметры",
                "field_is_unique": "Unique",
                "mark_as_unique": "Не допускать дублирования значений",
                "mark_as_unique_change_info": "Значение этой опции можно установить только при создании поля.",
                "unmark_as_unique_change_info": "This action is irreversible, after the field is unmarked as unique, cannot be marked as unique again.",
                "validation": {
                    "exist": "Похоже, что поле с таким идентификатором уже существует для ресурса.",
                    "requires_options": "Добавьте параметры для этого поля.",
                    "field_type_invalid": "Тип поля не поддерживается",
                    "field_id_invalid": "Допускаются только строчные буквы (a-z) и подчеркивание (_).",
                    "refuses_options": "Это поле не поддерживает параметры.",
                    "option_coma": "Comas are not allowed in option names."
                },
                "custom": {
                    "create_option_icon": "Щелкните значок {icon}, чтобы создать новую опцию.",
                    "or_add_options_via_text": "Or add options via text",
                    "convert_text_to_options": "Convert text to options",
                    "text_options_each_on_new_line": "Paste/enter each option on new line.",
                    "field": "Пользовательское поле",
                    "create": "Создать новое пользовательское  поле",
                    "update": "Измениь пользовательское  поле",
                    "type": "Тип поля",
                    "id": "Идентификатор поля",
                    "id_info": "Введите идентификатор поля в нижнем регистре, допустимы только буквенные символы (a-z) и подчеркивание (_).",
                    "updated": "Пользовательское поле успешно обновлено",
                    "created": "Пользовательское поле успешно создано",
                    "deleted": "Пользовательское поле успешно удалено"
                },
                "email_copied": "Адрес электронной почты скопирован в буфер обмена",
                "required_will_propagate": "Когда включено, распространяется и на представление \"{view_name}\"."
            },
            "filters": {
                "filters": "Фильтры",
                "apply": "Применить фильтры",
                "save_and_apply": "Сохранить и применить",
                "create": "Создать новый фильтр",
                "filter_by": "Фильтровать по",
                "edit": "Изменить",
                "save_as_new": "Сохранить фильтр?",
                "available": "Доступные фильтры",
                "not_available": "Нет доступных фильтров, начните с создания фильтра.",
                "cannot_be_shared": "Этот фильтр состоит из правил ({rules}), которые не всегда могут быть доступны для всех членов команды, по этой причине фильтр нельзя использовать совместно с другими членами команды.",
                "search": "Поиск фильтров...",
                "name": "Название фильтра",
                "new": "Новый фильтр",
                "clear_rules": "Очистить правила",
                "clear_applied": "Очистить фильтр",
                "static_rule_indicator": "Статическое правило",
                "is_readonly": "Этот фильтр доступен только для чтения с возможностью пометки по умолчанию, другие модификации фильтра отключены, если вам нужно расширить этот фильтр, создайте вместо него новый.",
                "system_default_delete_info": "Вы не можете удалить фильтр приложения по умолчанию",
                "country": "Страна",
                "share": {
                    "with": "Поделиться с",
                    "private": "Приватный",
                    "everyone": "Все",
                    "private_info": "Только создатель может видеть этот фильтр",
                    "everyone_info": "Все пользователи могут видеть и использовать этот фильтр"
                },
                "placeholders": {
                    "enter": "Введите {label}",
                    "choose": "Выбрать  {label}",
                    "choose_with_multiple": "Выберите один или более {label}",
                    "select_date": "Выбрать дату"
                },
                "conditions": {
                    "or": "или",
                    "and": "и"
                },
                "show_matching_records_conditions": "Показать записи, соответствующие {match_type} этим условиям:",
                "or_match_any_conditions": "{condition} соответствует {match_type} этих условий:",
                "mark_as_default": "Отметить как по умолчанию",
                "unmark_as_default": "Удалить как по умолчанию",
                "mark_as_default_for_current_account_only": "Applies only for your account.",
                "edit_filter": "Изменить фильтр",
                "match_type": "Тип соответствия",
                "match_type_all": "Все",
                "match_type_any": "Любой",
                "add_filter": "Добавить фильтр",
                "add_condition": "Добавить условие",
                "add_another_condition": "Add Another Condition",
                "add_group": "Добавить группу",
                "add_group_info": "A group to nest more filters",
                "select_rule": "Select Rule",
                "operators": {
                    "is": "является",
                    "was": "был",
                    "equal": "равно",
                    "not_equal": "не равно",
                    "in": "любой из",
                    "not_in": "не из",
                    "less": "меньше чем",
                    "less_or_equal": "меньше или равен чем",
                    "greater": "больше чем",
                    "greater_or_equal": "больше или равен чем",
                    "between": "между",
                    "not_between": "не между",
                    "begins_with": "начинается с",
                    "not_begins_with": "не начинается с",
                    "contains": "содержит",
                    "not_contains": "не содержит",
                    "ends_with": "заканчивается на",
                    "not_ends_with": "не заканчивается на",
                    "is_empty": "пусто",
                    "is_not_empty": "не пусто",
                    "is_null": "неизвестно",
                    "is_not_null": "известно"
                },
                "me": "Моё"
            },
            "import": {
                "import": "Импорт",
                "start": "Начать импорт",
                "import_records": "Импорт записей",
                "import_in_progress": "Import In Progress",
                "download_sample": "Скачать пример",
                "history": "История импорта",
                "no_history": "История импорта не найдена.",
                "spreadsheet_columns": "Столбцы электронной таблицы",
                "column_will_not_import": "не будет импортировано",
                "records_being_imported_in_batches": "The records are being imported in a few batches, do not navigate from this window until this message dissapear.",
                "date": "Дата",
                "file_name": "Имя файла",
                "user": "Пользователь",
                "total_imported": "Импортировано",
                "total_duplicates": "Дубликаты",
                "total_skipped": "Пропущено",
                "progress": "Progress",
                "status": "Статус",
                "imported": "Записи успешно импортированы",
                "revert": "Revert",
                "revert_info": "Reverting an import will permanently delete all of the imported records.",
                "why_skipped": "Почему?",
                "download_skip_file": "Скачать прощенные файлы",
                "skip_file": "Пропустить файл",
                "total_rows_skipped": "Всего пропущено строк: {count}",
                "skip_file_generation_info": "Файл пропуска создается каждый раз при сбое проверки строки электронной таблицы.",
                "skip_file_fix_and_continue": "Загрузите файл пропуска, чтобы изучить неудачные строки и причины их возникновения. После того, как строки будут исправлены, загрузите файл с фиксированным пропуском ниже, чтобы продолжить процесс импорта для текущего экземпляра импорта.",
                "upload_fixed_skip_file": "Загрузить файл с фиксированным пропуском",
                "steps": {
                    "step_1": {
                        "name": "Скачать пример",
                        "description": "Руководство по форматированию электронных таблиц."
                    },
                    "step_2": {
                        "name": "Загрузить таблицу",
                        "description": "Загрузите файл для сопоставления."
                    },
                    "step_3": {
                        "name": "Столбцы карты",
                        "description": "Сопоставьте столбцы с полями."
                    },
                    "step_4": {
                        "name": "Импорт",
                        "description": "Запустите процесс импорта."
                    }
                },
                "from_file": "Импорт из файла {file_type}"
            },
            "mail_template": {
                "mail_templates": "Почтовые шаблоны",
                "template": "Шаблон",
                "subject": "Тема",
                "message": "Сообщение",
                "updated": "Шаблон успешно обновлен.",
                "choose_to_edit": "Выберите шаблон для редактирования",
                "changes_not_saved_warning": "Your current changes have not been saved. If you proceed, you will lose any unsaved progress. Do you wish to continue without saving?",
                "placeholders": {
                    "view_record": "Посмотреть запись",
                    "placeholders": "Заполнители",
                    "mentioned_user": "Упомянутое имя пользователя.",
                    "user_that_mentions": "Имя пользователя, которое упоминают.",
                    "mention_url": "URL-адрес упоминания."
                }
            },
            "media": {
                "link_copied": "Ссылка успешно скопирована",
                "no_preview_available": "В настоящее время предварительный просмотр этого файла недоступен, попробуйте вместо этого загрузить файл."
            },
            "notifications": {
                "notifications": "Уведомления",
                "notification": "Уведомление",
                "your": "Ваши уведомления",
                "no_notifications": "У вас нет уведомлений.",
                "description": "Описание",
                "mark_all_as_read": "Пометить как прочитанное",
                "no_more_notifications": "Уведомлений больше нет.",
                "dismiss": "Dismiss",
                "channels": {
                    "mail": "Почта",
                    "database": "Прочее"
                }
            },
            "oauth": {
                "connect": "Подключить",
                "no_accounts": "У вас нет подключенных аккаунтов.",
                "invalid_state": "Неверный запрос, попробуйте еще раз.",
                "connect_new_account": "Подключить новый аккаунт",
                "add": "Добавить новый аккаунт",
                "or_choose_existing": "или выберите ранее добавленный аккаунт:",
                "stop_syncing": "Остановить синхронизацию",
                "start_syncing": "Начать синхронизацию",
                "deleted": "Аккаунт успешно удален",
                "connected_accounts": "Подключенные аккаунты",
                "requires_authentication": "Эта учетная запись требует повторной аутентификации для повторного подключения к приложению.",
                "re_authenticate": "Повторная аутентификация",
                "re_authenticated": "Аккаунт прошел повторную аутентификацию",
                "delete_warning": "Удаление подключенной учетной записи остановит все связанные службы, предоставляемые этой учетной записью, включая любые подключенные учетные записи электронной почты, которые используются для входящих сообщений."
            },
            "resource": {
                "all_resources": "All Resources",
                "created": "Запись успешно создана",
                "updated": "Запись успешно изменена",
                "deleted": "Запись успешно удалена",
                "create": "Создать {resource}",
                "edit": "Изменить {resource}",
                "already_associated": "Эта запись уже связана",
                "associate_with_records": "Связать с записями",
                "associated": "Запись успешно связана",
                "dissociated": "Удалена связка у записи",
                "associated_delete_warning": "{resource} уже связан с записями, поэтому его нельзя удалить.",
                "primary_record_delete_info": "Это первичный {resource}, его нельзя удалить.",
                "settings": {
                    "fields": "Поля {resourceName}"
                }
            },
            "role": {
                "permissions": "Разрешения",
                "role": "Роль",
                "roles": "Роли",
                "name": "Название",
                "create": "Создать роль",
                "edit": "Изменить роль",
                "created": "Роль успешно создана",
                "updated": "Роль успешно изменена",
                "deleted": "Роль успешно удалена",
                "granted": "Разрешено",
                "revoked": "Запрещено",
                "capabilities": {
                    "access": "Доступ",
                    "view": "Просмотр",
                    "delete": "Удаление",
                    "bulk_delete": "Массовое удаление",
                    "edit": "Редактировать",
                    "all": "Все {resourceName}",
                    "owning_only": "Только ответственный"
                },
                "view_non_authorized_after_record_create": "Ваша учетная запись не авторизована для просмотра этой записи, так как вы не являетесь владельцем записи, после перенаправления с этой страницы вы не сможете получить доступ к записи.",
                "empty_state": {
                    "title": "Нет ролей",
                    "description": "Начните с создания новой роли."
                }
            },
            "settings": {
                "settings": "Настройки",
                "updated": "Настройки изменены",
                "general_settings": "Основные настройки",
                "company_information": "Информация о компании",
                "update_user_account_info": "Обновление этих настроек не повлияет на настройки вашей учетной записи пользователя, поскольку эти настройки являются общими, вместо этого обновите те же настройки в своей учетной записи пользователя, если вы хотите обновить эти параметры.",
                "general": "Общие",
                "system": "Система",
                "system_email": "Системная учетная запись электронной почты",
                "system_email_configured": "Аккаунт настроен другим пользователем",
                "system_email_info": "Выберите учетную запись электронной почты, подключенную к папке «Входящие», которая будет использоваться для отправки сообщений, связанных с системой, таких как пользователь, назначенный контакту, напоминание об активности, приглашения пользователя и т. д.",
                "choose_logo": "Выберите логотип",
                "date_format": "Формат даты",
                "time_format": "Формат времени",
                "go_to_settings": "Перейти в настройки",
                "privacy_policy_info": "Если у вас нет политики конфиденциальности, вы можете настроить ее здесь, просмотреть политику конфиденциальности по следующему URL-адресу: {url}",
                "phones": {
                    "require_calling_prefix": "Требовать префикс для номера телефона",
                    "require_calling_prefix_info": "Для большинства интеграций вызовов требуется, чтобы телефонные номера были в формате +7. Включение этой опции гарантирует, что ни один телефонный номер не будет введен без префикса для конкретной страны."
                },
                "recaptcha": {
                    "recaptcha": "reCaptcha",
                    "site_key": "Site Key",
                    "secret_key": "Secret Key",
                    "ignored_ips": "Игнорируемые IP-адреса",
                    "ignored_ips_info": "Введите разделенные запятыми IP-адреса, которые вы хотите, чтобы reCaptcha пропускала проверку.",
                    "dont_get_locked": "Не блокирует",
                    "ensure_recaptcha_works": "Чтобы убедиться, что конфигурация reCaptcha работает правильно, всегда выполняйте тестовый вход в режиме инкогнито, оставляя текущее окно активным."
                },
                "security": {
                    "security": "Безопасность",
                    "disable_password_forgot": "Отключить функцию забытого пароля",
                    "disable_password_forgot_info": "При включении функция забытого пароля будет отключена.",
                    "block_bad_visitors": "Блокировать плохих посетителей",
                    "block_bad_visitors_info": "Если включено, для каждого гостя будет проверяться список плохих пользовательских агентов, IP-адресов и рефереров."
                },
                "tools": {
                    "tools": "Инструменты",
                    "run": "Запустить инструмент",
                    "executed": "Действие выполнено успешно",
                    "clear-cache": "Очистить кеш приложения",
                    "storage-link": "Создайте символическую ссылку из \"public/storage\" в \"storage/app/public\"",
                    "optimize": "Кэшируйте файлы начальной загрузки приложения, такие как config и route.",
                    "seed-mailable-templates": "Заполните почтовые шаблоны приложений"
                }
            },
            "table": {
                "default_sort": "Сортировка по умолчанию",
                "per_page": "На страницу",
                "columns": "Столбцы",
                "wrap_column": "Wrap Column",
                "primary_column": "Основной столбец",
                "empty": "Данные отсутствуют в таблице",
                "info": "Показать {from} в {to} из {total} записей",
                "previous": "Предыдущий",
                "next": "Следующий",
                "max_height": "Максимальная высота",
                "max_height_info": "Указание максимальной высоты таблицы гарантирует, что заголовки таблицы будут зафиксированы сверху при прокрутке.",
                "list_settings": "Список настроек",
                "customize_list_view": "Настроить вид списка",
                "condensed": "Сжатая таблица",
                "bordered": "Bordered Table",
                "enable_polling": "Enable Polling",
                "polling_info": "The interval in seconds at which should poll for new records.",
                "length_menu": {
                    "show": "Показать",
                    "entries": "записей"
                }
            },
            "tags": {
                "tags": "Tags",
                "search": "Search Tags",
                "add_new": "Add new tag",
                "tag_name": "Tag Name",
                "color": "Color",
                "edit_tag": "Edit Tag",
                "new_tag": "New Tag",
                "validation": {
                    "coma": "Comas are not allowed in tag names."
                }
            },
            "timeline": {
                "pin": "Закрепить сверху",
                "unpin": "Открепить сверху",
                "updated": "Запись обновлена пользователем {causer}",
                "association_restored": "Связка {associationDisplayName} была восстановлена из корзины пользователем {user}",
                "association_permanently_deleted": "Связка {associationDisplayName} удалена без возможности восстановления.",
                "deleted": "Запись была удалена пользователем {causer}",
                "restored": "Запись восстановлена из корзины пользователем {causer}",
                "created": "Запись создана пользователем {causer}",
                "imported": "The record has been imported by {causer}",
                "attached": "{user} связано",
                "detached": "{user} связка удалена",
                "associate_trashed": "Связанная запись {displayName} была перемещена в корзину пользователем {user}"
            },
            "update": {
                "system": "Обновление системы",
                "update": "Обновления",
                "perform": "Выполнить обновление",
                "installed_version": "Установленная версия",
                "latest_version": "Последняя версия",
                "not_available": "Нет новой версии!",
                "using_latest_version": "Вы используете последнюю версию!",
                "update_in_progress": "Производится обновление...",
                "patches": "Патчи",
                "patch_applied": "Применены",
                "apply_oldest_first": "Сначала необходимо применить самые старые исправления.",
                "no_patches": "Для вашей версии нет доступных исправлений, зайдите позже.",
                "update_zip_is_required": "Чтобы использовать функцию обновления в 1 клик, вам необходимо включить расширение PHP «zip».",
                "patch_zip_is_required": "Чтобы применить исправления, вам необходимо включить расширение PHP «zip».",
                "auto_apply_patches": "Automatically apply new patches"
            },
            "workflow": {
                "create": "Создать рабочий процесс",
                "workflows": "Рабочие процессы",
                "title": "Название",
                "description": "Описание",
                "created": "Рабочий процесс успешно создан",
                "updated": "Рабочий процесс успешно изменен",
                "deleted": "Рабочий процесс успешно удален",
                "when": "Когда",
                "then": "Затем",
                "field_change_to": "На",
                "total_executions": "Выполнено: {total}",
                "info": "Инструмент рабочих процессов автоматизирует ваши процессы продаж. Внутренние процессы, которые можно автоматизировать, включают создание действий, отправку электронных писем, запуск HTTP-запросов и т. д.",
                "validation": {
                    "invalid_webhook_url": "URL-адрес веб-хука не должен начинаться с «https://» или «http://»."
                },
                "actions": {
                    "webhook": "Триггер вебхука",
                    "webhook_url_info": "Должен быть полным, действительным, общедоступным URL-адресом."
                },
                "fields": {
                    "with_header_name": "С названием заголовка (необязательно)",
                    "with_header_value": "Со значением заголовка (необязательно)",
                    "for_owner": "Кому: Ответственный",
                    "dates": {
                        "now": "Со сроком исполнения: на данный момент",
                        "in_1_day": "Со сроком исполнения: в течение дня",
                        "in_2_days": "Со сроком: через два дня",
                        "in_3_days": "Со сроком: через три дня",
                        "in_4_days": "Со сроком: через четыре дня",
                        "in_5_days": "Со сроком: через пять дней"
                    }
                }
            }
        }
    }
}
