<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.4.1
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Core\App\Table;

use Illuminate\Database\Eloquent\Model;

class HasManyColumn extends RelationshipColumn
{
    /**
     * HasManyColumn is not sortable by default.
     */
    public bool $sortable = false;

    /**
     * Initialize new HasManyColumn instance class.
     */
    public function __construct()
    {
        parent::__construct(...func_get_args());

        $this->fillRowDataUsing(function (array &$row, Model $model) {
            $row[$this->attribute] = $model->{$this->relationName}->map(function (Model $relation) {
                return $this->toRowData($relation);
            });
        });
    }
}
