<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.4.1
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Core\App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\Core\App\Models\Synchronization;

class SynchronizationGoogleWebhookController extends Controller
{
    /**
     *  Handle the webhook request.
     */
    public function handle(Request $request): void
    {
        if ($request->header('x-goog-resource-state') !== 'exists') {
            return;
        }

        $synchronization = Synchronization::where('resource_id', $request->header('x-goog-resource-id'))
            ->findOrFail($request->header('x-goog-channel-id'));

        $synchronization->ping();
    }
}
