<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.4.1
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Core\App\Filters;

use Illuminate\Support\Str;

class Number extends Filter implements CountableRelation
{
    /**
     * The relation that the count is performed on
     *
     * @var string|null
     */
    public $countableRelation;

    /**
     * Indicates that the filter will count the val ues
     *
     * @param  string|null  $relationName
     * @return \Modules\Core\App\Filters\Filter
     */
    public function countableRelation($relationName = null)
    {
        $this->countableRelation = $relationName ?? lcfirst(Str::studly($this->field()));
        $operators = $this->getOperators();

        // between and not_between are not supported at this time.
        unset($operators[array_search('between', $operators)], $operators[array_search('not_between', $operators)]);

        $this->operators($operators);

        return $this;
    }

    /**
     * Get the countable relation name
     *
     * @return string|null
     */
    public function getCountableRelation()
    {
        return $this->countableRelation;
    }

    /**
     * Defines a filter type
     */
    public function type(): string
    {
        return 'number';
    }
}
