<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.4.1
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Core\App\Concerns;

use Illuminate\Database\Eloquent\Builder;

/** @mixin \Modules\Core\App\Models\Model */
trait HasDisplayOrder
{
    /**
     * Boot the HasDisplayOrder trait.
     */
    protected static function bootHasDisplayOrder()
    {
        static::addGlobalScope('displayOrder', fn (Builder $query) => $query->orderByDisplayOrder());
    }

    /**
     * Scope a query to order the model by "display_order" column.
     */
    public function scopeOrderByDisplayOrder(Builder $query): void
    {
        $query->orderBy('display_order');
    }
}
