<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.4.1
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Core\App\Card;

/** @mixin \Modules\Core\App\Card\Card */
trait FloatsResource
{
    protected ?array $floatingResource = null;

    public function floatResourceInEditMode(string $resourceName): static
    {
        $this->floatingResource = ['resourceName' => $resourceName, 'mode' => 'edit'];

        return $this;
    }

    public function floatResourceInDetailMode(string $resourceName): static
    {
        $this->floatingResource = ['resourceName' => $resourceName, 'mode' => 'detail'];

        return $this;
    }
}
