<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.4.1
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

use Illuminate\Support\Facades\Broadcast;
use Modules\Contacts\App\Models\Company;
use Modules\Contacts\App\Models\Contact;

Broadcast::channel('Modules.Contacts.App.Models.Contact.{contactId}', function ($user, $contactId) {
    return $user->can('view', Contact::findOrFail($contactId));
});

Broadcast::channel('Modules.Contacts.App.Models.Company.{companyId}', function ($user, $companyId) {
    return $user->can('view', Company::findOrFail($companyId));
});
