<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.4.1
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Contacts\App\Observers;

use Modules\Contacts\App\Models\Contact;

class ContactObserver
{
    /**
     * Handle the Contact "deleting" event.
     */
    public function deleting(Contact $contact): void
    {
        if ($contact->isForceDeleting()) {
            $contact->purge();
        } else {
            $contact->guests()->delete();
        }
    }
}
