<?php
/**
 * Concord CRM - https://www.concordcrm.com
 *
 * @version   1.4.1
 *
 * @link      Releases - https://www.concordcrm.com/releases
 * @link      Terms Of Service - https://www.concordcrm.com/terms
 *
 * @copyright Copyright (c) 2022-2024 KONKORD DIGITAL
 */

namespace Modules\Activities\App\Fields;

use Modules\Core\App\Fields\DateTime;

class NextActivityDate extends DateTime
{
    /**
     * Initialize new NextActivityDate instance
     */
    public function __construct()
    {
        parent::__construct('next_activity_date', __('activities::activity.next_activity_date'));

        $this->exceptOnForms()
            ->excludeFromDetail()
            ->excludeFromSettings()
            ->excludeFromImport()
            ->readOnly(true)
            ->help(__('activities::activity.next_activity_date_info'))
            ->hidden();
    }
}
